/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.database.DB;
import edu.uoregon.tau.dms.dss.DataSession;
import edu.uoregon.tau.dms.dss.Metric;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class Trial {
    private int trialID;
    private int experimentID;
    private int applicationID;
    private String name;
    private String time;
    private int nodeCount;
    private int contextsPerNode;
    private int threadsPerContext;
    private Vector metric;
    private String userData;
    private String problemDefinition;
    protected DataSession dataSession = null;

    public int getID() {
        return this.trialID;
    }

    public int getExperimentID() {
        return this.experimentID;
    }

    public int getApplicationID() {
        return this.applicationID;
    }

    public String getName() {
        return this.name;
    }

    public String getTime() {
        return this.time;
    }

    public String getProblemDefinition() {
        return this.problemDefinition;
    }

    public DataSession getDataSession() {
        return this.dataSession;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public int getNumContextsPerNode() {
        return this.contextsPerNode;
    }

    public int getNumThreadsPerContext() {
        return this.threadsPerContext;
    }

    public int[] getMaxNCTNumbers() {
        int[] nArray = new int[]{this.nodeCount, this.contextsPerNode, this.threadsPerContext};
        return nArray;
    }

    public String getUserData() {
        return this.userData;
    }

    public int getMetricCount() {
        if (this.metric == null) {
            return 0;
        }
        return this.metric.size();
    }

    public Vector getMetrics() {
        return this.metric;
    }

    public void setID(int n) {
        this.trialID = n;
    }

    public void setExperimentID(int n) {
        this.experimentID = n;
    }

    public void setApplicationID(int n) {
        this.applicationID = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setTime(String string) {
        this.time = string;
    }

    public void setProblemDefinition(String string) {
        this.problemDefinition = string;
    }

    public void setDataSession(DataSession dataSession) {
        this.dataSession = dataSession;
    }

    public void setNodeCount(int n) {
        this.nodeCount = n;
    }

    public void setNumContextsPerNode(int n) {
        this.contextsPerNode = n;
    }

    public void setNumThreadsPerContext(int n) {
        this.threadsPerContext = n;
    }

    public void setUserData(String string) {
        this.userData = string;
    }

    public void addMetric(Metric metric) {
        if (this.metric == null) {
            this.metric = new Vector();
        }
        this.metric.addElement(metric);
    }

    private void getTrialMetrics(DB dB) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select id, name ");
        stringBuffer.append("from metric ");
        stringBuffer.append("where trial = ");
        stringBuffer.append(this.getID());
        stringBuffer.append(" order by id ");
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                Metric metric = new Metric();
                metric.setID(resultSet.getInt(1));
                metric.setName(resultSet.getString(2));
                metric.setTrialID(this.getID());
                this.addMetric(metric);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static Vector getTrialList(DB dB, String string) {
        Trial trial;
        Object object;
        Vector<Trial> vector = new Vector<Trial>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select t.id, t.experiment, e.application, ");
        stringBuffer.append("t.time, t.problem_definition, t.node_count, ");
        stringBuffer.append("t.contexts_per_node, t.threads_per_context, ");
        stringBuffer.append("t.name, t.userdata ");
        stringBuffer.append("from trial t inner join experiment e ");
        stringBuffer.append("on t.experiment = e.id ");
        stringBuffer.append(string);
        stringBuffer.append(" order by t.node_count, t.contexts_per_node, t.threads_per_context, t.id ");
        try {
            object = dB.executeQuery(stringBuffer.toString());
            while (object.next()) {
                trial = new Trial();
                trial.setID(object.getInt(1));
                trial.setExperimentID(object.getInt(2));
                trial.setApplicationID(object.getInt(3));
                trial.setTime(object.getString(4));
                trial.setProblemDefinition(object.getString(5));
                trial.setNodeCount(object.getInt(6));
                trial.setNumContextsPerNode(object.getInt(7));
                trial.setNumThreadsPerContext(object.getInt(8));
                trial.setName(object.getString(9));
                trial.setUserData(object.getString(10));
                vector.addElement(trial);
            }
            object.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            trial = (Trial)object.nextElement();
            trial.getTrialMetrics(dB);
        }
        return vector;
    }

    public int saveTrial(DB dB) {
        boolean bl = this.exists(dB);
        int n = 0;
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = bl ? dB.prepareStatement("UPDATE trial SET name = ?, experiment = ?, time = ?, problem_definition = ?, node_count = ?, contexts_per_node = ?, threads_per_context = ?, userdata = ? WHERE id = ?") : dB.prepareStatement("INSERT INTO trial (name, experiment, time, problem_definition, node_count, contexts_per_node, threads_per_context, userdata) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setString(1, this.name);
            preparedStatement.setInt(2, this.experimentID);
            preparedStatement.setString(3, this.time);
            preparedStatement.setString(4, this.problemDefinition);
            preparedStatement.setInt(5, this.nodeCount);
            preparedStatement.setInt(6, this.contextsPerNode);
            preparedStatement.setInt(7, this.threadsPerContext);
            preparedStatement.setString(8, this.userData);
            if (bl) {
                preparedStatement.setInt(9, this.trialID);
            }
            preparedStatement.executeUpdate();
            if (bl) {
                n = this.trialID;
            } else {
                String string = new String();
                if (dB.getDBType().compareTo("mysql") == 0) {
                    string = "select LAST_INSERT_ID();";
                }
                string = dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM trial" : "select currval('trial_id_seq');";
                n = Integer.parseInt(dB.getDataItem(string));
            }
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the trial.");
            sQLException.printStackTrace();
            System.exit(0);
        }
        return n;
    }

    public static void deleteTrial(DB dB, int n) {
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("delete from atomic_location_profile where atomic_event in (select id from atomic_event where trial = ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement = dB.prepareStatement(" delete from atomic_event where trial = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement = dB.prepareStatement(" delete from interval_location_profile where interval_event in (select id from interval_event where trial = ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement = dB.prepareStatement(" delete from interval_mean_summary where interval_event in (select id from interval_event where trial = ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement = dB.prepareStatement(" delete from interval_total_summary where interval_event in (select id from interval_event where trial = ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement = dB.prepareStatement(" delete from interval_event where trial = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement = dB.prepareStatement(" delete from metric where trial = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement = dB.prepareStatement(" delete from trial where id = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while deleting the trial.");
            sQLException.printStackTrace();
            System.exit(0);
        }
    }

    private boolean exists(DB dB) {
        boolean bl = false;
        try {
            PreparedStatement preparedStatement = dB.prepareStatement("SELECT name FROM trial WHERE id = ?");
            preparedStatement.setInt(1, this.trialID);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                bl = true;
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the application.");
            sQLException.printStackTrace();
            System.exit(0);
        }
        return bl;
    }
}

