/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.database.DB;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class Experiment {
    private int experimentID;
    private int applicationID;
    private String name;
    private String userData;
    private String systemName;
    private String systemMachineType;
    private String systemArch;
    private String systemOS;
    private String systemMemorySize;
    private String systemProcessorAmount;
    private String systemL1CacheSize;
    private String systemL2CacheSize;
    private String systemUserData;
    private String configurationPrefix;
    private String configurationArchitecture;
    private String configurationCpp;
    private String configurationCc;
    private String configurationJdk;
    private String configurationProfile;
    private String configurationUserData;
    private String compilerCppName;
    private String compilerCppVersion;
    private String compilerCcName;
    private String compilerCcVersion;
    private String compilerJavaDirpath;
    private String compilerJavaVersion;
    private String compilerUserData;

    public int getID() {
        return this.experimentID;
    }

    public int getApplicationID() {
        return this.applicationID;
    }

    public String getName() {
        return this.name;
    }

    public String getUserData() {
        return this.userData;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getSystemMachineType() {
        return this.systemMachineType;
    }

    public String getSystemArch() {
        return this.systemArch;
    }

    public String getSystemOS() {
        return this.systemOS;
    }

    public String getSystemMemorySize() {
        return this.systemMemorySize;
    }

    public String getSystemProcessorAmount() {
        return this.systemProcessorAmount;
    }

    public String getSystemL1CacheSize() {
        return this.systemL1CacheSize;
    }

    public String getSystemL2CacheSize() {
        return this.systemL2CacheSize;
    }

    public String getSystemUserData() {
        return this.systemUserData;
    }

    public String getConfigPrefix() {
        return this.configurationPrefix;
    }

    public String getConfigArchitecture() {
        return this.configurationArchitecture;
    }

    public String getConfigCpp() {
        return this.configurationCpp;
    }

    public String getConfigCc() {
        return this.configurationCc;
    }

    public String getConfigJdk() {
        return this.configurationJdk;
    }

    public String getConfigProfile() {
        return this.configurationProfile;
    }

    public String getConfigUserData() {
        return this.configurationUserData;
    }

    public String getCompilerCppName() {
        return this.compilerCppName;
    }

    public String getCompilerCppVersion() {
        return this.compilerCppVersion;
    }

    public String getCompilerCcName() {
        return this.compilerCcName;
    }

    public String getCompilerCcVersion() {
        return this.compilerCcVersion;
    }

    public String getCompilerJavaDirpath() {
        return this.compilerJavaDirpath;
    }

    public String getCompilerJavaVersion() {
        return this.compilerJavaVersion;
    }

    public String getCompilerUserData() {
        return this.compilerUserData;
    }

    public void setID(int n) {
        this.experimentID = n;
    }

    public void setApplicationID(int n) {
        this.applicationID = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setUserData(String string) {
        this.userData = string;
    }

    public void setSystemName(String string) {
        this.systemName = string;
    }

    public void setSystemMachineType(String string) {
        this.systemMachineType = string;
    }

    public void setSystemArch(String string) {
        this.systemArch = string;
    }

    public void setSystemOS(String string) {
        this.systemOS = string;
    }

    public void setSystemMemorySize(String string) {
        this.systemMemorySize = string;
    }

    public void setSystemProcessorAmount(String string) {
        this.systemProcessorAmount = string;
    }

    public void setSystemL1CacheSize(String string) {
        this.systemL1CacheSize = string;
    }

    public void setSystemL2CacheSize(String string) {
        this.systemL2CacheSize = string;
    }

    public void setSystemUserData(String string) {
        this.systemUserData = string;
    }

    public void setConfigurationPrefix(String string) {
        this.configurationPrefix = string;
    }

    public void setConfigurationArchitecture(String string) {
        this.configurationArchitecture = string;
    }

    public void setConfigurationCpp(String string) {
        this.configurationCpp = string;
    }

    public void setConfigurationCc(String string) {
        this.configurationCc = string;
    }

    public void setConfigurationJdk(String string) {
        this.configurationJdk = string;
    }

    public void setConfigurationProfile(String string) {
        this.configurationProfile = string;
    }

    public void setConfigurationUserData(String string) {
        this.configurationUserData = string;
    }

    public void setCompilerCppName(String string) {
        this.compilerCppName = string;
    }

    public void setCompilerCppVersion(String string) {
        this.compilerCppVersion = string;
    }

    public void setCompilerCcName(String string) {
        this.compilerCcName = string;
    }

    public void setCompilerCcVersion(String string) {
        this.compilerCcVersion = string;
    }

    public void setCompilerJavaDirpath(String string) {
        this.compilerJavaDirpath = string;
    }

    public void setCompilerJavaVersion(String string) {
        this.compilerJavaVersion = string;
    }

    public void setCompilerUserData(String string) {
        this.compilerUserData = string;
    }

    public static Vector getExperimentList(DB dB, String string) {
        Vector<Experiment> vector = new Vector<Experiment>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select id, application, name, system_name, ");
        stringBuffer.append("system_machine_type, system_arch, system_os, ");
        stringBuffer.append("system_memory_size, system_processor_amt, ");
        stringBuffer.append("system_l1_cache_size, system_l2_cache_size, ");
        stringBuffer.append("system_userdata, ");
        stringBuffer.append("configure_prefix, configure_arch, configure_cpp, ");
        stringBuffer.append("configure_cc, configure_jdk, configure_profile, ");
        stringBuffer.append("configure_userdata, ");
        stringBuffer.append("compiler_cpp_name, compiler_cpp_version, ");
        stringBuffer.append("compiler_cc_name, compiler_cc_version, ");
        stringBuffer.append("compiler_java_dirpath, compiler_java_version, ");
        stringBuffer.append("compiler_userdata, userdata from experiment ");
        stringBuffer.append(string);
        stringBuffer.append(" order by name asc ");
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                Experiment experiment = new Experiment();
                experiment.setID(resultSet.getInt(1));
                experiment.setApplicationID(resultSet.getInt(2));
                experiment.setName(resultSet.getString(3));
                experiment.setSystemName(resultSet.getString(4));
                experiment.setSystemMachineType(resultSet.getString(5));
                experiment.setSystemArch(resultSet.getString(6));
                experiment.setSystemOS(resultSet.getString(7));
                experiment.setSystemMemorySize(resultSet.getString(8));
                experiment.setSystemProcessorAmount(resultSet.getString(9));
                experiment.setSystemL1CacheSize(resultSet.getString(10));
                experiment.setSystemL2CacheSize(resultSet.getString(11));
                experiment.setSystemUserData(resultSet.getString(12));
                experiment.setConfigurationPrefix(resultSet.getString(13));
                experiment.setConfigurationArchitecture(resultSet.getString(14));
                experiment.setConfigurationCpp(resultSet.getString(15));
                experiment.setConfigurationCc(resultSet.getString(16));
                experiment.setConfigurationJdk(resultSet.getString(17));
                experiment.setConfigurationProfile(resultSet.getString(18));
                experiment.setConfigurationUserData(resultSet.getString(19));
                experiment.setCompilerCppName(resultSet.getString(20));
                experiment.setCompilerCppVersion(resultSet.getString(21));
                experiment.setCompilerCcName(resultSet.getString(22));
                experiment.setCompilerCcVersion(resultSet.getString(23));
                experiment.setCompilerJavaDirpath(resultSet.getString(24));
                experiment.setCompilerJavaVersion(resultSet.getString(25));
                experiment.setCompilerUserData(resultSet.getString(26));
                experiment.setUserData(resultSet.getString(27));
                vector.addElement(experiment);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector;
    }

    public int saveExperiment(DB dB) {
        boolean bl = this.exists(dB);
        int n = 0;
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = bl ? dB.prepareStatement("UPDATE EXPERIMENT SET application = ?, name = ?, system_name = ?, system_machine_type = ?, system_arch = ?, system_os = ?, system_memory_size = ?, system_processor_amt = ?, system_l1_cache_size = ?, system_l2_cache_size = ?, system_userdata = ?, compiler_cpp_name = ?, compiler_cpp_version = ?, compiler_cc_name = ?, compiler_cc_version = ?, compiler_java_dirpath = ?, compiler_java_version = ?, compiler_userdata = ?, configure_prefix = ?, configure_arch = ?, configure_cpp = ?, configure_cc = ?, configure_jdk = ?, configure_profile = ?, configure_userdata = ?, userdata = ? WHERE id = ?") : dB.prepareStatement("INSERT INTO EXPERIMENT (application, name, system_name, system_machine_type, system_arch, system_os, system_memory_size, system_processor_amt, system_l1_cache_size, system_l2_cache_size, system_userdata, compiler_cpp_name, compiler_cpp_version, compiler_cc_name, compiler_cc_version, compiler_java_dirpath, compiler_java_version, compiler_userdata, configure_prefix, configure_arch, configure_cpp, configure_cc, configure_jdk, configure_profile, configure_userdata, userdata) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setInt(1, this.applicationID);
            preparedStatement.setString(2, this.name);
            preparedStatement.setString(3, this.systemName);
            preparedStatement.setString(4, this.systemMachineType);
            preparedStatement.setString(5, this.systemArch);
            preparedStatement.setString(6, this.systemOS);
            preparedStatement.setString(7, this.systemMemorySize);
            preparedStatement.setString(8, this.systemProcessorAmount);
            preparedStatement.setString(9, this.systemL1CacheSize);
            preparedStatement.setString(10, this.systemL2CacheSize);
            preparedStatement.setString(11, this.systemUserData);
            preparedStatement.setString(12, this.compilerCppName);
            preparedStatement.setString(13, this.compilerCppVersion);
            preparedStatement.setString(14, this.compilerCcName);
            preparedStatement.setString(15, this.compilerCcVersion);
            preparedStatement.setString(16, this.compilerJavaDirpath);
            preparedStatement.setString(17, this.compilerJavaVersion);
            preparedStatement.setString(18, this.compilerUserData);
            preparedStatement.setString(19, this.configurationPrefix);
            preparedStatement.setString(20, this.configurationArchitecture);
            preparedStatement.setString(21, this.configurationCpp);
            preparedStatement.setString(22, this.configurationCc);
            preparedStatement.setString(23, this.configurationJdk);
            preparedStatement.setString(24, this.configurationProfile);
            preparedStatement.setString(25, this.configurationUserData);
            preparedStatement.setString(26, this.userData);
            if (bl) {
                preparedStatement.setInt(27, this.experimentID);
            }
            preparedStatement.executeUpdate();
            if (bl) {
                n = this.experimentID;
            } else {
                String string = new String();
                if (dB.getDBType().compareTo("mysql") == 0) {
                    string = "select LAST_INSERT_ID();";
                }
                string = dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM experiment" : "select currval('experiment_id_seq');";
                n = Integer.parseInt(dB.getDataItem(string));
            }
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the experiment.");
            sQLException.printStackTrace();
            System.exit(0);
        }
        return n;
    }

    private boolean exists(DB dB) {
        boolean bl = false;
        try {
            PreparedStatement preparedStatement = dB.prepareStatement("SELECT application FROM experiment WHERE id = ?");
            preparedStatement.setInt(1, this.experimentID);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                bl = true;
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the experiment.");
            sQLException.printStackTrace();
            System.exit(0);
        }
        return bl;
    }

    public static void deleteExperiment(DB dB, int n) {
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("delete from experiment where id = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while deleting the experiment.");
            sQLException.printStackTrace();
            System.exit(0);
        }
    }
}

