//
// tardy - a tar post-processor
// Copyright (C) 1998, 1999, 2002, 2008, 2009 Peter Miller
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or (at
// your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program. If not, see <http://www.gnu.org/licenses/>.
//

#include <libtardy/error.h>
#include <libtardy/symtab.h>
#include <libtardy/tar/output/cpio/newascii.h>
#include <libtardy/tar/output/cpio/oldascii.h>
#include <libtardy/tar/output/tar/bsd.h>
#include <libtardy/tar/output/tar/posix.h>
#include <libtardy/tar/output/tar/v7.h>
#include <tardy/ofmt.h>


static tar_output *
output_opener_tar_posix(file_output *fp)
{
    return new tar_output_tar_posix(fp);
}


static tar_output *
output_opener_tar_bsd(file_output *fp)
{
    return new tar_output_tar_bsd(fp);
}


static tar_output *
output_opener_tar_v7(file_output *fp)
{
    return new tar_output_tar_v7(fp);
}


static tar_output *
output_opener_cpio_newascii(file_output *fp)
{
    return new tar_output_cpio_newascii(fp);
}


static tar_output *
output_opener_cpio_oldascii(file_output *fp)
{
    return new tar_output_cpio_oldascii(fp);
}


output_opener_ty
output_opener_by_name(const char *name)
{
    struct table_ty
    {
        const char *name;
        output_opener_ty func;
    };

    static table_ty table[] =
    {
        { "cpio-new-ascii", output_opener_cpio_newascii, },
        { "cpio-newc", output_opener_cpio_newascii, },
        { "cpio-old-ascii", output_opener_cpio_oldascii, },
        { "cpio-oldc", output_opener_cpio_oldascii, },
        { "cpio", output_opener_cpio_newascii, },
        { "gnu", output_opener_tar_posix, },
        { "newascii", output_opener_cpio_newascii, },
        { "newc", output_opener_cpio_newascii, },
        { "oldascii", output_opener_cpio_oldascii, },
        { "oldc", output_opener_cpio_oldascii, },
        { "posix", output_opener_tar_posix, },
        { "tar-bsd", output_opener_tar_bsd, },
        { "tar-posix", output_opener_tar_posix, },
        { "tar-v7", output_opener_tar_v7, },
        { "ustar", output_opener_tar_posix, },
        { "v7", output_opener_tar_v7, },
    };

    static symtab *stp;
    if (!stp)
    {
        stp = new symtab();
        for (table_ty *tp = table; tp < ENDOF(table); ++tp)
            stp->assign(tp->name, (void *)tp->func);
    }

    output_opener_ty result = (output_opener_ty)stp->query(name);
    if (!result)
    {
        rcstring guess = stp->query_fuzzy(name);
        if (guess != "")
        {
            fatal
            (
                  "output format \"%s\" unknown, closest is \"%s\"",
                name,
                guess.to_c_string()
            );
        }
        fatal("output format \"%s\" unknown", name);
    }

    return result;
}
