//
// tardy - a tar post-processor
// Copyright (C) 2002, 2008, 2009 Peter Miller
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or (at
// your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program. If not, see <http://www.gnu.org/licenses/>.
//

#include <libtardy/error.h>
#include <tardy/ifmt.h>
#include <libtardy/symtab.h>
#include <libtardy/tar/input/tar.h>
#include <libtardy/tar/input/filenamelist.h>
#include <libtardy/filenamelist/file.h>
#include <libtardy/filenamelist/filter/progress.h>

static bool progress;


void
ifmt_progress()
{
    progress = true;
}


static tar_input *
input_opener_list(file_input *fp)
{
    filenamelist *fnl = new filenamelist_file(fp);
    if (progress)
        fnl = new filenamelist_filter_progress(fnl);
    return new tar_input_filenamelist(fnl);
}


static tar_input *
input_opener_tar(file_input *fp)
{
    return new tar_input_tar(fp);
}


input_opener_ty
input_opener_by_name(const char *name)
{
    struct table_ty
    {
        const char *name;
        input_opener_ty func;
    };

    static const table_ty table[] =
    {
        { "list", input_opener_list, },
        { "tar", input_opener_tar, },
    };

    static symtab *stp;
    if (!stp)
    {
        stp = new symtab();
        for (const table_ty *tp = table; tp < ENDOF(table); ++tp)
            stp->assign(tp->name, (void *)tp->func);
    }

    input_opener_ty result = (input_opener_ty)stp->query(name);
    if (!result)
    {
        rcstring guess = stp->query_fuzzy(name);
        if (guess != "")
        {
            fatal
            (
                   "input format \"%s\" unknown, closest is \"%s\"",
                name,
                guess.to_c_string()
            );
        }
        fatal("input format \"%s\" unknown", name);
    }

    return result;
}
