//
//      tardy - a tar post-processor
//      Copyright (C) 1998, 1999, 2008, 2009 Peter Miller
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program. If not, see
//      <http://www.gnu.org/licenses/>.
//

#ifndef COMMON_TAR_OUTPUT_LIST_H
#define COMMON_TAR_OUTPUT_LIST_H

#include <libtardy/tar/header.h>
#include <libtardy/tar/output.h>

class tar_output_list: public tar_output
{
         public:
         virtual ~tar_output_list();
         tar_output_list(tar_output *);
         virtual void write_data(const void *, int);
         virtual void write_data_padding();
         virtual void write_header(const tar_header &);
         virtual void write_header_padding();
         virtual const char *filename() const;

         private:
         tar_output *fp;

         tar_output_list();
         tar_output_list(const tar_output_list &);
         tar_output_list &operator = (const tar_output_list &);
};

#endif // COMMON_TAR_OUTPUT_LIST_H
