//
//      tardy - a tar post-processor
//      Copyright (C) 1998, 1999, 2003, 2004, 2008, 2009 Peter Miller
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program. If not, see
//      <http://www.gnu.org/licenses/>.
//

#ifndef COMMON_FILE_OUTPUT_STDOUT_H
#define COMMON_FILE_OUTPUT_STDOUT_H

#include <libtardy/file/output.h>

/**
  * The file_output_normal class is used to represent an output stream
  * writing to the standard output.
  */
class file_output_stdout:
    public file_output
{
public:
    /**
      * The destructor.
      */
    virtual ~file_output_stdout();

    /**
      * The default constructor.
      */
    file_output_stdout();

    // See base class for documentation.
    virtual void write(const void *data, int nbytes);

    // See base class for documentation.
    virtual const char *filename() const;

private:
    /**
      * The copy constructor.  Do not use.
      */
    file_output_stdout(const file_output_stdout &);

    /**
      * The assignment operator.  Do not use.
      */
    file_output_stdout &operator = (const file_output_stdout &);
};

#endif // COMMON_FILE_OUTPUT_STDOUT_H
