//
// tardy - a tar post-processor
// Copyright (C) 1998, 1999, 2003, 2008, 2009 Peter Miller
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or (at
// your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
//

#include <libtardy/ac/fcntl.h>
#include <libtardy/ac/unistd.h>
#include <libtardy/file/output/normal.h>


file_output_normal::~file_output_normal()
{
    if (fd >= 0 && ::close(fd))
        nfatal("close");
}


file_output_normal::file_output_normal(const char *arg) :
    fn(arg),
    fd(-1)
{
    fd = ::creat(arg, 0666);
    if (fd < 0)
        nfatal("open");
}


file_output_normal::file_output_normal(const file_output_normal &arg) :
    file_output(arg),
    fn(arg.fn),
    fd(-1)
{
    fd = dup(arg.fd);
    if (fd < 0)
        nfatal("dup");
}


file_output_normal &
file_output_normal::operator = (const file_output_normal &arg)
{
    if (&arg != this)
    {
        file_output::operator=(arg);
        if (fd >= 0)
            ::close(fd);
        fn = arg.fn;
        fd = dup(arg.fd);
        if (fd < 0)
            nfatal("dup");
    }
    return *this;
}


void
file_output_normal::write(const void *buffer, int nbytes)
{
    int count = ::write(fd, buffer, nbytes);
    if (count < 0)
        nfatal("write");
    if (count != nbytes)
        fatal("short write (gave %d, got %d)", nbytes, count);
}

const char *
file_output_normal::filename()
    const
{
    return fn;
}
