//
//      tardy - a tar post-processor
//      Copyright (C) 1991-1999, 2001, 2002, 2004, 2008, 2009 Peter Miller
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program. If not, see
//      <http://www.gnu.org/licenses/>.
//

#ifndef COMMON_ERROR_H
#define COMMON_ERROR_H

#include <libtardy/main.h>

/**
  * The error function is used to print an error message in the standard
  * output.  The program name will be prepended, and a newline will be
  * appended.
  *
  * \param fmt
  *     The format string for the error message.  See printf(3) for a
  *     description of the format and its arguments.
  */
void error(const char *fmt, ...) ATTR_PRINTF(1, 2);

/**
  * The fatal function is used to print an error message in the standard
  * output and then exit with an exit status of one.  The program name
  * will be prepended, and a newline will be appended.
  *
  * \param fmt
  *     The format string for the error message.  See printf(3) for a
  *     description of the format and its arguments.
  */
void fatal(const char *fmt, ...) ATTR_PRINTF(1, 2);

/**
  * The error function is used to print an error message in the
  * standard output.  The program name will be prepended.  The strerror
  * translation of errno will be appended, plus a newline.
  *
  * \param fmt
  *     The format string for the error message.  See printf(3) for a
  *     description of the format and its arguments.
  */
void nerror(const char *fmt, ...) ATTR_PRINTF(1, 2);

/**
  * The fatal function is used to print an error message in the standard
  * output and then exit with an exit status of one.  The program
  * name will be prepended. The strerror translation of errno will be
  * appended, plus a newline.
  *
  * \param fmt
  *     The format string for the error message.  See printf(3) for a
  *     description of the format and its arguments.
  */
void nfatal(const char *fmt, ...) ATTR_PRINTF(1, 2);

typedef void (*quit_ty)(int);

/**
  * The quit_register function is used to register a call back to be
  * called by the quit function before exit is called.
  */
void quit_register(quit_ty);

/**
  * The quit function is used to exit the program, but any registered
  * quit callbacks will be called first.
  */
void quit(int);

/**
  * The signal_name function is used to translate a signal number into
  * the name of the corresponding signal.
  *
  * \param num
  *     The signal number to be translated.
  */
const char *signal_name(int num);

typedef void (*error_id_ty)(int *, int *);

void error_set_id_func(error_id_ty);

#endif // COMMON_ERROR_H
