/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate tar input mode clearing
 */

#include <tar/input/mode_clear.h>


tar_input_mode_clear::~tar_input_mode_clear()
{
}


tar_input_mode_clear::tar_input_mode_clear(tar_input *arg_fp, long arg_bits)
	: tar_input_filter_base(arg_fp), bits(arg_bits)
{
}


int
tar_input_mode_clear::read_header(tar_header &h)
{
	int ok = tar_input_filter_base::read_header(h);
	if (ok)
	{
		h.mode &= ~bits;

		/* don't clear everything */
		if ((h.mode & 0777) == 0)
			h.mode = 0400;
	}
	return ok;
}


tar_input_mode_clear::tar_input_mode_clear()
{
	fatal("bug %s %d", __FILE__, __LINE__);
}


tar_input_mode_clear::tar_input_mode_clear(const tar_input_mode_clear &)
{
	fatal("bug %s %d", __FILE__, __LINE__);
}


tar_input_mode_clear &
tar_input_mode_clear::operator = (const tar_input_mode_clear &)
{
	fatal("bug %s %d", __FILE__, __LINE__);
	return *this;
}
