/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for common/tar/input/clean.cc
 */

#ifndef COMMON_TAR_INPUT_CLEAN_H
#define COMMON_TAR_INPUT_CLEAN_H

#include <tar/input/filter_base.h>

class tar_input_clean: public tar_input_filter_base
{
	 public:
	 virtual ~tar_input_clean();
	 tar_input_clean(tar_input *, int);
	 virtual int read_header(tar_header &);

	enum
	{
		flag_down = 1,
		flag_print = 2,
		flag_shell = 4,
		flag_space = 8,
		flag_up = 16
	};

	 private:
	 int flag;

	 tar_input_clean();
	 tar_input_clean(const tar_input_clean &);
	 tar_input_clean &operator = (const tar_input_clean &);
};

#endif /* COMMON_TAR_INPUT_CLEAN_H */
