/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999, 2002 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: interface definition for common/file/input/normal.cc
 */

#ifndef COMMON_FILE_INPUT_NORMAL_H
#define COMMON_FILE_INPUT_NORMAL_H

#include <rcstring.h>
#include <file/input.h>

class file_input_normal:
	public file_input
{
public:
	virtual ~file_input_normal();
	file_input_normal(const char *);
	file_input_normal(const file_input_normal &);
	file_input_normal &operator = (const file_input_normal &);
	virtual int read(void *, int) const;
	virtual const char *filename() const;

private:
	rcstring fn;
	int fd;
	file_input_normal();
};

#endif /* COMMON_FILE_INPUT_NORMAL_H */
