const char box_lua[] =
"box.flags = { BOX_RETURN_TUPLE = 0x01, BOX_ADD = 0x02, BOX_REPLACE = 0x04 }\n"
"\n"
"\n"
"\n"
"--\n"
"--\n"
"--\n"
"function box.select_limit(space, index, offset, limit, ...)\n"
"    return box.net.self:select_limit(space, index, offset, limit, ...)\n"
"end\n"
"\n"
"\n"
"--\n"
"--\n"
"--\n"
"function box.select(space, index, ...)\n"
"    return box.net.self:select(space, index, ...)\n"
"end\n"
"\n"
"--\n"
"-- Select a range of tuples in a given namespace via a given\n"
"-- index. If key is NULL, starts from the beginning, otherwise\n"
"-- starts from the key.\n"
"--\n"
"function box.select_range(sno, ino, limit, ...)\n"
"    return box.net.self:select_range(sno, ino, limit, ...)\n"
"end\n"
"\n"
"--\n"
"-- Select a range of tuples in a given namespace via a given\n"
"-- index in reverse order. If key is NULL, starts from the end, otherwise\n"
"-- starts from the key.\n"
"--\n"
"function box.select_reverse_range(sno, ino, limit, ...)\n"
"    return box.net.self:select_reverse_range(sno, ino, limit, ...)\n"
"end\n"
"\n"
"--\n"
"-- delete can be done only by the primary key, whose\n"
"-- index is always 0. It doesn't accept compound keys\n"
"--\n"
"function box.delete(space, ...)\n"
"    return box.net.self:delete(space, ...)\n"
"end\n"
"\n"
"-- insert or replace a tuple\n"
"function box.replace(space, ...)\n"
"    return box.net.self:replace(space, ...)\n"
"end\n"
"\n"
"-- insert a tuple (produces an error if the tuple already exists)\n"
"function box.insert(space, ...)\n"
"    return box.net.self:insert(space, ...)\n"
"end\n"
"\n"
"--\n"
"function box.update(space, key, format, ...)\n"
"    return box.net.self:update(space, key, format, ...)\n"
"end\n"
"\n"
"\n"
"function box.dostring(s, ...)\n"
"    local chunk, message = loadstring(s)\n"
"    if chunk == nil then\n"
"        error(message, 2)\n"
"    end\n"
"    return chunk(...)\n"
"end\n"
"\n"
"function box.bless_space(space)\n"
"    local index_mt = {}\n"
"    -- __len and __index\n"
"    index_mt.len = function(index) return #index.idx end\n"
"    index_mt.__newindex = function(table, index)\n"
"        return error('Attempt to modify a read-only table') end\n"
"    index_mt.__index = index_mt\n"
"    -- min and max\n"
"    index_mt.min = function(index) return index.idx:min() end\n"
"    index_mt.max = function(index) return index.idx:max() end\n"
"    index_mt.random = function(index, rnd) return index.idx:random(rnd) end\n"
"    -- iteration\n"
"    index_mt.iterator = function(index, ...)\n"
"        return index.idx:iterator(...)\n"
"    end\n"
"    --\n"
"    -- pairs/next/prev methods are provided for backward compatibility purposes only\n"
"    index_mt.pairs = function(index)\n"
"        return index.idx.next, index.idx, nil\n"
"    end\n"
"    --\n"
"    local next_compat = function(idx, iterator_type, ...)\n"
"        local arg = {...}\n"
"        if #arg == 1 and type(arg[1]) == \"userdata\" then\n"
"            return idx:next(...)\n"
"        else\n"
"            return idx:next(iterator_type, ...)\n"
"        end\n"
"    end\n"
"    index_mt.next = function(index, ...)\n"
"        return next_compat(index.idx, box.index.GE, ...);\n"
"    end\n"
"    index_mt.prev = function(index, ...)\n"
"        return next_compat(index.idx, box.index.LE, ...);\n"
"    end\n"
"    index_mt.next_equal = function(index, ...)\n"
"        return next_compat(index.idx, box.index.EQ, ...);\n"
"    end\n"
"    index_mt.prev_equal = function(index, ...)\n"
"        return next_compat(index.idx, box.index.REQ, ...);\n"
"    end\n"
"    -- index subtree size\n"
"    index_mt.count = function(index, ...)\n"
"        return index.idx:count(...)\n"
"    end\n"
"    --\n"
"    index_mt.select_range = function(index, limit, ...)\n"
"        local range = {}\n"
"        for v in index:iterator(box.index.GE, ...) do\n"
"            if #range >= limit then\n"
"                break\n"
"            end\n"
"            table.insert(range, v)\n"
"            iterator_state, v = index:next(iterator_state)\n"
"        end\n"
"        return unpack(range)\n"
"    end\n"
"    index_mt.select_reverse_range = function(index, limit, ...)\n"
"        local range = {}\n"
"        for v in index:iterator(box.index.LE, ...) do\n"
"            if #range >= limit then\n"
"                break\n"
"            end\n"
"            table.insert(range, v)\n"
"            iterator_state, v = index:prev(iterator_state)\n"
"        end\n"
"        return unpack(range)\n"
"    end\n"
"    --\n"
"    local space_mt = {}\n"
"    space_mt.len = function(space) return space.index[0]:len() end\n"
"    space_mt.__newindex = index_mt.__newindex\n"
"    space_mt.select = function(space, ...) return box.select(space.n, ...) end\n"
"    space_mt.select_range = function(space, ino, limit, ...)\n"
"        return space.index[ino]:select_range(limit, ...)\n"
"    end\n"
"    space_mt.select_reverse_range = function(space, ino, limit, ...)\n"
"        return space.index[ino]:select_reverse_range(limit, ...)\n"
"    end\n"
"    space_mt.select_limit = function(space, ino, offset, limit, ...)\n"
"        return box.select_limit(space.n, ino, offset, limit, ...)\n"
"    end\n"
"    space_mt.insert = function(space, ...) return box.insert(space.n, ...) end\n"
"    space_mt.update = function(space, ...) return box.update(space.n, ...) end\n"
"    space_mt.replace = function(space, ...) return box.replace(space.n, ...) end\n"
"    space_mt.delete = function(space, ...) return box.delete(space.n, ...) end\n"
"    space_mt.truncate = function(space)\n"
"        local pk = space.index[0]\n"
"        while #pk.idx > 0 do\n"
"            for t in pk:iterator() do\n"
"                local key = {};\n"
"                -- ipairs does not work because pk.key_field is zero-indexed\n"
"                for _k2, key_field in pairs(pk.key_field) do\n"
"                    table.insert(key, t[key_field.fieldno])\n"
"                end\n"
"                space:delete(unpack(key))\n"
"            end\n"
"        end\n"
"    end\n"
"    space_mt.pairs = function(space) return space.index[0]:pairs() end\n"
"    space_mt.__index = space_mt\n"
"\n"
"    setmetatable(space, space_mt)\n"
"    if type(space.index) == 'table' and space.enabled then\n"
"        for j, index in pairs(space.index) do\n"
"            rawset(index, 'idx', box.index.new(space.n, j))\n"
"            setmetatable(index, index_mt)\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"-- User can redefine the hook\n"
"function box.on_reload_configuration()\n"
"end\n"
"\n"
"require(\"bit\")\n"
"\n"
"-- vim: set et ts=4 sts\n"
""
;
