/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_PRESENCE_H__
#define __TPA_PRESENCE_H__

#include <tapioca/base/tpa-errors.h>

G_BEGIN_DECLS

typedef struct _TpaIPresence TpaIPresence;
typedef struct _TpaIPresencePrivate TpaIPresencePrivate;

struct _TpaIPresence {
    GTypeInterface parent;

    TpaError    (* add_status)              (GObject *obj,
                                             const gchar *status,
                                             GHashTable *parms);
    TpaError    (* clear_status)            (GObject *obj);
    TpaError    (* get_statuses)            (GObject *obj,
                                             GHashTable **ret);
    TpaError    (* request_presence)        (GObject *obj,
                                             const gchar *contact);
    TpaError    (* remove_status)           (GObject *obj,
                                             const gchar *status);
    TpaError    (* set_last_activity_time)  (GObject *obj,
                                             guint time);
    TpaError    (* set_status)              (GObject *obj,
                                             GHashTable *statuses);
    TpaIPresencePrivate *priv;
};

/* TYPE MACROS */
#define TPA_TYPE_IPRESENCE \
    (tpa_presence_get_type ())
#define TPA_IS_IPRESENCE(obj) \
    (g_type_is_a (G_OBJECT_TYPE(obj), TPA_TYPE_IPRESENCE))
#define TPA_IPRESENCE(obj) \
    (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TPA_TYPE_IPRESENCE, TpaIPresence))

GType       tpa_presence_get_type               (void);
void        tpa_presence_init                   (TpaIPresence *iface,
                                                 gpointer data);
void        tpa_presence_finalize               (GObject *obj);
gboolean    tpa_presence_update                 (GObject *obj,
                                                 const gchar *contact,
                                                 const gchar *status,
                                                 const gchar *message);
void        tpa_presence_signal_presence_update (GObject *obj);

G_END_DECLS

#endif /* #ifndef __TPA_PRESENCE_H__*/
