/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Abner Jose de Faria Silva <abner.silva@indt.org.br>
 * @author  Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_TEXT_CHANNEL_H__
#define __TPA_TEXT_CHANNEL_H__

#include <glib.h>
#include <glib-object.h>

#include <tapioca/client/tpa-channel.h>
#include <tapioca/client/tpa-text-message.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_TEXT_CHANNEL \
    (tpa_text_channel_get_type())
#define TPA_TEXT_CHANNEL(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_TEXT_CHANNEL, TpaTextChannel))
#define TPA_TEXT_CHANNEL_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_TEXT_CHANNEL, TpaTextChannelClass))
#define TPA_IS_TEXT_CHANNEL(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_TEXT_CHANNEL))
#define TPA_IS_TEXT_CHANNEL_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_TEXT_CHANNEL))
#define TPA_TEXT_CHANNEL_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_TEXT_CHANNEL, TpaTextChannelClass))
#define TPA_TEXT_CHANNEL_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_TEXT_CHANNEL, TpaTextChannelPrivate))


typedef struct _TpaTextChannel TpaTextChannel;
typedef struct _TpaTextChannelClass TpaTextChannelClass;
typedef struct _TpaTextChannelPrivate TpaTextChannelPrivate;

struct _TpaTextChannelClass {
    TpaChannelClass parent_class;
};

struct _TpaTextChannel {
    TpaChannel parent;
    TpaTextChannelPrivate *priv;
};

GType               tpa_text_channel_get_type           (void);
void                tpa_text_channel_send               (TpaTextChannel *self,
                                                         const gchar *contents,
                                                         TpaTextMessageType type);
#define             tpa_text_channel_send_normal(self, contents) \
    (tpa_text_channel_send (self, contents, TPA_MESSAGE_TYPE_NORMAL))
#define             tpa_text_channel_send_action(self, contents) \
    (tpa_text_channel_send (self, contents, TPA_MESSAGE_TYPE_ACTION))
#define             tpa_text_channel_send_notice(self, contents) \
    (tpa_text_channel_send (self, contents, TPA_MESSAGE_TYPE_NOTICE))
#define             tpa_text_channel_send_auto_reply(self, contents) \
    (tpa_text_channel_send (self, contents, TPA_MESSAGE_TYPE_AUTO_REPLY))
void                tpa_text_channel_send_message       (TpaTextChannel *self,
                                                         TpaTextMessage *message);
GPtrArray *         tpa_text_channel_get_messages       (TpaTextChannel *self,
                                                         guint messages,
                                                         TpaTextMessageType type);
#define             tpa_text_channel_get_normal_messages(self, messages) \
    (tpa_text_channel_get_messages (self, messages, TPA_MESSAGE_TYPE_NORMAL))
#define             tpa_text_channel_get_action_messages(self, messages) \
    (tpa_text_channel_get_messages (self, messages, TPA_MESSAGE_TYPE_ACTION))
#define             tpa_text_channel_get_notice_messages(self, messages) \
    (tpa_text_channel_get_messages (self, messages, TPA_MESSAGE_TYPE_NOTICE))
#define             tpa_text_channel_get_auto_reply_messages(self, messages) \
    (tpa_text_channel_get_messages (self, messages, TPA_MESSAGE_TYPE_AUTO_REPLY))
#define             tpa_text_channel_get_error_messages(self, messages) \
    (tpa_text_channel_get_messages (self, messages, TPA_MESSAGE_TYPE_ERROR))
#define             tpa_text_channel_get_all_messages(self, messages) \
    (tpa_text_channel_get_messages (self, messages, TPA_MESSAGE_TYPE_ANY))
void                tpa_text_channel_set_log_size       (TpaTextChannel *self,
                                                         guint log_size);
guint               tpa_text_channel_get_log_size       (TpaTextChannel *self);
void                tpa_text_channel_acknowledge_message(TpaTextChannel *self,
                                                         TpaTextMessage *message);
GPtrArray *         tpa_text_channel_get_pending        (TpaTextChannel *self,
                                                         gboolean acknowledge);
gboolean            tpa_text_channel_set_local_chat_state (TpaTextChannel *self,
                                                           TpaChatState state);
TpaChatState        tpa_text_channel_get_local_chat_state (TpaTextChannel *self);

G_END_DECLS

#endif /* #ifndef __TPA_TEXT_CHANNEL_H__*/
