/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 * @author  Marcio Macedo <marcio.macedo@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_ENUMS_H__
#define __TPA_ENUMS_H__

/* Connection status */
typedef enum {
    TPA_CONNECTION_STATUS_CONNECTED = 0,
    TPA_CONNECTION_STATUS_CONNECTING = 1,
    TPA_CONNECTION_STATUS_DISCONNECTED = 2,
    TPA_CONNECTION_STATUS_LAST = TPA_CONNECTION_STATUS_DISCONNECTED
} TpaConnectionStatus;

/* Connection status reason */
typedef enum {
    TPA_CONNECTION_STATUS_REASON_NONE_SPECIFIED = 0,
    TPA_CONNECTION_STATUS_REASON_REQUESTED,
    TPA_CONNECTION_STATUS_REASON_NETWORK_ERROR,
    TPA_CONNECTION_STATUS_REASON_AUTHENTICATION_FAILED,
    TPA_CONNECTION_STATUS_REASON_ENCRYPTION_ERROR,
    TPA_CONNECTION_STATUS_REASON_NAME_IN_USE,
    TPA_CONNECTION_STATUS_REASON_CERT_NOT_PROVIDED,
    TPA_CONNECTION_STATUS_REASON_CERT_UNTRUSTED,
    TPA_CONNECTION_STATUS_REASON_CERT_EXPIRED,
    TPA_CONNECTION_STATUS_REASON_CERT_NOT_ACTIVATED,
    TPA_CONNECTION_STATUS_REASON_CERT_HOSTNAME_MISMATCH,
    TPA_CONNECTION_STATUS_REASON_CERT_FINGERPRINT_MISMATCH,
    TPA_CONNECTION_STATUS_REASON_CERT_this_SIGNED,
    TPA_CONNECTION_STATUS_REASON_CERT_OTHER_ERROR,
    TPA_CONNECTION_STATUS_REASON_LAST = TPA_CONNECTION_STATUS_REASON_CERT_OTHER_ERROR
} TpaConnectionStatusReason;

/* Contacts capabilities */
typedef enum {
    TPA_CAPABILITY_NONE = 0,
    TPA_CAPABILITY_TEXT = 1 << 0,
    TPA_CAPABILITY_AUDIO = 1 << 1,
    TPA_CAPABILITY_VIDEO = 1 << 2,
    TPA_CAPABILITY_ALL = 255
} TpaCapability;

/* Contacts presence status */
typedef enum {
    TPA_PRESENCE_OFFLINE = 1,
    TPA_PRESENCE_AVAILABLE = 2,
    TPA_PRESENCE_AWAY = 3,
    TPA_PRESENCE_XA = 4,
    TPA_PRESENCE_HIDDEN = 5,
    TPA_PRESENCE_BUSY = 6
} TpaContactPresence;

/* Contact subscription status */
typedef enum {
    TPA_SUBSCRIPTION_STATUS_NONE = 0,
    TPA_SUBSCRIPTION_STATUS_REMOTE_PENDING = 1,
    TPA_SUBSCRIPTION_STATUS_LOCAL_PENDING = 2,
    TPA_SUBSCRIPTION_STATUS_CURRENT = 3
} TpaSubscriptionStatus;

/* Contact authorization status */
typedef enum {
    TPA_AUTHORIZATION_STATUS_NON_EXISTENT = 0,
    TPA_AUTHORIZATION_STATUS_LOCAL_PENDING = 1,
    TPA_AUTHORIZATION_STATUS_AUTHORIZED = 2
} TpaAuthorizationStatus;

/* Channel types */
typedef enum {
    TPA_CHANNEL_TYPE_TEXT = 0,
    TPA_CHANNEL_TYPE_STREAM,
} TpaChannelType;

/* Stream types */
typedef enum {
    TPA_STREAM_TYPE_AUDIO = 0,
    TPA_STREAM_TYPE_VIDEO = 1,
} TpaStreamType;

/* Stream state*/
typedef enum {
    TPA_STREAM_STATE_PAUSED = 0,
    TPA_STREAM_STATE_CONNECTING = 1,
    TPA_STREAM_STATE_PLAYING = 2,
} TpaStreamState;

typedef enum {
    TPA_MESSAGE_TYPE_NORMAL = 0,
    TPA_MESSAGE_TYPE_ACTION = 1,
    TPA_MESSAGE_TYPE_NOTICE = 2,
    TPA_MESSAGE_TYPE_AUTO_REPLY = 3,
    TPA_MESSAGE_TYPE_ERROR = 4,
    TPA_MESSAGE_TYPE_ANY = 5
} TpaTextMessageType;

typedef enum {
    TPA_MESSAGE_DELIVERY_ERROR_UNKNOWN = 0,
    TPA_MESSAGE_DELIVERY_ERROR_CONTACT_OFFLINE = 1,
    TPA_MESSAGE_DELIVERY_ERROR_INVALID_CONTACT = 2,
    TPA_MESSAGE_DELIVERY_ERROR_PERMISSION_DENIED = 3,
    TPA_MESSAGE_DELIVERY_ERROR_MESSAGE_TOO_LONG = 4
} TpaTextMessageDeliveryError;

typedef enum {
    TPA_CHAT_STATE_GONE = 0,
    TPA_CHAT_STATE_INACTIVE = 1,
    TPA_CHAT_STATE_ACTIVE = 2,
    TPA_CHAT_STATE_PAUSED = 3,
    TPA_CHAT_STATE_COMPOSING = 4
} TpaChatState;

/* Handle types */
typedef enum {
    TPA_HANDLE_TYPE_NONE = 0,
    TPA_HANDLE_TYPE_CONTACT = 1,
    TPA_HANDLE_TYPE_ROOM = 2,
    TPA_HANDLE_TYPE_LIST = 3
} TpaHandleType;

typedef enum {
    TPA_PARAMETER_FLAGS_NONE = 0,
    TPA_PARAMETER_FLAGS_REQUIRED = 1 << 0,
    TPA_PARAMETER_FLAGS_REGISTER = 1 << 1,
    TPA_PARAMETER_FLAGS_DEFAULT = 1 << 2,
    TPA_PARAMETER_FLAGS_ALL = 255
} TpaParameterFlags;

#define TPA_INTERFACE_CM             "org.freedesktop.Telepathy.ConnectionManager"
#define TPA_INTERFACE_CONNECTION     "org.freedesktop.Telepathy.Connection"
#define TPA_INTERFACE_ALIASING       "org.freedesktop.Telepathy.Connection.Interface.Aliasing"
#define TPA_INTERFACE_AVATARS        "org.freedesktop.Telepathy.Connection.Interface.Avatars"
#define TPA_INTERFACE_CAPABILITIES   "org.freedesktop.Telepathy.Connection.Interface.Capabilities"
#define TPA_INTERFACE_CONTACT_INFO   "org.freedesktop.Telepathy.Connection.Interface.ContactInfo"
#define TPA_INTERFACE_FORWARD        "org.freedesktop.Telepathy.Connection.Interface.Forwarding"
#define TPA_INTERFACE_PRESENCE       "org.freedesktop.Telepathy.Connection.Interface.Presence"
#define TPA_INTERFACE_PRIVACY        "org.freedesktop.Telepathy.Connection.Interface.Privacy"
#define TPA_INTERFACE_RENAMING       "org.freedesktop.Telepathy.Connection.Interface.Renaming"
#define TPA_INTERFACE_CHANNEL        "org.freedesktop.Telepathy.Channel"
#define TPA_INTERFACE_CONTACT_LIST   "org.freedesktop.Telepathy.Channel.Type.ContactList"
#define TPA_INTERFACE_LIST_SUBSCRIBE "org.freedesktop.Telepathy.Channel.Type.ContactList:Subscribe"
#define TPA_INTERFACE_LIST_PUBLISH   "org.freedesktop.Telepathy.Channel.Type.ContactList:Publish"
#define TPA_INTERFACE_LIST_HIDE      "org.freedesktop.Telepathy.Channel.Type.ContactList:Hide"
#define TPA_INTERFACE_LIST_DENY      "org.freedesktop.Telepathy.Channel.Type.ContactList:Deny"
#define TPA_INTERFACE_CONTACT_SEARCH "org.freedesktop.Telepathy.Channel.Type.ContactSearch"
#define TPA_INTERFACE_STREAMED_MEDIA "org.freedesktop.Telepathy.Channel.Type.StreamedMedia"
#define TPA_INTERFACE_ROOM_LIST      "org.freedesktop.Telepathy.Channel.Type.RoomList"
#define TPA_INTERFACE_TEXT           "org.freedesktop.Telepathy.Channel.Type.Text"
#define TPA_INTERFACE_DTMF           "org.freedesktop.Telepathy.Channel.Interface.DTMF"
#define TPA_INTERFACE_GROUP          "org.freedesktop.Telepathy.Channel.Interface.Group"
#define TPA_INTERFACE_HOLD           "org.freedesktop.Telepathy.Channel.Interface.Hold"
#define TPA_INTERFACE_PASSWORD       "org.freedesktop.Telepathy.Channel.Interface.Password"
#define TPA_INTERFACE_TRANSFER       "org.freedesktop.Telepathy.Channel.Interface.Transfer"
#define TPA_INTERFACE_CHATSTATE      "org.freedesktop.Telepathy.Channel.Interface.ChatState"
#define TPA_INTERFACE_SESSION_HANDLER "org.freedesktop.Telepathy.Media.SessionHandler"
#define TPA_INTERFACE_STREAM_HANDLER "org.freedesktop.Telepathy.Media.StreamHandler"
#define TPA_INTERFACE_PROPERTIES     "org.freedesktop.Telepathy.Properties"

#endif /* #ifndef __TPA_ENUMS_H__*/
