/*----- PROTECTED REGION ID(DataBase.h) ENABLED START -----*/
//=============================================================================
//
// file :        DataBase.h
//
// description : Include for the DataBase class.
//
// project :     TANGO Database server.
//
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010,2011,2012,2013
//						European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#ifndef DATABASE_H
#define DATABASE_H

#include <cmake_config.h>

#include <tango/tango.h>
#include <mysql.h>
#include "update_starter.h"

#if !defined(LIBMARIADB) && !defined(MARIADB_BASE_VERSION)
#if MYSQL_VERSION_ID >= 80001 && MYSQL_VERSION_ID != 80002
typedef bool my_bool;
#endif
#endif

#define DB_SQLError 				"DB_SQLError"
#define DB_IncorrectArguments		"DB_IncorrectArguments"
#define DB_IncorrectDeviceName		"DB_IncorrectDeviceName"
#define DB_IncorrectServerName		"DB_IncorrectServerName"
#define DB_DeviceNotDefined			"DB_DeviceNotDefined"
#define DB_AliasNotDefined			"DB_AliasNotDefined"
#define	DB_NoFreeMySQLConnection	"DB_NoFreeMySQLConnection"
#define	DB_MySQLLibNotThreadSafe	"DB_MySQLLibNotThreadSafe"
#define DB_ParseStringError       "DB_ParseStringError"

#define	STARTER_DEVNAME_DOMAIN		"tango"
#define	STARTER_DEVNAME_FAMILY		"/admin/"

#define	DEFAULT_CONN_POOL_SIZE		20

//	Define time measuremnt type (depends on OS)
#ifndef WIN32

#	define	TimeVal	struct timeval
#	define	GetTime(t)	gettimeofday(&t, NULL);
#	define	Elapsed(before, after)	\
		1000.0*(after.tv_sec-before.tv_sec) + \
		((double)after.tv_usec-before.tv_usec) / 1000

#else

static LARGE_INTEGER	cpu_freq;
#	define	TimeVal	LARGE_INTEGER
#	define	GetTime(t)	w_gettimeofday(&t);
#	define	Elapsed(before, after)		\
		(cpu_freq.QuadPart==0) ? 0.0 :	\
			(double) (after.QuadPart - before.QuadPart)/cpu_freq.QuadPart * 1000;

#endif	/*	WIN32		*/

#ifndef  _TG_WINDOWS_
/* Struct to keep in the thread local store the client's address */
struct Value_t : public omni_thread::value_t {
	Value_t(const char *s) : addr(s) {}
	std::string addr;
};

#define MIN_TRANSPORT_STRING_LENGTH 8 /* giop:fd: */
#endif

/*----- PROTECTED REGION END -----*/	//	DataBase.h

/**
 *  DataBase class description:
 *    This class manage the TANGO database.
 */

namespace DataBase_ns
{
/*----- PROTECTED REGION ID(DataBase::Additional Class Declarations) ENABLED START -----*/

		//		Additional Class Declarations
class DummyDev: public Tango::Connection
{
public:
	DummyDev():Tango::Connection(true) {};

	virtual std::string get_corba_name(bool) {std::string str;return str;}
	virtual std::string build_corba_name() {std::string str;return str;}
	virtual int get_lock_ctr() {return 0;}
	virtual void set_lock_ctr(int) {};

	virtual std::string dev_name() {std::string str;return str;}

	int get_env_var(const char *cc,std::string &str_ref) {return Tango::Connection::get_env_var(cc,str_ref);}
};

	/*----- PROTECTED REGION END -----*/	//	DataBase::Additional Class Declarations

class DataBase : public TANGO_BASE_CLASS
{

/*----- PROTECTED REGION ID(DataBase::Data Members) ENABLED START -----*/

	//		Add your own data members
public:
	/**
	 *	current incarnation of database
	 */
	static std::string db_name;

	/**
	 *	Will be set by property of Default object
	 */
	bool	fireToStarter;

	/**
	 *	Database value history depth
	 */
	int	historyDepth;

	/**
	 *	Shared data for update starter thread
	 */
	UpdStarterData	*starter_shared;
	/**
	 *	update starter thread instance
	 */
	UpdateStarter	*upd_starter_thread;

	/*
	 * timing related variables
	 */
	typedef struct timing_stats_struct
	{
		double calls;
		double total_elapsed;
		double average;
		double minimum;
		double maximum;
	} TimingStatsStruct;

	std::map<std::string,TimingStatsStruct*> timing_stats_map;

	int timing_stats_size;
	double *timing_stats_average;
	double *timing_stats_minimum;
	double *timing_stats_maximum;
	double *timing_stats_calls;
	char **timing_stats_index;

	/*
	 * For the DbGetDeviceAttributeProperty2 command
	 */

	typedef struct prop_def
	{
		std::string			prop_name;
		std::string 			prop_name_cd;
		std::vector<std::string>	prop_val;
	} PropDef;

private:
	std::string mysql_db_name{TANGO_DB_NAME};

	/*----- PROTECTED REGION END -----*/	//	DataBase::Data Members


//	Attribute data members
public:
	Tango::DevString	*attr_StoredProcedureRelease_read;
	Tango::DevDouble	*attr_Timing_average_read;
	Tango::DevDouble	*attr_Timing_minimum_read;
	Tango::DevDouble	*attr_Timing_maximum_read;
	Tango::DevDouble	*attr_Timing_calls_read;
	Tango::DevString	*attr_Timing_index_read;
	Tango::DevString	*attr_Timing_info_read;

//	Constructors and destructors
public:
	/**
	 * Constructs a newly device object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device Name
	 */
	DataBase(Tango::DeviceClass *cl,std::string &s);
	/**
	 * Constructs a newly device object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device Name
	 */
	DataBase(Tango::DeviceClass *cl,const char *s);
	/**
	 * Constructs a newly device object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device name
	 *	@param d	Device description.
	 */
	DataBase(Tango::DeviceClass *cl,const char *s,const char *d);
	/**
	 * The device object destructor.
	 */
	~DataBase() {delete_device();};


//	Miscellaneous methods
public:
	/*
	 *	will be called at device destruction or at init command.
	 */
	void delete_device();
	/*
	 *	Initialize the device
	 */
	virtual void init_device();
	/*
	 *	Always executed method before execution command method.
	 */
	virtual void always_executed_hook();


//	Attribute methods
public:
	//--------------------------------------------------------
	/*
	 *	Method      : DataBase::read_attr_hardware()
	 *	Description : Hardware acquisition for attributes.
	 */
	//--------------------------------------------------------
	virtual void read_attr_hardware(std::vector<long> &attr_list);

/**
 *	Attribute StoredProcedureRelease related methods
 *	Description: 
 *
 *	Data type:	Tango::DevString
 *	Attr type:	Scalar
 */
	virtual void read_StoredProcedureRelease(Tango::Attribute &attr);
	virtual bool is_StoredProcedureRelease_allowed(Tango::AttReqType type);
/**
 *	Attribute Timing_average related methods
 *	Description: 
 *
 *	Data type:	Tango::DevDouble
 *	Attr type:	Spectrum max = 64
 */
	virtual void read_Timing_average(Tango::Attribute &attr);
	virtual bool is_Timing_average_allowed(Tango::AttReqType type);
/**
 *	Attribute Timing_minimum related methods
 *	Description: 
 *
 *	Data type:	Tango::DevDouble
 *	Attr type:	Spectrum max = 64
 */
	virtual void read_Timing_minimum(Tango::Attribute &attr);
	virtual bool is_Timing_minimum_allowed(Tango::AttReqType type);
/**
 *	Attribute Timing_maximum related methods
 *	Description: 
 *
 *	Data type:	Tango::DevDouble
 *	Attr type:	Spectrum max = 64
 */
	virtual void read_Timing_maximum(Tango::Attribute &attr);
	virtual bool is_Timing_maximum_allowed(Tango::AttReqType type);
/**
 *	Attribute Timing_calls related methods
 *	Description: 
 *
 *	Data type:	Tango::DevDouble
 *	Attr type:	Spectrum max = 64
 */
	virtual void read_Timing_calls(Tango::Attribute &attr);
	virtual bool is_Timing_calls_allowed(Tango::AttReqType type);
/**
 *	Attribute Timing_index related methods
 *	Description: 
 *
 *	Data type:	Tango::DevString
 *	Attr type:	Spectrum max = 64
 */
	virtual void read_Timing_index(Tango::Attribute &attr);
	virtual bool is_Timing_index_allowed(Tango::AttReqType type);
/**
 *	Attribute Timing_info related methods
 *	Description: 
 *
 *	Data type:	Tango::DevString
 *	Attr type:	Spectrum max = 64
 */
	virtual void read_Timing_info(Tango::Attribute &attr);
	virtual bool is_Timing_info_allowed(Tango::AttReqType type);


	//--------------------------------------------------------
	/**
	 *	Method      : DataBase::add_dynamic_attributes()
	 *	Description : Add dynamic attributes if any.
	 */
	//--------------------------------------------------------
	void add_dynamic_attributes();




//	Command related methods
public:
	/**
	 *	Command State related method
	 *	Description: This command gets the device state (stored in its <i>device_state</i> data member) and returns it to the caller.
	 *
	 *	@returns State Code
	 */
	virtual Tango::DevState dev_state();
	/**
	 *	Command DbAddDevice related method
	 *	Description: Add a Tango class device to a specific device server
	 *
	 *	@param argin Str[0] = Full device server process name
	 *               Str[1] = Device name
	 *               Str[2] = Tango class name
	 */
	virtual void db_add_device(const Tango::DevVarStringArray *argin);
	virtual bool is_DbAddDevice_allowed(const CORBA::Any &any);
	/**
	 *	Command DbAddServer related method
	 *	Description: Create a device server process entry in database
	 *
	 *	@param argin Str[0] = Full device server name
	 *               Str[1] = Device(s) name
	 *               Str[2] = Tango class name
	 *               Str[n] = Device name
	 *               Str[n + 1] = Tango class name
	 */
	virtual void db_add_server(const Tango::DevVarStringArray *argin);
	virtual bool is_DbAddServer_allowed(const CORBA::Any &any);
	/**
	 *	Command DbDeleteAttributeAlias related method
	 *	Description: Delete an attribute alias.
	 *
	 *	@param argin Attriibute alias name.
	 */
	virtual void db_delete_attribute_alias(Tango::DevString argin);
	virtual bool is_DbDeleteAttributeAlias_allowed(const CORBA::Any &any);
	/**
	 *	Command DbDeleteClassAttribute related method
	 *	Description: delete a class attribute and all its properties from database
	 *
	 *	@param argin Str[0] = Tango class name
	 *               Str[1] = Attribute name
	 */
	virtual void db_delete_class_attribute(const Tango::DevVarStringArray *argin);
	virtual bool is_DbDeleteClassAttribute_allowed(const CORBA::Any &any);
	/**
	 *	Command DbDeleteClassAttributeProperty related method
	 *	Description: delete class attribute properties from database
	 *
	 *	@param argin Str[0] = Tango class name
	 *               Str[1] = Attribute name
	 *               Str[2] = Property name
	 *               Str[n] = Property name
	 */
	virtual void db_delete_class_attribute_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbDeleteClassAttributeProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbDeleteClassProperty related method
	 *	Description: Delete class properties from database
	 *
	 *	@param argin Str[0] = Tango class name
	 *               Str[1] = Property name
	 *               Str[n] = Property name
	 */
	virtual void db_delete_class_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbDeleteClassProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbDeleteDevice related method
	 *	Description: Delete a device from database
	 *
	 *	@param argin device name
	 */
	virtual void db_delete_device(Tango::DevString argin);
	virtual bool is_DbDeleteDevice_allowed(const CORBA::Any &any);
	/**
	 *	Command DbDeleteDeviceAlias related method
	 *	Description: Delete a device alias.
	 *
	 *	@param argin device alias name
	 */
	virtual void db_delete_device_alias(Tango::DevString argin);
	virtual bool is_DbDeleteDeviceAlias_allowed(const CORBA::Any &any);
	/**
	 *	Command DbDeleteDeviceAttribute related method
	 *	Description: Delete  device attribute properties from database
	 *
	 *	@param argin Str[0] = Device name
	 *               Str[1] = Attribute name
	 */
	virtual void db_delete_device_attribute(const Tango::DevVarStringArray *argin);
	virtual bool is_DbDeleteDeviceAttribute_allowed(const CORBA::Any &any);
	/**
	 *	Command DbDeleteDeviceAttributeProperty related method
	 *	Description: delete a device attribute property from the database
	 *
	 *	@param argin Str[0] = Device name
	 *               Str[1] = Attribute name
	 *               Str[2] = Property name
	 *               Str[n] = Property name
	 */
	virtual void db_delete_device_attribute_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbDeleteDeviceAttributeProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbDeleteDeviceProperty related method
	 *	Description: Delete device property(ies)
	 *
	 *	@param argin Str[0] = Device name
	 *               Str[1] = Property name
	 *               Str[n] = Property name
	 */
	virtual void db_delete_device_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbDeleteDeviceProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbDeleteProperty related method
	 *	Description: Delete free property from database
	 *
	 *	@param argin Str[0]  = Object name
	 *               Str[1] = Property name
	 *               Str[n] = Property name
	 */
	virtual void db_delete_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbDeleteProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbDeleteServer related method
	 *	Description: Delete server from the database but dont delete device properties
	 *
	 *	@param argin Device server name
	 */
	virtual void db_delete_server(Tango::DevString argin);
	virtual bool is_DbDeleteServer_allowed(const CORBA::Any &any);
	/**
	 *	Command DbDeleteServerInfo related method
	 *	Description: delete info related to a Tango devvice server process
	 *
	 *	@param argin Device server name
	 */
	virtual void db_delete_server_info(Tango::DevString argin);
	virtual bool is_DbDeleteServerInfo_allowed(const CORBA::Any &any);
	/**
	 *	Command DbExportDevice related method
	 *	Description: Export a device to the database
	 *
	 *	@param argin Str[0] = Device name
	 *               Str[1] = CORBA IOR
	 *               Str[2] = Device server process host name
	 *               Str[3] = Device server process PID or string ``null``
	 *               Str[4] = Device server process version
	 */
	virtual void db_export_device(const Tango::DevVarStringArray *argin);
	virtual bool is_DbExportDevice_allowed(const CORBA::Any &any);
	/**
	 *	Command DbExportEvent related method
	 *	Description: Export Event channel to database
	 *
	 *	@param argin Str[0] = event channel name (or factory name)
	 *               Str[1] = CORBA IOR
	 *               Str[2] = Notifd host name
	 *               Str[3] = Notifd pid
	 *               Str[4] = Notifd version
	 */
	virtual void db_export_event(const Tango::DevVarStringArray *argin);
	virtual bool is_DbExportEvent_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetAliasDevice related method
	 *	Description: Get device name from its alias.
	 *
	 *	@param argin Alias name
	 *	@returns Device name
	 */
	virtual Tango::DevString db_get_alias_device(Tango::DevString argin);
	virtual bool is_DbGetAliasDevice_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetAttributeAlias related method
	 *	Description: Get the attribute name for the given alias.
	 *               If alias not found in database, returns an empty string.
	 *
	 *	@param argin The attribute alias name
	 *	@returns The attribute name (device/attribute)
	 */
	virtual Tango::DevString db_get_attribute_alias(Tango::DevString argin);
	virtual bool is_DbGetAttributeAlias_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetAttributeAliasList related method
	 *	Description: Get attribute alias list for a specified filter
	 *
	 *	@param argin attribute alias filter string (eg: att*)
	 *	@returns attribute aliases
	 */
	virtual Tango::DevVarStringArray *db_get_attribute_alias_list(Tango::DevString argin);
	virtual bool is_DbGetAttributeAliasList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetClassAttributeList related method
	 *	Description: Get attrilute list for a given Tango class with a specified filter
	 *
	 *	@param argin Str[0] = Tango class name
	 *               Str[1] = Attribute name filter (eg: att*)
	 *	@returns Str[0] = Class attribute name
	 *           Str[n] = Class attribute name
	 */
	virtual Tango::DevVarStringArray *db_get_class_attribute_list(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetClassAttributeList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetClassAttributeProperty related method
	 *	Description: Get Tango class property(ies) value
	 *
	 *	@param argin Str[0] = Tango class name
	 *               Str[1] = Attribute name
	 *               Str[n] = Attribute name
	 *	@returns Str[0] = Tango class name
	 *           Str[1] = Attribute property  number
	 *           Str[2] = Attribute property 1 name
	 *           Str[3] = Attribute property 1 value
	 *           Str[n + 1] = Attribute property 2 name
	 *           Str[n + 2] = Attribute property 2 value
	 */
	virtual Tango::DevVarStringArray *db_get_class_attribute_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetClassAttributeProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetClassAttributeProperty2 related method
	 *	Description: This command supports array property compared to the old command called
	 *               DbGetClassAttributeProperty. The old command has not been deleted from the
	 *               server for compatibility reasons.
	 *
	 *	@param argin Str[0] = Tango class name
	 *               Str[1] = Attribute name
	 *               Str[n] = Attribute name
	 *	@returns Str[0] = Tango class name
	 *           Str[1] = Attribute property  number
	 *           Str[2] = Attribute property 1 name
	 *           Str[3] = Attribute property 1 value number (array case)
	 *           Str[4] = Attribute property 1 value
	 *           Str[n] = Attribute property 1 value (array case)
	 *           Str[n + 1] = Attribute property 2 name
	 *           Str[n + 2] = Attribute property 2 value number (array case)
	 *           Str[n + 3] = Attribute property 2 value
	 *           Str[n + m] = Attribute property 2 value (array case)
	 */
	virtual Tango::DevVarStringArray *db_get_class_attribute_property2(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetClassAttributeProperty2_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetClassAttributePropertyHist related method
	 *	Description: Retrieve Tango class attribute property history
	 *
	 *	@param argin Str[0] = Tango class
	 *               Str[1] = Attribute name
	 *               Str[2] = Property name
	 *	@returns Str[0] = Attribute name
	 *           Str[1] = Property name
	 *           Str[2] = date
	 *           Str[3] = Property value number (array case)
	 *           Str[4] = Property value 1
	 *           Str[n] = Property value n
	 */
	virtual Tango::DevVarStringArray *db_get_class_attribute_property_hist(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetClassAttributePropertyHist_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetClassForDevice related method
	 *	Description: Get Tango class for the specified device.
	 *
	 *	@param argin Device name
	 *	@returns Device Tango class
	 */
	virtual Tango::DevString db_get_class_for_device(Tango::DevString argin);
	virtual bool is_DbGetClassForDevice_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetClassInheritanceForDevice related method
	 *	Description: Get class inheritance for the specified device.
	 *
	 *	@param argin Device name
	 *	@returns Classes off the specified device.
	 *           [0] - is the class of the device.
	 *           [1] - is the class from the device class is inherited.
	 *           ........and so on
	 */
	virtual Tango::DevVarStringArray *db_get_class_inheritance_for_device(Tango::DevString argin);
	virtual bool is_DbGetClassInheritanceForDevice_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetClassList related method
	 *	Description: Get Tango class list with a specified filter
	 *
	 *	@param argin Filter
	 *	@returns Class list
	 */
	virtual Tango::DevVarStringArray *db_get_class_list(Tango::DevString argin);
	virtual bool is_DbGetClassList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetClassProperty related method
	 *	Description: 
	 *
	 *	@param argin Str[0] = Tango class
	 *               Str[1] = Property name
	 *               Str[2] = Property name
	 *	@returns Str[0] = Tango class
	 *           Str[1] = Property number
	 *           Str[2] = Property name
	 *           Str[3] = Property value number (array case)
	 *           Str[4] = Property value
	 *           Str[n] = Property value (array case)
	 *           ....
	 */
	virtual Tango::DevVarStringArray *db_get_class_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetClassProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetClassPropertyHist related method
	 *	Description: Retrieve Tango class property history
	 *
	 *	@param argin Str[0] = Tango class
	 *               Str[1] = Property name
	 *	@returns Str[0] = Property name
	 *           Str[1] = date
	 *           Str[2] = Property value number (array case)
	 *           Str[3] = Property value 1
	 *           Str[n] = Property value n
	 */
	virtual Tango::DevVarStringArray *db_get_class_property_hist(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetClassPropertyHist_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetClassPropertyList related method
	 *	Description: Get property list for a given Tango class
	 *
	 *	@param argin The class
	 *	@returns Property name list
	 */
	virtual Tango::DevVarStringArray *db_get_class_property_list(Tango::DevString argin);
	virtual bool is_DbGetClassPropertyList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDeviceAlias related method
	 *	Description: Return alias for device name if found.
	 *
	 *	@param argin The device name
	 *	@returns The alias found
	 */
	virtual Tango::DevString db_get_device_alias(Tango::DevString argin);
	virtual bool is_DbGetDeviceAlias_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDeviceAliasList related method
	 *	Description: Get device alias name with a specific filter
	 *
	 *	@param argin The filter
	 *	@returns Device alias list
	 */
	virtual Tango::DevVarStringArray *db_get_device_alias_list(Tango::DevString argin);
	virtual bool is_DbGetDeviceAliasList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDeviceAttributeList related method
	 *	Description: Return list of attributes matching the wildcard
	 *                for the specified device
	 *
	 *	@param argin Str[0] = Device name
	 *               Str[1] = Wildcard
	 *	@returns attribute name list
	 */
	virtual Tango::DevVarStringArray *db_get_device_attribute_list(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetDeviceAttributeList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDeviceAttributeProperty related method
	 *	Description: Get device attribute property(ies) value
	 *
	 *	@param argin Str[0] = Device name
	 *               Str[1] = Attribute name
	 *               Str[n] = Attribute name
	 *	@returns Str[0] = Device name
	 *           Str[1] = Attribute property  number
	 *           Str[2] = Attribute property 1 name
	 *           Str[3] = Attribute property 1 value
	 *           Str[n + 1] = Attribute property 2 name
	 *           Str[n + 2] = Attribute property 2 value
	 */
	virtual Tango::DevVarStringArray *db_get_device_attribute_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetDeviceAttributeProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDeviceAttributeProperty2 related method
	 *	Description: Retrieve device attribute properties. This command has the possibility to retrieve
	 *               device attribute properties which are arrays. It is not possible with the old
	 *               DbGetDeviceAttributeProperty command. Nevertheless, the old command has not been
	 *               deleted for compatibility reason
	 *
	 *	@param argin Str[0] = Device name
	 *               Str[1] = Attribute name
	 *               Str[n] = Attribute name
	 *	@returns Str[0] = Device name
	 *           Str[1] = Attribute property  number
	 *           Str[2] = Attribute property 1 name
	 *           Str[3] = Attribute property 1 value number (array case)
	 *           Str[4] = Attribute property 1 value
	 *           Str[n] = Attribute property 1 value (array case)
	 *           Str[n + 1] = Attribute property 2 name
	 *           Str[n + 2] = Attribute property 2 value number (array case)
	 *           Str[n + 3] = Attribute property 2 value
	 *           Str[n + m] = Attribute property 2 value (array case)
	 */
	virtual Tango::DevVarStringArray *db_get_device_attribute_property2(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetDeviceAttributeProperty2_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDeviceAttributePropertyHist related method
	 *	Description: Retrieve device attribute property history
	 *
	 *	@param argin Str[0] = Device name
	 *               Str[1] = Attribute name
	 *               Str[2] = Property name
	 *	@returns Str[0] = Attribute name
	 *           Str[1] = Property name
	 *           Str[2] = date
	 *           Str[3] = Property value number (array case)
	 *           Str[4] = Property value 1
	 *           Str[n] = Property value n
	 */
	virtual Tango::DevVarStringArray *db_get_device_attribute_property_hist(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetDeviceAttributePropertyHist_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDeviceClassList related method
	 *	Description: Get Tango classes/device list embedded in a specific device server
	 *
	 *	@param argin Device server process name
	 *	@returns Str[0] = Device name
	 *           Str[1] = Tango class
	 *           Str[n] = Device name
	 *           Str[n + 1] = Tango class
	 */
	virtual Tango::DevVarStringArray *db_get_device_class_list(Tango::DevString argin);
	virtual bool is_DbGetDeviceClassList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDeviceDomainList related method
	 *	Description: Get list of device domain name matching the specified
	 *
	 *	@param argin The wildcard
	 *	@returns Device name domain list
	 */
	virtual Tango::DevVarStringArray *db_get_device_domain_list(Tango::DevString argin);
	virtual bool is_DbGetDeviceDomainList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDeviceExportedList related method
	 *	Description: Get a list of exported devices whose names satisfy the filter (wildcard is
	 *
	 *	@param argin filter
	 *	@returns list of exported devices
	 */
	virtual Tango::DevVarStringArray *db_get_device_exported_list(Tango::DevString argin);
	virtual bool is_DbGetDeviceExportedList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDeviceFamilyList related method
	 *	Description: Get a list of device name families for device name matching the
	 *               specified wildcard
	 *
	 *	@param argin The wildcard
	 *	@returns Family list
	 */
	virtual Tango::DevVarStringArray *db_get_device_family_list(Tango::DevString argin);
	virtual bool is_DbGetDeviceFamilyList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDeviceInfo related method
	 *	Description: Returns info from DbImportDevice and started/stopped dates.
	 *
	 *	@param argin Device name
	 *	@returns Str[0] = Device name
	 *           Str[1] = CORBA IOR
	 *           Str[2] = Device version
	 *           Str[3] = Device Server name
	 *           Str[4] = Device Server process host name
	 *           Str[5] = Started date (or ? if not set)
	 *           Str[6] = Stopped date (or ? if not set)
	 *           Str[7] = Device class
	 *           
	 *           Lg[0] = Device exported flag
	 *           Lg[1] = Device Server process PID (or -1 if not set)
	 */
	virtual Tango::DevVarLongStringArray *db_get_device_info(Tango::DevString argin);
	virtual bool is_DbGetDeviceInfo_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDeviceList related method
	 *	Description: Get a list of devices for specified server and class.
	 *
	 *	@param argin argin[0] : server name
	 *               argin[1] : class name
	 *	@returns The list of devices for specified server and class.
	 */
	virtual Tango::DevVarStringArray *db_get_device_list(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetDeviceList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDeviceWideList related method
	 *	Description: Get a list of devices whose names satisfy the filter.
	 *
	 *	@param argin filter
	 *	@returns list of exported devices
	 */
	virtual Tango::DevVarStringArray *db_get_device_wide_list(Tango::DevString argin);
	virtual bool is_DbGetDeviceWideList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDeviceMemberList related method
	 *	Description: Get a list of device name members for device name matching the
	 *               specified filter
	 *
	 *	@param argin The filter
	 *	@returns Device names member list
	 */
	virtual Tango::DevVarStringArray *db_get_device_member_list(Tango::DevString argin);
	virtual bool is_DbGetDeviceMemberList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDeviceProperty related method
	 *	Description: 
	 *
	 *	@param argin Str[0] = Device name
	 *               Str[1] = Property name
	 *               Str[n] = Property name
	 *	@returns Str[0] = Device name
	 *           Str[1] = Property number
	 *           Str[2] = Property name
	 *           Str[3] = Property value number (array case)
	 *           Str[4] = Property value 1
	 *           Str[n] = Property value n (array case)
	 *           Str[n + 1] = Property name
	 *           Str[n + 2] = Property value number (array case)
	 *           Str[n + 3] = Property value 1
	 *           Str[n + m] = Property value m
	 */
	virtual Tango::DevVarStringArray *db_get_device_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetDeviceProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDevicePropertyHist related method
	 *	Description: Retrieve device  property history
	 *
	 *	@param argin Str[0] = Device name
	 *               Str[2] = Property name
	 *	@returns Str[0] = Property name
	 *           Str[1] = date
	 *           Str[2] = Property value number (array case)
	 *           Str[3] = Property value 1
	 *           Str[n] = Property value n
	 */
	virtual Tango::DevVarStringArray *db_get_device_property_hist(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetDevicePropertyHist_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDevicePropertyList related method
	 *	Description: Get property list belonging to the specified device and with
	 *               name matching the specified filter
	 *
	 *	@param argin Str[0] = device name
	 *               Str[1] = Filter
	 *	@returns Property name list
	 */
	virtual Tango::DevVarStringArray *db_get_device_property_list(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetDevicePropertyList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDeviceServerClassList related method
	 *	Description: Get list of Tango classes for a device server
	 *
	 *	@param argin device server process name
	 *	@returns list of classes for this device server
	 */
	virtual Tango::DevVarStringArray *db_get_device_server_class_list(Tango::DevString argin);
	virtual bool is_DbGetDeviceServerClassList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetExportdDeviceListForClass related method
	 *	Description: Query the database for device exported for the specified class.
	 *
	 *	@param argin Class name
	 *	@returns Device exported list
	 */
	virtual Tango::DevVarStringArray *db_get_exportd_device_list_for_class(Tango::DevString argin);
	virtual bool is_DbGetExportdDeviceListForClass_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetHostList related method
	 *	Description: Get host list with name matching the specified filter
	 *
	 *	@param argin The filter
	 *	@returns Host name list
	 */
	virtual Tango::DevVarStringArray *db_get_host_list(Tango::DevString argin);
	virtual bool is_DbGetHostList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetHostServerList related method
	 *	Description: Get list of device server process name running on host with name matching
	 *               the specified filter
	 *
	 *	@param argin The filter
	 *	@returns Device server process name list
	 */
	virtual Tango::DevVarStringArray *db_get_host_server_list(Tango::DevString argin);
	virtual bool is_DbGetHostServerList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetHostServersInfo related method
	 *	Description: Get info about all servers running on specified host, name, mode and level
	 *
	 *	@param argin Host name
	 *	@returns Server info for all servers running on specified host
	 */
	virtual Tango::DevVarStringArray *db_get_host_servers_info(Tango::DevString argin);
	virtual bool is_DbGetHostServersInfo_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetInstanceNameList related method
	 *	Description: Returns the instance names found for specified server.
	 *
	 *	@param argin Server name
	 *	@returns The instance names found for specified server.
	 */
	virtual Tango::DevVarStringArray *db_get_instance_name_list(Tango::DevString argin);
	virtual bool is_DbGetInstanceNameList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetObjectList related method
	 *	Description: Get list of free object defined in database with name
	 *               matching the specified filter
	 *
	 *	@param argin The filter
	 *	@returns Object name list
	 */
	virtual Tango::DevVarStringArray *db_get_object_list(Tango::DevString argin);
	virtual bool is_DbGetObjectList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetProperty related method
	 *	Description: Get free object property
	 *
	 *	@param argin Str[0] = Object name
	 *               Str[1] = Property name
	 *               Str[n] = Property name
	 *	@returns Str[0] = Object name
	 *           Str[1] = Property number
	 *           Str[2] = Property name
	 *           Str[3] = Property value number (array case)
	 *           Str[4] = Property value 1
	 *           Str[n] = Property value n (array case)
	 *           Str[n + 1] = Property name
	 *           Str[n + 2] = Property value number (array case)
	 *           Str[n + 3] = Property value 1
	 *           Str[n + m] = Property value m
	 */
	virtual Tango::DevVarStringArray *db_get_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetPropertyHist related method
	 *	Description: Retrieve object  property history
	 *
	 *	@param argin Str[0] = Object name
	 *               Str[2] = Property name
	 *	@returns Str[0] = Property name
	 *           Str[1] = date
	 *           Str[2] = Property value number (array case)
	 *           Str[3] = Property value 1
	 *           Str[n] = Property value n
	 */
	virtual Tango::DevVarStringArray *db_get_property_hist(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetPropertyHist_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetPropertyList related method
	 *	Description: Get list of property defined for a free object and matching the
	 *               specified filter
	 *
	 *	@param argin Str[0] = Object name
	 *               Str[1] = filter
	 *	@returns Property name list
	 */
	virtual Tango::DevVarStringArray *db_get_property_list(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetPropertyList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetServerInfo related method
	 *	Description: Get info about host, mode and level for specified server
	 *
	 *	@param argin server name
	 *	@returns server info
	 */
	virtual Tango::DevVarStringArray *db_get_server_info(Tango::DevString argin);
	virtual bool is_DbGetServerInfo_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetServerList related method
	 *	Description: Get list of device server process defined in database
	 *               with name matching the specified filter
	 *
	 *	@param argin The filter
	 *	@returns Device server process name list
	 */
	virtual Tango::DevVarStringArray *db_get_server_list(Tango::DevString argin);
	virtual bool is_DbGetServerList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetServerNameList related method
	 *	Description: Returns the list of server names found for the wildcard specified.
	 *               It returns only the server executable name without instance name as DbGetServerList.
	 *
	 *	@param argin wildcard for server names.
	 *	@returns server names found.
	 */
	virtual Tango::DevVarStringArray *db_get_server_name_list(Tango::DevString argin);
	virtual bool is_DbGetServerNameList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbImportDevice related method
	 *	Description: Import a device from the database
	 *
	 *	@param argin Device name (or alias)
	 *	@returns Str[0] = device name
	 *           Str[1] = CORBA IOR
	 *           Str[2] = device version
	 *           Str[3] = device server process name
	 *           Str[4] = host name
	 *           Str[5] = Tango class name
	 *           
	 *           Lg[0] = Exported flag
	 *           Lg[1] = Device server process PID
	 */
	virtual Tango::DevVarLongStringArray *db_import_device(Tango::DevString argin);
	virtual bool is_DbImportDevice_allowed(const CORBA::Any &any);
	/**
	 *	Command DbImportEvent related method
	 *	Description: Get event channel info from database
	 *
	 *	@param argin name of event channel or factory
	 *	@returns export information e.g. IOR
	 */
	virtual Tango::DevVarLongStringArray *db_import_event(Tango::DevString argin);
	virtual bool is_DbImportEvent_allowed(const CORBA::Any &any);
	/**
	 *	Command DbInfo related method
	 *	Description: Get miscellaneous numbers on information
	 *               stored in database
	 *
	 *	@returns Miscellaneous info like:
	 *           - Device defined in database
	 *           - Device marked as exported in database
	 *           - Device server process defined in database
	 *           - Device server process marked as exported in database
	 *           - Device properties defined in database
	 *           - Class properties defined in database
	 *           - Device attribute properties defined in database
	 *           - Class attribute properties defined in database
	 *           - Object properties defined in database
	 */
	virtual Tango::DevVarStringArray *db_info();
	virtual bool is_DbInfo_allowed(const CORBA::Any &any);
	/**
	 *	Command DbPutAttributeAlias related method
	 *	Description: Define an alias for an attribute
	 *
	 *	@param argin Str[0] = attribute name
	 *               Str[1] = attribute alias
	 */
	virtual void db_put_attribute_alias(const Tango::DevVarStringArray *argin);
	virtual bool is_DbPutAttributeAlias_allowed(const CORBA::Any &any);
	/**
	 *	Command DbPutClassAttributeProperty related method
	 *	Description: Create/Update class attribute property(ies) in database
	 *
	 *	@param argin Str[0] = Tango class name
	 *               Str[1] = Attribute number
	 *               Str[2] = Attribute name
	 *               Str[3] = Property number
	 *               Str[4] = Property name
	 *               Str[5] = Property value
	 *               .....
	 */
	virtual void db_put_class_attribute_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbPutClassAttributeProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbPutClassAttributeProperty2 related method
	 *	Description: This command adds support for array properties compared to the previous one
	 *               called DbPutClassAttributeProperty. The old comman is still there for compatibility reason
	 *
	 *	@param argin Str[0] = Tango class name
	 *               Str[1] = Attribute number
	 *               Str[2] = Attribute name
	 *               Str[3] = Property number
	 *               Str[4] = Property name
	 *               Str[5] = Property value number (array case)
	 *               Str[5] = Property value 1
	 *               Str[n] = Property value n (array case)
	 *               .....
	 */
	virtual void db_put_class_attribute_property2(const Tango::DevVarStringArray *argin);
	virtual bool is_DbPutClassAttributeProperty2_allowed(const CORBA::Any &any);
	/**
	 *	Command DbPutClassProperty related method
	 *	Description: Create / Update class property(ies)
	 *
	 *	@param argin Str[0] = Tango class name
	 *               Str[1] = Property number
	 *               Str[2] = Property name
	 *               Str[3] = Property value number
	 *               Str[4] = Property value 1
	 *               Str[n] = Property value n
	 *               ....
	 */
	virtual void db_put_class_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbPutClassProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbPutDeviceAlias related method
	 *	Description: Define alias for  a given device name
	 *
	 *	@param argin Str[0] = device name
	 *               Str[1] = alias name
	 */
	virtual void db_put_device_alias(const Tango::DevVarStringArray *argin);
	virtual bool is_DbPutDeviceAlias_allowed(const CORBA::Any &any);
	/**
	 *	Command DbPutDeviceAttributeProperty related method
	 *	Description: Create/Update device attribute property(ies) in database
	 *
	 *	@param argin Str[0] = Device name
	 *               Str[1] = Attribute number
	 *               Str[2] = Attribute name
	 *               Str[3] = Property number
	 *               Str[4] = Property name
	 *               Str[5] = Property value
	 *               .....
	 */
	virtual void db_put_device_attribute_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbPutDeviceAttributeProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbPutDeviceAttributeProperty2 related method
	 *	Description: Put device attribute property. This command adds the possibility to have attribute property
	 *               which are arrays. Not possible with the old DbPutDeviceAttributeProperty command.
	 *               This old command is not deleted for compatibility reasons.
	 *
	 *	@param argin Str[0] = Device name
	 *               Str[1] = Attribute number
	 *               Str[2] = Attribute name
	 *               Str[3] = Property number
	 *               Str[4] = Property name
	 *               Str[5] = Property value number (array case)
	 *               Str[5] = Property value 1
	 *               Str[n] = Property value n (array case)
	 *               .....
	 */
	virtual void db_put_device_attribute_property2(const Tango::DevVarStringArray *argin);
	virtual bool is_DbPutDeviceAttributeProperty2_allowed(const CORBA::Any &any);
	/**
	 *	Command DbPutDeviceProperty related method
	 *	Description: Create / Update device property(ies)
	 *
	 *	@param argin Str[0] = Tango device name
	 *               Str[1] = Property number
	 *               Str[2] = Property name
	 *               Str[3] = Property value number
	 *               Str[4] = Property value 1
	 *               Str[n] = Property value n
	 *               ....
	 */
	virtual void db_put_device_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbPutDeviceProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbPutProperty related method
	 *	Description: Create / Update free object property(ies)
	 *
	 *	@param argin Str[0] = Object name
	 *               Str[1] = Property number
	 *               Str[2] = Property name
	 *               Str[3] = Property value number
	 *               Str[4] = Property value 1
	 *               Str[n] = Property value n
	 *               ....
	 */
	virtual void db_put_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbPutProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbPutServerInfo related method
	 *	Description: Update server info including host, mode and level
	 *
	 *	@param argin server info
	 */
	virtual void db_put_server_info(const Tango::DevVarStringArray *argin);
	virtual bool is_DbPutServerInfo_allowed(const CORBA::Any &any);
	/**
	 *	Command DbUnExportDevice related method
	 *	Description: Mark a device as non exported in database
	 *
	 *	@param argin Device name
	 */
	virtual void db_un_export_device(Tango::DevString argin);
	virtual bool is_DbUnExportDevice_allowed(const CORBA::Any &any);
	/**
	 *	Command DbUnExportEvent related method
	 *	Description: Mark one event channel as non exported in database
	 *
	 *	@param argin name of event channel or factory to unexport
	 */
	virtual void db_un_export_event(Tango::DevString argin);
	virtual bool is_DbUnExportEvent_allowed(const CORBA::Any &any);
	/**
	 *	Command DbUnExportServer related method
	 *	Description: Mark all devices belonging to a specified device server
	 *               process as non exported
	 *
	 *	@param argin Device server name (executable/instance)
	 */
	virtual void db_un_export_server(Tango::DevString argin);
	virtual bool is_DbUnExportServer_allowed(const CORBA::Any &any);
	/**
	 *	Command ResetTimingValues related method
	 *	Description: Reset the timing attribute values.
	 *
	 */
	virtual void reset_timing_values();
	virtual bool is_ResetTimingValues_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDataForServerCache related method
	 *	Description: This command returns all the data needed by a device server process during its
	 *               startup sequence. The aim of this command is to minimize database access during
	 *               device server startup sequence.
	 *
	 *	@param argin Elt[0] = DS name (exec_name/inst_name), Elt[1] = Host name
	 *	@returns All the data needed by the device server during its startup sequence. Precise list depend on the device server
	 */
	virtual Tango::DevVarStringArray *db_get_data_for_server_cache(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetDataForServerCache_allowed(const CORBA::Any &any);
	/**
	 *	Command DbDeleteAllDeviceAttributeProperty related method
	 *	Description: Delete all attribute properties for the specified device attribute(s)
	 *
	 *	@param argin str[0] = device name
	 *               Str[1]...str[n] = attribute name(s)
	 */
	virtual void db_delete_all_device_attribute_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbDeleteAllDeviceAttributeProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbMySqlSelect related method
	 *	Description: This is a very low level command.
	 *               It executes the specified  SELECT command on TANGO database and returns its result without filter.
	 *
	 *	@param argin MySql Select command
	 *	@returns MySql Select command result
	 *            - svalues : select results
	 *            - lvalue[n] : =0 if svalue[n] is null else =1
	 *            (last lvalue -1) is number of rows, (last lvalue) is number of fields
	 */
	virtual Tango::DevVarLongStringArray *db_my_sql_select(Tango::DevString argin);
	virtual bool is_DbMySqlSelect_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetCSDbServerList related method
	 *	Description: Get a list of host:port for all database server defined in the control system
	 *
	 *	@returns List of host:port with one element for each database server
	 */
	virtual Tango::DevVarStringArray *db_get_csdb_server_list();
	virtual bool is_DbGetCSDbServerList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetAttributeAlias2 related method
	 *	Description: Get the attribute alias from the attribute name.
	 *               Returns one empty string if nothing found in database
	 *
	 *	@param argin The attribute name (dev_name/att_name)
	 *	@returns The attribute alias name (or empty string)
	 */
	virtual Tango::DevString db_get_attribute_alias2(Tango::DevString argin);
	virtual bool is_DbGetAttributeAlias2_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetAliasAttribute related method
	 *	Description: Get the attribute name from the given alias.
	 *               If the given alias is not found in database, returns an empty string
	 *
	 *	@param argin The attribute alias
	 *	@returns The attribute name (dev_name/att_name)
	 */
	virtual Tango::DevString db_get_alias_attribute(Tango::DevString argin);
	virtual bool is_DbGetAliasAttribute_allowed(const CORBA::Any &any);
	/**
	 *	Command DbRenameServer related method
	 *	Description: Rename a device server process
	 *
	 *	@param argin s[0] = old device server name (exec/instance)
	 *               s[1] = new device server name (exec/instance)
	 */
	virtual void db_rename_server(const Tango::DevVarStringArray *argin);
	virtual bool is_DbRenameServer_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetClassPipeProperty related method
	 *	Description: Retrieve class pipe properties
	 *
	 *	@param argin Str[0] = Tango class name
	 *               Str[1] = Pipe name
	 *               Str[n] = Pipe name
	 *	@returns Str[0] = Tango class name
	 *           Str[1] = Pipe property  number
	 *           Str[2] = Pipe property 1 name
	 *           Str[3] = Pipe property 1 value number (array case)
	 *           Str[4] = Pipe property 1 value
	 *           Str[n] = Pipe property 1 value (array case)
	 *           Str[n + 1] = Pipe property 2 name
	 *           Str[n + 2] = Pipe property 2 value number (array case)
	 *           Str[n + 3] = Pipe property 2 value
	 *           Str[n + m] = Pipe property 2 value (array case)
	 */
	virtual Tango::DevVarStringArray *db_get_class_pipe_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetClassPipeProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDevicePipeProperty related method
	 *	Description: Retrieve device pipe properties
	 *
	 *	@param argin Str[0] = Device name
	 *               Str[1] = Pipe name
	 *               Str[n] = Pipe name
	 *	@returns Str[0] = Device name
	 *           Str[1] = Pipe property  number
	 *           Str[2] = Pipe property 1 name
	 *           Str[3] = Pipe property 1 value number (array case)
	 *           Str[4] = Pipe property 1 value
	 *           Str[n] = Pipe property 1 value (array case)
	 *           Str[n + 1] = Pipe property 2 name
	 *           Str[n + 2] = Pipe property 2 value number (array case)
	 *           Str[n + 3] = Pipe property 2 value
	 *           Str[n + m] = Pipe property 2 value (array case)
	 */
	virtual Tango::DevVarStringArray *db_get_device_pipe_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetDevicePipeProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbDeleteClassPipe related method
	 *	Description: Delete a class pipe and all its properties from database
	 *
	 *	@param argin Str[0] = Tango class name
	 *               Str[1] = Pipe name
	 */
	virtual void db_delete_class_pipe(const Tango::DevVarStringArray *argin);
	virtual bool is_DbDeleteClassPipe_allowed(const CORBA::Any &any);
	/**
	 *	Command DbDeleteDevicePipe related method
	 *	Description: Delete device pipe properties from database
	 *
	 *	@param argin Str[0] = Device name
	 *               Str[1] = Pipe name
	 */
	virtual void db_delete_device_pipe(const Tango::DevVarStringArray *argin);
	virtual bool is_DbDeleteDevicePipe_allowed(const CORBA::Any &any);
	/**
	 *	Command DbDeleteClassPipeProperty related method
	 *	Description: Delete class pipe properties from database
	 *
	 *	@param argin Str[0] = Tango class name
	 *               Str[1] = Pipe name
	 *               Str[2] = Property name
	 *               Str[n] = Property name
	 */
	virtual void db_delete_class_pipe_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbDeleteClassPipeProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbDeleteDevicePipeProperty related method
	 *	Description: Delete device pipe properties from database
	 *
	 *	@param argin Str[0] = Device name
	 *               Str[1] = Pipe name
	 *               Str[2] = Property name
	 *               Str[n] = Property name
	 */
	virtual void db_delete_device_pipe_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbDeleteDevicePipeProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetClassPipeList related method
	 *	Description: Get pipe list for a given Tango class with a specified filter
	 *
	 *	@param argin Str[0] = Tango class name
	 *               Str[1] = Pipe name filter (eg: pip*)
	 *	@returns Str[0] = Class pipe name
	 *           Str[n] = Class pipe name
	 */
	virtual Tango::DevVarStringArray *db_get_class_pipe_list(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetClassPipeList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDevicePipeList related method
	 *	Description: Return list of pipes matching the wildcard for the specified device
	 *
	 *	@param argin Str[0] = Device name
	 *               Str[1] = Wildcard
	 *	@returns Pipe name list
	 */
	virtual Tango::DevVarStringArray *db_get_device_pipe_list(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetDevicePipeList_allowed(const CORBA::Any &any);
	/**
	 *	Command DbDeleteAllDevicePipeProperty related method
	 *	Description: Delete all pipe properties for the specified device pipe(s)
	 *
	 *	@param argin str[0] = device name
	 *               Str[1]...str[n] = pipe name(s)
	 */
	virtual void db_delete_all_device_pipe_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbDeleteAllDevicePipeProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbPutClassPipeProperty related method
	 *	Description: Create/Update class pipe property(ies) in database
	 *
	 *	@param argin Str[0] = Tango class name
	 *               Str[1] = Pipe number
	 *               Str[2] = Pipe name
	 *               Str[3] = Property number
	 *               Str[4] = Property name
	 *               Str[5] = Property value number (array case)
	 *               Str[5] = Property value 1
	 *               Str[n] = Property value n (array case)
	 */
	virtual void db_put_class_pipe_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbPutClassPipeProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbPutDevicePipeProperty related method
	 *	Description: Create/Update device pipe property(ies) in database
	 *
	 *	@param argin Str[0] = Device name
	 *               Str[1] = Pipe number
	 *               Str[2] = Pipe name
	 *               Str[3] = Property number
	 *               Str[4] = Property name
	 *               Str[5] = Property value number (array case)
	 *               Str[6] = Property value 1
	 *               Str[n] = Property value n (array case)
	 */
	virtual void db_put_device_pipe_property(const Tango::DevVarStringArray *argin);
	virtual bool is_DbPutDevicePipeProperty_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetClassPipePropertyHist related method
	 *	Description: Retrieve Tango class pipe property history
	 *
	 *	@param argin Str[0] = Tango class
	 *               Str[1] = Pipe name
	 *               Str[2] = Property name
	 *	@returns Str[0] = Pipe name
	 *           Str[1] = Property name
	 *           Str[2] = date
	 *           Str[3] = Property value number (array case)
	 *           Str[4] = Property value 1
	 *           Str[n] = Property value n
	 */
	virtual Tango::DevVarStringArray *db_get_class_pipe_property_hist(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetClassPipePropertyHist_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetDevicePipePropertyHist related method
	 *	Description: Retrieve device pipe property history
	 *
	 *	@param argin Str[0] = Device name
	 *               Str[1] = Pipe name
	 *               Str[2] = Property name
	 *	@returns Str[0] = Pipe name
	 *           Str[1] = Property name
	 *           Str[2] = date
	 *           Str[3] = Property value number (array case)
	 *           Str[4] = Property value 1
	 *           Str[n] = Property value n
	 */
	virtual Tango::DevVarStringArray *db_get_device_pipe_property_hist(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetDevicePipePropertyHist_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetForwardedAttributeListForDevice related method
	 *	Description: Get the list of devices using forwarded attribute(s) from specified device
	 *
	 *	@param argin The specified device name
	 *	@returns argout[n]     : device name
	 *           argout[n+1] :the forwardef attribute
	 *           argout[n+2] :the root attribute (__root_att)
	 */
	virtual Tango::DevVarStringArray *db_get_forwarded_attribute_list_for_device(Tango::DevString argin);
	virtual bool is_DbGetForwardedAttributeListForDevice_allowed(const CORBA::Any &any);
	/**
	 *	Command DbGetClassPropertyListWildcard related method
	 *	Description: Get property list belonging to the specified class and with
	 *               name matching the specified filter
	 *
	 *	@param argin Str[0] = class name
	 *               Str[1] = Filter
	 *	@returns Property name list
	 */
	virtual Tango::DevVarStringArray *db_get_class_property_list_wildcard(const Tango::DevVarStringArray *argin);
	virtual bool is_DbGetClassPropertyListWildcard_allowed(const CORBA::Any &any);


	//--------------------------------------------------------
	/**
	 *	Method      : DataBase::add_dynamic_commands()
	 *	Description : Add dynamic commands if any.
	 */
	//--------------------------------------------------------
	void add_dynamic_commands();

/*----- PROTECTED REGION ID(DataBase::Additional Method prototypes) ENABLED START -----*/

	//	Additional Method prototypes
protected :
	unsigned long	mysql_svr_version;

	bool check_device_name(std::string &);
	bool device_name_to_dfm(std::string &device_name, char domain[], char family[], char member[]);
	std::string replace_wildcard(const char*);
	Tango::DevString db_get_device_host(Tango::DevString,int con_nb=-1);
	std::string escape_string(const char *string_c_str);
	void init_timing_stats();
	Tango::DevULong64 get_id(const char *name,int con_nb=-1);
	void check_history_tables();
	void purge_property(const char *table,const char *field,const char *object,const char *name,int con_nb=-1);
	void purge_att_property(const char *table,const char *field,const char *object,const char *attribute,const char *name,int con_nb=-1);
	void purge_pipe_property(const char *table,const char *field,const char *object,const char *pipe,const char *name,int con_nb=-1);

	typedef struct
	{
		MYSQL 			*db;
		omni_semaphore 	the_sema;
	}DbConnection;
	DbConnection	*conn_pool;
	int				last_sem_wait;
	static int		conn_pool_size;
	char 			*stored_release_ptr;
	char			stored_release[128];

	std::string			ho;
	char			ho_name[1024];

	omni_mutex		timing_stats_mutex;
	omni_mutex		starter_mutex;
	omni_mutex		sem_wait_mutex;

	void create_connection_pool(const char *,const char *,const char *);
	void base_connect(int);
	bool host_port_from_ior(const char *,std::string &);
    void create_update_mem_att(const Tango::DevVarStringArray *);

	inline void update_timing_stats(TimeVal before, TimeVal after, std::string command)
	{
		double time_elapsed = Elapsed(before, after);
		timing_stats_mutex.lock();
		TimingStatsStruct *timing_stats = timing_stats_map[command];
		if (timing_stats != NULL)
		{
			timing_stats->calls++;
			timing_stats->total_elapsed = timing_stats->total_elapsed+time_elapsed;
			timing_stats->average = timing_stats->total_elapsed/timing_stats->calls;
			if (time_elapsed > timing_stats->maximum) timing_stats->maximum = time_elapsed;
			if (time_elapsed < timing_stats->minimum || timing_stats->minimum == 0.0) timing_stats->minimum = time_elapsed;
		}
		timing_stats_mutex.unlock();
	}

#ifdef WIN32
	inline static void w_gettimeofday(LARGE_INTEGER *t)
	{
		static int				status = 0;
		if (status==0)
			//	Initialize
			status = QueryPerformanceFrequency(&cpu_freq);

		if (status!=0)
			QueryPerformanceCounter(t);		//	Get micro-second time
		else
			t->QuadPart = 0;
	}
#endif

public:

	void simple_query(std::string sql_query,const char *method,int con_nb=-1);
	MYSQL_RES *query(std::string sql_query,const char *method,int con_nb=-1);
	static void set_conn_pool_size(int si) {conn_pool_size = si;}

	int get_connection();
	void release_connection(int con_nb) {conn_pool[con_nb].the_sema.post();}

private:
	void check_authorization();

private:
  template<typename T>
  T ParseString(const char * c_str);

	/*----- PROTECTED REGION END -----*/	//	DataBase::Additional Method prototypes
};

/*----- PROTECTED REGION ID(DataBase::Additional Classes Definitions) ENABLED START -----*/

template<>
int DataBase::ParseString<int>(const char * c_str);

	//	Additional Classes definitions
class AutoLock
{
public:
	AutoLock(const char *,DataBase *);
	~AutoLock();

	int get_con_nb() {return con_nb;}

private:
	DataBase	*the_db;
	int 		con_nb;
};

class DbInter: public Tango::Interceptors
{
public:
	DbInter() {}
	~DbInter() {}

	virtual void create_thread()
	{
		if (Tango::Util::instance()->is_svr_starting() == false)
			mysql_thread_init();
	}
	virtual void delete_thread()
	{
		if (Tango::Util::instance()->is_svr_starting() == false)
			mysql_thread_end();
	}
};

	/*----- PROTECTED REGION END -----*/	//	DataBase::Additional Classes Definitions

}	//	End of namespace

#endif   //	DataBase_H
