static const char *RcsId = "$Header$";
//+=============================================================================
//
// file :        main.cpp
//
// description : C++ source for a TANGO device server main.
//               The main rule is to initialise (and create) the Tango
//               system and to create the DServerClass singleton.
//               The main should be the same for every Tango device server.
//
// project :     TANGO Device Server
//
// $Author: taurel $
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010
//						Synchrotron SOLEIL
//                		L'Orme des Merisiers
//                		Saint-Aubin - BP 48 - France
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Revision: 19209 $ $
//
// $Log$
// Revision 1.9  2010/09/21 12:04:45  taurel
// - Added GPL header for next source distribution
//
// Revision 1.8  2010/09/10 17:21:30  nleclercq
// Added support for crash report  (i.e. google breakpad)
// Added ClassID to the cvs repository
//
// Revision 1.7  2007/12/11 19:07:52  nleclercq
// added a "no_value" and a "throw_exception" attribute
//
// Revision 1.6  2006/05/17 17:07:53  leclercq
// Update NL du 17.05.06 (Tango 5.4.2)
//
// Revision 1.6  2006/03/20 15:21:51  jensmeyer
// Added some castings for porting to VC8
//
// Revision 1.5  2006/02/08 16:14:28  nleclercq
// Minor modifs in RW spectrum and image attributes
//
//-=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================

#include <tango.h>

#if defined(ENABLE_CRASH_REPORT)
# include <crashreporting/crash_report.h>
#else
# define DECLARE_CRASH_HANDLER
# define INSTALL_CRASH_HANDLER
#endif

DECLARE_CRASH_HANDLER;

int main(int argc, char *argv[])
{
  INSTALL_CRASH_HANDLER;

	Tango::Util *tg = NULL;

	try
	{
		// Initialise the device server
		//----------------------------------------
		tg = Tango::Util::init(argc,argv);
 
		// Create the device server singleton 
		//	which will create everything
		//----------------------------------------
		tg->server_init(false);

		// Run the endless loop
		//----------------------------------------
		cout << "Ready to accept request" << endl;

		tg->server_run();
	}
	catch (bad_alloc)
	{
		cout << "Can't allocate memory to store device object !!!" << endl;
		cout << "Exiting" << endl;
	}
	catch (CORBA::Exception &e)
	{
		Tango::Except::print_exception(e);
		
		cout << "Received a CORBA_Exception" << endl;
		cout << "Exiting" << endl;
	}
  catch (...)
  {
		cout << "Received an unknown exception" << endl;
		cout << "Exiting" << endl;
  }

	tg->server_cleanup();

	return(0);
}
