.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.14
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "TAKTUKCOMM 3"
.TH TAKTUKCOMM 3 "2007-05-31" "perl v5.8.6" "TakTuk Library Functions Manual"
.SH "NAME"
TakTukComm \- Interface to \f(CWtaktuk(1)\fR communication facilities
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
.IP "\fBPerl interface:\fR" 4
.IX Item "Perl interface:"
.Vb 2
\&  $taktuk::error;
\&  taktuk::error_msg($);
.Ve
.Sp
.Vb 2
\&  taktuk::send(%);
\&  taktuk::recv(%);
.Ve
.IP "\fBC interface:\fR" 4
.IX Item "C interface:"
.Vb 1
\&  #include <taktuk.h>
.Ve
.Sp
.Vb 1
\&  extern int taktuk_error;
.Ve
.Sp
.Vb 7
\&  char *taktuk_error_msg(int msg_code);
\&  int taktuk_send(char *dest, const void *buffer, size_t length);
\&  int taktuk_recv(char *from, void *buffer, size_t length,
\&                  int timeout);
\&  int taktuk_sendv(char *dest, const struct iovec *iov, int iovcnt);
\&  int taktuk_recvv(char *from, const struct iovec *iov, int iovcnt,
\&                   int timeout);
.Ve
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
The \fBTakTuk\fR communication layer interfaces provide a way for programs
executed using the \f(CWtaktuk(1)\fR to exchange data. It is based on a simple
send/receive model using multicast-like sends and optionally timeouted
receives.  This is only designed to be a control facility, in
particular this is not a high performance communication library. This interface
is available both for the Perl and the C langages.
.PP
\&\s-1WARNING:\s0 the \fBTakTuk\fR communication interface is not process-safe : it is
probably a very bad idea to use point-to-point communication in
more than one process related to a single logical peer (these processes might
be several local commands or forked processes). Nevertheless, the C interface
is thread-safe (it uses posix mutexes in its critical sections). These issues
are likely to be addressed in future \fBTakTuk\fR versions.
.SH "PERL INTERFACE"
.IX Header "PERL INTERFACE"
The Perl communication interface for \fBTakTuk\fR is made of two functions that
can be called by scripts executed using the \f(CW\*(C`taktuk_perl\*(C'\fR command of
\&\fBTakTuk\fR or using the \fBTakTuk\fR package provided with the \fBTakTuk\fR
distribution.
These two functions are:
.IP "\fBtaktuk::send(%);\fR" 4
.IX Item "taktuk::send(%);"
sends a scalar to a single peer or a set specification (see \f(CWtaktuk(1)\fR for
informations about set specifications).
The two mandatory fields in the arguments are \f(CW\*(C`to\*(C'\fR (with a set specification)
and \f(CW\*(C`body\*(C'\fR. Returns an undefined value upon error.
.IP "\fBtaktuk::recv(%);\fR" 4
.IX Item "taktuk::recv(%);"
blocks until the reception of a message. Returns a list of three elements: the
logical number of the destination of the message, the logical number of its
source and the message itself.
Accepts an optional \f(CW\*(C`timeout\*(C'\fR argument with a numeric value.
Returns an empty list upon error.
.PP
When an error occur, both of these functions set the variable \f(CW$taktuk::error\fR
to the numeric code of the error that occured. A textual description of the
error is provided by the function \f(CWtaktuk::error_msg($)\fR that takes the error
code as an argument.
.PP
Error codes are the following :
.IP "taktuk::ESWRIT" 4
.IX Item "taktuk::ESWRIT"
a call to \f(CW\*(C`taktuk::syswrite\*(C'\fR failed. This is due to a \f(CW\*(C`syswrite\*(C'\fR error
different than \f(CW\*(C`EAGAIN\*(C'\fR. The code should be accessible using \f(CW\*(C`errno\*(C'\fR.
.IP "taktuk::EFCLSD" 4
.IX Item "taktuk::EFCLSD"
the communication channel to the \fBTakTuk\fR engine has been closed. This
typically occur when shutting down the logical network (using Ctrl-C on root
node for instance).
.ie n .IP "taktuk::ESREAD (""taktuk::recv"" only)" 4
.el .IP "taktuk::ESREAD (\f(CWtaktuk::recv\fR only)" 4
.IX Item "taktuk::ESREAD (taktuk::recv only)"
a call to \f(CW\*(C`sysread\*(C'\fR failed (the code should be accessible using \f(CW\*(C`errno\*(C'\fR).
.ie n .IP "taktuk::EARGTO (""taktuk::send"" only)" 4
.el .IP "taktuk::EARGTO (\f(CWtaktuk::send\fR only)" 4
.IX Item "taktuk::EARGTO (taktuk::send only)"
\&\f(CW\*(C`to\*(C'\fR field missing in the arguments.
.ie n .IP "taktuk::EARGBD (""taktuk::send"" only)" 4
.el .IP "taktuk::EARGBD (\f(CWtaktuk::send\fR only)" 4
.IX Item "taktuk::EARGBD (taktuk::send only)"
\&\f(CW\*(C`body\*(C'\fR field missing in the arguments.
.ie n .IP "taktuk::ETMOUT (""taktuk::recv"" only)" 4
.el .IP "taktuk::ETMOUT (\f(CWtaktuk::recv\fR only)" 4
.IX Item "taktuk::ETMOUT (taktuk::recv only)"
The call to \f(CW\*(C`taktuk::recv\*(C'\fR timeouted. This only occur when giving a \f(CW\*(C`timeout\*(C'\fR
field as \f(CW\*(C`taktuk::recv\*(C'\fR argument.
.ie n .IP "taktuk::EINVST (""taktuk::send"" only)" 4
.el .IP "taktuk::EINVST (\f(CWtaktuk::send\fR only)" 4
.IX Item "taktuk::EINVST (taktuk::send only)"
The set specification given as a destination to the \f(CW\*(C`taktuk::send\*(C'\fR function is
not correct.
.SH "C INTERFACE"
.IX Header "C INTERFACE"
The C communication interface for \fBTakTuk\fR is very similar in its use to
\&\f(CWread(2)\fR, \f(CWreadv(2)\fR, \f(CWwrite(2)\fR, \f(CWwritev(2)\fR functions.
Any program using \fBTakTuk\fR C communication interface has to link his program
to the \f(CW\*(C`taktuk\*(C'\fR and \f(CW\*(C`pthread\*(C'\fR libraries (the \f(CW\*(C`taktuk\*(C'\fR library is provided
with the distribution).
Headers of communication functions and constants definitions can be found in
\&\f(CW\*(C`taktuk.h\*(C'\fR also provided with the distribution.
.PP
The communication functions are:
.IP "\fBint taktuk_send(char *dest, const void *buffer, size_t length);\fR" 4
.IX Item "int taktuk_send(char *dest, const void *buffer, size_t length);"
sends the content of \f(CW\*(C`buffer\*(C'\fR made of \f(CW\*(C`length\*(C'\fR bytes to \f(CW\*(C`dest\*(C'\fR. \f(CW\*(C`dest\*(C'\fR
might be a single peer or a set specification (see \f(CWtaktuk(1)\fR for
informations about set specifications). In both cases it should contain
a nul terminated characters string.
Returns the number of bytes written or \-1 upon error.
.IP "\fBint taktuk_recv(char *from, void *buffer, size_t length, int timeout);\fR" 4
.IX Item "int taktuk_recv(char *from, void *buffer, size_t length, int timeout);"
blocks until the reception of a message.
If a regular message is received, returns the number of bytes read and sets
the value of its arguments:
\&\f(CW\*(C`from\*(C'\fR to the string that represents the logical number of the sender,
\&\f(CW\*(C`buffer\*(C'\fR to the data received up to \f(CW\*(C`length\*(C'\fR bytes.
If timeout is non nul, \f(CW\*(C`taktuk_recv()\*(C'\fR might receive a timeout notification.
In this case or in case of error, \f(CW\*(C`taktuk_recv()\*(C'\fR returns \-1.
.IP "\fBint taktuk_sendv(char *dest, const struct iovec *iov, int iovcnt);\fR" 4
.IX Item "int taktuk_sendv(char *dest, const struct iovec *iov, int iovcnt);"
.PD 0
.IP "\fBint taktuk_recvv(char *from, const struct iovec *iov, int iovcnt, int timeout);\fR" 4
.IX Item "int taktuk_recvv(char *from, const struct iovec *iov, int iovcnt, int timeout);"
.PD
these two functions do the same as \f(CW\*(C`taktuk_send()\*(C'\fR and \f(CW\*(C`taktuk_recv()\*(C'\fR except
that the trasmitted data is contained in a vector as in \f(CWreadv(2)\fR or
\&\f(CWwritev(2)\fR.
.Sp
\&\s-1WARNING:\s0 for these function the vector of \f(CW\*(C`taktuk_recvv\*(C'\fR must have the same size
as the vector of \f(CW\*(C`taktuk_sendv\*(C'\fR otherwise the reception might either block or
cause memory errors. This might be fixed in the future (but not for sure as
the fix would involve some costly operations and does not seem necessary).
.PP
When an error occur, all of these functions set the variable \f(CW\*(C`taktuk_error\*(C'\fR
to the numeric code of the error that occured. A textual description of the
error is provided by the function \f(CW\*(C`taktuk_error_msg()\*(C'\fR that takes the error
code as an argument.
.PP
Error codes are the following :
.IP "\s-1TAKTUK_ESWRIT\s0" 4
.IX Item "TAKTUK_ESWRIT"
a call to \f(CWwrite(2)\fR failed.
The code should be accessible using \f(CW\*(C`errno\*(C'\fR.
.IP "\s-1TAKTUK_EFCLSD\s0" 4
.IX Item "TAKTUK_EFCLSD"
the communication channel to the \fBTakTuk\fR engine has been closed. This
typically occur when shutting down the logical network (using Ctrl-C on root
node for instance).
.IP "\s-1TAKTUK_ESREAD\s0 (receives only)" 4
.IX Item "TAKTUK_ESREAD (receives only)"
a call to \f(CWread(2)\fR failed.
The code should be accessible using \f(CW\*(C`errno\*(C'\fR.
.IP "\s-1TAKTUK_ETMOUT\s0 (receives only)" 4
.IX Item "TAKTUK_ETMOUT (receives only)"
The call to \f(CW\*(C`taktuk_recv()\*(C'\fR (or its vectorized equivalent) timeouted.
This only occur when giving a non nul \f(CW\*(C`timeout\*(C'\fR value to \f(CW\*(C`taktuk_recv()\*(C'\fR.
.IP "\s-1TAKTUK_EALLOC\s0" 4
.IX Item "TAKTUK_EALLOC"
An internal memory allocation failure occured.
.IP "\s-1TAKTUK_EIBUFF\s0" 4
.IX Item "TAKTUK_EIBUFF"
An unsufficient buffer has been given to store all the data.
.IP "\s-1TAKTUK_EINTRN\s0" 4
.IX Item "TAKTUK_EINTRN"
An internal error occured. This strongly suggest a bug in \fBTakTuk\fR.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
\&\f(CWtatkuk(1)\fR
.SH "AUTHOR"
.IX Header "AUTHOR"
The original concept of \fBTakTuk\fR has been proposed by Cyrille Martin in his PhD thesis. People involved in this work include Jacques Briat, Olivier Richard, Thierry Gautier and Guillaume Huard.
.PP
The author of the perl version and current maintainer of the package is Guillaume Huard.
.SH "COPYRIGHT"
.IX Header "COPYRIGHT"
The \f(CW\*(C`taktukcomm\*(C'\fR communication interface library is provided under the terms
of the \s-1GNU\s0 General Public License version 2 or later.
