/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002 Tomaz Solc                                           */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: error.h,v 1.7 2004/01/06 12:27:57 avian Exp $ */

#ifndef _ERROR_H
#define _ERROR_H

#define BUFFSIZE	256

void fatalxml(const char *fmt, int no, ...);
void tell(char *module, int msgtag, const char *fmt, ...);
#ifdef _STDARG_H
void vtell(char *module, int msgtag, const char *fmt, va_list ap);
#endif

void fatal(const char *fmt, ...);
void error(const char *fmt, ...);
void notify(const char *fmt, ...);
void info(const char *fmt, ...);
void debug(const char *fmt, ...);

extern int verbosity;
extern char *curmodule;

#endif
