/* TABLIX, PGA highschool timetable generator                              */
/* Copyright (C) 2002-2004 Tomaz Solc                                      */

/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; either version 2 of the License, or       */
/* (at your option) any later version.                                     */

/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */

/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software             */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/* $Id: subject_sameday.c,v 1.6 2004/10/17 09:37:05 avian Exp $ */

/* 
 * AUTHOR:
 *
 *  Tomaz Solc <tomaz.solc@siol.net>
 *
 *  Ideas taken from a patch for Tablix 0.0.3 by
 *  Jaume Obrador <obrador@espaiweb.net>
 *
 * DESCRIPTION:
 *
 *  Adds a weight if a class has the same subject twice in a day. Adds two
 *  weights if three times in a day, etc.
 *
 * DEFINED CLASS RESTRICTIONS:
 *
 *  <restriction type="ignore-sameday"/>
 *
 *  Set this restriction to a class that you don't want to be checked for 
 *  multiple occurrences of the same subject in a day. This module ignores 
 *  classes that have this restriction.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>

#include "modsup.h"
#include "data.h"
#include "gettext.h"

int *ignore;

int getignoresameday(char *type, char *cont, int cid)
{
	ignore[cid]=1;
	return 0;
}

parop class_restrictions[] = { 
	{ type : "ignore-sameday", parfunc: getignoresameday },
	{ type : 0, parfunc: 0 }
};

int init_mod()
{
	int c;

	ignore=malloc(sizeof(*ignore)*cmapnum);

	for(c=0;c<cmapnum;c++) {
		ignore[c]=0;
	}

	return 0;
}

int grade_function(chromo *t, int *cpnt, int *tpnt, int **start, int **lead)
{
	int a,b,c,d;
	int flag,sid;
	int sum;
	int *pnt;
	int su[PERIODS];
	int nsu;

	sum=0;

	pnt=cpnt;

	for(c=0;c<cmapnum;c++) {
		if (ignore[c]==0) {
			for (d=0;d<DAYS;d++) {
				nsu=0;
				for(b=0;b<PERIODS;b++) {
					if(*pnt!=-1) {
						flag=1;
						sid=tuplemap[*pnt].sid;

						for(a=0;a<nsu;a++) {
							if(sid==su[a]) {
								sum++;
								flag=0;
								break;
							}
						}
						if(flag) {
							su[nsu]=sid;
							nsu++;
						}
					}
					pnt++;
				}
			}
		}
		else pnt=pnt+TIMES;
	}
	return(sum);
}
