

#define ENLARGEMENT_PER_STEP 50
#define PROFILE_ENLARGEMENT 550

// static char pos2aa[] = {'A','C','D','E','F','G','H','I','K','L','M','N','P','Q','R','S','T','V','W','Y'};


/**
 * \brief Struct to save all informations of a profile.
 * 
 */
typedef struct
{
	/// Number of sequences in this profile
	int num_sequences;
	/// number of the profile
	int prf_number;
	///0 = combination of two profiles, 1 = profile of a single sequence -> name1 = seq_name
	int is_leaf;
	///length of the profile
	int length;
	///weight of the sequence
	int weight;
	///saves the amount of allocated memory
	int allocated_memory;	
	///the profile itself [alphabet_size][profile_length]
	int **prf;
}
Fastal_profile;

/**
 * \brief Struct to save all parameters for fastal.
 * 
 */
typedef struct
{
	/// size of alphabet_size
	int alphabet_size;
	/// converting char2position (for profile)
	int char2pos[26];
	/// converting pos2char (for profile)
	char pos2char[26];
	/// gap opening costs
	int gop;
	/// gap extension costs
	int gep;
	/// nomatch???
	int nomatch;
	///method to align profile
	char method[20];
	///scoring Matrix;
	int **M;
}
Fastal_param;



//tree
void generate_random_tree(int number);


Fastal_profile* make_profile_of_sequence(char *seq_name, char *sequence, int number);



//Definite use

//*********************    input/output    **********************************
void file2profile(FILE* profile_f, Fastal_profile *profile, int prf_number, Fastal_param *param_set);
void file_pos2profile(FILE *seq_file, long off_set, Fastal_profile *profile, int prf_number, Fastal_param *param_set);
void profile2file(Fastal_profile *profile, FILE* prf_f, Fastal_param *param_set);

//index
int make_index_of_file(char *file_name, long **result);


//*********************    pairwise alignment methods     ************************

	//Needleman-Wunsch
	int prf_nw(Fastal_profile *profile1, Fastal_profile *profile2, double **prog_matrix, FILE *edit_file_name, int **sumup_prf, int *sumup_length, Fastal_param *param_set);
	int nw_matrix2edit_file(double **prog_matrix, Fastal_profile *profile1, Fastal_profile *profile2, FILE *edit_f, int **prf_field, int *field_length, Fastal_param *param_set);
	int** sumup_profile(Fastal_profile *profile, int **sumup_prf, Fastal_param *param_set);
	void write2file(int **sumup_prf, int length, FILE *file, int number, Fastal_param *param_set);

	
	//Sparse dynamic programming
	int seq_pair2blast_diagonal(char *seq_file_name1, char *seq_file_name2, int **diagonals, int *dig_length, int l1, int l2, int is_dna);
	
	
	
	
	
	
	
	
//edit_files 2 alignment
	void edit2alignment(FILE *sequence_file, long *seq_positions, FILE *edit_file, long *edit_positions, int node_number, int number_of_sequences, char *aligned_sequence, int alignment_length, FILE *edit_seq_file, int offset, FILE* alignment_file);
void edit_seq2aligned_seq(char *aligned_sequence, FILE *sequence_file, long sequence_position, FILE *alignment_file);


//main
int fastal(int argc, char **argv);

//toolbox
void initiate_profile_files(FILE **profile_files);
void initiate_profiles(Fastal_profile **profiles, Fastal_param *param_set);
void free_fastal_profile(Fastal_profile *profile, int alphabet_size);
double **resize_dyn_matrix(double **dyn_matrix, int *old_length1, int *old_length2, int length1, int length2);
void free_dyn_matrix(int length1, double **dyn_matrix);
void fill_parameters(int is_dna, Fastal_param *param_set, char *method);

struct fastal_arguments
{
// 	char *args[2];
	char *method;
	char *sequence_file;
	char *tree_file;
	char *output_file;
	int is_dna;
	int gop;
	int gep;
};

// static char fastal_doc[] = "Fastal -- a program to align sequences with little memory";
// // static char args_doc[] = "ARG1 ARG2";
// static void* fastal_options[]=
// {
// 	{"in", 		'i', "FILE", 0, "Sequence file (FASTA format)" },
// 	{"output",  'o', "FILE", 0, "Output to FILE" },
// 	{"tree",  	't', "FILE", 0, "Tree file" },
//  	{"method",	'm', "METHOD", 0, "Methods:\n   fast (sparse dynamic),\n   nw (Needleman-Wunsch) "},
// 	{"is_dna",	'd', 0, 0, "Sequences are DNA"},
// 	{"is_aa", 	'a', 0, 0, "Sequences are AminoAcids"},
// 	{"gop",		'g', "VALUE", 0, "Gap opening costs"},
// 	{"gep",		'e', "VALUE", 0, "Gap extension costs"},
// 	{ 0 }
// };





/*
void
fastal_parse_opt (int key, char *arg)
{
// 	struct fastal_arguments *arguments = state->input;

	switch (key)
	{
		case 'o':
			arguments->output_file = arg;
			break;
		case 't':
			arguments->tree_file = arg;
			break;
		case 'i':
			arguments->sequence_file = arg;
			break;
		case 'm':
			arguments->method = arg;
			break;
		case 'g':
			arguments->gop = atoi(arg);
			break;
		case 'e':
			arguments->gep = atoi(arg);
			break;
		case 'd':
			arguments->is_dna = 1;
			break;
		case 'a':
			arguments->is_dna = 0;
			break;
		default:
			printf("UNKNOWN OPTION key");
			exit(1);
	}
	return 0;
}*/
// 
// 
// static struct argp argp = { fastal_options, fastal_parse_opt,/* fastal_args_doc,*/ fastal_doc};
/*********************************COPYRIGHT NOTICE**********************************/
/* Centro de Regulacio Genomica */
/*and */
/*Cedric Notredame */
/*Tue Oct 27 10:12:26 WEST 2009. */
/*All rights reserved.*/
/*This file is part of T-COFFEE.*/
/**/
/*    T-COFFEE is free software; you can redistribute it and/or modify*/
/*    it under the terms of the GNU General Public License as published by*/
/*    the Free Software Foundation; either version 2 of the License, or*/
/*    (at your option) any later version.*/
/**/
/*    T-COFFEE is distributed in the hope that it will be useful,*/
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*    GNU General Public License for more details.*/
/**/
/*    You should have received a copy of the GNU General Public License*/
/*    along with Foobar; if not, write to the Free Software*/
/*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/
/*...............................................                                                                                      |*/
/*  If you need some more information*/
/*  cedric.notredame@europe.com*/
/*...............................................                                                                                                                                     |*/
/**/
/**/
/*	*/
/*********************************COPYRIGHT NOTICE**********************************/
