#!/usr/bin/python

"""Usage: man smb.conf | ./sambaoptionscheck.py"""

import sambaDefaults
import re
import sys
import string

if __name__ == "__main__":
    global_re = re.compile ('^\s*(?P<option>.*\S)\s+\(G\)\s+$')
    section_re = re.compile ('^\s*(?P<option>.*\S)\s+\(S\)\s+$')

    lines = sys.stdin.readlines ()
    global_options = {}
    section_options = {}

    for line in lines:
        string.rstrip (line)
        m = global_re.match (line)
        if m:
            option = m.group("option")
            global_options[option] = option
        else:
            m = section_re.match (line)
            if m:
                option = m.group("option")
                section_options[option] = option

    keys = sambaDefaults.global_keys.keys ()
    keys.sort ()
    for o in keys:
        if not global_options.has_key (o):
            print "unknown global option", o

    keys = sambaDefaults.section_keys.keys ()
    keys.sort ()
    for o in keys:
        if not section_options.has_key (o):
            print "unknown section option", o

    keys = global_options.keys ()
    keys.sort ()
    for o in keys:
        if sambaDefaults.section_keys.has_key (o):
            print "should be global option:", o
        elif not sambaDefaults.global_keys.has_key (o):
            print "missing global option", o

    keys = section_options.keys ()
    keys.sort ()
    for o in keys:
        if sambaDefaults.global_keys.has_key (o):
            print "should be section option:", o
        if not sambaDefaults.section_keys.has_key (o):
            print "missing section option", o
