//Filename: cpu_info.h
/*
 * Sysinfo
 * Copyright (C) Nil Gradisnik 2005 <ghaefb@gmail.com>
 * 
 * Sysinfo is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2, or (at your option) any later version.
 * 
 * sysinfo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with main.cc.  See the file "COPYING".  If not,
 * write to:  The Free Software Foundation, Inc.,
 *            59 Temple Place - Suite 330,
 *            Boston,  MA  02111-1307, USA.
 */

#ifndef CPU_INFO_H
#define CPU_INFO_H

#include <iostream>
#include <fstream>

//global variables
Glib::ustring cpuinfo1 = "unknown";
Glib::ustring cpuinfo2 = "unknown";
Glib::ustring cpuinfo3 = "unknown";
Glib::ustring cpuinfo4 = "unknown";
Glib::ustring cpuinfo5 = "unknown";
Glib::ustring cpuinfo6 = "unknown";
Glib::ustring cpuinfo7 = "unknown";
Glib::ustring cpuinfo8 = "unknown";

//cpuinfo1
void Cpuinfo1() {
	
	std::ifstream text("/proc/cpuinfo");
	char line[150];
	while (!text.eof()) {
		text.getline(line,150,'\n');
		if(strstr(line, "vendor_id")) {
			cpuinfo1 = line;
			cpuinfo1.erase(0, 12);
		}
	}
	text.close();
}


//cpuinfo2
void Cpuinfo2() {
	
	std::ifstream text("/proc/cpuinfo");
	char line[150];
	while (!text.eof()) {
		text.getline(line,150,'\n');
		if(strstr(line, "model name")) {
			cpuinfo2 = line;
			cpuinfo2.erase(0, 13);
		}
	}
	text.close();
}

//cpuinfo3
void Cpuinfo3() {
	
	std::ifstream text("/proc/cpuinfo");
	char line[150];
	while (!text.eof()) {
		text.getline(line,150,'\n');
		if(strstr(line, "cpu MHz")) {
			char units[5] = " MHz";
			
			strcat(line,units);
			
			cpuinfo3 = line;
			cpuinfo3.erase(0, 11);
		}
	}
	text.close();
}

//cpuinfo4
void Cpuinfo4() {
	
	std::ifstream text("/proc/cpuinfo");
	char line[150];
	while (!text.eof()) {
		text.getline(line,150,'\n');
		if(strstr(line, "cache size")) {
			cpuinfo4 = line;
			cpuinfo4.erase(0, 13);
		}
	}
	text.close();
}

//cpuinfo5
void Cpuinfo5() {
	
	std::ifstream text("/proc/cpuinfo");
	char line[150];
	int a = 0;
	while (!text.eof() && a < 1) {
		text.getline(line,150,'\n');
		if(strstr(line, "model")) {
			cpuinfo5 = line;
			cpuinfo5.erase(0, 9);
			a++;
		}
	}
	text.close();
}

//cpuinfo6
void Cpuinfo6() {
	
	std::ifstream text("/proc/cpuinfo");
	char line[150];
	while (!text.eof()) {
		text.getline(line,150,'\n');
		if(strstr(line, "cpu family")) {
			cpuinfo6 = line;
			cpuinfo6.erase(0, 13);
		}
	}
	text.close();
}

//cpuinfo7
void Cpuinfo7() {
	
	std::ifstream text("/proc/cpuinfo");
	char line[150];
	while (!text.eof()) {
		text.getline(line,150,'\n');
		if(strstr(line, "stepping")) {
			cpuinfo7 = line;
			cpuinfo7.erase(0, 11);
		}

	}
	text.close();
}

//cpuinfo8
void Cpuinfo8() {
	
	std::ifstream text("/proc/cpuinfo");
	char line[150];
	while (!text.eof()) {
		text.getline(line,150,'\n');
		if(strstr(line, "bogomips")) {
			cpuinfo8 = line;
			cpuinfo8.erase(0, 11);
		}
	}
	text.close();
}

#endif //CPU_INFO_H

//ghaefb
