C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE RESRER
C                       *****************
C
C     ----------------------------------------------------------- 
     * (MODE,
     *  NFPERA,NELRAY,NGFPER,TEMRAY,TRAYEQ,ERAYEQ,PHFRAE, TF,XH)
C     ----------------------------------------------------------- 
C 
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C FONCTION :                                                           *
C ----------                                                           *
C                                                                      *
C            TRAITEMENT DU RAYONNEMENT TRANSPARENT                     *
C            Sur la partie solide equivalent isolee                    *
C            On utilise une formulation analytique de la resolution    *
C            de l'equation equivalente                                 *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME (2 OU 3)               !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !___________!____!____!______________________________________________!
C !___________!____!____!______________________________________________!
C
C     TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C            L (LOGIQUE)   .. ET TYPES COMPOSES (EX : TR TABLEAU REEL)
C     MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (AUXILIAIRE MODIFIE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME APPELANT     :  
C
C     SOUS PROGRAMME(S) APPELE(S) :
C
C***********************************************************************
C
      IMPLICIT NONE        
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "divct.h"
#include "nlofes.h"
#include "rayonn.h"
C
C **********************************************************************
C.. Variables externes
      INTEGER MODE,NFPERA,NELRAY,NGFPER(NFPERA)
      DOUBLE PRECISION TEMRAY(NELRAY),ERAYEQ(NELRAY)
      DOUBLE PRECISION TRAYEQ(NELRAY),PHFRAE(NFPERA,4)
      DOUBLE PRECISION TF(NELRAY),XH(NELRAY)
C
C..Variables Internes
      INTEGER I,NGFAC,N
      DOUBLE PRECISION UNS3,DEUS3,RAC2,RAC3,R18T,R18T2
      DOUBLE PRECISION TREQ,EREQ,SKEQ,SEEQ,STEQ,SHEQ
      DOUBLE PRECISION A,B,C,X1,X2,X3,X4,X5,X6,TFWALL,XTF,XHTF
C
C***********************************************************************
C
C      
C     1 Initialisation
C     =================
      UNS3  = 1./3.
      DEUS3 = 2./3.
      RAC2  = SQRT(2.)
      RAC3  = SQRT(3.)
      R18T  = 18**(1./3.)
      R18T2 = R18T*R18T
C
      IF (MODE.EQ.1) THEN
        DO N=1,NELRAY
          TF(N)=0.
          XH(N)=0.
        ENDDO
      ENDIF
C
C     2- Boucle sur tous les noeuds concernes
C     =======================================
      DO 200 I=1,NFPERA
C
         NGFAC = NGFPER(I)
         TREQ = TRAYEQ(NGFAC) + TKEL
         EREQ = ERAYEQ(NGFAC)
C
         SKEQ = PHFRAE(I,1)
         SEEQ = PHFRAE(I,2)
         STEQ = PHFRAE(I,3) + TKEL
         SHEQ = PHFRAE(I,4)
C  
         XTF  = TF(NGFAC) + TKEL
         XHTF = XH(NGFAC)
C
         A = SIGMA * EREQ
         IF (ABS(SHEQ) .LT. 1.E-6 .AND. ABS(XHTF).LT. 1.E-6) THEN
             TFWALL =  TRAYEQ(NGFAC)
         ELSE
            IF (ABS(SHEQ) .LT. 1.E-6) THEN
              B = XHTF 
              C = XHTF * XTF + SIGMA*EREQ*TREQ**4
            ELSE
              B = XHTF + 1. / ( SEEQ / SKEQ + 1. / SHEQ )
              C = XHTF * XTF + SIGMA*EREQ*TREQ**4
     &             + 1. / ( SEEQ / SKEQ + 1. / SHEQ ) * STEQ
            ENDIF
C        
            X1  =  9*B*B + SQRT(256*C*C*C*A + 27*B*B*B*B) * RAC3
            X2  =  R18T * X1**(DEUS3) - 24. * C * A**(UNS3)
            X3  =  18**(5./6.) * B * RAC2 * SQRT(X1)
            X4  =  R18T * C * A**(UNS3) * SQRT(X2)
            X5  =  R18T2 * X1**(DEUS3) * SQRT(X2)
            X6  =  RAC2/A**(UNS3)/X1**(1./6.)*SQRT(R18T*X2)
C
            TFWALL = 1./12.* 
     &               (-X6 + RAC2/A**(UNS3)/X1**(1./6.)/X2**(1./4.)
     &               *SQRT(-X5+24.*X4+6*X3)) - TKEL
         ENDIF
C
C
         TEMRAY(NGFAC) = TFWALL
C
  200 CONTINUE  
C 
C
C     3- IMPRESSION DE CONTROLE
C     =========================
C
      IF (NBLBLR .GE. 10) THEN
C
         WRITE(NFECRA,3000)
         WRITE(NFECRA,3010)
         DO 3100 I=1,NFPERA
            WRITE(NFECRA,3110) I,NGFPER(I),TEMRAY(NGFPER(I))
 3100    CONTINUE
C
      ENDIF
C
C
C--------
C FORMATS
C--------
C
 3000 FORMAT(/,'  *** RESRER : IMPRESSION DE LA RESOLUTION THERMIQUE',
     &          ' DANS LA PAROI 1D EQUIVALENTE (Face interne) ')
 3010 FORMAT(/,'  Num de la face  -  Num glob de la face -',
     &         '  Temperature degres C' )
 3110 FORMAT(8X,I6,15X,I6,15X,E12.5)
C
C----
C FIN
C----
      END

     
