/* === S Y N F I G ========================================================= */
/*!	\file dialog_tooloptions.cpp
**	\brief Template File
**
**	$Id$
**
**	\legal
**	Copyright (c) 2002-2005 Robert B. Quattlebaum Jr., Adrian Bentley
**	Copyright (c) 2009 Nikita Kitaev
**
**	This package is free software; you can redistribute it and/or
**	modify it under the terms of the GNU General Public License as
**	published by the Free Software Foundation; either version 2 of
**	the License, or (at your option) any later version.
**
**	This package is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**	General Public License for more details.
**	\endlegal
*/
/* ========================================================================= */

/* === H E A D E R S ======================================================= */

#ifdef USING_PCH
#	include "pch.h"
#else
#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <gtkmm/label.h>
#include <gtkmm/scrolledwindow.h>
#include <synfig/general.h>
#include "docks/dialog_tooloptions.h"
#include "general.h"

#endif

/* === U S I N G =========================================================== */

using namespace std;
using namespace etl;
using namespace synfig;
using namespace studio;

/* === M A C R O S ========================================================= */

/* === G L O B A L S ======================================================= */

/* === P R O C E D U R E S ================================================= */

/* === M E T H O D S ======================================================= */

Dialog_ToolOptions::Dialog_ToolOptions():
	Dockable("tool_options",_("Tool Options"),Gtk::StockID("synfig-about")),
	empty_label(_("This tool has no options"))
{
	add(sub_vbox_);

	set_widget(empty_label);
	empty_label.show();
}

Dialog_ToolOptions::~Dialog_ToolOptions()
{
}

void
Dialog_ToolOptions::clear()
{
	Dockable::clear();
	set_local_name(_("Tool Options"));
	add(sub_vbox_);
	set_widget(empty_label);
	empty_label.show();

	set_stock_id(Gtk::StockID("synfig-about"));
}

void
Dialog_ToolOptions::set_widget(Gtk::Widget&x)
{
	if(!sub_vbox_.children().empty())
		sub_vbox_.children().clear();

	sub_vbox_.show();
	sub_vbox_.pack_start(x,false,false);
	x.show();
}

void
Dialog_ToolOptions::set_name(const synfig::String& name)
{
	set_stock_id(Gtk::StockID("synfig-"+name));
}
