/* === S Y N F I G ========================================================= */
/*!	\file layer_polygon.h
**	\brief Template Header
**
**	$Id: layer_polygon.h,v 1.1.1.1 2005/01/04 01:23:14 darco Exp $
**
**	\legal
**	Copyright (c) 2002-2005 Robert B. Quattlebaum Jr., Adrian Bentley
**
**	This package is free software; you can redistribute it and/or
**	modify it under the terms of the GNU General Public License as
**	published by the Free Software Foundation; either version 2 of
**	the License, or (at your option) any later version.
**
**	This package is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**	General Public License for more details.
**	\endlegal
*/
/* ========================================================================= */

/* === S T A R T =========================================================== */

#ifndef __SYNFIG_LAYER_POLYGON_H
#define __SYNFIG_LAYER_POLYGON_H

/* === H E A D E R S ======================================================= */

#include "layer_shape.h"
#include "color.h"
#include "vector.h"
#include <list>
#include <vector>

/* === M A C R O S ========================================================= */

/* === T Y P E D E F S ===================================================== */

/* === C L A S S E S & S T R U C T S ======================================= */

namespace synfig {
	
/*!	\class Layer_Polygon
**	\beief writeme
**	\todo This layer needs to support multiple polygons */
class Layer_Polygon : public Layer_Shape
{
	SYNFIG_LAYER_MODULE_EXT
	
private:
		
	//exported data
	std::vector< Point > 	vector_list;

protected:

	Layer_Polygon();

public:

	~Layer_Polygon();

	//! Adds a polygon to the layer
	/*!	The edge data is automaticly added to the
	**	EdgeTable, so there is no need to call sync()
	**	after adding a polygon using this function.
	**	\param point_list A list containing the
	**		points that define the polygon's parameter.
	*/
	void add_polygon(const std::vector<Point> &point_list);

	//! Clears out any polygon data
	/*!	Also clears out the EdgeTable, so there is no
	**	need to call sync() after using this function.
	*/
	void clear();

	//! Updates EdgeTable so it will reflect the parameter data
	void sync();
	
	virtual bool set_param(const String & param, const synfig::ValueBase &value);

	virtual ValueBase get_param(const String & param)const;
	
	virtual Vocab get_param_vocab()const;

private:
	class 		PolySpan;
	bool render_polyspan(Surface *surface,PolySpan &polyspan)const;
}; // END of Layer_Polygon

}; // END of namespace synfig
/* === E N D =============================================================== */

#endif
