# DeviceDetection.py 
#  
#  Copyright (c) 2005 INdT (Instituto Nokia de Technologia)
#  
#  Author: Kenneth Rohde Christiansen <kenneth.christiansen@gmail.com>
# 
#  This program is free software; you can redistribute it and/or 
#  modify it under the terms of the GNU General Public License as 
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
#  USA

import dbus

def get_compatible_devices():
	devices = []

	bus = dbus.SystemBus()
	hal_manager_obj = bus.get_object("org.freedesktop.Hal", "/org/freedesktop/Hal/Manager")
	hal_manager = dbus.Interface(hal_manager_obj, "org.freedesktop.Hal.Manager")

	volume_udi_list = hal_manager.FindDeviceByCapability ('volume')

	for udi in volume_udi_list:
		volume = bus.get_object("org.freedesktop.Hal", udi)
		fstype = volume.GetProperty ('volume.fstype')
		mount_point = volume.GetProperty ('volume.mount_point')
		is_mounted = volume.GetProperty ('volume.is_mounted')
		is_mounted_read_only = volume.GetProperty ('volume.is_mounted_read_only')

		device_file = volume.GetProperty ('block.device')
		storage_udi = volume.GetProperty ('block.storage_device')

		storage = bus.get_object("org.freedesktop.Hal", storage_udi)
		drive_type = storage.GetProperty ('storage.bus')

		# Check if it is a Mass Storage Device and we can write to it
		if drive_type != "usb" or not is_mounted or is_mounted_read_only:
			continue	

		info_udi = volume.GetProperty ('info.parent')
		info = bus.get_object("org.freedesktop.Hal", info_udi)

		# Only accept N770 and Portable Audio Players
		try: 
			player_type = info.GetProperty ('portable_audio_player.type')
		except dbus.DBusException, e:
			if info.GetProperty ('info.product') == "770":
				player_type = "770"
				pass
			else:
				continue

		# Ignore iPods as they work differently than other Mass Storage Devices
		if player_type == "ipod":
			continue

		for i in range(4):
 			info_udi = info.GetProperty ('info.parent')
			info = bus.get_object("org.freedesktop.Hal", info_udi)

		product_name = info.GetProperty ('info.product')

		devices.append( (product_name, mount_point) )

	return devices
