/* smd-applet.c generated by valac 0.12.1, the Vala compiler
 * generated from smd-applet.vala, do not modify */

/* Released under the terms of GPLv3 or at your option any later version.*/
/* No warranties.*/
/* Copyright 2008-2010 Enrico Tassi <gares@fettunta.org>*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gio/gio.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include <libnotify/notify.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>
#include <signal.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/wait.h>
#include <smd-config.h>
#include <gobject/gvaluecollector.h>


#define TYPE_NETWORK_MANAGER (network_manager_get_type ())
#define NETWORK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NETWORK_MANAGER, NetworkManager))
#define IS_NETWORK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NETWORK_MANAGER))
#define NETWORK_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_NETWORK_MANAGER, NetworkManagerIface))

typedef struct _NetworkManager NetworkManager;
typedef struct _NetworkManagerIface NetworkManagerIface;

#define TYPE_NETWORK_MANAGER_PROXY (network_manager_proxy_get_type ())
typedef GDBusProxy NetworkManagerProxy;
typedef GDBusProxyClass NetworkManagerProxyClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;
typedef struct _EventPrivate EventPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _event_unref0(var) ((var == NULL) ? NULL : (var = (event_unref (var), NULL)))
typedef struct _ParamSpecEvent ParamSpecEvent;

#define TYPE_SMD_APPLET (smd_applet_get_type ())
#define SMD_APPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SMD_APPLET, smdApplet))
#define SMD_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SMD_APPLET, smdAppletClass))
#define IS_SMD_APPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SMD_APPLET))
#define IS_SMD_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SMD_APPLET))
#define SMD_APPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SMD_APPLET, smdAppletClass))

typedef struct _smdApplet smdApplet;
typedef struct _smdAppletClass smdAppletClass;
typedef struct _smdAppletPrivate smdAppletPrivate;
#define _g_mutex_free0(var) ((var == NULL) ? NULL : (var = (g_mutex_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _smd_applet_unref0(var) ((var == NULL) ? NULL : (var = (smd_applet_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _ParamSpecsmdApplet ParamSpecsmdApplet;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

typedef enum  {
	EXIT_ABORT
} Exit;
#define EXIT exit_quark ()
struct _NetworkManagerIface {
	GTypeInterface parent_iface;
	guint (*get_state) (NetworkManager* self);
};

struct _Event {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EventPrivate * priv;
	gchar* message;
	gchar* message_icon;
	gboolean enter_network_error_mode;
	gboolean enter_error_mode;
	gboolean transient_error_message;
	gchar* context;
	gchar* cause;
	gchar* permissions;
	gchar* mail_name;
	gchar* mail_body;
	GeeArrayList* commands;
};

struct _EventClass {
	GTypeClass parent_class;
	void (*finalize) (Event *self);
};

struct _ParamSpecEvent {
	GParamSpec parent_instance;
};

struct _smdApplet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	smdAppletPrivate * priv;
};

struct _smdAppletClass {
	GTypeClass parent_class;
	void (*finalize) (smdApplet *self);
};

struct _smdAppletPrivate {
	GtkBuilder* builder;
	GtkMenu* menuL;
	GtkMenu* menuR;
	GtkStatusIcon* si;
	GtkWindow* win;
	GtkWindow* err_win;
	GtkWindow* log_win;
	GtkAboutDialog* about_win;
	GtkCheckMenuItem* miPause;
	GtkComboBoxText* cblogs;
	GeeArrayList* lognames;
	GConfClient* gconf;
	GThread* thread;
	gboolean thread_die;
	GPid pid;
	GMutex* events_lock;
	GeeArrayList* events;
	gboolean error_mode;
	gboolean network_error_mode;
	gboolean config_wait_mode;
	GHashTable* command_hash;
	NetworkManager* net_manager;
	NotifyNotification* notification;
	gboolean notification_server_has_persistence;
};

struct _ParamSpecsmdApplet {
	GParamSpec parent_instance;
};


extern gboolean verbose;
gboolean verbose = FALSE;
static gpointer event_parent_class = NULL;
extern gchar* SMD_LOGS_DIR;
gchar* SMD_LOGS_DIR = NULL;
extern gchar* SMD_LOOP_CFG;
gchar* SMD_LOOP_CFG = NULL;
extern gchar* SMD_PP_DEF_CFG;
gchar* SMD_PP_DEF_CFG = NULL;
static gpointer smd_applet_parent_class = NULL;
extern gchar* smd_applet_smd_loop_cmd;
gchar* smd_applet_smd_loop_cmd = NULL;
extern gchar* smd_applet_smd_applet_ui;
gchar* smd_applet_smd_applet_ui = NULL;
extern gchar* smd_applet_smd_push_cmd;
gchar* smd_applet_smd_push_cmd = NULL;

GQuark exit_quark (void);
void debug (const gchar* message);
GType network_manager_get_type (void) G_GNUC_CONST;
GType network_manager_proxy_get_type (void) G_GNUC_CONST;
guint network_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
guint network_manager_get_state (NetworkManager* self);
static void network_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_network_manager_state_changed (NetworkManager* self, GVariant* parameters);
static guint network_manager_dbus_proxy_get_state (NetworkManager* self);
static void network_manager_proxy_network_manager_interface_init (NetworkManagerIface* iface);
static void network_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* network_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_network_manager_get_state (NetworkManager* self);
static gboolean network_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_network_manager_state_changed (GObject* _sender, guint state, gpointer* _data);
static void _network_manager_unregister_object (gpointer user_data);
#define NM_SERVICE "org.freedesktop.NetworkManager"
#define NM_PATH "/org/freedesktop/NetworkManager"
gboolean is_nm_connected (guint code);
gpointer event_ref (gpointer instance);
void event_unref (gpointer instance);
GParamSpec* param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_event (GValue* value, gpointer v_object);
void value_take_event (GValue* value, gpointer v_object);
gpointer value_get_event (const GValue* value);
GType event_get_type (void) G_GNUC_CONST;
enum  {
	EVENT_DUMMY_PROPERTY
};
Event* event_error (const gchar* account, const gchar* host, const gchar* context, const gchar* cause, const gchar* permissions, const gchar* mail_name, const gchar* mail_body, GeeArrayList* commands);
Event* event_new (void);
Event* event_construct (GType object_type);
Event* event_generic_error (const gchar* cause);
Event* event_network_error (void);
Event* event_stats (const gchar* account, const gchar* host, gint new_mails, gint del_mails);
gboolean event_is_error_event (Event* self);
static void event_finalize (Event* obj);
#define SMD_LOOP "/bin/smd-loop"
#define SMD_PUSH "/bin/smd-push"
#define SMD_APPLET_UI "/share/syncmaildir-applet/smd-applet.ui"
gpointer smd_applet_ref (gpointer instance);
void smd_applet_unref (gpointer instance);
GParamSpec* param_spec_smd_applet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_smd_applet (GValue* value, gpointer v_object);
void value_take_smd_applet (GValue* value, gpointer v_object);
gpointer value_get_smd_applet (const GValue* value);
GType smd_applet_get_type (void) G_GNUC_CONST;
#define SMD_APPLET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SMD_APPLET, smdAppletPrivate))
enum  {
	SMD_APPLET_DUMMY_PROPERTY
};
#define SMD_APPLET_key_icon "/apps/smd-applet/icon_only_on_errors"
#define SMD_APPLET_key_newmail "/apps/smd-applet/notify_new_mail"
smdApplet* smd_applet_new (gboolean hide_status_icon, GError** error);
smdApplet* smd_applet_construct (GType object_type, gboolean hide_status_icon, GError** error);
static void _lambda0_ (guint s, smdApplet* self);
static void __lambda0__network_manager_state_changed (NetworkManager* _sender, guint state, gpointer self);
static void _lambda1_ (GtkComboBox* cb, smdApplet* self);
static void __lambda1__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void smd_applet_close_logs_action (smdApplet* self, GtkButton* b);
static void _smd_applet_close_logs_action_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean smd_applet_close_logs_event (smdApplet* self, GdkEvent* e);
static gboolean _smd_applet_close_logs_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static void smd_applet_close_prefs_action (smdApplet* self, GtkButton* b);
static void _smd_applet_close_prefs_action_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda3_ (GtkToggleButton* b, smdApplet* self);
static void __lambda3__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lambda4_ (GtkToggleButton* b, smdApplet* self);
static void __lambda4__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void smd_applet_close_err_action (smdApplet* self, GtkButton* b);
static void _smd_applet_close_err_action_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda5_ (GtkButton* b, smdApplet* self);
static gboolean smd_applet_is_smd_loop_configured (smdApplet* self);
static void __lambda5__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda6_ (GtkButton* b, smdApplet* self);
static gboolean smd_applet_is_smd_pushpull_configured (smdApplet* self);
static void __lambda6__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda7_ (GtkMenuItem* b, smdApplet* self);
static void __lambda7__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda8_ (GtkCheckMenuItem* b, smdApplet* self);
static void smd_applet_pause (smdApplet* self);
static void smd_applet_unpause (smdApplet* self);
static void __lambda8__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void _lambda9_ (gint id, smdApplet* self);
static void __lambda9__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void _lambda10_ (GtkMenuItem* b, smdApplet* self);
static void __lambda10__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda11_ (GtkMenuItem* b, smdApplet* self);
static void __lambda11__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda12_ (GtkMenuItem* b, smdApplet* self);
static void smd_applet_update_loglist (smdApplet* self);
static void __lambda12__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda13_ (guint button, guint time, smdApplet* self);
static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static void __lambda13__gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self);
static void _lambda14_ (GtkStatusIcon* s, smdApplet* self);
static void __lambda14__gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
static void* smd_applet_smdThread (smdApplet* self);
static gboolean smd_applet_run_smd_loop (smdApplet* self, GError** error);
static void smd_applet_start_smdThread (smdApplet* self, gboolean force);
static gpointer _smd_applet_smdThread_gthread_func (gpointer self);
static gboolean smd_applet_eval_smd_loop_error_message (smdApplet* self, const gchar* args, const gchar* account, const gchar* host, GError** error);
static gboolean smd_applet_eval_smd_loop_message (smdApplet* self, const gchar* s);
static void _lambda2_ (smdApplet* self);
static void __lambda2__gspawn_child_setup_func (gpointer self);
static gboolean smd_applet_eat_event (smdApplet* self);
static void _lambda15_ (NotifyNotification* not, const gchar* action, smdApplet* self);
static void __lambda15__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self);
static void _lambda16_ (GtkButton* b, smdApplet* self);
static void __lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void smd_applet_reset_to_regular_run (smdApplet* self, gboolean force);
static gboolean smd_applet_close_err_event (smdApplet* self, GdkEvent* e);
static void smd_applet_close_prefs (smdApplet* self);
static gboolean smd_applet_close_prefs_event (smdApplet* self, GdkEvent* e);
static gboolean smd_applet_is_smd_stack_configured (smdApplet* self);
static void smd_applet_close_logs (smdApplet* self);
static void smd_applet_my_gtk_main_quit_button (smdApplet* self, GtkButton* b);
static gboolean smd_applet_my_gtk_main_quit_event (smdApplet* self, GdkEvent* b);
void smd_applet_run (smdApplet* self, GError** error);
static gboolean _smd_applet_eat_event_gsource_func (gpointer self);
static gboolean _smd_applet_close_prefs_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static gboolean _smd_applet_close_err_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
void smd_applet_configure (smdApplet* self);
static void _smd_applet_my_gtk_main_quit_button_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean _smd_applet_my_gtk_main_quit_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
static void smd_applet_finalize (smdApplet* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusMethodInfo * const _network_manager_dbus_method_info[] = {NULL};
static const GDBusArgInfo _network_manager_dbus_arg_info_state_changed_state = {-1, "state", "u"};
static const GDBusArgInfo * const _network_manager_dbus_arg_info_state_changed[] = {&_network_manager_dbus_arg_info_state_changed_state, NULL};
static const GDBusSignalInfo _network_manager_dbus_signal_info_state_changed = {-1, "StateChanged", (GDBusArgInfo **) (&_network_manager_dbus_arg_info_state_changed)};
static const GDBusSignalInfo * const _network_manager_dbus_signal_info[] = {&_network_manager_dbus_signal_info_state_changed, NULL};
static const GDBusPropertyInfo _network_manager_dbus_property_info_state = {-1, "State", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo * const _network_manager_dbus_property_info[] = {&_network_manager_dbus_property_info_state, NULL};
static const GDBusInterfaceInfo _network_manager_dbus_interface_info = {-1, "org.freedesktop.NetworkManager", (GDBusMethodInfo **) (&_network_manager_dbus_method_info), (GDBusSignalInfo **) (&_network_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_network_manager_dbus_property_info)};
static const GDBusInterfaceVTable _network_manager_dbus_interface_vtable = {network_manager_dbus_interface_method_call, network_manager_dbus_interface_get_property, network_manager_dbus_interface_set_property};

GQuark exit_quark (void) {
	return g_quark_from_static_string ("exit-quark");
}


void debug (const gchar* message) {
	g_return_if_fail (message != NULL);
	if (verbose) {
		fprintf (stderr, "DEBUG: %s\n", message);
	}
}


guint network_manager_get_state (NetworkManager* self) {
	return NETWORK_MANAGER_GET_INTERFACE (self)->get_state (self);
}


static void network_manager_base_init (NetworkManagerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("state_changed", TYPE_NETWORK_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	}
}


GType network_manager_get_type (void) {
	static volatile gsize network_manager_type_id__volatile = 0;
	if (g_once_init_enter (&network_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetworkManagerIface), (GBaseInitFunc) network_manager_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType network_manager_type_id;
		network_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "NetworkManager", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (network_manager_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (network_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) network_manager_proxy_get_type);
		g_type_set_qdata (network_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.NetworkManager");
		g_type_set_qdata (network_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) network_manager_register_object);
		g_once_init_leave (&network_manager_type_id__volatile, network_manager_type_id);
	}
	return network_manager_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (NetworkManagerProxy, network_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_NETWORK_MANAGER, network_manager_proxy_network_manager_interface_init) )
static void network_manager_proxy_class_init (NetworkManagerProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = network_manager_proxy_g_signal;
}


static void _dbus_handle_network_manager_state_changed (NetworkManager* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint state = 0U;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	state = g_variant_get_uint32 (_tmp0_);
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "state-changed", state);
}


static void network_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "StateChanged") == 0) {
		_dbus_handle_network_manager_state_changed ((NetworkManager*) proxy, parameters);
	}
}


static void network_manager_proxy_init (NetworkManagerProxy* self) {
}


static guint network_manager_dbus_proxy_get_state (NetworkManager* self) {
	GVariant *_inner_reply;
	guint _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "State");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.NetworkManager"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("State"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0U;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void network_manager_proxy_network_manager_interface_init (NetworkManagerIface* iface) {
	iface->get_state = network_manager_dbus_proxy_get_state;
}


static void network_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}


static GVariant* _dbus_network_manager_get_state (NetworkManager* self) {
	guint result;
	GVariant* _reply;
	result = network_manager_get_state (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}


static GVariant* network_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "State") == 0) {
		return _dbus_network_manager_get_state (object);
	}
	return NULL;
}


static gboolean network_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_network_manager_state_changed (GObject* _sender, guint state, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (state));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.NetworkManager", "StateChanged", _arguments, NULL);
}


guint network_manager_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_network_manager_dbus_interface_info), &_network_manager_dbus_interface_vtable, data, _network_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "state-changed", (GCallback) _dbus_network_manager_state_changed, data);
	return result;
}


static void _network_manager_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


gboolean is_nm_connected (guint code) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	if (code == 3) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = code == 70;
	}
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Event* event_error (const gchar* account, const gchar* host, const gchar* context, const gchar* cause, const gchar* permissions, const gchar* mail_name, const gchar* mail_body, GeeArrayList* commands) {
	Event* result = NULL;
	Event* _tmp0_ = NULL;
	Event* e;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GeeArrayList* _tmp8_;
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (host != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (cause != NULL, NULL);
	g_return_val_if_fail (commands != NULL, NULL);
	_tmp0_ = event_new ();
	e = _tmp0_;
	_tmp1_ = g_strdup ("An error occurred, click on the icon for more details");
	_g_free0 (e->message);
	e->message = _tmp1_;
	_tmp2_ = g_strdup ("error");
	_g_free0 (e->message_icon);
	e->message_icon = _tmp2_;
	e->enter_error_mode = TRUE;
	_tmp3_ = g_strdup (cause);
	_g_free0 (e->cause);
	e->cause = _tmp3_;
	_tmp4_ = g_strdup (context);
	_g_free0 (e->context);
	e->context = _tmp4_;
	_tmp5_ = g_strdup (permissions);
	_g_free0 (e->permissions);
	e->permissions = _tmp5_;
	_tmp6_ = g_strdup (mail_name);
	_g_free0 (e->mail_name);
	e->mail_name = _tmp6_;
	_tmp7_ = g_strdup (mail_body);
	_g_free0 (e->mail_body);
	e->mail_body = _tmp7_;
	_tmp8_ = _g_object_ref0 (commands);
	_g_object_unref0 (e->commands);
	e->commands = _tmp8_;
	result = e;
	return result;
}


Event* event_generic_error (const gchar* cause) {
	Event* result = NULL;
	Event* _tmp0_ = NULL;
	Event* e;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (cause != NULL, NULL);
	_tmp0_ = event_new ();
	e = _tmp0_;
	_tmp1_ = g_strconcat ("A failure occurred: ", cause, NULL);
	_g_free0 (e->message);
	e->message = _tmp1_;
	_tmp2_ = g_strdup ("dialog-warning");
	_g_free0 (e->message_icon);
	e->message_icon = _tmp2_;
	e->transient_error_message = TRUE;
	result = e;
	return result;
}


Event* event_network_error (void) {
	Event* result = NULL;
	Event* _tmp0_ = NULL;
	Event* e;
	gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = event_new ();
	e = _tmp0_;
	_tmp1_ = g_strdup ("A persistent network failure occurred");
	_g_free0 (e->message);
	e->message = _tmp1_;
	_tmp2_ = g_strdup ("dialog-warning");
	_g_free0 (e->message_icon);
	e->message_icon = _tmp2_;
	e->enter_network_error_mode = TRUE;
	result = e;
	return result;
}


Event* event_stats (const gchar* account, const gchar* host, gint new_mails, gint del_mails) {
	Event* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* preamble;
	Event* _tmp1_ = NULL;
	Event* e;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (host != NULL, NULL);
	_tmp0_ = g_strdup_printf ("Synchronize with %s:\n", account);
	preamble = _tmp0_;
	_tmp1_ = event_new ();
	e = _tmp1_;
	if (new_mails > 0) {
		_tmp2_ = del_mails > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_strdup_printf ("%s%d new messages\n%d deleted messages", preamble, new_mails, del_mails);
		_g_free0 (e->message);
		e->message = _tmp3_;
	} else {
		if (new_mails > 0) {
			gchar* _tmp4_ = NULL;
			_tmp4_ = g_strdup_printf ("%s%d new messages", preamble, new_mails);
			_g_free0 (e->message);
			e->message = _tmp4_;
		} else {
			gchar* _tmp5_ = NULL;
			_tmp5_ = g_strdup_printf ("%s%d deleted messages", preamble, del_mails);
			_g_free0 (e->message);
			e->message = _tmp5_;
		}
	}
	result = e;
	_g_free0 (preamble);
	return result;
}


gboolean event_is_error_event (Event* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->enter_error_mode) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->enter_network_error_mode;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->transient_error_message;
	}
	result = _tmp0_;
	return result;
}


Event* event_construct (GType object_type) {
	Event* self = NULL;
	self = (Event*) g_type_create_instance (object_type);
	return self;
}


Event* event_new (void) {
	return event_construct (TYPE_EVENT);
}


static void value_event_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_event_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		event_unref (value->data[0].v_pointer);
	}
}


static void value_event_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = event_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_event_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_event_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Event* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = event_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_event_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Event** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = event_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecEvent* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EVENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_event (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT), NULL);
	return value->data[0].v_pointer;
}


void value_set_event (GValue* value, gpointer v_object) {
	Event* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		event_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		event_unref (old);
	}
}


void value_take_event (GValue* value, gpointer v_object) {
	Event* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		event_unref (old);
	}
}


static void event_class_init (EventClass * klass) {
	event_parent_class = g_type_class_peek_parent (klass);
	EVENT_CLASS (klass)->finalize = event_finalize;
}


static void event_instance_init (Event * self) {
	gchar* _tmp0_;
	self->message = NULL;
	_tmp0_ = g_strdup ("gtk-about");
	self->message_icon = _tmp0_;
	self->enter_network_error_mode = FALSE;
	self->enter_error_mode = FALSE;
	self->transient_error_message = FALSE;
	self->context = NULL;
	self->cause = NULL;
	self->permissions = NULL;
	self->mail_name = NULL;
	self->mail_body = NULL;
	self->commands = NULL;
	self->ref_count = 1;
}


static void event_finalize (Event* obj) {
	Event * self;
	self = EVENT (obj);
	_g_free0 (self->message);
	_g_free0 (self->message_icon);
	_g_free0 (self->context);
	_g_free0 (self->cause);
	_g_free0 (self->permissions);
	_g_free0 (self->mail_name);
	_g_free0 (self->mail_body);
	_g_object_unref0 (self->commands);
}


GType event_get_type (void) {
	static volatile gsize event_type_id__volatile = 0;
	if (g_once_init_enter (&event_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_event_init, value_event_free_value, value_event_copy_value, value_event_peek_pointer, "p", value_event_collect_value, "p", value_event_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Event), 0, (GInstanceInitFunc) event_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType event_type_id;
		event_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Event", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&event_type_id__volatile, event_type_id);
	}
	return event_type_id__volatile;
}


gpointer event_ref (gpointer instance) {
	Event* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void event_unref (gpointer instance) {
	Event* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EVENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _lambda0_ (guint s, smdApplet* self) {
	gboolean _tmp0_;
	_tmp0_ = is_nm_connected (s);
	if (_tmp0_) {
		gtk_check_menu_item_set_active (self->priv->miPause, FALSE);
	} else {
		gtk_check_menu_item_set_active (self->priv->miPause, TRUE);
	}
}


static void __lambda0__network_manager_state_changed (NetworkManager* _sender, guint state, gpointer self) {
	_lambda0_ (state, self);
}


static void _lambda1_ (GtkComboBox* cb, smdApplet* self) {
	gint _tmp0_;
	gint selected;
	GError * _inner_error_ = NULL;
	g_return_if_fail (cb != NULL);
	_tmp0_ = gtk_combo_box_get_active ((GtkComboBox*) self->priv->cblogs);
	selected = _tmp0_;
	if (selected >= 0) {
		gpointer _tmp1_ = NULL;
		gchar* file;
		gchar* content = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gboolean _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->lognames, selected);
		file = (gchar*) _tmp1_;
		_tmp2_ = g_strconcat (SMD_LOGS_DIR, file, NULL);
		_tmp3_ = _tmp2_;
		_tmp5_ = g_file_get_contents (_tmp3_, &_tmp4_, NULL, &_inner_error_);
		_g_free0 (content);
		content = _tmp4_;
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp3_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			_g_free0 (content);
			_g_free0 (file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (_tmp7_) {
			GObject* _tmp8_ = NULL;
			GObject* _tmp9_;
			GtkTextView* _tmp10_;
			GtkTextView* tv;
			GtkTextBuffer* _tmp11_ = NULL;
			GtkTextBuffer* _tmp12_;
			GtkTextBuffer* b;
			GtkTextIter end_iter = {0};
			GtkTextIter _tmp13_ = {0};
			GtkTextMark* _tmp14_ = NULL;
			GtkTextMark* _tmp15_;
			GtkTextMark* end_mark;
			_tmp8_ = gtk_builder_get_object (self->priv->builder, "tvLog");
			_tmp9_ = _tmp8_;
			_tmp10_ = _g_object_ref0 (GTK_IS_TEXT_VIEW (_tmp9_) ? ((GtkTextView*) _tmp9_) : NULL);
			tv = _tmp10_;
			_tmp11_ = gtk_text_view_get_buffer (tv);
			_tmp12_ = _g_object_ref0 (_tmp11_);
			b = _tmp12_;
			gtk_text_buffer_set_text (b, content, -1);
			gtk_text_buffer_get_end_iter (b, &_tmp13_);
			end_iter = _tmp13_;
			_tmp14_ = gtk_text_buffer_create_mark (b, "end", &end_iter, FALSE);
			_tmp15_ = _g_object_ref0 (_tmp14_);
			end_mark = _tmp15_;
			gtk_text_view_scroll_to_mark (tv, end_mark, 0.0, TRUE, 0.0, 0.0);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (b);
			_g_object_unref0 (tv);
		} else {
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp16_ = g_strconcat (SMD_LOGS_DIR, file, NULL);
			_tmp17_ = _tmp16_;
			fprintf (stderr, "Unable to read %s\n", _tmp17_);
			_g_free0 (_tmp17_);
		}
		goto __finally2;
		__catch2_g_file_error:
		{
			GError * e;
			gchar* _tmp18_;
			gchar* _tmp19_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp18_ = g_strconcat (SMD_LOGS_DIR, file, NULL);
			_tmp19_ = _tmp18_;
			fprintf (stderr, "Unable to read %s: %s\n", _tmp19_, e->message);
			_g_free0 (_tmp19_);
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_free0 (content);
			_g_free0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (content);
		_g_free0 (file);
	}
}


static void __lambda1__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	_lambda1_ (_sender, self);
}


static void _smd_applet_close_logs_action_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	smd_applet_close_logs_action (self, _sender);
}


static gboolean _smd_applet_close_logs_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = smd_applet_close_logs_event (self, event);
	return result;
}


static void _smd_applet_close_prefs_action_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	smd_applet_close_prefs_action (self, _sender);
}


static void _lambda3_ (GtkToggleButton* b, smdApplet* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	_tmp0_ = gtk_toggle_button_get_active (b);
	gconf_client_set_bool (self->priv->gconf, SMD_APPLET_key_icon, _tmp0_, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	_tmp1_ = gconf_client_get_bool (self->priv->gconf, SMD_APPLET_key_icon, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	gtk_status_icon_set_visible (self->priv->si, !_tmp2_);
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "%s\n", e->message);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda3__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda3_ (_sender, self);
}


static void _lambda4_ (GtkToggleButton* b, smdApplet* self) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	_tmp0_ = gtk_toggle_button_get_active (b);
	gconf_client_set_bool (self->priv->gconf, SMD_APPLET_key_newmail, _tmp0_, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch6_g_error;
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "%s\n", e->message);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda4__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda4_ (_sender, self);
}


static void _smd_applet_close_err_action_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	smd_applet_close_err_action (self, _sender);
}


static void _lambda5_ (GtkButton* b, smdApplet* self) {
	gboolean _tmp0_;
	gchar* _tmp3_ = NULL;
	gchar* cmd;
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	_tmp0_ = smd_applet_is_smd_loop_configured (self);
	if (!_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = g_strdup_printf ("%s -t", smd_applet_smd_loop_cmd);
		_tmp2_ = _tmp1_;
		g_spawn_command_line_sync (_tmp2_, NULL, NULL, NULL, &_inner_error_);
		_g_free0 (_tmp2_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch7_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = g_strdup_printf ("gnome-open %s", SMD_LOOP_CFG);
	cmd = _tmp3_;
	g_spawn_command_line_async (cmd, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (cmd);
		if (_inner_error_->domain == G_SPAWN_ERROR) {
			goto __catch7_g_spawn_error;
		}
		_g_free0 (cmd);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	smd_applet_is_smd_loop_configured (self);
	_g_free0 (cmd);
	goto __finally7;
	__catch7_g_spawn_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "%s\n", e->message);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda5__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda5_ (_sender, self);
}


static void _lambda6_ (GtkButton* b, smdApplet* self) {
	gboolean _tmp0_;
	gchar* _tmp3_ = NULL;
	gchar* cmd;
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	_tmp0_ = smd_applet_is_smd_pushpull_configured (self);
	if (!_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = g_strdup_printf ("%s -t", smd_applet_smd_push_cmd);
		_tmp2_ = _tmp1_;
		g_spawn_command_line_sync (_tmp2_, NULL, NULL, NULL, &_inner_error_);
		_g_free0 (_tmp2_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch8_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = g_strdup_printf ("gnome-open %s", SMD_PP_DEF_CFG);
	cmd = _tmp3_;
	g_spawn_command_line_async (cmd, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (cmd);
		if (_inner_error_->domain == G_SPAWN_ERROR) {
			goto __catch8_g_spawn_error;
		}
		_g_free0 (cmd);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	smd_applet_is_smd_pushpull_configured (self);
	_g_free0 (cmd);
	goto __finally8;
	__catch8_g_spawn_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "%s\n", e->message);
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda6__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda6_ (_sender, self);
}


static void _lambda7_ (GtkMenuItem* b, smdApplet* self) {
	g_return_if_fail (b != NULL);
	self->priv->thread_die = TRUE;
	if (((gint) self->priv->pid) != 0) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = g_strdup_printf ("sending SIGTERM to %d", -((gint) self->priv->pid));
		_tmp1_ = _tmp0_;
		debug (_tmp1_);
		_g_free0 (_tmp1_);
		kill ((pid_t) (-((gint) self->priv->pid)), SIGTERM);
	}
	gtk_main_quit ();
}


static void __lambda7__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda7_ (_sender, self);
}


static void _lambda8_ (GtkCheckMenuItem* b, smdApplet* self) {
	gboolean _tmp0_;
	g_return_if_fail (b != NULL);
	_tmp0_ = gtk_check_menu_item_get_active (self->priv->miPause);
	if (_tmp0_) {
		smd_applet_pause (self);
	} else {
		smd_applet_unpause (self);
	}
}


static void __lambda8__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	_lambda8_ (_sender, self);
}


static void _lambda9_ (gint id, smdApplet* self) {
	gtk_widget_hide ((GtkWidget*) self->priv->about_win);
}


static void __lambda9__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	_lambda9_ (response_id, self);
}


static void _lambda10_ (GtkMenuItem* b, smdApplet* self) {
	g_return_if_fail (b != NULL);
	gtk_dialog_run ((GtkDialog*) self->priv->about_win);
}


static void __lambda10__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda10_ (_sender, self);
}


static void _lambda11_ (GtkMenuItem* b, smdApplet* self) {
	g_return_if_fail (b != NULL);
	gtk_widget_show ((GtkWidget*) self->priv->win);
}


static void __lambda11__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda11_ (_sender, self);
}


static void _lambda12_ (GtkMenuItem* b, smdApplet* self) {
	g_return_if_fail (b != NULL);
	smd_applet_update_loglist (self);
	gtk_widget_show ((GtkWidget*) self->priv->log_win);
}


static void __lambda12__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda12_ (_sender, self);
}


static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	gtk_status_icon_position_menu (menu, x, y, push_in, self);
}


static void _lambda13_ (guint button, guint time, smdApplet* self) {
	guint32 _tmp0_;
	_tmp0_ = gtk_get_current_event_time ();
	gtk_menu_popup (self->priv->menuR, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, self->priv->si, (guint) 0, _tmp0_);
}


static void __lambda13__gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self) {
	_lambda13_ (button, activate_time, self);
}


static void _lambda14_ (GtkStatusIcon* s, smdApplet* self) {
	g_return_if_fail (s != NULL);
	if (self->priv->error_mode) {
		gtk_window_reshow_with_initial_size (self->priv->err_win);
	} else {
		if (self->priv->config_wait_mode) {
			gtk_widget_show ((GtkWidget*) self->priv->win);
		} else {
			guint32 _tmp0_;
			_tmp0_ = gtk_get_current_event_time ();
			gtk_menu_popup (self->priv->menuL, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, self->priv->si, (guint) 0, _tmp0_);
		}
	}
}


static void __lambda14__gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self) {
	_lambda14_ (_sender, self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


smdApplet* smd_applet_construct (GType object_type, gboolean hide_status_icon, GError** error) {
	smdApplet* self = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GeeArrayList* _tmp2_ = NULL;
	GMutex* _tmp3_ = NULL;
	GConfClient* _tmp4_ = NULL;
	GConfClient* _tmp5_;
	NetworkManager* _tmp6_ = NULL;
	NetworkManager* _tmp7_;
	GObject* _tmp8_ = NULL;
	GObject* _tmp9_;
	GtkWindow* _tmp10_;
	GObject* _tmp11_ = NULL;
	GObject* _tmp12_;
	GtkWindow* _tmp13_;
	GObject* _tmp14_ = NULL;
	GObject* _tmp15_;
	GtkAboutDialog* _tmp16_;
	GObject* _tmp17_ = NULL;
	GObject* _tmp18_;
	GtkWindow* _tmp19_;
	GObject* _tmp20_ = NULL;
	GObject* _tmp21_;
	GtkVBox* _tmp22_;
	GtkVBox* logs_vb;
	GtkComboBoxText* _tmp23_ = NULL;
	GeeArrayList* _tmp24_ = NULL;
	GObject* _tmp25_ = NULL;
	GObject* _tmp26_;
	GtkButton* _tmp27_;
	GtkButton* close_log;
	GObject* _tmp28_ = NULL;
	GObject* _tmp29_;
	GtkButton* _tmp30_;
	GtkButton* close;
	GObject* _tmp31_ = NULL;
	GObject* _tmp32_;
	GtkCheckButton* _tmp33_;
	GtkCheckButton* bicon;
	gboolean _tmp34_;
	gboolean _tmp35_;
	GObject* _tmp36_ = NULL;
	GObject* _tmp37_;
	GtkCheckButton* _tmp38_;
	GtkCheckButton* bnotify;
	gboolean _tmp39_;
	gboolean _tmp40_;
	GObject* _tmp41_ = NULL;
	GObject* _tmp42_;
	GtkButton* _tmp43_;
	GtkButton* bc;
	GObject* _tmp44_ = NULL;
	GObject* _tmp45_;
	GtkButton* _tmp46_;
	GtkButton* bel;
	GObject* _tmp47_ = NULL;
	GObject* _tmp48_;
	GtkButton* _tmp49_;
	GtkButton* bepp;
	GObject* _tmp50_ = NULL;
	GObject* _tmp51_;
	GtkMenu* _tmp52_;
	GObject* _tmp53_ = NULL;
	GObject* _tmp54_;
	GtkMenu* _tmp55_;
	GObject* _tmp56_ = NULL;
	GObject* _tmp57_;
	GtkMenuItem* _tmp58_;
	GtkMenuItem* quit;
	GObject* _tmp59_ = NULL;
	GObject* _tmp60_;
	GtkCheckMenuItem* _tmp61_;
	GObject* _tmp62_ = NULL;
	GObject* _tmp63_;
	GtkMenuItem* _tmp64_;
	GtkMenuItem* about;
	GObject* _tmp65_ = NULL;
	GObject* _tmp66_;
	GtkMenuItem* _tmp67_;
	GtkMenuItem* prefs;
	GObject* _tmp68_ = NULL;
	GObject* _tmp69_;
	GtkMenuItem* _tmp70_;
	GtkMenuItem* logs;
	GtkStatusIcon* _tmp71_ = NULL;
	GList* _tmp72_ = NULL;
	GList* l;
	gint _tmp73_;
	GHashTable* _tmp74_ = NULL;
	GError * _inner_error_ = NULL;
	self = (smdApplet*) g_type_create_instance (object_type);
	_tmp0_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->builder);
	self->priv->builder = _tmp0_;
	gtk_builder_add_from_file (self->priv->builder, smd_applet_smd_applet_ui, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		GError* _tmp1_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "%s\n", e->message);
		_tmp1_ = g_error_new_literal (EXIT, EXIT_ABORT, "Unable to load the ui file");
		_inner_error_ = _tmp1_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			_smd_applet_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = gee_array_list_new (TYPE_EVENT, (GBoxedCopyFunc) event_ref, event_unref, NULL);
	_g_object_unref0 (self->priv->events);
	self->priv->events = _tmp2_;
	_tmp3_ = g_mutex_new ();
	_g_mutex_free0 (self->priv->events_lock);
	self->priv->events_lock = _tmp3_;
	_tmp4_ = gconf_client_get_default ();
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->gconf);
	self->priv->gconf = _tmp5_;
	_tmp6_ = g_initable_new (TYPE_NETWORK_MANAGER_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", NM_SERVICE, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", NM_PATH, "g-interface-name", "org.freedesktop.NetworkManager", NULL);
	_tmp7_ = (NetworkManager*) _tmp6_;
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	_g_object_unref0 (self->priv->net_manager);
	self->priv->net_manager = _tmp7_;
	g_signal_connect (self->priv->net_manager, "state-changed", (GCallback) __lambda0__network_manager_state_changed, self);
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "%s\n", e->message);
		_g_object_unref0 (self->priv->net_manager);
		self->priv->net_manager = NULL;
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			_smd_applet_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = gtk_builder_get_object (self->priv->builder, "wPrefs");
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (GTK_IS_WINDOW (_tmp9_) ? ((GtkWindow*) _tmp9_) : NULL);
	_g_object_unref0 (self->priv->win);
	self->priv->win = _tmp10_;
	_tmp11_ = gtk_builder_get_object (self->priv->builder, "wError");
	_tmp12_ = _tmp11_;
	_tmp13_ = _g_object_ref0 (GTK_IS_WINDOW (_tmp12_) ? ((GtkWindow*) _tmp12_) : NULL);
	_g_object_unref0 (self->priv->err_win);
	self->priv->err_win = _tmp13_;
	_tmp14_ = gtk_builder_get_object (self->priv->builder, "wAbout");
	_tmp15_ = _tmp14_;
	_tmp16_ = _g_object_ref0 (GTK_IS_ABOUT_DIALOG (_tmp15_) ? ((GtkAboutDialog*) _tmp15_) : NULL);
	_g_object_unref0 (self->priv->about_win);
	self->priv->about_win = _tmp16_;
	_tmp17_ = gtk_builder_get_object (self->priv->builder, "wLog");
	_tmp18_ = _tmp17_;
	_tmp19_ = _g_object_ref0 (GTK_IS_WINDOW (_tmp18_) ? ((GtkWindow*) _tmp18_) : NULL);
	_g_object_unref0 (self->priv->log_win);
	self->priv->log_win = _tmp19_;
	_tmp20_ = gtk_builder_get_object (self->priv->builder, "vbLog");
	_tmp21_ = _tmp20_;
	_tmp22_ = _g_object_ref0 (GTK_IS_VBOX (_tmp21_) ? ((GtkVBox*) _tmp21_) : NULL);
	logs_vb = _tmp22_;
	_tmp23_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	_g_object_unref0 (self->priv->cblogs);
	self->priv->cblogs = g_object_ref_sink (_tmp23_);
	_tmp24_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_g_object_unref0 (self->priv->lognames);
	self->priv->lognames = _tmp24_;
	gtk_box_pack_start ((GtkBox*) logs_vb, (GtkWidget*) self->priv->cblogs, FALSE, TRUE, (guint) 0);
	gtk_box_reorder_child ((GtkBox*) logs_vb, (GtkWidget*) self->priv->cblogs, 0);
	gtk_widget_show ((GtkWidget*) self->priv->cblogs);
	g_signal_connect ((GtkComboBox*) self->priv->cblogs, "changed", (GCallback) __lambda1__gtk_combo_box_changed, self);
	_tmp25_ = gtk_builder_get_object (self->priv->builder, "bLogClose");
	_tmp26_ = _tmp25_;
	_tmp27_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp26_) ? ((GtkButton*) _tmp26_) : NULL);
	close_log = _tmp27_;
	g_signal_connect (close_log, "clicked", (GCallback) _smd_applet_close_logs_action_gtk_button_clicked, self);
	g_signal_connect ((GtkWidget*) self->priv->log_win, "delete-event", (GCallback) _smd_applet_close_logs_event_gtk_widget_delete_event, self);
	_tmp28_ = gtk_builder_get_object (self->priv->builder, "bClosePrefs");
	_tmp29_ = _tmp28_;
	_tmp30_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp29_) ? ((GtkButton*) _tmp29_) : NULL);
	close = _tmp30_;
	g_signal_connect (close, "clicked", (GCallback) _smd_applet_close_prefs_action_gtk_button_clicked, self);
	_tmp31_ = gtk_builder_get_object (self->priv->builder, "cbIcon");
	_tmp32_ = _tmp31_;
	_tmp33_ = _g_object_ref0 (GTK_IS_CHECK_BUTTON (_tmp32_) ? ((GtkCheckButton*) _tmp32_) : NULL);
	bicon = _tmp33_;
	_tmp34_ = gconf_client_get_bool (self->priv->gconf, SMD_APPLET_key_icon, &_inner_error_);
	_tmp35_ = _tmp34_;
	if (_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	gtk_toggle_button_set_active ((GtkToggleButton*) bicon, _tmp35_);
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "%s\n", e->message);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (bicon);
			_g_object_unref0 (close);
			_g_object_unref0 (close_log);
			_g_object_unref0 (logs_vb);
			_smd_applet_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (bicon);
			_g_object_unref0 (close);
			_g_object_unref0 (close_log);
			_g_object_unref0 (logs_vb);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_signal_connect ((GtkToggleButton*) bicon, "toggled", (GCallback) __lambda3__gtk_toggle_button_toggled, self);
	_tmp36_ = gtk_builder_get_object (self->priv->builder, "cbNotify");
	_tmp37_ = _tmp36_;
	_tmp38_ = _g_object_ref0 (GTK_IS_CHECK_BUTTON (_tmp37_) ? ((GtkCheckButton*) _tmp37_) : NULL);
	bnotify = _tmp38_;
	_tmp39_ = gconf_client_get_bool (self->priv->gconf, SMD_APPLET_key_newmail, &_inner_error_);
	_tmp40_ = _tmp39_;
	if (_inner_error_ != NULL) {
		goto __catch5_g_error;
	}
	gtk_toggle_button_set_active ((GtkToggleButton*) bnotify, _tmp40_);
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "%s\n", e->message);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (bnotify);
			_g_object_unref0 (bicon);
			_g_object_unref0 (close);
			_g_object_unref0 (close_log);
			_g_object_unref0 (logs_vb);
			_smd_applet_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (bnotify);
			_g_object_unref0 (bicon);
			_g_object_unref0 (close);
			_g_object_unref0 (close_log);
			_g_object_unref0 (logs_vb);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	g_signal_connect ((GtkToggleButton*) bnotify, "toggled", (GCallback) __lambda4__gtk_toggle_button_toggled, self);
	_tmp41_ = gtk_builder_get_object (self->priv->builder, "bClose");
	_tmp42_ = _tmp41_;
	_tmp43_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp42_) ? ((GtkButton*) _tmp42_) : NULL);
	bc = _tmp43_;
	g_signal_connect (bc, "clicked", (GCallback) _smd_applet_close_err_action_gtk_button_clicked, self);
	_tmp44_ = gtk_builder_get_object (self->priv->builder, "bEditLoopCfg");
	_tmp45_ = _tmp44_;
	_tmp46_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp45_) ? ((GtkButton*) _tmp45_) : NULL);
	bel = _tmp46_;
	g_signal_connect (bel, "clicked", (GCallback) __lambda5__gtk_button_clicked, self);
	_tmp47_ = gtk_builder_get_object (self->priv->builder, "bEditPushPullCfg");
	_tmp48_ = _tmp47_;
	_tmp49_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp48_) ? ((GtkButton*) _tmp48_) : NULL);
	bepp = _tmp49_;
	g_signal_connect (bepp, "clicked", (GCallback) __lambda6__gtk_button_clicked, self);
	_tmp50_ = gtk_builder_get_object (self->priv->builder, "mLeft");
	_tmp51_ = _tmp50_;
	_tmp52_ = _g_object_ref0 (GTK_IS_MENU (_tmp51_) ? ((GtkMenu*) _tmp51_) : NULL);
	_g_object_unref0 (self->priv->menuL);
	self->priv->menuL = _tmp52_;
	_tmp53_ = gtk_builder_get_object (self->priv->builder, "mRight");
	_tmp54_ = _tmp53_;
	_tmp55_ = _g_object_ref0 (GTK_IS_MENU (_tmp54_) ? ((GtkMenu*) _tmp54_) : NULL);
	_g_object_unref0 (self->priv->menuR);
	self->priv->menuR = _tmp55_;
	_tmp56_ = gtk_builder_get_object (self->priv->builder, "miQuit");
	_tmp57_ = _tmp56_;
	_tmp58_ = _g_object_ref0 (GTK_IS_MENU_ITEM (_tmp57_) ? ((GtkMenuItem*) _tmp57_) : NULL);
	quit = _tmp58_;
	g_signal_connect (quit, "activate", (GCallback) __lambda7__gtk_menu_item_activate, self);
	_tmp59_ = gtk_builder_get_object (self->priv->builder, "miPause");
	_tmp60_ = _tmp59_;
	_tmp61_ = _g_object_ref0 (GTK_IS_CHECK_MENU_ITEM (_tmp60_) ? ((GtkCheckMenuItem*) _tmp60_) : NULL);
	_g_object_unref0 (self->priv->miPause);
	self->priv->miPause = _tmp61_;
	g_signal_connect (self->priv->miPause, "toggled", (GCallback) __lambda8__gtk_check_menu_item_toggled, self);
	_tmp62_ = gtk_builder_get_object (self->priv->builder, "miAbout");
	_tmp63_ = _tmp62_;
	_tmp64_ = _g_object_ref0 (GTK_IS_MENU_ITEM (_tmp63_) ? ((GtkMenuItem*) _tmp63_) : NULL);
	about = _tmp64_;
	g_signal_connect ((GtkDialog*) self->priv->about_win, "response", (GCallback) __lambda9__gtk_dialog_response, self);
	g_signal_connect (about, "activate", (GCallback) __lambda10__gtk_menu_item_activate, self);
	gtk_about_dialog_set_comments (self->priv->about_win, "GNOME applet for syncmaildir version " SMD_CONF_VERSION);
	_tmp65_ = gtk_builder_get_object (self->priv->builder, "miPrefs");
	_tmp66_ = _tmp65_;
	_tmp67_ = _g_object_ref0 (GTK_IS_MENU_ITEM (_tmp66_) ? ((GtkMenuItem*) _tmp66_) : NULL);
	prefs = _tmp67_;
	g_signal_connect (prefs, "activate", (GCallback) __lambda11__gtk_menu_item_activate, self);
	_tmp68_ = gtk_builder_get_object (self->priv->builder, "miLog");
	_tmp69_ = _tmp68_;
	_tmp70_ = _g_object_ref0 (GTK_IS_MENU_ITEM (_tmp69_) ? ((GtkMenuItem*) _tmp69_) : NULL);
	logs = _tmp70_;
	g_signal_connect (logs, "activate", (GCallback) __lambda12__gtk_menu_item_activate, self);
	_tmp71_ = gtk_status_icon_new_from_icon_name ("mail-send-receive");
	_g_object_unref0 (self->priv->si);
	self->priv->si = _tmp71_;
	gtk_status_icon_set_visible (self->priv->si, !hide_status_icon);
	gtk_status_icon_set_tooltip_text (self->priv->si, "smd-applet is running");
	g_signal_connect (self->priv->si, "popup-menu", (GCallback) __lambda13__gtk_status_icon_popup_menu, self);
	g_signal_connect (self->priv->si, "activate", (GCallback) __lambda14__gtk_status_icon_activate, self);
	_tmp72_ = notify_get_server_caps ();
	l = _tmp72_;
	_tmp73_ = g_list_index (l, "persistence");
	self->priv->notification_server_has_persistence = 0 <= _tmp73_;
	_tmp74_ = g_hash_table_new_full (g_direct_hash, g_str_equal, _g_object_unref0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->command_hash);
	self->priv->command_hash = _tmp74_;
	_g_object_unref0 (logs);
	_g_object_unref0 (prefs);
	_g_object_unref0 (about);
	_g_object_unref0 (quit);
	_g_object_unref0 (bepp);
	_g_object_unref0 (bel);
	_g_object_unref0 (bc);
	_g_object_unref0 (bnotify);
	_g_object_unref0 (bicon);
	_g_object_unref0 (close);
	_g_object_unref0 (close_log);
	_g_object_unref0 (logs_vb);
	return self;
}


smdApplet* smd_applet_new (gboolean hide_status_icon, GError** error) {
	return smd_applet_construct (TYPE_SMD_APPLET, hide_status_icon, error);
}


static void* smd_applet_smdThread (smdApplet* self) {
	void* result = NULL;
	gboolean rc;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	rc = TRUE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		gboolean _tmp2_;
		if (rc) {
			_tmp0_ = !self->priv->thread_die;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		debug ("(re)starting smd-loop");
		_tmp1_ = smd_applet_run_smd_loop (self, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == EXIT) {
				goto __catch9_exit;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		rc = _tmp2_;
		goto __finally9;
		__catch9_exit:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			rc = FALSE;
			_g_error_free0 (e);
		}
		__finally9:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = NULL;
	return result;
}


static gpointer _smd_applet_smdThread_gthread_func (gpointer self) {
	gpointer result;
	result = smd_applet_smdThread (self);
	return result;
}


static void smd_applet_start_smdThread (smdApplet* self, gboolean force) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (!force) {
		_tmp1_ = self->priv->net_manager != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		guint _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = network_manager_get_state (self->priv->net_manager);
		_tmp3_ = is_nm_connected (_tmp2_);
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_check_menu_item_set_active (self->priv->miPause, TRUE);
	} else {
		GThread* _tmp4_ = NULL;
		GThread* _tmp5_;
		_tmp4_ = g_thread_create (_smd_applet_smdThread_gthread_func, self, TRUE, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_THREAD_ERROR) {
				goto __catch10_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->thread = _tmp5_;
		goto __finally10;
		__catch10_g_thread_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stderr, "Unable to start a thread\n");
			gtk_main_quit ();
			_g_error_free0 (e);
		}
		__finally10:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gboolean smd_applet_eval_smd_loop_error_message (smdApplet* self, const gchar* args, const gchar* account, const gchar* host, GError** error) {
	gboolean result = FALSE;
	GRegex* _tmp0_ = NULL;
	GRegex* context;
	GRegex* _tmp1_ = NULL;
	GRegex* cause;
	GRegex* _tmp2_ = NULL;
	GRegex* human;
	GRegex* _tmp3_ = NULL;
	GRegex* actions;
	GMatchInfo* i_ctx;
	GMatchInfo* i_cause;
	GMatchInfo* i_human;
	GMatchInfo* i_act;
	GMatchInfo* _tmp4_ = NULL;
	gboolean _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_;
	GMatchInfo* _tmp8_ = NULL;
	gboolean _tmp9_;
	GMatchInfo* _tmp10_ = NULL;
	gboolean _tmp11_;
	gboolean has_actions;
	gboolean _tmp12_ = FALSE;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gboolean _tmp15_;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	gboolean _tmp23_;
	gchar* permissions;
	gchar* mail_name;
	gchar* mail_body;
	GeeArrayList* _tmp29_ = NULL;
	GeeArrayList* commands;
	gint _tmp63_;
	gchar* _tmp64_ = NULL;
	gchar* _tmp65_;
	gchar* _tmp66_ = NULL;
	gchar* _tmp67_;
	Event* _tmp68_ = NULL;
	Event* _tmp69_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (args != NULL, FALSE);
	g_return_val_if_fail (account != NULL, FALSE);
	g_return_val_if_fail (host != NULL, FALSE);
	_tmp0_ = g_regex_new ("context\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
	context = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp1_ = g_regex_new ("probable-cause\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
	cause = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_regex_unref0 (context);
			return FALSE;
		} else {
			_g_regex_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp2_ = g_regex_new ("human-intervention\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
	human = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			return FALSE;
		} else {
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp3_ = g_regex_new ("suggested-actions\\((.*)\\) *$", 0, 0, &_inner_error_);
	actions = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_regex_unref0 (human);
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			return FALSE;
		} else {
			_g_regex_unref0 (human);
			_g_regex_unref0 (cause);
			_g_regex_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	i_ctx = NULL;
	i_cause = NULL;
	i_human = NULL;
	i_act = NULL;
	_tmp5_ = g_regex_match (context, args, 0, &_tmp4_);
	_g_match_info_free0 (i_ctx);
	i_ctx = _tmp4_;
	if (!_tmp5_) {
		fprintf (stderr, "smd-loop error with no context: %s\n", args);
		result = TRUE;
		_g_match_info_free0 (i_act);
		_g_match_info_free0 (i_human);
		_g_match_info_free0 (i_cause);
		_g_match_info_free0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	_tmp7_ = g_regex_match (cause, args, 0, &_tmp6_);
	_g_match_info_free0 (i_cause);
	i_cause = _tmp6_;
	if (!_tmp7_) {
		fprintf (stderr, "smd-loop error with no cause: %s\n", args);
		result = TRUE;
		_g_match_info_free0 (i_act);
		_g_match_info_free0 (i_human);
		_g_match_info_free0 (i_cause);
		_g_match_info_free0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	_tmp9_ = g_regex_match (human, args, 0, &_tmp8_);
	_g_match_info_free0 (i_human);
	i_human = _tmp8_;
	if (!_tmp9_) {
		fprintf (stderr, "smd-loop error with no human: %s\n", args);
		result = TRUE;
		_g_match_info_free0 (i_act);
		_g_match_info_free0 (i_human);
		_g_match_info_free0 (i_cause);
		_g_match_info_free0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	_tmp11_ = g_regex_match (actions, args, 0, &_tmp10_);
	_g_match_info_free0 (i_act);
	i_act = _tmp10_;
	has_actions = _tmp11_;
	_tmp13_ = g_match_info_fetch (i_human, 1);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strcmp0 (_tmp14_, "necessary") != 0;
	_g_free0 (_tmp14_);
	if (_tmp15_) {
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp16_ = g_match_info_fetch (i_cause, 1);
		_tmp17_ = _tmp16_;
		_tmp12_ = g_strcmp0 (_tmp17_, "network") == 0;
		_g_free0 (_tmp17_);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gint _tmp18_;
		Event* _tmp19_ = NULL;
		Event* _tmp20_;
		g_mutex_lock (self->priv->events_lock);
		_tmp18_ = gee_collection_get_size ((GeeCollection*) self->priv->events);
		_tmp19_ = event_network_error ();
		_tmp20_ = _tmp19_;
		gee_abstract_list_insert ((GeeAbstractList*) self->priv->events, _tmp18_, _tmp20_);
		_event_unref0 (_tmp20_);
		g_mutex_unlock (self->priv->events_lock);
		result = TRUE;
		_g_match_info_free0 (i_act);
		_g_match_info_free0 (i_human);
		_g_match_info_free0 (i_cause);
		_g_match_info_free0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	_tmp21_ = g_match_info_fetch (i_human, 1);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strcmp0 (_tmp22_, "necessary") != 0;
	_g_free0 (_tmp22_);
	if (_tmp23_) {
		gint _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		Event* _tmp27_ = NULL;
		Event* _tmp28_;
		fprintf (stderr, "smd-loop giving an avoidable error: %s\n", args);
		g_mutex_lock (self->priv->events_lock);
		_tmp24_ = gee_collection_get_size ((GeeCollection*) self->priv->events);
		_tmp25_ = g_match_info_fetch (i_cause, 1);
		_tmp26_ = _tmp25_;
		_tmp27_ = event_generic_error (_tmp26_);
		_tmp28_ = _tmp27_;
		gee_abstract_list_insert ((GeeAbstractList*) self->priv->events, _tmp24_, _tmp28_);
		_event_unref0 (_tmp28_);
		_g_free0 (_tmp26_);
		g_mutex_unlock (self->priv->events_lock);
		result = TRUE;
		_g_match_info_free0 (i_act);
		_g_match_info_free0 (i_human);
		_g_match_info_free0 (i_cause);
		_g_match_info_free0 (i_ctx);
		_g_regex_unref0 (actions);
		_g_regex_unref0 (human);
		_g_regex_unref0 (cause);
		_g_regex_unref0 (context);
		return result;
	}
	permissions = NULL;
	mail_name = NULL;
	mail_body = NULL;
	_tmp29_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	commands = _tmp29_;
	if (has_actions) {
		gchar* _tmp30_ = NULL;
		gchar* acts;
		GRegex* _tmp31_ = NULL;
		GRegex* r_perm;
		GRegex* _tmp32_ = NULL;
		GRegex* r_mail;
		GRegex* _tmp33_ = NULL;
		GRegex* r_cmd;
		gint from;
		_tmp30_ = g_match_info_fetch (i_act, 1);
		acts = _tmp30_;
		_tmp31_ = g_regex_new ("display-permissions\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
		r_perm = _tmp31_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_free0 (i_act);
				_g_match_info_free0 (i_human);
				_g_match_info_free0 (i_cause);
				_g_match_info_free0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				return FALSE;
			} else {
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_free0 (i_act);
				_g_match_info_free0 (i_human);
				_g_match_info_free0 (i_cause);
				_g_match_info_free0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		_tmp32_ = g_regex_new ("display-mail\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
		r_mail = _tmp32_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_free0 (i_act);
				_g_match_info_free0 (i_human);
				_g_match_info_free0 (i_cause);
				_g_match_info_free0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				return FALSE;
			} else {
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_free0 (i_act);
				_g_match_info_free0 (i_human);
				_g_match_info_free0 (i_cause);
				_g_match_info_free0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		_tmp33_ = g_regex_new ("run\\(([^\\)]+)\\)", 0, 0, &_inner_error_);
		r_cmd = _tmp33_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_regex_unref0 (r_mail);
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_free0 (i_act);
				_g_match_info_free0 (i_human);
				_g_match_info_free0 (i_cause);
				_g_match_info_free0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				return FALSE;
			} else {
				_g_regex_unref0 (r_mail);
				_g_regex_unref0 (r_perm);
				_g_free0 (acts);
				_g_object_unref0 (commands);
				_g_free0 (mail_body);
				_g_free0 (mail_name);
				_g_free0 (permissions);
				_g_match_info_free0 (i_act);
				_g_match_info_free0 (i_human);
				_g_match_info_free0 (i_cause);
				_g_match_info_free0 (i_ctx);
				_g_regex_unref0 (actions);
				_g_regex_unref0 (human);
				_g_regex_unref0 (cause);
				_g_regex_unref0 (context);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		from = 0;
		{
			gboolean _tmp34_;
			_tmp34_ = TRUE;
			while (TRUE) {
				gboolean _tmp35_ = FALSE;
				GMatchInfo* i_cmd;
				GMatchInfo* _tmp37_ = NULL;
				gboolean _tmp38_;
				gchar* _tmp62_ = NULL;
				if (!_tmp34_) {
				}
				_tmp34_ = FALSE;
				if (acts != NULL) {
					gint _tmp36_;
					_tmp36_ = strlen (acts);
					_tmp35_ = _tmp36_ > 0;
				} else {
					_tmp35_ = FALSE;
				}
				if (!_tmp35_) {
					break;
				}
				i_cmd = NULL;
				_tmp38_ = g_regex_match (r_perm, acts, 0, &_tmp37_);
				_g_match_info_free0 (i_cmd);
				i_cmd = _tmp37_;
				if (_tmp38_) {
					gint _tmp39_;
					gchar* _tmp40_ = NULL;
					gchar* file;
					gchar* output;
					gchar* err;
					gchar* _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp43_ = NULL;
					gchar* _tmp44_ = NULL;
					gchar* _tmp45_;
					g_match_info_fetch_pos (i_cmd, 0, NULL, &_tmp39_);
					from = _tmp39_;
					_tmp40_ = g_match_info_fetch (i_cmd, 1);
					file = _tmp40_;
					output = NULL;
					err = NULL;
					_tmp41_ = g_strconcat ("ls -ld ", file, NULL);
					_tmp42_ = _tmp41_;
					g_spawn_command_line_sync (_tmp42_, &_tmp43_, &_tmp44_, NULL, &_inner_error_);
					_g_free0 (output);
					output = _tmp43_;
					_g_free0 (err);
					err = _tmp44_;
					_g_free0 (_tmp42_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_SPAWN_ERROR) {
							goto __catch11_g_spawn_error;
						}
						_g_free0 (err);
						_g_free0 (output);
						_g_free0 (file);
						_g_match_info_free0 (i_cmd);
						_g_regex_unref0 (r_cmd);
						_g_regex_unref0 (r_mail);
						_g_regex_unref0 (r_perm);
						_g_free0 (acts);
						_g_object_unref0 (commands);
						_g_free0 (mail_body);
						_g_free0 (mail_name);
						_g_free0 (permissions);
						_g_match_info_free0 (i_act);
						_g_match_info_free0 (i_human);
						_g_match_info_free0 (i_cause);
						_g_match_info_free0 (i_ctx);
						_g_regex_unref0 (actions);
						_g_regex_unref0 (human);
						_g_regex_unref0 (cause);
						_g_regex_unref0 (context);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
					_tmp45_ = g_strconcat (output, err, NULL);
					_g_free0 (permissions);
					permissions = _tmp45_;
					goto __finally11;
					__catch11_g_spawn_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						fprintf (stderr, "Spawning ls: %s\n", e->message);
						_g_error_free0 (e);
					}
					__finally11:
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_REGEX_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (err);
							_g_free0 (output);
							_g_free0 (file);
							_g_match_info_free0 (i_cmd);
							_g_regex_unref0 (r_cmd);
							_g_regex_unref0 (r_mail);
							_g_regex_unref0 (r_perm);
							_g_free0 (acts);
							_g_object_unref0 (commands);
							_g_free0 (mail_body);
							_g_free0 (mail_name);
							_g_free0 (permissions);
							_g_match_info_free0 (i_act);
							_g_match_info_free0 (i_human);
							_g_match_info_free0 (i_cause);
							_g_match_info_free0 (i_ctx);
							_g_regex_unref0 (actions);
							_g_regex_unref0 (human);
							_g_regex_unref0 (cause);
							_g_regex_unref0 (context);
							return FALSE;
						} else {
							_g_free0 (err);
							_g_free0 (output);
							_g_free0 (file);
							_g_match_info_free0 (i_cmd);
							_g_regex_unref0 (r_cmd);
							_g_regex_unref0 (r_mail);
							_g_regex_unref0 (r_perm);
							_g_free0 (acts);
							_g_object_unref0 (commands);
							_g_free0 (mail_body);
							_g_free0 (mail_name);
							_g_free0 (permissions);
							_g_match_info_free0 (i_act);
							_g_match_info_free0 (i_human);
							_g_match_info_free0 (i_cause);
							_g_match_info_free0 (i_ctx);
							_g_regex_unref0 (actions);
							_g_regex_unref0 (human);
							_g_regex_unref0 (cause);
							_g_regex_unref0 (context);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
					}
					_g_free0 (err);
					_g_free0 (output);
					_g_free0 (file);
				} else {
					GMatchInfo* _tmp46_ = NULL;
					gboolean _tmp47_;
					_tmp47_ = g_regex_match (r_mail, acts, 0, &_tmp46_);
					_g_match_info_free0 (i_cmd);
					i_cmd = _tmp46_;
					if (_tmp47_) {
						gint _tmp48_;
						gchar* _tmp49_ = NULL;
						gchar* file;
						gchar* _tmp50_;
						gchar* output;
						gchar* err;
						gchar* _tmp51_;
						gchar* _tmp52_;
						gchar* _tmp53_;
						gchar* _tmp54_ = NULL;
						gchar* _tmp55_ = NULL;
						gchar* _tmp56_;
						g_match_info_fetch_pos (i_cmd, 0, NULL, &_tmp48_);
						from = _tmp48_;
						_tmp49_ = g_match_info_fetch (i_cmd, 1);
						file = _tmp49_;
						_tmp50_ = g_strdup ("");
						output = _tmp50_;
						err = NULL;
						_tmp51_ = g_strdup (file);
						_g_free0 (mail_name);
						mail_name = _tmp51_;
						_tmp52_ = g_strconcat ("cat ", file, NULL);
						_tmp53_ = _tmp52_;
						g_spawn_command_line_sync (_tmp53_, &_tmp54_, &_tmp55_, NULL, &_inner_error_);
						_g_free0 (output);
						output = _tmp54_;
						_g_free0 (err);
						err = _tmp55_;
						_g_free0 (_tmp53_);
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == G_SPAWN_ERROR) {
								goto __catch12_g_spawn_error;
							}
							_g_free0 (err);
							_g_free0 (output);
							_g_free0 (file);
							_g_match_info_free0 (i_cmd);
							_g_regex_unref0 (r_cmd);
							_g_regex_unref0 (r_mail);
							_g_regex_unref0 (r_perm);
							_g_free0 (acts);
							_g_object_unref0 (commands);
							_g_free0 (mail_body);
							_g_free0 (mail_name);
							_g_free0 (permissions);
							_g_match_info_free0 (i_act);
							_g_match_info_free0 (i_human);
							_g_match_info_free0 (i_cause);
							_g_match_info_free0 (i_ctx);
							_g_regex_unref0 (actions);
							_g_regex_unref0 (human);
							_g_regex_unref0 (cause);
							_g_regex_unref0 (context);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
						_tmp56_ = g_strconcat (output, err, NULL);
						_g_free0 (mail_body);
						mail_body = _tmp56_;
						goto __finally12;
						__catch12_g_spawn_error:
						{
							GError * e;
							e = _inner_error_;
							_inner_error_ = NULL;
							fprintf (stderr, "Spawning ls: %s\n", e->message);
							_g_error_free0 (e);
						}
						__finally12:
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == G_REGEX_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (err);
								_g_free0 (output);
								_g_free0 (file);
								_g_match_info_free0 (i_cmd);
								_g_regex_unref0 (r_cmd);
								_g_regex_unref0 (r_mail);
								_g_regex_unref0 (r_perm);
								_g_free0 (acts);
								_g_object_unref0 (commands);
								_g_free0 (mail_body);
								_g_free0 (mail_name);
								_g_free0 (permissions);
								_g_match_info_free0 (i_act);
								_g_match_info_free0 (i_human);
								_g_match_info_free0 (i_cause);
								_g_match_info_free0 (i_ctx);
								_g_regex_unref0 (actions);
								_g_regex_unref0 (human);
								_g_regex_unref0 (cause);
								_g_regex_unref0 (context);
								return FALSE;
							} else {
								_g_free0 (err);
								_g_free0 (output);
								_g_free0 (file);
								_g_match_info_free0 (i_cmd);
								_g_regex_unref0 (r_cmd);
								_g_regex_unref0 (r_mail);
								_g_regex_unref0 (r_perm);
								_g_free0 (acts);
								_g_object_unref0 (commands);
								_g_free0 (mail_body);
								_g_free0 (mail_name);
								_g_free0 (permissions);
								_g_match_info_free0 (i_act);
								_g_match_info_free0 (i_human);
								_g_match_info_free0 (i_cause);
								_g_match_info_free0 (i_ctx);
								_g_regex_unref0 (actions);
								_g_regex_unref0 (human);
								_g_regex_unref0 (cause);
								_g_regex_unref0 (context);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return FALSE;
							}
						}
						_g_free0 (err);
						_g_free0 (output);
						_g_free0 (file);
					} else {
						GMatchInfo* _tmp57_ = NULL;
						gboolean _tmp58_;
						_tmp58_ = g_regex_match (r_cmd, acts, 0, &_tmp57_);
						_g_match_info_free0 (i_cmd);
						i_cmd = _tmp57_;
						if (_tmp58_) {
							gchar* _tmp59_ = NULL;
							gchar* command;
							gint _tmp60_;
							gint _tmp61_;
							_tmp59_ = g_match_info_fetch (i_cmd, 1);
							command = _tmp59_;
							g_match_info_fetch_pos (i_cmd, 0, NULL, &_tmp60_);
							from = _tmp60_;
							_tmp61_ = gee_collection_get_size ((GeeCollection*) commands);
							gee_abstract_list_insert ((GeeAbstractList*) commands, _tmp61_, command);
							_g_free0 (command);
						} else {
							fprintf (stderr, "Unrecognized action: %s\n", acts);
							_g_match_info_free0 (i_cmd);
							break;
						}
					}
				}
				_tmp62_ = string_substring (acts, (glong) from, (glong) (-1));
				_g_free0 (acts);
				acts = _tmp62_;
				_g_match_info_free0 (i_cmd);
			}
		}
		_g_regex_unref0 (r_cmd);
		_g_regex_unref0 (r_mail);
		_g_regex_unref0 (r_perm);
		_g_free0 (acts);
	}
	g_mutex_lock (self->priv->events_lock);
	_tmp63_ = gee_collection_get_size ((GeeCollection*) self->priv->events);
	_tmp64_ = g_match_info_fetch (i_ctx, 1);
	_tmp65_ = _tmp64_;
	_tmp66_ = g_match_info_fetch (i_cause, 1);
	_tmp67_ = _tmp66_;
	_tmp68_ = event_error (account, host, _tmp65_, _tmp67_, permissions, mail_name, mail_body, commands);
	_tmp69_ = _tmp68_;
	gee_abstract_list_insert ((GeeAbstractList*) self->priv->events, _tmp63_, _tmp69_);
	_event_unref0 (_tmp69_);
	_g_free0 (_tmp67_);
	_g_free0 (_tmp65_);
	g_mutex_unlock (self->priv->events_lock);
	result = FALSE;
	_g_object_unref0 (commands);
	_g_free0 (mail_body);
	_g_free0 (mail_name);
	_g_free0 (permissions);
	_g_match_info_free0 (i_act);
	_g_match_info_free0 (i_human);
	_g_match_info_free0 (i_cause);
	_g_match_info_free0 (i_ctx);
	_g_regex_unref0 (actions);
	_g_regex_unref0 (human);
	_g_regex_unref0 (cause);
	_g_regex_unref0 (context);
	return result;
}


static gboolean smd_applet_eval_smd_loop_message (smdApplet* self, const gchar* s) {
	gboolean result = FALSE;
	GMatchInfo* info;
	GRegex* _tmp0_ = NULL;
	GRegex* r_tags;
	GRegex* _tmp1_ = NULL;
	GRegex* r_skip;
	gboolean _tmp2_;
	GMatchInfo* _tmp3_ = NULL;
	gboolean _tmp4_;
	gchar* _tmp7_ = NULL;
	gchar* account;
	gchar* _tmp8_ = NULL;
	gchar* host;
	gchar* _tmp9_ = NULL;
	gchar* tags;
	GMatchInfo* i_args;
	GRegex* _tmp10_ = NULL;
	GRegex* r_stats;
	GRegex* _tmp11_ = NULL;
	GRegex* r_error;
	GMatchInfo* _tmp12_ = NULL;
	gboolean _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (s != NULL, FALSE);
	info = NULL;
	_tmp0_ = g_regex_new ("^([^:]+): smd-(client|server|loop|push|pull|pushpull)@([^:]+): TAGS:(." \
"*)$", 0, 0, &_inner_error_);
	r_tags = _tmp0_;
	if (_inner_error_ != NULL) {
		_g_match_info_free0 (info);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch13_g_regex_error;
		}
		_g_match_info_free0 (info);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp1_ = g_regex_new ("^([^:]+): smd-(client|server)@([^:]+): ERROR", 0, 0, &_inner_error_);
	r_skip = _tmp1_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (r_tags);
		_g_match_info_free0 (info);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch13_g_regex_error;
		}
		_g_regex_unref0 (r_tags);
		_g_match_info_free0 (info);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp2_ = g_regex_match (r_skip, s, 0, NULL);
	if (_tmp2_) {
		result = TRUE;
		_g_regex_unref0 (r_skip);
		_g_regex_unref0 (r_tags);
		_g_match_info_free0 (info);
		return result;
	}
	_tmp4_ = g_regex_match (r_tags, s, 0, &_tmp3_);
	_g_match_info_free0 (info);
	info = _tmp3_;
	if (!_tmp4_) {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp5_ = g_strdup_printf ("unhandled smd-loop message: %s", s);
		_tmp6_ = _tmp5_;
		debug (_tmp6_);
		_g_free0 (_tmp6_);
		result = TRUE;
		_g_regex_unref0 (r_skip);
		_g_regex_unref0 (r_tags);
		_g_match_info_free0 (info);
		return result;
	}
	_tmp7_ = g_match_info_fetch (info, 1);
	account = _tmp7_;
	_tmp8_ = g_match_info_fetch (info, 3);
	host = _tmp8_;
	_tmp9_ = g_match_info_fetch (info, 4);
	tags = _tmp9_;
	i_args = NULL;
	_tmp10_ = g_regex_new (" stats::(.*)$", 0, 0, &_inner_error_);
	r_stats = _tmp10_;
	if (_inner_error_ != NULL) {
		_g_match_info_free0 (i_args);
		_g_free0 (tags);
		_g_free0 (host);
		_g_free0 (account);
		_g_regex_unref0 (r_skip);
		_g_regex_unref0 (r_tags);
		_g_match_info_free0 (info);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch13_g_regex_error;
		}
		_g_match_info_free0 (i_args);
		_g_free0 (tags);
		_g_free0 (host);
		_g_free0 (account);
		_g_regex_unref0 (r_skip);
		_g_regex_unref0 (r_tags);
		_g_match_info_free0 (info);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp11_ = g_regex_new (" error::(.*)$", 0, 0, &_inner_error_);
	r_error = _tmp11_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (r_stats);
		_g_match_info_free0 (i_args);
		_g_free0 (tags);
		_g_free0 (host);
		_g_free0 (account);
		_g_regex_unref0 (r_skip);
		_g_regex_unref0 (r_tags);
		_g_match_info_free0 (info);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch13_g_regex_error;
		}
		_g_regex_unref0 (r_stats);
		_g_match_info_free0 (i_args);
		_g_free0 (tags);
		_g_free0 (host);
		_g_free0 (account);
		_g_regex_unref0 (r_skip);
		_g_regex_unref0 (r_tags);
		_g_match_info_free0 (info);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp13_ = g_regex_match (r_stats, tags, 0, &_tmp12_);
	_g_match_info_free0 (i_args);
	i_args = _tmp12_;
	if (_tmp13_) {
		GRegex* _tmp14_ = NULL;
		GRegex* r_neW;
		GRegex* _tmp15_ = NULL;
		GRegex* r_del;
		GMatchInfo* i_new;
		GMatchInfo* i_del;
		gchar* _tmp16_ = NULL;
		gchar* args;
		GMatchInfo* _tmp17_ = NULL;
		gboolean _tmp18_;
		gboolean has_new;
		GMatchInfo* _tmp19_ = NULL;
		gboolean _tmp20_;
		gboolean has_del;
		gint new_mails;
		gint del_mails;
		gboolean _tmp27_ = FALSE;
		_tmp14_ = g_regex_new ("new-mails\\(([0-9]+)\\)", 0, 0, &_inner_error_);
		r_neW = _tmp14_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (r_error);
			_g_regex_unref0 (r_stats);
			_g_match_info_free0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			_g_regex_unref0 (r_error);
			_g_regex_unref0 (r_stats);
			_g_match_info_free0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp15_ = g_regex_new ("del-mails\\(([0-9]+)\\)", 0, 0, &_inner_error_);
		r_del = _tmp15_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (r_neW);
			_g_regex_unref0 (r_error);
			_g_regex_unref0 (r_stats);
			_g_match_info_free0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			_g_regex_unref0 (r_neW);
			_g_regex_unref0 (r_error);
			_g_regex_unref0 (r_stats);
			_g_match_info_free0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		i_new = NULL;
		i_del = NULL;
		_tmp16_ = g_match_info_fetch (i_args, 1);
		args = _tmp16_;
		_tmp18_ = g_regex_match (r_neW, args, 0, &_tmp17_);
		_g_match_info_free0 (i_new);
		i_new = _tmp17_;
		has_new = _tmp18_;
		_tmp20_ = g_regex_match (r_del, args, 0, &_tmp19_);
		_g_match_info_free0 (i_del);
		i_del = _tmp19_;
		has_del = _tmp20_;
		new_mails = 0;
		if (has_new) {
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			gint _tmp23_;
			_tmp21_ = g_match_info_fetch (i_new, 1);
			_tmp22_ = _tmp21_;
			_tmp23_ = atoi (_tmp22_);
			new_mails = _tmp23_;
			_g_free0 (_tmp22_);
		}
		del_mails = 0;
		if (has_del) {
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			gint _tmp26_;
			_tmp24_ = g_match_info_fetch (i_del, 1);
			_tmp25_ = _tmp24_;
			_tmp26_ = atoi (_tmp25_);
			del_mails = _tmp26_;
			_g_free0 (_tmp25_);
		}
		if (g_strcmp0 (host, "localhost") == 0) {
			gboolean _tmp28_ = FALSE;
			if (new_mails > 0) {
				_tmp28_ = TRUE;
			} else {
				_tmp28_ = del_mails > 0;
			}
			_tmp27_ = _tmp28_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			gint _tmp29_;
			Event* _tmp30_ = NULL;
			Event* _tmp31_;
			g_mutex_lock (self->priv->events_lock);
			_tmp29_ = gee_collection_get_size ((GeeCollection*) self->priv->events);
			_tmp30_ = event_stats (account, host, new_mails, del_mails);
			_tmp31_ = _tmp30_;
			gee_abstract_list_insert ((GeeAbstractList*) self->priv->events, _tmp29_, _tmp31_);
			_event_unref0 (_tmp31_);
			g_mutex_unlock (self->priv->events_lock);
		} else {
		}
		result = TRUE;
		_g_free0 (args);
		_g_match_info_free0 (i_del);
		_g_match_info_free0 (i_new);
		_g_regex_unref0 (r_del);
		_g_regex_unref0 (r_neW);
		_g_regex_unref0 (r_error);
		_g_regex_unref0 (r_stats);
		_g_match_info_free0 (i_args);
		_g_free0 (tags);
		_g_free0 (host);
		_g_free0 (account);
		_g_regex_unref0 (r_skip);
		_g_regex_unref0 (r_tags);
		_g_match_info_free0 (info);
		return result;
	} else {
		GMatchInfo* _tmp32_ = NULL;
		gboolean _tmp33_;
		_tmp33_ = g_regex_match (r_error, tags, 0, &_tmp32_);
		_g_match_info_free0 (i_args);
		i_args = _tmp32_;
		if (_tmp33_) {
			gchar* _tmp34_ = NULL;
			gchar* args;
			gboolean _tmp35_;
			gboolean _tmp36_;
			_tmp34_ = g_match_info_fetch (i_args, 1);
			args = _tmp34_;
			_tmp35_ = smd_applet_eval_smd_loop_error_message (self, args, account, host, &_inner_error_);
			_tmp36_ = _tmp35_;
			if (_inner_error_ != NULL) {
				_g_free0 (args);
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_free0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_free0 (info);
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch13_g_regex_error;
				}
				_g_free0 (args);
				_g_regex_unref0 (r_error);
				_g_regex_unref0 (r_stats);
				_g_match_info_free0 (i_args);
				_g_free0 (tags);
				_g_free0 (host);
				_g_free0 (account);
				_g_regex_unref0 (r_skip);
				_g_regex_unref0 (r_tags);
				_g_match_info_free0 (info);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			result = _tmp36_;
			_g_free0 (args);
			_g_regex_unref0 (r_error);
			_g_regex_unref0 (r_stats);
			_g_match_info_free0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			return result;
		} else {
			fprintf (stderr, "unhandled smd-loop message: %s\n", s);
			result = TRUE;
			_g_regex_unref0 (r_error);
			_g_regex_unref0 (r_stats);
			_g_match_info_free0 (i_args);
			_g_free0 (tags);
			_g_free0 (host);
			_g_free0 (account);
			_g_regex_unref0 (r_skip);
			_g_regex_unref0 (r_tags);
			_g_match_info_free0 (info);
			return result;
		}
	}
	_g_regex_unref0 (r_error);
	_g_regex_unref0 (r_stats);
	_g_match_info_free0 (i_args);
	_g_free0 (tags);
	_g_free0 (host);
	_g_free0 (account);
	_g_regex_unref0 (r_skip);
	_g_regex_unref0 (r_tags);
	_g_match_info_free0 (info);
	goto __finally13;
	__catch13_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "%s\n", e->message);
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void _lambda2_ (smdApplet* self) {
	setpgid ((pid_t) 0, (pid_t) 0);
}


static void __lambda2__gspawn_child_setup_func (gpointer self) {
	_lambda2_ (self);
}


static gboolean smd_applet_run_smd_loop (smdApplet* self, GError** error) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** cmd;
	gint cmd_length1;
	gint _cmd_size_;
	gint child_in = 0;
	gint child_out = 0;
	gint child_err = 0;
	gchar* _tmp3_ = NULL;
	gchar* buff;
	gint buff_length1;
	gint _buff_size_;
	GSpawnFlags flags;
	gboolean rc = FALSE;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GPid _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_strdup (smd_applet_smd_loop_cmd);
	_tmp1_ = g_strdup ("-v");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	cmd = _tmp2_;
	cmd_length1 = 2;
	_cmd_size_ = 2;
	_tmp3_ = g_new0 (gchar, 10240);
	buff = _tmp3_;
	buff_length1 = 10240;
	_buff_size_ = 10240;
	flags = 0;
	_tmp4_ = g_strdup_printf ("spawning %s\n", smd_applet_smd_loop_cmd);
	_tmp5_ = _tmp4_;
	debug (_tmp5_);
	_g_free0 (_tmp5_);
	_tmp10_ = g_spawn_async_with_pipes (NULL, cmd, NULL, flags, __lambda2__gspawn_child_setup_func, self, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_inner_error_);
	self->priv->pid = _tmp6_;
	child_in = _tmp7_;
	child_out = _tmp8_;
	child_err = _tmp9_;
	_tmp11_ = _tmp10_;
	if (_inner_error_ != NULL) {
		goto __catch14_g_error;
	}
	rc = _tmp11_;
	goto __finally14;
	__catch14_g_error:
	{
		GError * e;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GError* _tmp20_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = g_strconcat ("Unable to execute ", smd_applet_smd_loop_cmd, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, ": ", NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_tmp15_, e->message, NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat (_tmp17_, "\n", NULL);
		_tmp19_ = _tmp18_;
		fprintf (stderr, "%s", _tmp19_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_tmp20_ = g_error_new_literal (EXIT, EXIT_ABORT, "Unable to run smd-loop");
		_inner_error_ = _tmp20_;
		_g_error_free0 (e);
		goto __finally14;
	}
	__finally14:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			buff = (g_free (buff), NULL);
			cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
			return FALSE;
		} else {
			buff = (g_free (buff), NULL);
			cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (rc) {
		FILE* _tmp21_ = NULL;
		FILE* input;
		gchar* s;
		gboolean goon;
		_tmp21_ = fdopen (child_out, "r");
		input = _tmp21_;
		s = NULL;
		goon = TRUE;
		while (TRUE) {
			gboolean _tmp22_ = FALSE;
			gboolean _tmp23_ = FALSE;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			gboolean _tmp28_;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_;
			if (goon) {
				const gchar* _tmp24_ = NULL;
				gchar* _tmp25_;
				_tmp24_ = fgets (buff, buff_length1, input);
				_tmp25_ = g_strdup (_tmp24_);
				_g_free0 (s);
				s = _tmp25_;
				_tmp23_ = s != NULL;
			} else {
				_tmp23_ = FALSE;
			}
			if (_tmp23_) {
				_tmp22_ = !self->priv->thread_die;
			} else {
				_tmp22_ = FALSE;
			}
			if (!_tmp22_) {
				break;
			}
			_tmp26_ = g_strdup_printf ("smd-loop outputs: %s", s);
			_tmp27_ = _tmp26_;
			debug (_tmp27_);
			_g_free0 (_tmp27_);
			_tmp28_ = smd_applet_eval_smd_loop_message (self, s);
			goon = _tmp28_;
			_tmp29_ = g_strdup_printf ("eval_smd_loop_message returned %d", (gint) goon);
			_tmp30_ = _tmp29_;
			debug (_tmp30_);
			_g_free0 (_tmp30_);
		}
		if (s != NULL) {
			const gchar* _tmp31_ = NULL;
			gchar* _tmp32_;
			_tmp31_ = fgets (buff, buff_length1, input);
			_tmp32_ = g_strdup (_tmp31_);
			_g_free0 (s);
			s = _tmp32_;
			if (s != NULL) {
				fprintf (stderr, "smd-loop gave error tag but not died\n");
				fprintf (stderr, "smd-loop has pid %d and prints %s\n", (gint) self->priv->pid, s);
			}
		}
		g_spawn_close_pid (self->priv->pid);
		kill ((pid_t) (-((gint) self->priv->pid)), SIGTERM);
		result = goon;
		_g_free0 (s);
		_fclose0 (input);
		buff = (g_free (buff), NULL);
		cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		GError* _tmp37_ = NULL;
		_tmp33_ = g_strconcat ("Unable to execute ", smd_applet_smd_loop_cmd, NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strconcat (_tmp34_, "\n", NULL);
		_tmp36_ = _tmp35_;
		fprintf (stderr, "%s", _tmp36_);
		_g_free0 (_tmp36_);
		_g_free0 (_tmp34_);
		_tmp37_ = g_error_new_literal (EXIT, EXIT_ABORT, "Unable to run smd-loop");
		_inner_error_ = _tmp37_;
		if (_inner_error_->domain == EXIT) {
			g_propagate_error (error, _inner_error_);
			buff = (g_free (buff), NULL);
			cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
			return FALSE;
		} else {
			buff = (g_free (buff), NULL);
			cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	buff = (g_free (buff), NULL);
	cmd = (_vala_array_free (cmd, cmd_length1, (GDestroyNotify) g_free), NULL);
}


static void _lambda15_ (NotifyNotification* not, const gchar* action, smdApplet* self) {
	g_return_if_fail (not != NULL);
	g_return_if_fail (action != NULL);
	gtk_window_reshow_with_initial_size (self->priv->err_win);
}


static void __lambda15__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self) {
	_lambda15_ (notification, action, self);
}


static void _lambda16_ (GtkButton* b, smdApplet* self) {
	gint cmd_status = 0;
	gchar* output = NULL;
	gchar* _error_ = NULL;
	gconstpointer _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gconstpointer _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (b != NULL);
	_tmp0_ = g_hash_table_lookup (self->priv->command_hash, (GtkWidget*) b);
	_tmp1_ = g_strdup_printf ("executing: %s\n", (const gchar*) _tmp0_);
	_tmp2_ = _tmp1_;
	debug (_tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = g_hash_table_lookup (self->priv->command_hash, (GtkWidget*) b);
	g_spawn_command_line_sync ((const gchar*) _tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_inner_error_);
	_g_free0 (output);
	output = _tmp4_;
	_g_free0 (_error_);
	_error_ = _tmp5_;
	cmd_status = _tmp6_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_SPAWN_ERROR) {
			goto __catch19_g_spawn_error;
		}
		_g_free0 (_error_);
		_g_free0 (output);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = WIFEXITED (cmd_status);
	if (_tmp8_) {
		gint _tmp9_;
		_tmp9_ = WEXITSTATUS (cmd_status);
		_tmp7_ = 0 == _tmp9_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gtk_widget_set_sensitive ((GtkWidget*) b, FALSE);
	} else {
		GtkMessageDialog* _tmp10_ = NULL;
		GtkMessageDialog* w;
		_tmp10_ = (GtkMessageDialog*) gtk_message_dialog_new (self->priv->err_win, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "An error occurred:\n%s\n%s", output, _error_);
		w = g_object_ref_sink (_tmp10_);
		gtk_dialog_run ((GtkDialog*) w);
		gtk_widget_destroy ((GtkWidget*) w);
		_g_object_unref0 (w);
	}
	goto __finally19;
	__catch19_g_spawn_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Spawning: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally19:
	if (_inner_error_ != NULL) {
		_g_free0 (_error_);
		_g_free0 (output);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (_error_);
	_g_free0 (output);
}


static void __lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda16_ (_sender, self);
}


static gboolean smd_applet_eat_event (smdApplet* self) {
	gboolean result = FALSE;
	Event* e;
	gint _tmp0_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp16_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	e = NULL;
	if (self->priv->error_mode) {
		result = TRUE;
		_event_unref0 (e);
		return result;
	}
	g_mutex_lock (self->priv->events_lock);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->events);
	if (_tmp0_ > 0) {
		gpointer _tmp1_ = NULL;
		gpointer _tmp2_ = NULL;
		Event* _tmp3_;
		_tmp1_ = gee_abstract_list_first ((GeeAbstractList*) self->priv->events);
		_event_unref0 (e);
		e = (Event*) _tmp1_;
		_tmp2_ = gee_abstract_list_remove_at ((GeeAbstractList*) self->priv->events, 0);
		_tmp3_ = (Event*) _tmp2_;
		_event_unref0 (_tmp3_);
	}
	g_mutex_unlock (self->priv->events_lock);
	if (e != NULL) {
		_tmp4_ = e->message != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean notify_on_newail;
		gboolean _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_ = FALSE;
		notify_on_newail = FALSE;
		_tmp5_ = gconf_client_get_bool (self->priv->gconf, SMD_APPLET_key_newmail, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		notify_on_newail = _tmp6_;
		goto __finally15;
		__catch15_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stderr, "%s\n", e->message);
			_g_error_free0 (e);
		}
		__finally15:
		if (_inner_error_ != NULL) {
			_event_unref0 (e);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		if (e->enter_network_error_mode) {
			_tmp7_ = self->priv->network_error_mode;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
		} else {
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_;
			_tmp10_ = event_is_error_event (e);
			if (!_tmp10_) {
				_tmp9_ = notify_on_newail;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				_tmp8_ = TRUE;
			} else {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_;
				_tmp12_ = event_is_error_event (e);
				if (_tmp12_) {
					_tmp11_ = e->enter_network_error_mode;
				} else {
					_tmp11_ = FALSE;
				}
				_tmp8_ = _tmp11_;
			}
			if (_tmp8_) {
				NotifyNotification* _tmp13_ = NULL;
				_tmp13_ = notify_notification_new ("Syncmaildir", e->message, e->message_icon);
				_g_object_unref0 (self->priv->notification);
				self->priv->notification = _tmp13_;
				notify_notification_set_hint_byte (self->priv->notification, "transient", (guchar) 1);
				notify_notification_show (self->priv->notification, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch16_g_error;
				}
				goto __finally16;
				__catch16_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					fprintf (stderr, "%s\n", e->message);
					_g_error_free0 (e);
				}
				__finally16:
				if (_inner_error_ != NULL) {
					_event_unref0 (e);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			} else {
				gboolean _tmp14_;
				_tmp14_ = event_is_error_event (e);
				if (_tmp14_) {
					NotifyNotification* _tmp15_ = NULL;
					_tmp15_ = notify_notification_new ("Syncmaildir", e->message, e->message_icon);
					_g_object_unref0 (self->priv->notification);
					self->priv->notification = _tmp15_;
					notify_notification_set_timeout (self->priv->notification, 0);
					notify_notification_add_action (self->priv->notification, "clicked", "Handle error", __lambda15__notify_action_callback, smd_applet_ref (self), smd_applet_unref);
					notify_notification_show (self->priv->notification, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch17_g_error;
					}
					goto __finally17;
					__catch17_g_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						fprintf (stderr, "%s\n", e->message);
						_g_error_free0 (e);
					}
					__finally17:
					if (_inner_error_ != NULL) {
						_event_unref0 (e);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
			}
		}
	}
	if (e != NULL) {
		_tmp16_ = e->enter_error_mode;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		GObject* _tmp17_ = NULL;
		GObject* _tmp18_;
		GtkLabel* _tmp19_;
		GtkLabel* l_ctx;
		GObject* _tmp20_ = NULL;
		GObject* _tmp21_;
		GtkLabel* _tmp22_;
		GtkLabel* l_cause;
		GObject* _tmp23_ = NULL;
		GObject* _tmp24_;
		GtkVBox* _tmp25_;
		GtkVBox* vb;
		GList* _tmp26_ = NULL;
		GObject* _tmp62_ = NULL;
		GObject* _tmp63_;
		GtkWidget* _tmp64_;
		GtkWidget* x;
		GObject* _tmp65_ = NULL;
		GObject* _tmp66_;
		GtkWidget* _tmp67_;
		GObject* _tmp68_ = NULL;
		GObject* _tmp69_;
		GtkWidget* _tmp70_;
		gint _tmp71_;
		gtk_status_icon_set_from_icon_name (self->priv->si, "error");
		gtk_status_icon_set_tooltip_text (self->priv->si, "smd-applet encountered an error");
		self->priv->error_mode = TRUE;
		if (!self->priv->notification_server_has_persistence) {
			gtk_status_icon_set_visible (self->priv->si, TRUE);
		}
		_tmp17_ = gtk_builder_get_object (self->priv->builder, "lContext");
		_tmp18_ = _tmp17_;
		_tmp19_ = _g_object_ref0 (GTK_IS_LABEL (_tmp18_) ? ((GtkLabel*) _tmp18_) : NULL);
		l_ctx = _tmp19_;
		_tmp20_ = gtk_builder_get_object (self->priv->builder, "lCause");
		_tmp21_ = _tmp20_;
		_tmp22_ = _g_object_ref0 (GTK_IS_LABEL (_tmp21_) ? ((GtkLabel*) _tmp21_) : NULL);
		l_cause = _tmp22_;
		gtk_label_set_text (l_ctx, e->context);
		gtk_label_set_text (l_cause, e->cause);
		g_hash_table_remove_all (self->priv->command_hash);
		_tmp23_ = gtk_builder_get_object (self->priv->builder, "vbRun");
		_tmp24_ = _tmp23_;
		_tmp25_ = _g_object_ref0 (GTK_IS_VBOX (_tmp24_) ? ((GtkVBox*) _tmp24_) : NULL);
		vb = _tmp25_;
		_tmp26_ = gtk_container_get_children ((GtkContainer*) vb);
		{
			GList* w_collection;
			GList* w_it;
			w_collection = _tmp26_;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				GtkWidget* _tmp27_;
				GtkWidget* w;
				_tmp27_ = _g_object_ref0 ((GtkWidget*) w_it->data);
				w = _tmp27_;
				{
					gtk_container_remove ((GtkContainer*) vb, w);
					_g_object_unref0 (w);
				}
			}
			_g_list_free0 (w_collection);
		}
		if (e->permissions != NULL) {
			GObject* _tmp28_ = NULL;
			GObject* _tmp29_;
			GtkLabel* _tmp30_;
			GtkLabel* l;
			_tmp28_ = gtk_builder_get_object (self->priv->builder, "lPermissions");
			_tmp29_ = _tmp28_;
			_tmp30_ = _g_object_ref0 (GTK_IS_LABEL (_tmp29_) ? ((GtkLabel*) _tmp29_) : NULL);
			l = _tmp30_;
			gtk_label_set_text (l, e->permissions);
			_g_object_unref0 (l);
		}
		if (e->mail_name != NULL) {
			GObject* _tmp31_ = NULL;
			GObject* _tmp32_;
			GtkEntry* _tmp33_;
			GtkEntry* fn;
			GObject* _tmp34_ = NULL;
			GObject* _tmp35_;
			GtkTextView* _tmp36_;
			GtkTextView* l;
			GtkTextBuffer* _tmp37_ = NULL;
			GtkTextBuffer* _tmp38_;
			GtkTextBuffer* b;
			GtkTextIter it = {0};
			GtkTextIter subj = {0};
			GtkTextIter _tmp39_ = {0};
			GtkTextIter _tmp40_ = {0};
			gboolean _tmp41_;
			_tmp31_ = gtk_builder_get_object (self->priv->builder, "eMailName");
			_tmp32_ = _tmp31_;
			_tmp33_ = _g_object_ref0 (GTK_IS_ENTRY (_tmp32_) ? ((GtkEntry*) _tmp32_) : NULL);
			fn = _tmp33_;
			gtk_entry_set_text (fn, e->mail_name);
			_tmp34_ = gtk_builder_get_object (self->priv->builder, "tvMail");
			_tmp35_ = _tmp34_;
			_tmp36_ = _g_object_ref0 (GTK_IS_TEXT_VIEW (_tmp35_) ? ((GtkTextView*) _tmp35_) : NULL);
			l = _tmp36_;
			_tmp37_ = gtk_text_view_get_buffer (l);
			_tmp38_ = _g_object_ref0 (_tmp37_);
			b = _tmp38_;
			gtk_text_buffer_set_text (b, e->mail_body, -1);
			gtk_text_buffer_get_start_iter (b, &_tmp39_);
			it = _tmp39_;
			_tmp41_ = gtk_text_iter_forward_search (&it, "Subject:", GTK_TEXT_SEARCH_TEXT_ONLY, &_tmp40_, NULL, NULL);
			subj = _tmp40_;
			if (_tmp41_) {
				GtkTextMark* _tmp42_ = NULL;
				GtkTextMark* _tmp43_;
				GtkTextMark* insert;
				_tmp42_ = gtk_text_buffer_get_insert (b);
				_tmp43_ = _g_object_ref0 (_tmp42_);
				insert = _tmp43_;
				gtk_text_buffer_select_range (b, &subj, &subj);
				gtk_text_view_scroll_to_mark (l, insert, 0.0, TRUE, 0.0, 0.0);
				_g_object_unref0 (insert);
			}
			_g_object_unref0 (b);
			_g_object_unref0 (l);
			_g_object_unref0 (fn);
		}
		if (e->commands != NULL) {
			{
				GeeArrayList* _tmp44_;
				GeeArrayList* _command_list;
				gint _tmp45_;
				gint _command_size;
				gint _command_index;
				_tmp44_ = _g_object_ref0 (e->commands);
				_command_list = _tmp44_;
				_tmp45_ = gee_collection_get_size ((GeeCollection*) _command_list);
				_command_size = _tmp45_;
				_command_index = -1;
				while (TRUE) {
					gpointer _tmp46_ = NULL;
					gchar* command;
					GtkHBox* _tmp47_ = NULL;
					GtkHBox* hb;
					gchar* nice_command = NULL;
					GMatchInfo* i_mailto = NULL;
					GRegex* _tmp48_ = NULL;
					GRegex* mailto_rex;
					GMatchInfo* _tmp49_ = NULL;
					gboolean _tmp50_;
					GtkLabel* _tmp58_ = NULL;
					GtkLabel* lbl;
					GtkButton* _tmp59_ = NULL;
					GtkButton* but;
					GtkWidget* _tmp60_;
					gchar* _tmp61_;
					_command_index = _command_index + 1;
					if (!(_command_index < _command_size)) {
						break;
					}
					_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _command_list, _command_index);
					command = (gchar*) _tmp46_;
					_tmp47_ = (GtkHBox*) gtk_hbox_new (FALSE, 10);
					hb = g_object_ref_sink (_tmp47_);
					_tmp48_ = g_regex_new ("^gnome-open..mailto:", 0, 0, &_inner_error_);
					mailto_rex = _tmp48_;
					if (_inner_error_ != NULL) {
						_g_match_info_free0 (i_mailto);
						if (_inner_error_->domain == G_REGEX_ERROR) {
							goto __catch18_g_regex_error;
						}
						_g_match_info_free0 (i_mailto);
						_g_free0 (nice_command);
						_g_object_unref0 (hb);
						_g_free0 (command);
						_g_object_unref0 (_command_list);
						_g_object_unref0 (vb);
						_g_object_unref0 (l_cause);
						_g_object_unref0 (l_ctx);
						_event_unref0 (e);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
					_tmp50_ = g_regex_match (mailto_rex, command, 0, &_tmp49_);
					_g_match_info_free0 (i_mailto);
					i_mailto = _tmp49_;
					if (_tmp50_) {
						gchar* _tmp51_ = NULL;
						gchar* _tmp52_;
						gchar* _tmp53_ = NULL;
						gchar* _tmp54_;
						gchar* _tmp55_;
						_tmp51_ = g_uri_unescape_string (command, NULL);
						_tmp52_ = _tmp51_;
						_tmp53_ = string_substring (_tmp52_, (glong) 12, (glong) 70);
						_tmp54_ = _tmp53_;
						_tmp55_ = g_strconcat (_tmp54_, "...", NULL);
						_g_free0 (nice_command);
						nice_command = _tmp55_;
						_g_free0 (_tmp54_);
						_g_free0 (_tmp52_);
					} else {
						gchar* _tmp56_;
						_tmp56_ = g_strdup (command);
						_g_free0 (nice_command);
						nice_command = _tmp56_;
					}
					_g_regex_unref0 (mailto_rex);
					_g_match_info_free0 (i_mailto);
					goto __finally18;
					__catch18_g_regex_error:
					{
						GError * e;
						gchar* _tmp57_;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp57_ = g_strdup (command);
						_g_free0 (nice_command);
						nice_command = _tmp57_;
						_g_error_free0 (e);
					}
					__finally18:
					if (_inner_error_ != NULL) {
						_g_free0 (nice_command);
						_g_object_unref0 (hb);
						_g_free0 (command);
						_g_object_unref0 (_command_list);
						_g_object_unref0 (vb);
						_g_object_unref0 (l_cause);
						_g_object_unref0 (l_ctx);
						_event_unref0 (e);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
					_tmp58_ = (GtkLabel*) gtk_label_new (nice_command);
					lbl = g_object_ref_sink (_tmp58_);
					gtk_misc_set_alignment ((GtkMisc*) lbl, 0.0f, 0.5f);
					_tmp59_ = (GtkButton*) gtk_button_new_from_stock ("gtk-execute");
					but = g_object_ref_sink (_tmp59_);
					_tmp60_ = _g_object_ref0 ((GtkWidget*) but);
					_tmp61_ = g_strdup (command);
					g_hash_table_insert (self->priv->command_hash, _tmp60_, _tmp61_);
					g_signal_connect (but, "clicked", (GCallback) __lambda16__gtk_button_clicked, self);
					gtk_box_pack_end ((GtkBox*) hb, (GtkWidget*) lbl, TRUE, TRUE, (guint) 0);
					gtk_box_pack_end ((GtkBox*) hb, (GtkWidget*) but, FALSE, FALSE, (guint) 0);
					gtk_box_pack_end ((GtkBox*) vb, (GtkWidget*) hb, TRUE, TRUE, (guint) 0);
					gtk_widget_show_all ((GtkWidget*) hb);
					_g_object_unref0 (but);
					_g_object_unref0 (lbl);
					_g_free0 (nice_command);
					_g_object_unref0 (hb);
					_g_free0 (command);
				}
				_g_object_unref0 (_command_list);
			}
		}
		_tmp62_ = gtk_builder_get_object (self->priv->builder, "fDisplayPermissions");
		_tmp63_ = _tmp62_;
		_tmp64_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp63_) ? ((GtkWidget*) _tmp63_) : NULL);
		x = _tmp64_;
		gtk_widget_set_visible (x, e->permissions != NULL);
		_tmp65_ = gtk_builder_get_object (self->priv->builder, "fDisplayMail");
		_tmp66_ = _tmp65_;
		_tmp67_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp66_) ? ((GtkWidget*) _tmp66_) : NULL);
		_g_object_unref0 (x);
		x = _tmp67_;
		gtk_widget_set_visible (x, e->mail_name != NULL);
		_tmp68_ = gtk_builder_get_object (self->priv->builder, "fRun");
		_tmp69_ = _tmp68_;
		_tmp70_ = _g_object_ref0 (GTK_IS_WIDGET (_tmp69_) ? ((GtkWidget*) _tmp69_) : NULL);
		_g_object_unref0 (x);
		x = _tmp70_;
		_tmp71_ = gee_collection_get_size ((GeeCollection*) e->commands);
		gtk_widget_set_visible (x, _tmp71_ > 0);
		_g_object_unref0 (x);
		_g_object_unref0 (vb);
		_g_object_unref0 (l_cause);
		_g_object_unref0 (l_ctx);
	} else {
		gboolean _tmp72_ = FALSE;
		if (e != NULL) {
			_tmp72_ = e->enter_network_error_mode;
		} else {
			_tmp72_ = FALSE;
		}
		if (_tmp72_) {
			self->priv->network_error_mode = TRUE;
			gtk_status_icon_set_from_icon_name (self->priv->si, "dialog-warning");
			gtk_status_icon_set_tooltip_text (self->priv->si, "Network error");
		} else {
			if (e != NULL) {
				self->priv->network_error_mode = FALSE;
				gtk_status_icon_set_from_icon_name (self->priv->si, "mail-send-receive");
				gtk_status_icon_set_tooltip_text (self->priv->si, "smd-applet is running");
			}
		}
	}
	result = TRUE;
	_event_unref0 (e);
	return result;
}


static void smd_applet_close_err_action (smdApplet* self, GtkButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	smd_applet_reset_to_regular_run (self, FALSE);
}


static gboolean smd_applet_close_err_event (smdApplet* self, GdkEvent* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	smd_applet_reset_to_regular_run (self, FALSE);
	result = TRUE;
	return result;
}


static void smd_applet_reset_to_regular_run (smdApplet* self, gboolean force) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self->priv->err_win);
	self->priv->error_mode = FALSE;
	gtk_status_icon_set_tooltip_text (self->priv->si, "smd-applet is running");
	gtk_status_icon_set_from_icon_name (self->priv->si, "mail-send-receive");
	_tmp0_ = gconf_client_get_bool (self->priv->gconf, SMD_APPLET_key_icon, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch20_g_error;
	}
	gtk_status_icon_set_visible (self->priv->si, !_tmp1_);
	goto __finally20;
	__catch20_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "%s\n", e->message);
		_g_error_free0 (e);
	}
	__finally20:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	debug ("joining smdThread");
	g_thread_join (self->priv->thread);
	self->priv->thread_die = FALSE;
	debug ("starting smdThread");
	smd_applet_start_smdThread (self, force);
}


static void smd_applet_close_prefs_action (smdApplet* self, GtkButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	smd_applet_close_prefs (self);
}


static gboolean smd_applet_close_prefs_event (smdApplet* self, GdkEvent* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	smd_applet_close_prefs (self);
	result = TRUE;
	return result;
}


static void smd_applet_close_prefs (smdApplet* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self->priv->win);
	_tmp1_ = smd_applet_is_smd_stack_configured (self);
	if (_tmp1_) {
		_tmp0_ = self->priv->config_wait_mode;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		self->priv->config_wait_mode = FALSE;
		_tmp2_ = gconf_client_get_bool (self->priv->gconf, SMD_APPLET_key_icon, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch21_g_error;
		}
		gtk_status_icon_set_visible (self->priv->si, !_tmp3_);
		goto __finally21;
		__catch21_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stderr, "Unable to read gconf key %s: %s\n", SMD_APPLET_key_icon, e->message);
			_g_error_free0 (e);
		}
		__finally21:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		gtk_status_icon_set_from_icon_name (self->priv->si, "mail-send-receive");
		debug ("starting smdThread since smd stack is configured");
		smd_applet_start_smdThread (self, FALSE);
	}
}


static void smd_applet_close_logs (smdApplet* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self->priv->log_win);
}


static void smd_applet_close_logs_action (smdApplet* self, GtkButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	smd_applet_close_logs (self);
}


static gboolean smd_applet_close_logs_event (smdApplet* self, GdkEvent* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	smd_applet_close_logs (self);
	result = TRUE;
	return result;
}


static void smd_applet_my_gtk_main_quit_button (smdApplet* self, GtkButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	gtk_main_quit ();
}


static gboolean smd_applet_my_gtk_main_quit_event (smdApplet* self, GdkEvent* b) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	gtk_main_quit ();
	result = FALSE;
	return result;
}


static void smd_applet_pause (smdApplet* self) {
	g_return_if_fail (self != NULL);
	debug ("enter pause mode");
	if (((gint) self->priv->pid) != 0) {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = g_strdup_printf ("sending SIGTERM to %d", -((gint) self->priv->pid));
		_tmp1_ = _tmp0_;
		debug (_tmp1_);
		_g_free0 (_tmp1_);
		kill ((pid_t) (-((gint) self->priv->pid)), SIGTERM);
	}
	self->priv->thread_die = TRUE;
	gtk_status_icon_set_from_stock (self->priv->si, "gtk-media-pause");
	gtk_status_icon_set_tooltip_text (self->priv->si, "smd-applet is paused");
}


static void smd_applet_unpause (smdApplet* self) {
	g_return_if_fail (self != NULL);
	debug ("exit pause mode");
	smd_applet_reset_to_regular_run (self, TRUE);
}


static gboolean smd_applet_is_smd_loop_configured (smdApplet* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean rc;
	GObject* _tmp1_ = NULL;
	GObject* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* l;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_file_test (SMD_LOOP_CFG, G_FILE_TEST_EXISTS);
	rc = _tmp0_;
	_tmp1_ = gtk_builder_get_object (self->priv->builder, "lErrLoop");
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (GTK_IS_LABEL (_tmp2_) ? ((GtkLabel*) _tmp2_) : NULL);
	l = _tmp3_;
	if (!rc) {
		gtk_widget_show ((GtkWidget*) l);
	} else {
		gtk_widget_hide ((GtkWidget*) l);
	}
	result = rc;
	_g_object_unref0 (l);
	return result;
}


static gboolean smd_applet_is_smd_pushpull_configured (smdApplet* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean rc;
	GObject* _tmp1_ = NULL;
	GObject* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* l;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_file_test (SMD_PP_DEF_CFG, G_FILE_TEST_EXISTS);
	rc = _tmp0_;
	_tmp1_ = gtk_builder_get_object (self->priv->builder, "lErrPushPull");
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (GTK_IS_LABEL (_tmp2_) ? ((GtkLabel*) _tmp2_) : NULL);
	l = _tmp3_;
	if (!rc) {
		gtk_widget_show ((GtkWidget*) l);
	} else {
		gtk_widget_hide ((GtkWidget*) l);
	}
	result = rc;
	_g_object_unref0 (l);
	return result;
}


static gboolean smd_applet_is_smd_stack_configured (smdApplet* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean a;
	gboolean _tmp1_;
	gboolean b;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = smd_applet_is_smd_loop_configured (self);
	a = _tmp0_;
	_tmp1_ = smd_applet_is_smd_pushpull_configured (self);
	b = _tmp1_;
	if (a) {
		_tmp2_ = b;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	return result;
}


static void smd_applet_update_loglist (smdApplet* self) {
	GObject* _tmp0_ = NULL;
	GObject* _tmp1_;
	GtkTextView* _tmp2_;
	GtkTextView* tv;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* b;
	GDir* _tmp5_ = NULL;
	GDir* d;
	gchar* file = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	gint _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_get_object (self->priv->builder, "tvLog");
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (GTK_IS_TEXT_VIEW (_tmp1_) ? ((GtkTextView*) _tmp1_) : NULL);
	tv = _tmp2_;
	_tmp3_ = gtk_text_view_get_buffer (tv);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	b = _tmp4_;
	_tmp5_ = g_dir_open (SMD_LOGS_DIR, (guint) 0, &_inner_error_);
	d = _tmp5_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch22_g_file_error;
		}
		_g_object_unref0 (b);
		_g_object_unref0 (tv);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = gtk_combo_box_get_model ((GtkComboBox*) self->priv->cblogs);
	gtk_list_store_clear (GTK_LIST_STORE (_tmp6_));
	gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->lognames);
	while (TRUE) {
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp7_ = g_dir_read_name (d);
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (file);
		file = _tmp8_;
		if (!(file != NULL)) {
			break;
		}
		gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->lognames, file);
		gtk_combo_box_text_append_text (self->priv->cblogs, file);
	}
	_tmp9_ = gee_collection_get_size ((GeeCollection*) self->priv->lognames);
	if (_tmp9_ == 0) {
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp10_ = g_strdup_printf ("No logs in %s", SMD_LOGS_DIR);
		_tmp11_ = _tmp10_;
		gtk_text_buffer_set_text (b, _tmp11_, -1);
		_g_free0 (_tmp11_);
	} else {
		gtk_combo_box_set_title ((GtkComboBox*) self->priv->cblogs, "Choose log file");
		gtk_combo_box_set_active ((GtkComboBox*) self->priv->cblogs, 0);
	}
	_g_free0 (file);
	_g_dir_close0 (d);
	goto __finally22;
	__catch22_g_file_error:
	{
		GError * e;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = g_strdup_printf ("Unable to list directory %s", SMD_LOGS_DIR);
		_tmp13_ = _tmp12_;
		gtk_text_buffer_set_text (b, _tmp13_, -1);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
	}
	__finally22:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (b);
		_g_object_unref0 (tv);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (b);
	_g_object_unref0 (tv);
}


static gboolean _smd_applet_eat_event_gsource_func (gpointer self) {
	gboolean result;
	result = smd_applet_eat_event (self);
	return result;
}


static gboolean _smd_applet_close_prefs_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = smd_applet_close_prefs_event (self, event);
	return result;
}


static gboolean _smd_applet_close_err_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = smd_applet_close_err_event (self, event);
	return result;
}


void smd_applet_run (smdApplet* self, GError** error) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _smd_applet_eat_event_gsource_func, smd_applet_ref (self), smd_applet_unref);
	_tmp0_ = smd_applet_is_smd_stack_configured (self);
	if (_tmp0_) {
		smd_applet_start_smdThread (self, FALSE);
	} else {
		self->priv->config_wait_mode = TRUE;
	}
	g_signal_connect ((GtkWidget*) self->priv->win, "delete-event", (GCallback) _smd_applet_close_prefs_event_gtk_widget_delete_event, self);
	g_signal_connect ((GtkWidget*) self->priv->err_win, "delete-event", (GCallback) _smd_applet_close_err_event_gtk_widget_delete_event, self);
	if (self->priv->config_wait_mode) {
		NotifyNotification* _tmp3_ = NULL;
		gtk_status_icon_set_visible (self->priv->si, FALSE);
		while (TRUE) {
			gboolean _tmp1_;
			_tmp1_ = gtk_events_pending ();
			if (!_tmp1_) {
				break;
			}
			gtk_main_iteration ();
		}
		sleep ((guint) 5);
		gtk_status_icon_set_visible (self->priv->si, TRUE);
		gtk_status_icon_set_from_icon_name (self->priv->si, "error");
		while (TRUE) {
			gboolean _tmp2_;
			_tmp2_ = gtk_events_pending ();
			if (!_tmp2_) {
				break;
			}
			gtk_main_iteration ();
		}
		_tmp3_ = notify_notification_new ("Syncmaildir", "Syncmaildir is not configured properly, " "click on the icon to configure it.", "dialog-warning");
		_g_object_unref0 (self->priv->notification);
		self->priv->notification = _tmp3_;
		notify_notification_set_hint_byte (self->priv->notification, "transient", (guchar) 1);
		notify_notification_show (self->priv->notification, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch23_g_error;
		}
		goto __finally23;
		__catch23_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stderr, "%s\n", e->message);
			_g_error_free0 (e);
		}
		__finally23:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == EXIT) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = gconf_client_get_bool (self->priv->gconf, SMD_APPLET_key_icon, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			goto __catch24_g_error;
		}
		gtk_status_icon_set_visible (self->priv->si, !_tmp5_);
		goto __finally24;
		__catch24_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			fprintf (stderr, "%s\n", e->message);
			_g_error_free0 (e);
		}
		__finally24:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == EXIT) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	gtk_main ();
	if (self->priv->thread != NULL) {
		g_thread_join (self->priv->thread);
	}
}


static void _smd_applet_my_gtk_main_quit_button_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	smd_applet_my_gtk_main_quit_button (self, _sender);
}


static gboolean _smd_applet_my_gtk_main_quit_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	gboolean result;
	result = smd_applet_my_gtk_main_quit_event (self, event);
	return result;
}


void smd_applet_configure (smdApplet* self) {
	GObject* _tmp0_ = NULL;
	GObject* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* close;
	guint _tmp3_;
	guint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_builder_get_object (self->priv->builder, "bClosePrefs");
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp1_) ? ((GtkButton*) _tmp1_) : NULL);
	close = _tmp2_;
	g_signal_connect (close, "clicked", (GCallback) _smd_applet_my_gtk_main_quit_button_gtk_button_clicked, self);
	g_signal_connect ((GtkWidget*) self->priv->win, "delete-event", (GCallback) _smd_applet_my_gtk_main_quit_event_gtk_widget_delete_event, self);
	gtk_widget_show ((GtkWidget*) self->priv->win);
	gtk_main ();
	g_signal_parse_name ("clicked", GTK_TYPE_BUTTON, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (close, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _smd_applet_my_gtk_main_quit_button_gtk_button_clicked, self);
	g_signal_parse_name ("delete-event", GTK_TYPE_WIDGET, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) self->priv->win, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _smd_applet_my_gtk_main_quit_event_gtk_widget_delete_event, self);
	_g_object_unref0 (close);
}


static void value_smd_applet_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_smd_applet_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		smd_applet_unref (value->data[0].v_pointer);
	}
}


static void value_smd_applet_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = smd_applet_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_smd_applet_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_smd_applet_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		smdApplet* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = smd_applet_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_smd_applet_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	smdApplet** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = smd_applet_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_smd_applet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecsmdApplet* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SMD_APPLET), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_smd_applet (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SMD_APPLET), NULL);
	return value->data[0].v_pointer;
}


void value_set_smd_applet (GValue* value, gpointer v_object) {
	smdApplet* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SMD_APPLET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SMD_APPLET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		smd_applet_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		smd_applet_unref (old);
	}
}


void value_take_smd_applet (GValue* value, gpointer v_object) {
	smdApplet* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SMD_APPLET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SMD_APPLET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		smd_applet_unref (old);
	}
}


static void smd_applet_class_init (smdAppletClass * klass) {
	smd_applet_parent_class = g_type_class_peek_parent (klass);
	SMD_APPLET_CLASS (klass)->finalize = smd_applet_finalize;
	g_type_class_add_private (klass, sizeof (smdAppletPrivate));
}


static void smd_applet_instance_init (smdApplet * self) {
	self->priv = SMD_APPLET_GET_PRIVATE (self);
	self->priv->builder = NULL;
	self->priv->menuL = NULL;
	self->priv->menuR = NULL;
	self->priv->si = NULL;
	self->priv->win = NULL;
	self->priv->err_win = NULL;
	self->priv->log_win = NULL;
	self->priv->about_win = NULL;
	self->priv->miPause = NULL;
	self->priv->cblogs = NULL;
	self->priv->lognames = NULL;
	self->priv->gconf = NULL;
	self->priv->thread = NULL;
	self->priv->thread_die = FALSE;
	self->priv->events_lock = NULL;
	self->priv->events = NULL;
	self->priv->error_mode = FALSE;
	self->priv->network_error_mode = FALSE;
	self->priv->command_hash = NULL;
	self->priv->net_manager = NULL;
	self->priv->notification = NULL;
	self->priv->notification_server_has_persistence = FALSE;
	self->ref_count = 1;
}


static void smd_applet_finalize (smdApplet* obj) {
	smdApplet * self;
	self = SMD_APPLET (obj);
	_g_object_unref0 (self->priv->builder);
	_g_object_unref0 (self->priv->menuL);
	_g_object_unref0 (self->priv->menuR);
	_g_object_unref0 (self->priv->si);
	_g_object_unref0 (self->priv->win);
	_g_object_unref0 (self->priv->err_win);
	_g_object_unref0 (self->priv->log_win);
	_g_object_unref0 (self->priv->about_win);
	_g_object_unref0 (self->priv->miPause);
	_g_object_unref0 (self->priv->cblogs);
	_g_object_unref0 (self->priv->lognames);
	_g_object_unref0 (self->priv->gconf);
	_g_mutex_free0 (self->priv->events_lock);
	_g_object_unref0 (self->priv->events);
	_g_hash_table_unref0 (self->priv->command_hash);
	_g_object_unref0 (self->priv->net_manager);
	_g_object_unref0 (self->priv->notification);
}


GType smd_applet_get_type (void) {
	static volatile gsize smd_applet_type_id__volatile = 0;
	if (g_once_init_enter (&smd_applet_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_smd_applet_init, value_smd_applet_free_value, value_smd_applet_copy_value, value_smd_applet_peek_pointer, "p", value_smd_applet_collect_value, "p", value_smd_applet_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (smdAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) smd_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (smdApplet), 0, (GInstanceInitFunc) smd_applet_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType smd_applet_type_id;
		smd_applet_type_id = g_type_register_fundamental (g_type_fundamental_next (), "smdApplet", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&smd_applet_type_id__volatile, smd_applet_type_id);
	}
	return smd_applet_type_id__volatile;
}


gpointer smd_applet_ref (gpointer instance) {
	smdApplet* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void smd_applet_unref (gpointer instance) {
	smdApplet* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SMD_APPLET_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gchar* _tmp0_;
	gchar* PREFIX;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* homedir;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean config_only;
	GOptionEntry _tmp16_ = {0};
	GOptionEntry _tmp17_ = {0};
	GOptionEntry _tmp18_ = {0};
	GOptionEntry _tmp19_ = {0};
	GOptionEntry _tmp20_ = {0};
	GOptionEntry _tmp21_ = {0};
	GOptionEntry _tmp22_ = {0};
	GOptionEntry _tmp23_ = {0};
	GOptionEntry* _tmp24_ = NULL;
	GOptionEntry* oe;
	gint oe_length1;
	gint _oe_size_;
	GOptionContext* _tmp25_ = NULL;
	GOptionContext* oc;
	smdApplet* _tmp26_ = NULL;
	smdApplet* smd_applet;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_strdup (SMD_CONF_PREFIX);
	PREFIX = _tmp0_;
	_tmp1_ = g_strconcat (PREFIX, SMD_APPLET_UI, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_test (_tmp2_, G_FILE_TEST_EXISTS);
	_tmp4_ = !_tmp3_;
	_g_free0 (_tmp2_);
	if (_tmp4_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		fprintf (stderr, "error: file not found: %s + %s\n", PREFIX, SMD_APPLET_UI);
		_tmp5_ = g_strdup ("./smd-loop");
		_g_free0 (smd_applet_smd_loop_cmd);
		smd_applet_smd_loop_cmd = _tmp5_;
		fprintf (stderr, "smd-applet not installed, " "assuming smd-loop is: %s\n", smd_applet_smd_loop_cmd);
		_tmp6_ = g_strdup ("./smd-applet.ui");
		_g_free0 (smd_applet_smd_applet_ui);
		smd_applet_smd_applet_ui = _tmp6_;
		fprintf (stderr, "smd-applet not installed, " "assuming smd-applet.ui is: %s\n", smd_applet_smd_applet_ui);
		_tmp7_ = g_strdup ("./smd-push");
		_g_free0 (smd_applet_smd_push_cmd);
		smd_applet_smd_push_cmd = _tmp7_;
		fprintf (stderr, "smd-applet not installed, " "assuming smd-push is: %s\n", smd_applet_smd_push_cmd);
	} else {
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = g_strconcat (PREFIX, SMD_LOOP, NULL);
		_g_free0 (smd_applet_smd_loop_cmd);
		smd_applet_smd_loop_cmd = _tmp8_;
		_tmp9_ = g_strconcat (PREFIX, SMD_PUSH, NULL);
		_g_free0 (smd_applet_smd_push_cmd);
		smd_applet_smd_push_cmd = _tmp9_;
		_tmp10_ = g_strconcat (PREFIX, SMD_APPLET_UI, NULL);
		_g_free0 (smd_applet_smd_applet_ui);
		smd_applet_smd_applet_ui = _tmp10_;
	}
	_tmp11_ = g_get_home_dir ();
	_tmp12_ = g_strdup (_tmp11_);
	homedir = _tmp12_;
	_tmp13_ = g_strconcat (homedir, "/.smd/log/", NULL);
	_g_free0 (SMD_LOGS_DIR);
	SMD_LOGS_DIR = _tmp13_;
	_tmp14_ = g_strconcat (homedir, "/.smd/loop", NULL);
	_g_free0 (SMD_LOOP_CFG);
	SMD_LOOP_CFG = _tmp14_;
	_tmp15_ = g_strconcat (homedir, "/.smd/config.default", NULL);
	_g_free0 (SMD_PP_DEF_CFG);
	SMD_PP_DEF_CFG = _tmp15_;
	gtk_init (&args_length1, &args);
	notify_init ("smd-applet");
	config_only = FALSE;
	memset (&_tmp16_, 0, sizeof (GOptionEntry));
	_tmp16_.long_name = "configure";
	_tmp16_.short_name = 'c';
	_tmp16_.flags = 0;
	_tmp16_.arg = G_OPTION_ARG_NONE;
	_tmp16_.arg_data = &config_only;
	_tmp16_.description = "show config window, don't really run the applet";
	_tmp16_.arg_description = NULL;
	_tmp17_ = _tmp16_;
	memset (&_tmp18_, 0, sizeof (GOptionEntry));
	_tmp18_.long_name = "verbose";
	_tmp18_.short_name = 'v';
	_tmp18_.flags = 0;
	_tmp18_.arg = G_OPTION_ARG_NONE;
	_tmp18_.arg_data = &verbose;
	_tmp18_.description = "verbose output, for debugging only";
	_tmp18_.arg_description = NULL;
	_tmp19_ = _tmp18_;
	memset (&_tmp20_, 0, sizeof (GOptionEntry));
	_tmp20_.long_name = "smd-loop";
	_tmp20_.short_name = 'l';
	_tmp20_.flags = 0;
	_tmp20_.arg = G_OPTION_ARG_STRING;
	_tmp20_.arg_data = &smd_applet_smd_loop_cmd;
	_tmp20_.description = "override smd-loop command name, debugging only";
	_tmp20_.arg_description = "program";
	_tmp21_ = _tmp20_;
	memset (&_tmp22_, 0, sizeof (GOptionEntry));
	_tmp22_.long_name = NULL;
	_tmp23_ = _tmp22_;
	_tmp24_ = g_new0 (GOptionEntry, 4);
	_tmp24_[0] = _tmp17_;
	_tmp24_[1] = _tmp19_;
	_tmp24_[2] = _tmp21_;
	_tmp24_[3] = _tmp23_;
	oe = _tmp24_;
	oe_length1 = 4;
	_oe_size_ = 4;
	_tmp25_ = g_option_context_new (" - syncmaildir applet");
	oc = _tmp25_;
	g_option_context_add_main_entries (oc, oe, NULL);
	g_option_context_parse (oc, &args_length1, &args, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_OPTION_ERROR) {
			goto __catch25_g_option_error;
		}
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	goto __finally25;
	__catch25_g_option_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "%s\n", e->message);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		return result;
	}
	__finally25:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp26_ = smd_applet_new (config_only, &_inner_error_);
	smd_applet = _tmp26_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == EXIT) {
			goto __catch26_exit;
		}
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (config_only) {
		smd_applet_configure (smd_applet);
	} else {
		smd_applet_run (smd_applet, &_inner_error_);
		if (_inner_error_ != NULL) {
			_smd_applet_unref0 (smd_applet);
			if (_inner_error_->domain == EXIT) {
				goto __catch26_exit;
			}
			_smd_applet_unref0 (smd_applet);
			_g_option_context_free0 (oc);
			oe = (g_free (oe), NULL);
			_g_free0 (homedir);
			_g_free0 (PREFIX);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_smd_applet_unref0 (smd_applet);
	goto __finally26;
	__catch26_exit:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "abort: %s\n", e->message);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		return result;
	}
	__finally26:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (oc);
		oe = (g_free (oe), NULL);
		_g_free0 (homedir);
		_g_free0 (PREFIX);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	_g_option_context_free0 (oc);
	oe = (g_free (oe), NULL);
	_g_free0 (homedir);
	_g_free0 (PREFIX);
	return result;
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



