/***************************************************************************
 * Copyright (c) 2003 Volker Christian <voc@users.sourceforge.net>         *
 *                                                                         *
 * Permission is hereby granted, free of charge, to any person obtaining a *
 * copy of this software and associated documentation files (the           *
 * "Software"), to deal in the Software without restriction, including     *
 * without limitation the rights to use, copy, modify, merge, publish,     *
 * distribute, sublicense, and/or sell copies of the Software, and to      *
 * permit persons to whom the Software is furnished to do so, subject to   *
 * the following conditions:                                               *
 *                                                                         *
 * The above copyright notice and this permission notice shall be included *
 * in all copies or substantial portions of the Software.                  *
 *                                                                         *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS *
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF              *
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  *
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY    *
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,    *
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE       *
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                  *
 ***************************************************************************/
 
#ifndef THREADEVENT_H
#define THREADEVENT_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qobject.h>
#include <qevent.h>
#include <qmutex.h>
#include <qwaitcondition.h>

class WorkerThreadInterface;

/**
@author Volker Christian,,,
*/

class ThreadEvent : public QCustomEvent
{
public:
    ThreadEvent(WorkerThreadInterface *wti,
            void *(WorkerThreadInterface::*userEventMethode)(void *data = 0),
            void *data);
    void *(WorkerThreadInterface::*userEventMethode)(void *data = 0);
    WorkerThreadInterface *wti;
    void *threadData;
};


class ThreadEventObject : public QObject
{
Q_OBJECT
public:
    void eventMutexLock();
    void eventMutexUnlock();
    void waitOnEvent();
    void wakeUpOnEvent();
private:
    void customEvent (QCustomEvent *customEvent);
    QMutex eventMutex;
    QWaitCondition eventCondition;
};


#endif
