/*
 * synaptiks -- a touchpad control tool
 *
 *
 * Copyright (C) 2010 Sebastian Wiesner <basti.wiesner@gmx.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef TOUCHPADADAPTOR_H
#define TOUCHPADADAPTOR_H

#include "touchpad.h"
#include <QtDBus/QDBusAbstractAdaptor>

namespace synaptiks {

    /*
     * Adaptor class for interface org.kde.Touchpad
     */
    class TouchpadAdaptor: public QDBusAbstractAdaptor {
        Q_OBJECT
        Q_CLASSINFO("D-Bus Interface", "org.kde.Touchpad")

    public:
        TouchpadAdaptor(synaptiks::Touchpad *parent);
        virtual ~TouchpadAdaptor();

        inline synaptiks::Touchpad *parent() const {
            return static_cast<synaptiks::Touchpad *>(QObject::parent());
        }

    public Q_SLOTS:
        QString name() const;

        bool isOn() const;
        void setOn(bool on);

        double minimumSpeed() const;
        void setMinimumSpeed(double speed);

        double maximumSpeed() const;
        void setMaximumSpeed(double speed);

        double accelerationFactor() const;
        void setAccelerationFactor(double accel);

        bool edgeMotionAlways() const;
        void setEdgeMotionAlways(bool enabled);

        bool tapAndDragGesture() const;
        void setTapAndDragGesture(bool enabled);

        bool lockedDrags() const;
        void setLockedDrags(bool enabled);

        int lockedDragsTimeout() const;
        void setLockedDragsTimeout(int timeout);

        bool circularScrolling() const;
        void setCircularScrolling(bool enabled);

        uchar circularScrollingTrigger() const;
        void setCircularScrollingTrigger(uchar trigger);

        double circularScrollingDistance() const;
        void setCircularScrollingDistance(double angle);

        bool horizontalTwoFingerScrolling() const;
        void setHorizontalTwoFingerScrolling(bool enabled);

        bool verticalTwoFingerScrolling() const;
        void setVerticalTwoFingerScrolling(bool enabled);

        bool horizontalEdgeScrolling() const;
        void setHorizontalEdgeScrolling(bool enabled);

        bool verticalEdgeScrolling() const;
        void setVerticalEdgeScrolling(bool enabled);

        bool cornerCoasting() const;
        void setCornerCoasting(bool enabled);

        double coastingSpeed() const;
        void setCoastingSpeed(double speed);

        int horizontalScrollingDistance() const;
        void setHorizontalScrollingDistance(int distance);

        int verticalScrollingDistance() const;
        void setVerticalScrollingDistance(int distance);

        QByteArray cornerButtons() const;
        void setCornerButtons(const QByteArray &buttons);

        QByteArray fingerButtons() const;
        void setFingerButtons(const QByteArray &buttons);

        bool fastTaps() const;
        void setFastTaps(bool enabled);

        bool circularTouchpad() const;
        void setCircularTouchpad(bool circular);

        bool hasLeftButton() const;
        bool hasMiddleButton() const;
        bool hasRightButton() const;
        int fingerDetection() const;

    private:
        /**
         * @brief Return the value of @p property of the associated
         * touchpad.
         *
         * If a QXDeviceError exception is thrown, it is caugth by this
         * function and turned into a DBus-Error.  In this case, an invalid
         * QVariant is returned.
         *
         * @param property the property to get
         * @return The property value or an invalid QVariant in case of
         *         error
         */
        QVariant propertyOrDBusError(const char *property) const;

        /**
         * @brief Set the @p value of @p property on the associated
         * touchpad.
         *
         * If a QXDeviceError exception is thrown, it is caugth by this
         * function and turned into a DBus-Error.
         *
         * @param property the property to set
         * @param value the property value
         */
        void setPropertyOrDBusError(const char *property,
                                    const QVariant &value);
    };
}

#endif /* TOUCHPADADAPTOR_H */
