/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SWSCONFIG_H
#define SWSCONFIG_H

#include <kconfig.h>
#include <kglobal.h>

#include <qstring.h>

/**
@author Ivn Forcada Atienza
*/
class SWSconfig {
private:
	KConfig * cfg;
	
public:
	SWSconfig();
	~SWSconfig();
 
	void setBaud (int b);
	void setDataBits (int d);
	void setStopBits (int s);
	void setParity (QString p);
	void setDhclient (QString d);
	void setSerialDev (QString s);
	void setDefIface (QString i);
	void setStartScanning (bool s);
	void setUseTerminal (bool t);
	void setTerminal(QString t);
	void setFileToOpen(QString f);
	void setSpeedUnits(QString s);
	
	int getBaud();
	int getDataBits ();
	int getStopBits ();
	QString getParity ();
	QString getDhclient ();
	QString getSerialDev ();
	QString getDefIface ();
	QString getTerminal ();
	QString getFileToOpen ();
	QString getSpeedUnits ();
	bool getUseTerminal ();
	bool getStartScanning ();
};

#endif
