/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "frmconfig.h"

frmconfig::frmconfig(QWidget* parent, const char* name, bool modal)
                : KDialogBase( parent, name, modal, i18n("Network Settings"), Cancel|User1, Cancel )
{
	qDebug("Creating frmconfig...");
	
	d = new dlgConfig(this);
	this->setMainWidget(d);

	setButtonGuiItem(User1, KGuiItem(i18n("Save"), "filesave"));

	if (d->txtDhcpClient->text().length() == 0)
		d->txtDhcpClient->setText("/sbin/dhclient");

	d->btnScript->setPixmap(SmallIcon("fileopen"));

	// Asociate validator with ip textboxes
	QValidator* validator = new QIntValidator( 0, 255, this );
	d->txtIP1->setValidator(validator);
	d->txtIP2->setValidator(validator);
	d->txtIP3->setValidator(validator);
	d->txtIP4->setValidator(validator);
	d->txtMask1->setValidator(validator);
	d->txtMask2->setValidator(validator);
	d->txtMask3->setValidator(validator);
	d->txtMask4->setValidator(validator);
	d->txtGat1->setValidator(validator);
	d->txtGat2->setValidator(validator);
	d->txtGat3->setValidator(validator);
	d->txtGat4->setValidator(validator);

	
	// Connections:
	connect( d->chkWEP, SIGNAL(stateChanged(int)), this, SLOT(enableWEP(int)) );
	connect( d->frmStatic, SIGNAL(toggled(bool)), this, SLOT(statSelected(bool)) );
	connect( d->frmDhcp, SIGNAL(toggled(bool)), this, SLOT(dhcpSelected(bool)) );
	connect( d->cmbKeyLength, SIGNAL(activated(int)), this, SLOT(keyLengthSel()) );
	connect( d->btnScript, SIGNAL(clicked()), this, SLOT(findScript()) );
	
	frmconfig::configureConnection();	//connection to the db	

}

frmconfig::~frmconfig()
{
	qDebug("Deleting frmconfig...");	
}

/*$SPECIALIZATION$*/

bool frmconfig::configureConnection()
{
	bool found = false;
	QString filename = QDir::homeDirPath() + "/.swscanner/swscanner.db";
	QFile file (filename);
	// Create de default database connection for the application:
	db = QSqlDatabase::addDatabase( "QSQLITE" );
	db->setDatabaseName( filename );
	//db->setUserName( USER );
	//db->setPassword( PASSWORD );
	//db->setHostName( HOST );
	
	// If it doesn't exists then create it
	if (!file.exists()) 
	{
		if ( !QDir(QDir::homeDirPath() + "/.swscanner").exists() )
		{
			qDebug("Creating '~/.swscanner' directory for first time...");
			QDir::home().mkdir( ".swscanner" );
		}
		qDebug("Creating database for first time...");
		file.open(IO_ReadWrite);
		file.close();
	}
	
	if( !db->open() )
	{
		KMessageBox::error(this, i18n("An error occured while opening the database:") + " " + db->lastError().text() );
		return false;
	}
	
	QStringList list = db->tables();
	QStringList::Iterator it = list.begin();
	while( it != list.end() ) 
	{
		    cout << "Tables found: ";
		    cout << "    " << *it << endl;
		    if(*it=="networks") found = true;
		    ++it;
	}
	if (!found)
	{
		qDebug("No tables found--> Creating table 'networks'");
		QString sql;
		sql = "CREATE TABLE networks (";
			sql += "'mac' varchar(18) primary key, ";
			sql += "'essid' varchar(256), ";
			sql += "'haswep' int, ";
			sql += "'wepkey' varchar(13), ";
			sql += "'ingroup' int, ";
			sql += "'static' int, ";
			sql += "'ip' varchar(16), ";
			sql += "'netmask' varchar(16), ";
			sql += "'hasgw' int, ";
			sql += "'ipgw' varchar(16), ";
			sql += "'script' varchar(256))";
		
		QSqlQuery query(sql,db);
		if (query.lastError().type() != 0) 
			KMessageBox::error(this, i18n("SQL error:") + " " + query.lastError().text());
		qDebug("Adding a test record...");
		sql="INSERT INTO networks (mac, essid, haswep, wepkey, ingroup, static, ip, netmask, hasgw, ipgw, script) ";
		sql+="VALUES ('11:22:33:44:55:66', 'test', 0, NULL, 1,1,'192.189.1.2', ";
		sql+="'255.255.255.0',1,'192.168.1.1',NULL)";
		query = QSqlQuery (sql,db);
		if (query.lastError().type() != 0) 
			KMessageBox::error(this, i18n("SQL error:") + " " + query.lastError().text());
	}
	return true;
}
void frmconfig::enableWEP(int e)
{
	if (e==0)
	{
		d->txtKey->setEnabled(false);
		d->cmbKeyLength->setEnabled(false);
	}	
	else
	{
		d->txtKey->setEnabled(true);
		d->cmbKeyLength->setEnabled(true);
	}
}

void frmconfig::statSelected(bool sel)
{
	d->frmDhcp->setChecked(!sel);
	
	d->txtIP1->setEnabled(sel);
	d->txtIP1->setEnabled(sel);
	d->txtIP2->setEnabled(sel);
	d->txtIP3->setEnabled(sel);
	d->txtIP4->setEnabled(sel);
	d->txtMask1->setEnabled(sel);
	d->txtMask2->setEnabled(sel);
	d->txtMask3->setEnabled(sel);
	d->txtMask4->setEnabled(sel);
	d->lblIP->setEnabled(sel);
	d->lblMask->setEnabled(sel);
}

void frmconfig::dhcpSelected(bool sel)
{
	d->frmStatic->setChecked(!sel);
}

void frmconfig::keyLengthSel()
{
	int i = d->cmbKeyLength->currentItem();
	if (i==0)	//64bit
		d->txtKey->setMaxLength(5);
	else if (i==1)	//128bit
		d->txtKey->setMaxLength(13);
}

void frmconfig::slotUser1()
{

	if (	d->frmStatic->isChecked() && (
		d->txtIP1->text().length() == 0 ||
		d->txtIP2->text().length() == 0 ||
		d->txtIP3->text().length() == 0 ||
		d->txtIP4->text().length() == 0 ||
		d->txtMask1->text().length() == 0 ||
		d->txtMask2->text().length() == 0 ||
		d->txtMask3->text().length() == 0 ||
		d->txtMask4->text().length() == 0	))
	{
		KMessageBox::error(this, i18n("You have seleced a static IP and left blank one or more boxes"));
		return;
	}

	if (	d->frmGate->isChecked()   && 
		d->frmStatic->isChecked() && (
		d->txtGat1->text().length() == 0 ||
		d->txtGat2->text().length() == 0 ||
		d->txtGat3->text().length() == 0 ||
		d->txtGat4->text().length() == 0	))
	{
		KMessageBox::error(this, i18n("You have seleced to use a gateway but haved left blank one or more of it's boxes"));
		return;
	}


	QString sql;
	QString mac = "'" + d->lblMAC->text() + "'";
	QString essid = "'" + d->lblEssid->text() + "'";
	int haswep = d->chkWEP->isChecked() ? 1 : 0;
	QString wepkey = ((haswep==1)?"'" + d->txtKey->text() + "'":"NULL");
	int ingroup = d->chkGrouped->isChecked() ? 1 : 0;
	int staticIP = d->frmStatic->isChecked() ? 1 : 0;
	QString IP = "'" +d-> txtIP1->text() + "." + d->txtIP2->text() + "." + d->txtIP3->text() + "." + d->txtIP4->text() + "'";
		IP = ((staticIP==1)?IP:"NULL");
	QString Mask = "'" + d->txtMask1->text() + "." + d->txtMask2->text() + "." + d->txtMask3->text() + "." + d->txtMask4->text() + "'";
		Mask = ((staticIP==1)?Mask:"NULL");
	int hasgw = d->frmGate->isChecked() ? 1 : 0;
	QString GW = "'" + d->txtGat1->text() + "." + d->txtGat2->text() + "." + d->txtGat3->text() + "." + d->txtGat4->text() + "'";
		GW = (staticIP==1)?GW:"NULL";
	QString script = (d->txtScript->text().length()>0) ? "'" + d->txtScript->text() + "'" : "NULL";
	
	if (!Configured)
	{
		sql="INSERT INTO networks (mac, essid, haswep, wepkey, ingroup, static, ip, netmask, hasgw, ipgw,script) VALUES ";
		sql+="( " + mac + "," + essid + ", " +QVariant(haswep).toString() + ", " + wepkey + ", " ;
		sql+=QVariant(ingroup).toString() + ", " + QVariant(staticIP).toString() + ", " + IP + ", " ;
		sql+=Mask + ", " + QVariant(hasgw).toString() + ", " + GW + ", " + script + " )";
	}
	else
	{
		sql = "UPDATE networks SET ";
		sql += "mac=" + mac + ", ";
		sql += "essid=" + essid + ", ";
		sql += "haswep=" + QVariant(haswep).toString() + ", ";
		sql += "wepkey=" + wepkey + ", ";
		sql += "ingroup=" + QVariant(ingroup).toString() + ", ";
		sql += "static=" + QVariant(staticIP).toString() + ", ";
		sql += "ip=" + IP + ", ";
		sql += "netmask=" + Mask + ", ";
		sql += "hasgw=" + QVariant(hasgw).toString() + ", ";
		sql += "ipgw=" + GW + ", ";
		sql += "script=" + script + " ";
		if (ingroup==1)
			sql += "WHERE essid=" + essid;	
		else
			sql += "WHERE mac=" + mac;
	}
	cout << "Query: " << sql << endl;
	QSqlQuery query(sql,db);
	//query.exec(sql,db);
	if (query.lastError().type() != 0) 
		KMessageBox::error(this, i18n("SQL error:") + " " + query.lastError().text());
	else
	{
	/* I use a config file to store dhcpClient instead
		query.exec("UPDATE networks SET essid='" + txtDhcpClient->text() + "' WHERE mac='11:22:33:44:55:66'");
		if (query.lastError().type() != 0) 
			KMessageBox::error(this, i18n("SQL error:") + " " + query.lastError().text());
		else */
			KMessageBox::information( this, 
						  !Configured ? i18n("Configuration successfully saved"):i18n("Configuration successfully updated")
						);
	}
	frmconfig::close();

}

bool frmconfig::isConfigured(QString essid, QString mac)
{
	if (isGrouped(essid)) 
	{
		Configured = TRUE;
		return true;
	}
	else		//need to look for that mac specifically
	{
		QSqlQuery q("SELECT count(*) FROM networks WHERE mac = '" + mac + "'");
		if (q.lastError().type() != 0) 
		{	
			KMessageBox::error(this, i18n("SQL error:") + " " + q.lastError().text());
			Configured = FALSE;
			return FALSE;
		}
		q.first();
		if (q.value(0).toInt() > 0) {
			Configured = TRUE;
			return TRUE;	//if the mac exist in the db, then it has been already configured
		}
		else
		{
			Configured = FALSE;
			return FALSE;	//otherwise not
		}
	}
}

void frmconfig::removeConfig(QString essid, QString mac)
{
	QSqlQuery q(QString::null,db);
	if (isGrouped(essid))
		q.exec("DELETE FROM networks WHERE essid='" + essid + "'");
	else
		q.exec("DELETE FROM networks WHERE mac='" + mac + "'");
	
	if (q.lastError().type() != 0) 
		KMessageBox::error(this, i18n("SQL error:") + " " + q.lastError().text());
	else
		KMessageBox::information( this, i18n("Configuration for '%1' (%2) successfully removed").arg(essid,mac));
}

bool frmconfig::isGrouped(QString essid)
{
	int c=0;
	QSqlQuery q("SELECT essid, mac, ingroup FROM networks WHERE essid='" + essid + "'");
	if (q.lastError().type() != 0) 
	{	
		KMessageBox::error(this, i18n("SQL error:") + " " + q.lastError().text());
		return false;
	}
	while ( q.next() ) c++;	//count the records
	if (c==0) return false;
	q.first();
	if (q.value(2).toInt()==1) 	//ingroup==1 -> all mac's with that essid have the same configuration
		return true;		//-> don't mind if there are more records whith that essid	
	else
		return false;
}

void frmconfig::loadConfiguration(QString essid, QString mac)
{
	//char temp [256];
/* Now I use a config file to store the dhcp client so next 3 lines are obsolete
	QSqlQuery q("SELECT essid FROM networks WHERE mac='11:22:33:44:55:66'");
	q.first();
	d->txtDhcpClient->setText(q.value(0).toString());
*/
	//configIni * conf = new configIni;	// obsolete
	SWSconfig * conf = new SWSconfig;
	d->txtDhcpClient->setText(conf->getDhclient());
	delete conf;
	
	QSqlCursor cur( "networks", db ); 	// Specify the table/view name
	if (isGrouped(essid))	
	{
        	cur.select("essid='" + essid + "'"); 	//query and filter
		if (cur.lastError().type() != 0) 
		{	
			KMessageBox::error(this, i18n("SQL error:") + " " + cur.lastError().text());
			return;
		}
	}
	else
	{
        	cur.select("mac='" + mac + "'"); 	//query and filter
		if (cur.lastError().type() != 0) 
		{	
			KMessageBox::error(this, i18n("SQL error:") + " " + cur.lastError().text());
			return;
		}
	}

	cur.first();	//There should be only one record		
	d->lblEssid->setText(essid);
	d->lblMAC->setText(mac);
	if (cur.value("haswep").toInt() == 1)
	{
		d->chkWEP->setChecked(true);
		if (cur.value("wepkey").toString().length()==5)
		{
			d->cmbKeyLength->setCurrentItem(0);
			d->txtKey->setMaxLength(5);
		}
		else
		{
			d->cmbKeyLength->setCurrentItem(1);
			d->txtKey->setMaxLength(13);
		}
		d->txtKey->setText(cur.value("wepkey").toString());
	}
	else
		d->chkWEP->setChecked(false);
	if (cur.value("ingroup").toInt()==1)
		d->chkGrouped->setChecked(true);
	else
		d->chkGrouped->setChecked(false);
	if (cur.value("static").toInt()==1)
	{
		d->frmStatic->setChecked(true);
		d->txtIP1->setText(cur.value("ip").toString().section(".",0,0));
		d->txtIP2->setText(cur.value("ip").toString().section(".",1,1));
		d->txtIP3->setText(cur.value("ip").toString().section(".",2,2));
		d->txtIP4->setText(cur.value("ip").toString().section(".",3,3));
		d->txtMask1->setText(cur.value("netmask").toString().section(".",0,0));
		d->txtMask2->setText(cur.value("netmask").toString().section(".",1,1));
		d->txtMask3->setText(cur.value("netmask").toString().section(".",2,2));
		d->txtMask4->setText(cur.value("netmask").toString().section(".",3,3));
		if (cur.value("hasgw").toInt()==1)
		{
			d->frmGate->setChecked(true);
			d->txtGat1->setText(cur.value("ipgw").toString().section(".",0,0));
			d->txtGat2->setText(cur.value("ipgw").toString().section(".",1,1));
			d->txtGat3->setText(cur.value("ipgw").toString().section(".",2,2));
			d->txtGat4->setText(cur.value("ipgw").toString().section(".",3,3));
		}
		else
			d->frmGate->setChecked(false);
	}
	else
		d->frmDhcp->setChecked(true);
	
	d->txtScript->setText(cur.value("script").toString());
}

void frmconfig::findScript()
{
    QString s = KFileDialog::getOpenFileName(
                    QString::null,
                    QString::null,
                    this	 );

    d->txtScript->setText(s);
}

#include "frmconfig.moc"

