/***************************************************************************
 *   Copyright (C) 2004 by Ivan Forcada Atienza                            *
 *   ivan@forcada.info                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 **************************************************************************/
 
#include "apentry.h"

APEntry::APEntry()
{
	MAC = (char *)0;
	essid = (char *)0;
	vendor = (char *)0;
	mode = -1;
	wep = false;
	channel = 0;
	signal = 0;
	noise = 0;
	signalmax = -999;
	snrmax = -999;
	latitude = 0.0;
	longitude = 0.0;
};

void APEntry::reset()
{
	if (MAC) delete [] MAC;
	MAC = (char *)0;
	if (essid) delete [] essid;
	essid = (char *)0;
	if (vendor) delete [] vendor;
	vendor = (char *)0;
	mode = -1;
	channel = 0;
	signal = 0;
	noise = 0;
	signalmax = -999;
	snrmax = -999;
}

void APEntry::setVendor(char * vend)
{
	mut.lock();
		delete [] vendor;
		vendor = PutString(vend);
	mut.unlock();
}

void APEntry::setEssid(char *id)
{
	mut.lock();
		delete [] essid;
		essid = PutString(id);
	mut.unlock();
}

char* APEntry::getVendor(char * temp)
{
	if (vendor)
		return strcpy(temp,vendor);
	else
		return 0;
}

char* APEntry::getEssid(char * temp)
{
	return strcpy(temp,essid);
}

void APEntry::setMAC(char* mac)
{
	delete [] MAC;
	MAC = PutString(mac);
}

char* APEntry::getMAC(char * temp)
{
	return strcpy(temp,MAC);	
}

void APEntry::setWEP(bool w)
{
	mut.lock();
	  wep = w;
	mut.unlock();
}

bool APEntry::getWEP()
{
	return wep;
}

void APEntry::setMode(int m)
{
	mut.lock();
	   mode = m;
	mut.unlock();
}


int APEntry::getMode()
{
    return mode;
}


QString APEntry::getModeString()
{
    if(mode == 0) {
        return i18n("master");
    }
    if(mode == 1) {
        return i18n("ad-hoc");
    }
    return i18n("unknown");
}

QString APEntry::getModeString(int m)
{
    if(m == 0) {
        return i18n("master");
    }
    if(m == 1) {
        return i18n("ad-hoc");
    }
    return i18n("unknown");
}

void APEntry::setChannel(unsigned int ch)
{
	if (ch != 0)
	{
		mut.lock();
		channel=ch;
		mut.unlock();
	}
}

unsigned int APEntry::getChannel()
{
    return channel;
}

void APEntry::setSignal(int s)
{
	mut.lock();
	   signal = s;
	mut.unlock();
}

int APEntry::getSignal()
{
    return signal;
}

void APEntry::setNoise(int n)
{
	mut.lock();
	   noise = n;
	mut.unlock();
}

int APEntry::getNoise()
{
    return noise;
}

void APEntry::setSNRMax(int n)
{
	mut.lock();
	   snrmax = n;
	mut.unlock();
}

int APEntry::getSNRMax()
{
    return snrmax;
}

void APEntry::setSignalMax(int n)
{
	mut.lock();
	   signalmax = n;
	mut.unlock();
}

int APEntry::getSignalMax()
{
    return signalmax;
}

void APEntry::setLatitude (float f)
{
	mut.lock();
	   latitude = f;
	mut.unlock();
}

float APEntry::getLatitude()
{
    return latitude;
}

void APEntry::setLongitude (float f)
{
	mut.lock();
	   longitude = f;
	mut.unlock();
}

float APEntry::getLongitude()
{
    return longitude;
}

char * APEntry::PutString(char *str)
{
	char * mystr; //var to return	
	if (str == NULL) return NULL;
	mystr = new char[ strlen(str) + 1 ];
	if (mystr == NULL) ErrorMem();
	strcpy(mystr, str);
	return mystr;
}

APEntry & APEntry::operator=( const APEntry &a )
{
	char temp [256];
	mut.lock();
		mode = a.mode;
		wep = a.wep;
		channel = a.channel;
		signal = a.signal;
		noise = a.noise;
		delete [] MAC;
		delete [] essid;
		MAC = new char[ strlen(a.MAC) + 1 ];
		strcpy(MAC,temp);
		essid = new char [ strlen(a.essid) + 1 ];
		strcpy(essid,temp);
	mut.unlock();
	return *this;
}
	
APEntry::APEntry( const APEntry &a)
{
	char temp [256];
	mut.lock();
		mode = a.mode;
		wep = a.wep;
		channel = a.channel;
		signal = a.signal;
		noise = a.noise;
		MAC = new char[ strlen(a.MAC) +1 ];
		strcpy(MAC,temp);
		essid = new char [ strlen(a.essid) ];
		strcpy(essid,temp);
	mut.unlock();
}

void APEntry::ErrorMem()
{
	cerr << "APEntry: Not enough memory\n";
	exit (1);
}
