/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: DefaultTreeCellRenderer.java,v $
   Revision 1.5  2004/05/05 12:43:22  bobintetley
   Patches/new files from Laurent Martell

   Revision 1.4  2004/04/15 13:23:03  bobintetley
   Default JTree images in cell renderer for folder/doc like Swing

   Revision 1.3  2003/12/14 09:13:39  bobintetley
   Added CVS log to source headers

*/

package swingwtx.swing.tree;

import swingwtx.swing.*;
import swingwt.awt.*;

public class DefaultTreeCellRenderer extends JLabel implements TreeCellRenderer {
    
    protected boolean hasFocus;
    protected boolean selected;
    
    public Component getTreeCellRendererComponent(swingwtx.swing.JTree tree, 
            Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
         
         this.hasFocus = hasFocus;
         this.selected = selected;
                
         // Default tree images
         if (leaf)
             if (expanded)
                setIcon(openIcon);
             else
                setIcon(closedIcon);
         else
             setIcon(leafIcon);
         
         setText(value.toString());
         return this;
    }
    
    public Color getTextSelectionColor() { return SystemColor.controlHighlight; }
    public Color getTextNonSelectionColor() { return SystemColor.controlText; }

    ImageIcon leafIcon = new ImageIcon(getClass().getResource("/swingwtx/swing/tree/doc.gif"));
    ImageIcon openIcon = new ImageIcon(getClass().getResource("/swingwtx/swing/tree/folderopen.gif"));
    ImageIcon closedIcon = new ImageIcon(getClass().getResource("/swingwtx/swing/tree/folder.gif"));
                                                                                                                                         
    public Icon getLeafIcon() { return leafIcon; }
    public Icon getOpenIcon() { return openIcon; }
    public Icon getClosedIcon() { return closedIcon; }

}
