/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: DefaultMutableTreeNode.java,v $
   Revision 1.7  2004/10/30 20:11:58  bobintetley
   Code cleanup

   Revision 1.6  2004/05/04 11:17:40  bobintetley
   (Laurent Martell) DefaultMutableTreeNode/DefaultTreeModel fixes

   Revision 1.5  2003/12/14 09:13:39  bobintetley
   Added CVS log to source headers

*/

package swingwtx.swing.tree;

import java.util.*;

public class DefaultMutableTreeNode implements MutableTreeNode {

    /** The SWT TreeItem peer */
    public org.eclipse.swt.widgets.TreeItem peer = null;
    
    /** An empty enumeration */
    static public final Enumeration EMPTY_ENUMERATION = new Enumeration() {
        public Object nextElement() {
            throw new NoSuchElementException("No elements");
        }
        public boolean hasMoreElements() { return false; }
    };

    protected MutableTreeNode parent;
    protected boolean allowsChildren;
    protected Vector children;
    protected Object userObject;

    public DefaultMutableTreeNode() {
	this(null);
    }
    
    public DefaultMutableTreeNode(Object userObject) {
	this(userObject, true);
    }

    public DefaultMutableTreeNode(Object userObject, boolean allowsChildren) {
	super();
	this.allowsChildren = allowsChildren;
	this.userObject = userObject;
        parent = null;
    }

    public void insert(MutableTreeNode newChild, int childIndex) {
        MutableTreeNode oldParent = (MutableTreeNode) newChild.getParent();
        if (oldParent != null)
            oldParent.remove(newChild);
        newChild.setParent(this);
        if (children == null)
            children = new Vector();
        children.insertElementAt(newChild, childIndex); 
    }

    public void remove(int childIndex) {
	MutableTreeNode child = (MutableTreeNode) getChildAt(childIndex);
	children.removeElementAt(childIndex);
	child.setParent(null);
    }
    
    public void add(MutableTreeNode newChild) {
	if(newChild.getParent() == this && newChild != null)
	    insert(newChild, getChildCount() - 1);
	else
	    insert(newChild, getChildCount());
    }

    public void setParent(MutableTreeNode newParent) {
	parent = newParent;
    }

    public TreeNode getParent() {
	return parent;
    }    

    public void removeFromParent() {
	MutableTreeNode parent = (MutableTreeNode) getParent();
	parent.remove(this);
    }

    public TreeNode getChildAt(int index) {
	return (TreeNode) children.elementAt(index);
    }

    public int getChildCount() {
	if (children == null)
	    return 0;
	else
	    return children.size();
    }

    public int getIndex(TreeNode aChild) {
	return children.indexOf(aChild);
    }

    public Enumeration children() {
	if (children != null)
	    return children.elements();	
        else
            return EMPTY_ENUMERATION;
    }
    
    public boolean getAllowsChildren() {
	return allowsChildren;
    }
    
    public void setAllowsChildren(boolean allows) {
	if (allows != allowsChildren) {
	    allowsChildren = allows;
	    if (!allowsChildren) {
		removeAllChildren();
	    }
	}
    }

    public Object getUserObject() {
	return userObject;
    }
    
    public void setUserObject(Object userObject) {
	this.userObject = userObject;
    }

    public void remove(MutableTreeNode aChild) {
	remove(getIndex(aChild));	
    }
    
    public void removeAllChildren() {
	for (int i = getChildCount() - 1; i >= 0; i--) {
	    remove(i);
	}
    }
    
    public boolean isLeaf() {
        return getChildCount() > 0;    
    }

    public TreeNode[] getPath() {
        ArrayList path = new ArrayList();
	TreeNode current = this;
	while (current!=null) {
	    path.add(0,current);
	    current = current.getParent();
	}
	return (TreeNode[])path.toArray(new TreeNode[0]);
    }
		    
    
    public boolean isNodeAncestor(TreeNode anotherNode) {
	TreeNode ancestor = this;
	while (ancestor != null) {
	    if (ancestor == anotherNode) {
		return true;
	    }
            ancestor = ancestor.getParent();
	}
	return false;
    }

    public boolean isNodeDescendant(DefaultMutableTreeNode anotherNode) {
	return anotherNode.isNodeAncestor(this);
    }

    public TreeNode getRoot() {
	TreeNode anc = this;
	TreeNode previous;
        previous = anc;
	while (anc != null) {
	    anc = anc.getParent();
	}
	return previous;
    }

    public boolean isRoot() {
	return getParent() == null;
    }

    public String toString() {
	if (userObject == null) {
	    return null;
	} else {
	    return userObject.toString();
	}
    }
}
