/*
   SwingWT
   Copyright(c)2003-2004, R. Rawson-Tetley

   For more information on distributing and using this program, please
   see the accompanying "COPYING" file.

   Contact me by electronic mail: bobintetley@users.sourceforge.net

   $Log: JTextArea.java,v $
   Revision 1.33  2004/11/02 11:26:05  bobintetley
   Fix to default size of JTextArea/JTextField

   Revision 1.32  2004/09/24 14:07:30  bobintetley
   JScrollPane/Toolbar fixes

   Revision 1.31  2004/08/02 22:01:03  dannaab
   JViewport/JScrollPane integration

   Revision 1.30  2004/07/19 10:09:25  dannaab
   *** empty log message ***

   Revision 1.29  2004/06/10 07:57:59  dannaab
   Added AWTSwingWrapper to map AWT components to the corresponding Swing version.  Implemted using it: TextComponent, TextArea, TextField; used similar technique for Menu components

   Revision 1.27  2004/06/04 14:21:09  bobintetley
   JTextArea default size fixes and new computePreferredSize() method that
      delegates to peer to size a component

   Revision 1.26  2004/05/06 12:35:22  bobintetley
   Parity with Swing constants for Binary Compatibility + fixes to JDesktopPane

   Revision 1.25  2004/05/04 09:31:43  bobintetley
   PlainDocument/View support and implementation. Build script supports java/javax
   packages - fix to build script to use nested args in bootclasspath (single path broke on my Ant 1.6.1/Linux)

   Revision 1.24  2004/04/30 13:20:43  bobintetley
   Fix to unrealised peer preferred sizes, forwarding window events to
   content panes and fix for mouse drag events.

   Revision 1.23  2004/04/28 11:02:03  bobintetley
   PlainDocument implementation

   Revision 1.22  2004/04/28 08:38:12  bobintetley
   Hierarchy fixes, code cleanup for base classes, additional javadocs and use of flag to identify JComponent descendants with peers

   Revision 1.21  2004/03/18 16:21:37  bobintetley
   JTextComponent/Caret implementation and fix to JFileChooser for bug in GNU classpath

   Revision 1.20  2004/02/23 12:11:24  bobintetley
   JScrollPane bug fixed, tabbing in JTextArea fixed

   Revision 1.19  2004/02/19 09:58:44  bobintetley
   Various small bug fixes and JTextArea should be much faster/lighter

   Revision 1.18  2004/01/27 09:05:11  bobintetley
   ListModel and List Selection implemented. ScrollPane fix so all components
      scrollable

   Revision 1.17  2004/01/20 07:38:05  bobintetley
   Bug fixes and compatibility methods

   Revision 1.16  2004/01/16 15:53:32  bobintetley
   Many compatibility methods added to Container, Component, JInternalFrame,
      UIManager, SwingUtilities, JTabbedPane, JPasswordField, JCheckBox
      and JRadioButton.

   Revision 1.15  2004/01/08 12:56:30  bobintetley
   Experiment with hotkeys - unworkable in current SWT

   Revision 1.14  2004/01/08 12:17:51  bobintetley
   JTextArea supports CTRL+A like Swing

   Revision 1.13  2003/12/17 09:03:14  bobintetley
   Closely matches Swing behaviour + JScrollPane support for Panels

   Revision 1.12  2003/12/16 17:46:17  bobintetley
   Additional thread safety methods

   Revision 1.11  2003/12/16 13:14:33  bobintetley
   Use of SwingWTUtils.isSWTControlAvailable instead of null test

   Revision 1.10  2003/12/15 18:29:57  bobintetley
   Changed setParent() method to setSwingWTParent() to avoid conflicts with applications

   Revision 1.9  2003/12/15 15:54:25  bobintetley
   Additional core methods

   Revision 1.8  2003/12/14 09:13:38  bobintetley
   Added CVS log to source headers

*/


package swingwtx.swing;

import swingwtx.swing.text.*;

import org.eclipse.swt.widgets.*;
import org.eclipse.swt.*;

public class JTextArea extends swingwtx.swing.text.JTextComponent {

    protected boolean pWordWrap = false;
    
    /** The default number of columns used if the app doesn't specify */
    private final static int DEFAULT_COLS = 8;
    /** The default number of rows used if the app doesn't specify */
    private final static int DEFAULT_ROWS = 4;
    
    protected int pRows = DEFAULT_ROWS;
    protected int pCols = DEFAULT_COLS;
    
    /** Return value for thread safe accessors */
    private String retVal = "";
    private int iRetVal = 0;
    
    public JTextArea() {
        this(null, "", DEFAULT_ROWS, DEFAULT_COLS);
    }
    public JTextArea(String text) {
        this(null, text, DEFAULT_ROWS, DEFAULT_COLS);
    }
    public JTextArea(int rows, int columns) {
        this(null, "", rows, columns);
    }
    public JTextArea(String text, int rows, int columns) {
        this(null, text, rows, columns);
    }
    public JTextArea(Document doc) {
        this(doc, "", DEFAULT_ROWS, DEFAULT_COLS);
    }
    public JTextArea(Document doc, String text, int rows, int columns) {
        super(); 
        if (doc != null) setDocument(doc);
        if (text != null) {
            setText(text);
            view.updateModelFromComponent(getText());
        }
        pRows = rows;
        pCols = columns;
        calculateFromRowsCols();
    }

    // TODO
    public void setHorizontalScrollPane(boolean scroll) {}
    public void setVerticalScrollPane(boolean scroll) {}
    public boolean getHorizontalScrollPane() { return false; }
    public boolean getVerticalScrollPane() { return false; }
    public void setScrollPane(JScrollPane pane) {}

    // TODO: implement sizing by row/columns
    public void setColumns(int columns) {}
    public void setRows(int rows) {}
    public int getColumns() { return 0;}
    public int getRows() { return 0; }
    
    /**
     * Calculates the component's preferred size based on how
     * many rows/columns the user chose.
     */
    protected void calculateFromRowsCols() {
        if (pRows != 0 && pCols != 0)
            setPreferredSize( new swingwt.awt.Dimension((SwingWTUtils.getRenderStringWidth("W") * pCols), 25 * pRows ));
        else if (pRows == 0 && pCols != 0)
            setPreferredSize( new swingwt.awt.Dimension((SwingWTUtils.getRenderStringWidth("W") * pCols), 25 ));
    }
    
    
    public void append(final String text) { 
        pText += text;
        SwingUtilities.invokeSync(new Runnable() {
            public void run() {
                if (SwingWTUtils.isSWTControlAvailable(ppeer)) ppeer.append(text); 
            }
        });
    }
    
    public boolean getLineWrap() { return true; }
    public void setLineWrap(boolean b) { }
    public boolean getWrapStyleWord() { return pWordWrap; }
    public void setWrapStyleWord(final boolean b) { pWordWrap = b; } 
    
    /** Overriden to calculate non-realised
     *  preferred size.
     */
    protected swingwt.awt.Dimension calculatePreferredSize() {
    	swingwt.awt.Dimension size = new swingwt.awt.Dimension(
    			(SwingWTUtils.getRenderStringWidth("W") * pCols), 
    			pRows * 25
				);
        setSize(size);
        return size;
    }
    
    /** Overriden so we can make sure that text areas aren't
     *  too small to match Swing.
     */
    protected swingwt.awt.Dimension computePreferredSize() {
        swingwt.awt.Dimension size = new swingwt.awt.Dimension(
            SwingWTUtils.getRenderStringWidth(pText), 
            SwingWTUtils.getRenderStringHeight(pText) + 4);
        int oneChar = SwingWTUtils.getRenderStringHeight("W") + 4;
        if (size.height <= oneChar)
            size.height = oneChar * 4;
        int smallest = SwingWTUtils.getRenderStringWidth("WWWWWWWWW");
        if (size.width < smallest)
            size.width = smallest;
        return size;
    }
    
    /**
     * Once a parent component receives an "add" call for a child, this being
     * the child, this should be called to tell us to instantiate the peer
     * and load in any cached properties.
     */
    public void setSwingWTParent(swingwt.awt.Container parent) throws Exception {
        descendantHasPeer = true;
        
        int swtFlags = SWT.BORDER | SWT.MULTI;
        swtFlags |= pWordWrap ? SWT.WRAP : SWT.NONE;
        
        if (parent instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane) parent;
            boolean useHorizontal = false, useVertical = false;
            switch (scrollPane.getHorizontalScrollBarPolicy()) {
                case JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS:
                    useHorizontal = true;
                    break;
                case JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED:
                    useHorizontal = true;
                    break;
                case JScrollPane.HORIZONTAL_SCROLLBAR_NEVER:
                    break;
                default:
                    useHorizontal = false;
                    break;
            }
            switch (scrollPane.getVerticalScrollBarPolicy()) {
                case JScrollPane.VERTICAL_SCROLLBAR_ALWAYS:
                    useVertical = true;
                    break;
                case JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED:
                    useVertical = true;
                    break;
                case JScrollPane.VERTICAL_SCROLLBAR_NEVER:
                    break;
                default:
                    useVertical = false;
                    break;
            }
            swtFlags |= useHorizontal ? SWT.H_SCROLL : SWT.NONE;
            swtFlags |= useVertical ? SWT.V_SCROLL : SWT.NONE;
        }
        
        ppeer = new Text(parent.getComposite(), swtFlags);
        ppeer.setText(pText);
        ppeer.setEditable(pEditable);
        ppeer.setTabs(0);
        peer = ppeer;

        ppeer.addKeyListener(new org.eclipse.swt.events.KeyAdapter() {
            public void keyPressed(org.eclipse.swt.events.KeyEvent e) {
                
                // This is so that CTRL+A selects everything in the text field
                if ((e.keyCode == 97 ) && ((e.stateMask & SWT.CTRL) > 0)) {
                    selectAll();
                    e.doit = false;
                }
                
                // TAB navigation
                if ((e.keyCode == SWT.TAB) && ((e.stateMask & SWT.SHIFT) > 0)) {
                    ppeer.traverse(SWT.TRAVERSE_TAB_PREVIOUS);
                    e.doit = false;
                }
                else if (e.keyCode == SWT.TAB) {
                    ppeer.traverse(SWT.TRAVERSE_TAB_NEXT);
                    e.doit = false;
                }
                
            }    
        });
        
        this.parent = parent;
        ppeer.addVerifyListener(new TextEventHandler());
    }
}
