/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProduct;

public class Product
implements IProduct {
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_APPLICATION = "application";
    String application = null;
    String name = null;
    String id = null;
    String description = null;
    Dictionary properties;

    public Product(IConfigurationElement element) {
        if (element == null) {
            return;
        }
        this.application = element.getAttribute(ATTR_APPLICATION);
        this.name = element.getAttribute(ATTR_NAME);
        this.id = element.getAttribute(ATTR_ID);
        this.description = element.getAttribute(ATTR_DESCRIPTION);
        this.loadProperties(element);
    }

    private void loadProperties(IConfigurationElement element) {
        String[] attributes = element.getAttributeNames();
        this.properties = new Hashtable(attributes.length);
        int i = 0;
        while (i < attributes.length) {
            if (!(attributes[i].equalsIgnoreCase(ATTR_DESCRIPTION) || attributes[i].equalsIgnoreCase(ATTR_ID) || attributes[i].equalsIgnoreCase(ATTR_NAME) || attributes[i].equalsIgnoreCase(ATTR_APPLICATION))) {
                this.properties.put(attributes[i], element.getAttribute(attributes[i]));
            }
            ++i;
        }
    }

    public String getApplication() {
        return this.application;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getProperty(String key) {
        return (String)this.properties.get(key);
    }
}

