/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwtx.accessibility.Accessible;
import swingwtx.swing.SwingConstants;
import swingwtx.swing.SwingWTUtils;

public abstract class SwingUtilities
implements SwingConstants {
    public static void invokeAndWait(Runnable run) {
        SwingUtilities.invokeSync(run);
    }

    public static void invokeLater(Runnable run) {
        SwingUtilities.invokeAsync(run);
    }

    public static void invokeAsync(Runnable run) {
        SwingWTUtils.checkEventDispatcher();
        SwingWTUtils.getDisplay().asyncExec(run);
    }

    public static void invokeSync(Runnable run) {
        SwingWTUtils.checkEventDispatcher();
        if (Thread.currentThread().equals(SwingWTUtils.getDisplay().getThread())) {
            run.run();
        } else {
            SwingWTUtils.getDisplay().syncExec(run);
        }
    }

    public static void invokeIn(Runnable run, int milliseconds) {
        SwingWTUtils.checkEventDispatcher();
        SwingWTUtils.getDisplay().timerExec(milliseconds, run);
    }

    public static void updateComponentTreeUI(Component c) {
        if (c instanceof Container) {
            ((Container)c).invalidate();
        }
        c.repaint();
    }

    public static Container getAncestorOfClass(Class c, Component comp) {
        Container parent;
        if (comp == null || c == null) {
            return null;
        }
        for (parent = comp.getParent(); parent != null && !c.isInstance(parent); parent = parent.getParent()) {
        }
        return parent;
    }

    public static int getAccessibleChildrenCount(Component component) {
        return 0;
    }

    public static Accessible getAccessibleChild(Component component, int i) {
        return component.getAccessibleContext().getAccessibleChild(i);
    }
}

