/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwtx.swing.SwingConstants;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.text.Document;
import swingwtx.swing.text.JTextComponent;

public class JTextField
extends JTextComponent
implements SwingConstants {
    private static final int DEFAULT_COLS = 8;
    protected int pCols = 8;
    private String retVal = "";

    public JTextField() {
        this(null, "", 8);
    }

    public JTextField(int columns) {
        this(null, "", columns);
    }

    public JTextField(String text) {
        this(null, text, 8);
    }

    public JTextField(String text, int columns) {
        this(null, text, columns);
    }

    public JTextField(Document doc, String text, int columns) {
        if (doc != null) {
            this.setDocument(doc);
        }
        this.pText = text;
        this.pCols = columns;
        if (this.pCols != 0) {
            this.calculateFromCols();
        }
        if (this.pText != null && !this.pText.equals("")) {
            this.view.updateModelFromComponent(this.pText);
        }
    }

    protected void calculateFromCols() {
        this.setPreferredSize(new Dimension(SwingWTUtils.getRenderStringWidth("W") * this.pCols, 25));
    }

    public int getColumns() {
        return this.pCols;
    }

    public void setColumns(int columns) {
        this.pCols = columns;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            this.ppeer.setTextLimit(this.pCols);
        }
    }

    public void setEditable(boolean b) {
        this.pEditable = b;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            this.ppeer.setEditable(b);
        }
    }

    public boolean isEditable() {
        return this.pEditable;
    }

    protected Dimension calculatePreferredSize() {
        Dimension size = new Dimension(SwingWTUtils.getRenderStringWidth("W") * this.pCols, 25);
        this.setSize(size);
        return size;
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.descendantHasPeer = true;
        this.ppeer = new Text(parent.getComposite(), 2052);
        if (this.pText == null) {
            this.ppeer.setText("");
        } else {
            this.ppeer.setText(this.pText);
        }
        this.ppeer.setEditable(this.pEditable);
        if (this.pCols > 1 && this.pCols != 8) {
            this.ppeer.setTextLimit(this.pCols);
        }
        this.peer = this.ppeer;
        this.parent = parent;
        this.ppeer.addVerifyListener((VerifyListener)new JTextComponent.TextEventHandler(this));
    }
}

