/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scale;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwtx.swing.JComponent;
import swingwtx.swing.SwingConstants;
import swingwtx.swing.SwingUtilities;
import swingwtx.swing.SwingWTUtils;
import swingwtx.swing.border.EmptyBorder;
import swingwtx.swing.event.ChangeEvent;
import swingwtx.swing.event.ChangeListener;

public class JSlider
extends JComponent
implements SwingConstants {
    protected int orientation = 0;
    protected int min = 0;
    protected int max = 100;
    protected int value = 50;
    protected int thumb = 10;
    protected Dictionary labelTable = new Hashtable();
    protected Vector changeListeners = new Vector();
    protected Scale ppeer = null;
    private int threadSafeInt = 0;

    public JSlider() {
        this(0, 0, 100, 50);
    }

    public JSlider(int orientation) {
        this(orientation, 0, 100, 50);
    }

    public JSlider(int min, int max) {
        this(0, min, max, (min + max) / 2);
    }

    public JSlider(int min, int max, int value) {
        this(0, min, max, value);
    }

    public JSlider(int orientation, int min, int max, int value) {
        this.orientation = orientation;
        this.min = min;
        this.max = max;
        this.value = value;
    }

    public Hashtable createStandardLabels(int increment) {
        Hashtable<Integer, Integer> h = new Hashtable<Integer, Integer>(10);
        for (int i = 0; i <= this.max; i += increment) {
            h.put(new Integer(i), new Integer(i));
        }
        return h;
    }

    public Hashtable createStandardLabels(int increment, int start) {
        Hashtable<Integer, Integer> h = new Hashtable<Integer, Integer>(10);
        for (int i = start; i <= this.max; i += increment) {
            h.put(new Integer(i), new Integer(i));
        }
        return h;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    protected void fireStateChanged() {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            ((ChangeListener)this.changeListeners.get(i)).stateChanged(new ChangeEvent(this));
        }
    }

    public int getValue() {
        if (!SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            return this.value;
        }
        SwingUtilities.invokeSync(new Runnable(){

            public void run() {
                JSlider.this.threadSafeInt = JSlider.this.ppeer.getSelection();
            }
        });
        return this.threadSafeInt;
    }

    public void setValue(final int value) {
        this.value = value;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JSlider.this.ppeer.setSelection(value);
                }
            });
        }
    }

    public int getExtent() {
        return this.thumb;
    }

    public void setExtent(int extent) {
        this.thumb = extent;
        if (SwingWTUtils.isSWTControlAvailable((Control)this.ppeer)) {
            SwingUtilities.invokeSync(new Runnable(){

                public void run() {
                    JSlider.this.ppeer.setPageIncrement(JSlider.this.thumb);
                }
            });
        }
    }

    public boolean getInverted() {
        return false;
    }

    public boolean isInverted() {
        return false;
    }

    public void setInverted(boolean b) {
    }

    public int getMajorTickSpacing() {
        return this.getExtent();
    }

    public void setMajorTickSpacing(int spacing) {
        this.setExtent(spacing);
    }

    public int getMinorTickSpacing() {
        return this.getExtent() / 2;
    }

    public void setMinorTickSpacing(int spacing) {
    }

    public boolean getSnapToTicks() {
        return true;
    }

    public boolean getSnapToValue() {
        return true;
    }

    public boolean isSnapToTicks() {
        return true;
    }

    public boolean isSnapToValue() {
        return true;
    }

    public void setSnapToTicks(boolean b) {
    }

    public void setSnapToValue(boolean b) {
    }

    public boolean getPaintTicks() {
        return true;
    }

    public boolean isPaintTicks() {
        return true;
    }

    public void setPaintTicks(boolean b) {
    }

    public boolean getPaintTrack() {
        return true;
    }

    public boolean isPaintTrack() {
        return true;
    }

    public void setPaintTrack(boolean b) {
    }

    public boolean getPaintLabels() {
        return true;
    }

    public boolean isPaintLabels() {
        return true;
    }

    public void setPaintLabels(boolean b) {
    }

    public Dictionary getLabelTable() {
        return this.labelTable;
    }

    public void setLabelTable(Dictionary table) {
        this.labelTable = table;
    }

    protected Dimension calculatePreferredSize() {
        Dimension size = new Dimension(200, 25);
        this.setSize(size);
        return size;
    }

    public void setSwingWTParent(Container parent) throws Exception {
        this.descendantHasPeer = true;
        this.ppeer = new Scale(parent.getComposite(), (this.border instanceof EmptyBorder ? 0 : 2048) | (this.orientation == 0 ? 256 : 512));
        this.ppeer.setMaximum(this.max);
        this.ppeer.setMinimum(this.min);
        this.ppeer.setPageIncrement(this.thumb);
        this.ppeer.setSelection(this.value);
        if (this.orientation == 0 && this.pPrefSize == null) {
            this.setPreferredSize(new Dimension(200, 20));
        }
        if (this.orientation == 1 && this.pPrefSize == null) {
            this.setPreferredSize(new Dimension(20, 200));
        }
        this.ppeer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSlider.this.fireStateChanged();
            }
        });
        this.peer = this.ppeer;
        this.parent = parent;
    }
}

