/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Vector;
import swingwtx.swing.AbstractListModel;
import swingwtx.swing.MutableComboBoxModel;

public class DefaultComboBoxModel
extends AbstractListModel
implements MutableComboBoxModel {
    protected Vector objects;
    protected Object selectedObject;

    public DefaultComboBoxModel() {
        this.objects = new Vector();
    }

    public DefaultComboBoxModel(Object[] items) {
        this.objects = new Vector(items.length);
        for (int i = 0; i < items.length; ++i) {
            this.objects.add(items[i]);
        }
        if (this.objects.size() > 0) {
            this.selectedObject = this.objects.get(0);
        }
    }

    public DefaultComboBoxModel(Vector v) {
        this.objects = v;
        if (this.objects.size() > 0) {
            this.selectedObject = this.objects.get(0);
        }
    }

    public void setSelectedItem(Object anObject) {
        if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
            this.selectedObject = anObject;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public Object getSelectedItem() {
        return this.selectedObject;
    }

    public int getSize() {
        return this.objects.size();
    }

    public Object getElementAt(int index) {
        if (index >= 0 && index < this.objects.size()) {
            return this.objects.get(index);
        }
        return null;
    }

    public int getIndexOf(Object anObject) {
        return this.objects.indexOf(anObject);
    }

    public void addElement(Object anObject) {
        this.objects.add(anObject);
        this.fireIntervalAdded(this, this.objects.size() - 1, this.objects.size() - 1);
        if (this.objects.size() == 1 && this.selectedObject == null && anObject != null) {
            this.setSelectedItem(anObject);
        }
    }

    public void insertElementAt(Object anObject, int index) {
        this.objects.insertElementAt(anObject, index);
        this.fireIntervalAdded(this, index, index);
    }

    public void removeElementAt(int index) {
        if (this.objects.get(index) == this.selectedObject) {
            if (index == 0) {
                this.setSelectedItem(this.objects.size() == 1 ? null : this.objects.get(index + 1));
            } else {
                this.setSelectedItem(this.objects.get(index - 1));
            }
        }
        this.objects.removeElementAt(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void removeElement(Object anObject) {
        int index = this.getIndexOf(anObject);
        this.removeElementAt(index);
    }

    public void removeAllElements() {
        if (this.objects.size() > 0) {
            int firstIndex = 0;
            int lastIndex = this.objects.size() - 1;
            this.objects.removeAllElements();
            this.selectedObject = null;
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        } else {
            this.selectedObject = null;
        }
    }
}

