/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing;

import java.util.Enumeration;
import java.util.Vector;
import swingwtx.swing.AbstractButton;
import swingwtx.swing.ButtonModel;

public class ButtonGroup {
    protected Vector buttons = new Vector();
    ButtonModel selection = null;

    public void add(AbstractButton b) {
        this.buttons.add(b);
        if (b.isSelected()) {
            if (this.selection == null) {
                this.selection = b.getModel();
            } else {
                b.setSelected(false);
            }
        }
        b.getModel().setGroup(this);
    }

    public void remove(AbstractButton b) {
        if (b == null) {
            return;
        }
        this.buttons.remove(b);
        if (b.getModel() == this.selection) {
            this.selection = null;
        }
        b.getModel().setGroup(null);
    }

    public Enumeration getElements() {
        return this.buttons.elements();
    }

    public ButtonModel getSelection() {
        return this.selection;
    }

    public void setSelected(ButtonModel m, boolean b) {
        if (b && m != null && m != this.selection) {
            ButtonModel oldSelection = this.selection;
            this.selection = m;
            if (oldSelection != null) {
                oldSelection.setSelected(false);
            }
            m.setSelected(true);
        }
    }

    public boolean isSelected(ButtonModel m) {
        return m == this.selection;
    }

    public int getButtonCount() {
        if (this.buttons == null) {
            return 0;
        }
        return this.buttons.size();
    }
}

