/*
 * Decompiled with CFR 0.152.
 */
package swingwt.awt;

import java.util.Vector;
import swingwt.awt.Component;
import swingwt.awt.Container;
import swingwt.awt.Dimension;
import swingwt.awt.Insets;
import swingwt.awt.LayoutManager2;

public class CardLayout
implements LayoutManager2 {
    int currentCard = 0;
    int hgap;
    int vgap;
    Vector cards = new Vector();

    public CardLayout() {
        this(0, 0);
    }

    public CardLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints instanceof String) {
            this.addLayoutComponent((String)constraints, comp);
        } else {
            System.out.println(comp.toString());
        }
    }

    public void addLayoutComponent(String name, Component comp) {
        if (!this.cards.isEmpty()) {
            comp.setVisible(false);
        }
        for (int i = 0; i < this.cards.size(); ++i) {
            if (!((Card)this.cards.get((int)i)).name.equals(name)) continue;
            ((Card)this.cards.get((int)i)).comp = comp;
            return;
        }
        this.cards.add(new Card(name, comp));
    }

    public void removeLayoutComponent(Component comp) {
        for (int i = 0; i < this.cards.size(); ++i) {
            if (((Card)this.cards.get((int)i)).comp != comp) continue;
            if (comp.isVisible() && comp.getParent() != null) {
                this.next(comp.getParent());
            }
            this.cards.remove(i);
            if (this.currentCard <= i) break;
            --this.currentCard;
            break;
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int w = 0;
        int h = 0;
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            Dimension d = comp.getPreferredSize();
            if (d.width > w) {
                w = d.width;
            }
            if (d.height <= h) continue;
            h = d.height;
        }
        return new Dimension(insets.left + insets.right + w + this.hgap * 2, insets.top + insets.bottom + h + this.vgap * 2);
    }

    public Dimension minimumLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        int w = 0;
        int h = 0;
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            Dimension d = comp.getMinimumSize();
            if (d.width > w) {
                w = d.width;
            }
            if (d.height <= h) continue;
            h = d.height;
        }
        return new Dimension(insets.left + insets.right + w + this.hgap * 2, insets.top + insets.bottom + h + this.vgap * 2);
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int ncomponents = parent.getComponentCount();
        Component comp = null;
        boolean currentFound = false;
        for (int i = 0; i < ncomponents; ++i) {
            comp = parent.getComponent(i);
            comp.setBounds(this.hgap + insets.left, this.vgap + insets.top, parent.getWidth() - (this.hgap * 2 + insets.left + insets.right), parent.getHeight() - (this.vgap * 2 + insets.top + insets.bottom));
            if (!comp.isVisible()) continue;
            currentFound = true;
        }
        if (!currentFound && ncomponents > 0) {
            parent.getComponent(0).setVisible(true);
        }
    }

    void checkLayout(Container parent) {
    }

    public void first(Container parent) {
        int ncomponents = parent.getComponentCount();
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            if (!comp.isVisible()) continue;
            comp.setVisible(false);
            break;
        }
        if (ncomponents > 0) {
            this.currentCard = 0;
            parent.getComponent(0).setVisible(true);
            parent.validate();
        }
    }

    public void next(Container parent) {
        int ncomponents = parent.getComponentCount();
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            if (!comp.isVisible()) continue;
            comp.setVisible(false);
            this.currentCard = (i + 1) % ncomponents;
            comp = parent.getComponent(this.currentCard);
            comp.setVisible(true);
            parent.validate();
            return;
        }
        this.showFirstAvailableComponent(parent);
    }

    public void previous(Container parent) {
        int ncomponents = parent.getComponentCount();
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            if (!comp.isVisible()) continue;
            comp.setVisible(false);
            this.currentCard = i > 0 ? i - 1 : ncomponents - 1;
            comp = parent.getComponent(this.currentCard);
            comp.setVisible(true);
            parent.validate();
            return;
        }
        this.showFirstAvailableComponent(parent);
    }

    public void last(Container parent) {
        int ncomponents = parent.getComponentCount();
        for (int i = 0; i < ncomponents; ++i) {
            Component comp = parent.getComponent(i);
            if (!comp.isVisible()) continue;
            comp.setVisible(false);
            break;
        }
        if (ncomponents > 0) {
            this.currentCard = ncomponents - 1;
            parent.getComponent(this.currentCard).setVisible(true);
            parent.validate();
        }
    }

    public void show(Container parent, String name) {
        int i;
        Component next = null;
        int ncomponents = this.cards.size();
        for (i = 0; i < ncomponents; ++i) {
            Card card = (Card)this.cards.get(i);
            if (!card.name.equals(name)) continue;
            next = card.comp;
            this.currentCard = i;
            break;
        }
        if (next != null && !next.isVisible()) {
            ncomponents = parent.getComponentCount();
            for (i = 0; i < ncomponents; ++i) {
                Component comp = parent.getComponent(i);
                if (!comp.isVisible()) continue;
                comp.setVisible(false);
                break;
            }
            next.setVisible(true);
            parent.validate();
        }
    }

    private void showFirstAvailableComponent(Container parent) {
        if (parent.getComponentCount() > 0) {
            this.currentCard = 0;
            parent.getComponent(0).setVisible(true);
            parent.validate();
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    private class Card {
        public String name;
        public Component comp;

        public Card(String cardName, Component cardComponent) {
            this.name = cardName;
            this.comp = cardComponent;
        }
    }
}

