/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal.graph;

import java.util.ArrayList;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.internal.graph.SpanningTreeVisitor;

public class TightSpanningTreeSolver
extends SpanningTreeVisitor {
    protected DirectedGraph graph;
    protected EdgeList candidates = new EdgeList();
    protected NodeList members = new NodeList();

    public void visit(DirectedGraph graph) {
        this.graph = graph;
        this.init();
        this.solve();
    }

    Node addEdge(Edge edge) {
        Node node;
        int delta = edge.getSlack();
        edge.tree = true;
        if (edge.target.flag) {
            delta = -delta;
            node = edge.source;
            this.setParentEdge(node, edge);
            this.getSpanningTreeChildren(edge.target).add(edge);
        } else {
            node = edge.target;
            this.setParentEdge(node, edge);
            this.getSpanningTreeChildren(edge.source).add(edge);
        }
        this.members.adjustRank(delta);
        this.addNode(node);
        return node;
    }

    void addNode(Node node) {
        Edge e;
        node.flag = true;
        EdgeList list = node.incoming;
        int i = 0;
        while (i < list.size()) {
            e = list.getEdge(i);
            if (!e.source.flag) {
                if (!this.candidates.contains(e)) {
                    this.candidates.add(e);
                }
            } else {
                this.candidates.remove(e);
            }
            ++i;
        }
        list = node.outgoing;
        i = 0;
        while (i < list.size()) {
            e = list.getEdge(i);
            if (!e.target.flag) {
                if (!this.candidates.contains(e)) {
                    this.candidates.add(e);
                }
            } else {
                this.candidates.remove(e);
            }
            ++i;
        }
        this.members.add(node);
    }

    void init() {
        this.graph.edges.resetFlags();
        this.graph.nodes.resetFlags();
        int i = 0;
        while (i < this.graph.nodes.size()) {
            Node node = (Node)this.graph.nodes.get(i);
            node.workingData[0] = new EdgeList();
            ++i;
        }
    }

    protected void solve() {
        Node root = this.graph.nodes.getNode(0);
        this.setParentEdge(root, null);
        this.addNode(root);
        ArrayList nonMembers = new ArrayList(this.graph.nodes);
        while (this.members.size() < this.graph.nodes.size()) {
            if (this.candidates.size() == 0) {
                throw new RuntimeException("graph is not fully connected");
            }
            int minSlack = Integer.MAX_VALUE;
            Edge minEdge = null;
            int i = 0;
            while (i < this.candidates.size() && minSlack > 0) {
                Edge edge = this.candidates.getEdge(i);
                int slack = edge.getSlack();
                if (slack < minSlack) {
                    minSlack = slack;
                    minEdge = edge;
                }
                ++i;
            }
            Node added = this.addEdge(minEdge);
            nonMembers.remove(added);
        }
        this.graph.nodes.normalizeRanks();
    }
}

