/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.DragCursors;
import org.eclipse.ui.internal.IWindowTrim;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartTabFolder;
import org.eclipse.ui.internal.RootLayoutContainer;
import org.eclipse.ui.internal.TrimLayout;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.AbstractDropTarget;
import org.eclipse.ui.internal.dnd.CompatibilityDragTarget;
import org.eclipse.ui.internal.dnd.IDragOverListener;
import org.eclipse.ui.internal.dnd.IDropTarget;

class TrimDropTarget
implements IDragOverListener {
    private TrimLayout layout;
    private Composite windowComposite;
    private WorkbenchWindow window;
    private static final float edgeDockRatio = 0.2f;

    public TrimDropTarget(Composite someComposite, WorkbenchWindow theWindow) {
        this.layout = (TrimLayout)someComposite.getLayout();
        this.windowComposite = someComposite;
        this.window = theWindow;
    }

    public IDropTarget drag(Control currentControl, Object draggedObject, Point position, final Rectangle dragRectangle) {
        Control targetTrim;
        IWindowTrim draggedTrim;
        Control trimControl;
        if (draggedObject instanceof IWindowTrim && (trimControl = (draggedTrim = (IWindowTrim)draggedObject).getControl()).getParent() == this.windowComposite && (targetTrim = this.getTrimControl(currentControl)) != null) {
            int side = this.layout.getTrimLocation(targetTrim);
            if (side == -1 && targetTrim == this.layout.getCenterControl()) {
                side = CompatibilityDragTarget.getRelativePosition(targetTrim, position);
                if (side == 0x1000000) {
                    side = -1;
                }
                targetTrim = null;
            }
            if (side != -1 && targetTrim != trimControl && (targetTrim != null || side != this.layout.getTrimLocation(trimControl)) && (side & draggedTrim.getValidSides()) != 0) {
                final int dropSide = side;
                return new AbstractDropTarget(){

                    public void drop() {
                        draggedTrim.dock(dropSide);
                    }

                    public Cursor getCursor() {
                        return DragCursors.getCursor(DragCursors.positionToDragCursor(dropSide));
                    }

                    public Rectangle getSnapRectangle() {
                        int smaller = Math.min(dragRectangle.width, dragRectangle.height);
                        return Geometry.toDisplay((Control)TrimDropTarget.this.windowComposite, (Rectangle)Geometry.getExtrudedEdge((Rectangle)TrimDropTarget.this.windowComposite.getClientArea(), (int)smaller, (int)dropSide));
                    }
                };
            }
        }
        if (draggedObject instanceof ViewPane || draggedObject instanceof PartTabFolder) {
            PartTabFolder folder;
            final LayoutPart draggedPane = (LayoutPart)draggedObject;
            if (draggedPane.getWorkbenchWindow() != this.window) {
                return null;
            }
            if (draggedPane instanceof PartTabFolder && (folder = (PartTabFolder)draggedPane).getWindow() != this.window) {
                return null;
            }
            final Rectangle bounds = Geometry.toDisplay((Control)this.layout.getCenterControl().getParent(), (Rectangle)this.layout.getCenterControl().getBounds());
            final int relativePosition = Geometry.getClosestSide((Rectangle)bounds, (Point)position);
            if (bounds.contains(position)) {
                return null;
            }
            final RootLayoutContainer sashContainer = this.window.getActiveWorkbenchPage().getPerspectivePresentation().getLayout();
            return new AbstractDropTarget(){

                public void drop() {
                    PartTabFolder folder;
                    TrimDropTarget.this.window.getActiveWorkbenchPage().getPerspectivePresentation().derefPart(draggedPane);
                    if (draggedPane instanceof PartTabFolder) {
                        folder = (PartTabFolder)draggedPane;
                    } else {
                        folder = new PartTabFolder(TrimDropTarget.this.window.getActiveWorkbenchPage());
                        folder.add(draggedPane);
                    }
                    sashContainer.addEnhanced(folder, relativePosition, 0.2f, null);
                    draggedPane.setFocus();
                }

                public Cursor getCursor() {
                    return DragCursors.getCursor(DragCursors.positionToDragCursor(Geometry.getOppositeSide((int)relativePosition)));
                }

                public Rectangle getSnapRectangle() {
                    int sz = (int)((float)Geometry.getDimension((Rectangle)bounds, (!Geometry.isHorizontal((int)relativePosition) ? 1 : 0) != 0) * 0.2f);
                    return Geometry.getExtrudedEdge((Rectangle)bounds, (int)sz, (int)relativePosition);
                }
            };
        }
        return null;
    }

    private Control getTrimControl(Control searchSource) {
        if (searchSource == null) {
            return null;
        }
        if (searchSource.getParent() == this.windowComposite) {
            return searchSource;
        }
        return this.getTrimControl((Control)searchSource.getParent());
    }
}

