/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.ChangeToPerspectiveMenu;
import org.eclipse.ui.internal.PinEditorAction;
import org.eclipse.ui.internal.ReopenEditorMenu;
import org.eclipse.ui.internal.ShowInMenu;
import org.eclipse.ui.internal.ShowViewMenu;
import org.eclipse.ui.internal.SwitchToWindowMenu;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.actions.PinEditorContributionItem;

public abstract class ContributionItemFactory {
    private final String contributionItemId;
    public static final ContributionItemFactory PIN_EDITOR = new ContributionItemFactory("pinEditor"){

        public IContributionItem create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            PinEditorAction action = new PinEditorAction(window);
            action.setId(this.getId());
            PinEditorContributionItem item = new PinEditorContributionItem(action, window);
            return item;
        }
    };
    public static final ContributionItemFactory OPEN_WINDOWS = new ContributionItemFactory("openWindows"){

        public IContributionItem create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            SwitchToWindowMenu item = new SwitchToWindowMenu(window, this.getId(), true);
            return item;
        }
    };
    public static final ContributionItemFactory VIEWS_SHORTLIST = new ContributionItemFactory("viewsShortlist"){

        public IContributionItem create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            ((WorkbenchWindow)window).addSubmenu(1);
            ShowViewMenu item = new ShowViewMenu(window, this.getId());
            return item;
        }
    };
    public static final ContributionItemFactory VIEWS_SHOW_IN = new ContributionItemFactory("viewsShowIn"){

        public IContributionItem create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            ShowInMenu item = new ShowInMenu(window, this.getId());
            return item;
        }
    };
    public static final ContributionItemFactory REOPEN_EDITORS = new ContributionItemFactory("reopenEditors"){

        public IContributionItem create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            ReopenEditorMenu item = new ReopenEditorMenu(window, this.getId(), true);
            return item;
        }
    };
    public static final ContributionItemFactory PERSPECTIVES_SHORTLIST = new ContributionItemFactory("perspectivesShortlist"){

        public IContributionItem create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            ((WorkbenchWindow)window).addSubmenu(2);
            ChangeToPerspectiveMenu item = new ChangeToPerspectiveMenu(window, this.getId());
            return item;
        }
    };

    protected ContributionItemFactory(String contributionItemId) {
        this.contributionItemId = contributionItemId;
    }

    public abstract IContributionItem create(IWorkbenchWindow var1);

    public String getId() {
        return this.contributionItemId;
    }
}

