/*
 * Copyright (c) 2011 Tobias Markmann
 * Licensed under the BSD license.
 * See http://www.opensource.org/licenses/bsd-license.php for more information.
 */

/*
 * Copyright (c) 2015 Isode Limited.
 * All rights reserved.
 * See the COPYING file for more information.
 */

#pragma once

#include <Swiften/Base/API.h>
#include <Swiften/Elements/DeliveryReceipt.h>
#include <Swiften/Parser/GenericPayloadParser.h>

namespace Swift {
	class SWIFTEN_API DeliveryReceiptParser : public GenericPayloadParser<DeliveryReceipt> {
		public:
			DeliveryReceiptParser();

			virtual void handleStartElement(const std::string& element, const std::string&, const AttributeMap& attributeMap);
			virtual void handleEndElement(const std::string& element, const std::string&);
			virtual void handleCharacterData(const std::string& data);

		private:
			int level_;
	};
}
