#ifdef __WINDOWS__
typedef int int32_t;
#else
#include <inttypes.h>
#endif

#ifndef NULL
#define NULL ((void*)0)
#endif

#define UNICODE_MAP_SIZE 128

static const int32_t ucp0x00[256] =
{ 0x000000, 0x000100, 0x000200, 0x000300, 0x000400, 0x000500, 0x000600, 0x000700,
  0x000800, 0x000900, 0x000a00, 0x000b00, 0x000c00, 0x000d00, 0x000e00, 0x000f00,
  0x001000, 0x001100, 0x001200, 0x001300, 0x001400, 0x001500, 0x001600, 0x001700,
  0x001800, 0x001900, 0x001a00, 0x001b00, 0x001c00, 0x001d00, 0x001e00, 0x001f00,
  0x002000, 0x002100, 0x002200, 0x002300, 0x002400, 0x002500, 0x002600, 0x002700,
  0x002800, 0x002900, 0x002a00, 0x002b00, 0x002c00, 0x002d00, 0x002e00, 0x002f00,
  0x003000, 0x003100, 0x003200, 0x003300, 0x003400, 0x003500, 0x003600, 0x003700,
  0x003800, 0x003900, 0x003a00, 0x003b00, 0x003c00, 0x003d00, 0x003e00, 0x003f00,
  0x004000, 0x004100, 0x004200, 0x004300, 0x004400, 0x004500, 0x004600, 0x004700,
  0x004800, 0x004900, 0x004a00, 0x004b00, 0x004c00, 0x004d00, 0x004e00, 0x004f00,
  0x005000, 0x005100, 0x005200, 0x005300, 0x005400, 0x005500, 0x005600, 0x005700,
  0x005800, 0x005900, 0x005a00, 0x005b00, 0x005c00, 0x005d00, 0x005e00, 0x005f00,
  0x006000, 0x004180, 0x004280, 0x004380, 0x004480, 0x004580, 0x004680, 0x004780,
  0x004880, 0x004980, 0x004a80, 0x004b80, 0x004c80, 0x004d80, 0x004e80, 0x004f80,
  0x005080, 0x005180, 0x005280, 0x005380, 0x005480, 0x005580, 0x005680, 0x005780,
  0x005880, 0x005980, 0x005a80, 0x007b00, 0x007c00, 0x007d00, 0x007e00, 0x007f00,
  0x008000, 0x008100, 0x008200, 0x008300, 0x008400, 0x008500, 0x008600, 0x008700,
  0x008800, 0x008900, 0x008a00, 0x008b00, 0x008c00, 0x008d00, 0x008e00, 0x008f00,
  0x009000, 0x009100, 0x009200, 0x009300, 0x009400, 0x009500, 0x009600, 0x009700,
  0x009800, 0x009900, 0x009a00, 0x009b00, 0x009c00, 0x009d00, 0x009e00, 0x009f00,
  0x002001, 0x00a100, 0x00a200, 0x00a300, 0x00a400, 0x00a500, 0x00a600, 0x00a700,
  0x00a800, 0x00a900, 0x006101, 0x00ab00, 0x00ac00, 0x00ad00, 0x00ae00, 0x00af00,
  0x00b000, 0x00b100, 0x003201, 0x003301, 0x00b400, 0x039c80, 0x00b600, 0x00b700,
  0x00b800, 0x003101, 0x006f01, 0x00bb00, 0x00bc00, 0x00bd00, 0x00be00, 0x00bf00,
  0x004103, 0x004104, 0x004105, 0x004106, 0x00410a, 0x00410c, 0x00c600, 0x004318,
  0x004503, 0x004504, 0x004505, 0x00450a, 0x004903, 0x004904, 0x004905, 0x00490a,
  0x00d000, 0x004e06, 0x004f03, 0x004f04, 0x004f05, 0x004f06, 0x004f0a, 0x00d700,
  0x00d800, 0x005503, 0x005504, 0x005505, 0x00550a, 0x005904, 0x00de00, 0x00df00,
  0x004183, 0x004184, 0x004185, 0x004186, 0x00418a, 0x00418c, 0x00c680, 0x004398,
  0x004583, 0x004584, 0x004585, 0x00458a, 0x004983, 0x004984, 0x004985, 0x00498a,
  0x00d080, 0x004e86, 0x004f83, 0x004f84, 0x004f85, 0x004f86, 0x004f8a, 0x00f700,
  0x00d880, 0x005583, 0x005584, 0x005585, 0x00558a, 0x005984, 0x00de80, 0x00598a
};

static const int32_t ucp0x01[256] =
{ 0x004107, 0x004187, 0x004108, 0x004188, 0x004119, 0x004199, 0x004304, 0x004384,
  0x004305, 0x004385, 0x004309, 0x004389, 0x00430e, 0x00438e, 0x00440e, 0x00448e,
  0x011000, 0x011080, 0x004507, 0x004587, 0x004508, 0x004588, 0x004509, 0x004589,
  0x004519, 0x004599, 0x00450e, 0x00458e, 0x004705, 0x004785, 0x004708, 0x004788,
  0x004709, 0x004789, 0x004718, 0x004798, 0x004805, 0x004885, 0x012600, 0x012680,
  0x004906, 0x004986, 0x004907, 0x004987, 0x004908, 0x004988, 0x004919, 0x004999,
  0x004909, 0x004980, 0x013200, 0x013280, 0x004a05, 0x004a85, 0x004b18, 0x004b98,
  0x013800, 0x004c04, 0x004c84, 0x004c18, 0x004c98, 0x004c0e, 0x004c8e, 0x013f00,
  0x013f80, 0x014100, 0x014180, 0x004e04, 0x004e84, 0x004e18, 0x004e98, 0x004e0e,
  0x004e8e, 0x014900, 0x014a00, 0x014a80, 0x004f07, 0x004f87, 0x004f08, 0x004f88,
  0x004f0d, 0x004f8d, 0x015200, 0x015280, 0x005204, 0x005284, 0x005218, 0x005298,
  0x00520e, 0x00528e, 0x005304, 0x005384, 0x005305, 0x005385, 0x005318, 0x005398,
  0x00530e, 0x00538e, 0x005418, 0x005498, 0x00540e, 0x00548e, 0x016600, 0x016680,
  0x005506, 0x005586, 0x005507, 0x005587, 0x005508, 0x005588, 0x00550c, 0x00558c,
  0x00550d, 0x00558d, 0x005519, 0x005599, 0x005705, 0x005785, 0x005905, 0x005985,
  0x00590a, 0x005a04, 0x005a84, 0x005a09, 0x005a89, 0x005a0e, 0x005a8e, 0x005380,
  0x018000, 0x018100, 0x018200, 0x018280, 0x018400, 0x018480, 0x018600, 0x018700,
  0x018780, 0x018900, 0x018a00, 0x018b00, 0x018b80, 0x018d00, 0x018e00, 0x018f00,
  0x019000, 0x019100, 0x019180, 0x019300, 0x019400, 0x01f680, 0x019600, 0x019700,
  0x019800, 0x019880, 0x023d80, 0x019b00, 0x019c00, 0x019d00, 0x022080, 0x019f00,
  0x004f13, 0x004f93, 0x01a200, 0x01a280, 0x01a400, 0x01a480, 0x01a600, 0x01a700,
  0x01a780, 0x01a900, 0x01aa00, 0x01ab00, 0x01ac00, 0x01ac80, 0x01ae00, 0x005513,
  0x005593, 0x01b100, 0x01b200, 0x01b300, 0x01b380, 0x01b500, 0x01b580, 0x01b700,
  0x01b800, 0x01b880, 0x01ba00, 0x01bb00, 0x01bc00, 0x01bc80, 0x01be00, 0x01f780,
  0x01c000, 0x01c100, 0x01c200, 0x01c300, 0x01c400, 0x01c480, 0x01c480, 0x01c700,
  0x01c780, 0x01c780, 0x01ca00, 0x01ca80, 0x01ca80, 0x00410e, 0x00418e, 0x00490e,
  0x00498e, 0x004f0e, 0x004f8e, 0x00550e, 0x00558e, 0x00dc07, 0x00dc87, 0x00dc04,
  0x00dc84, 0x00dc0e, 0x00dc8e, 0x00dc03, 0x00dc83, 0x018e80, 0x00c407, 0x00c487,
  0x022607, 0x022687, 0x00c607, 0x00c687, 0x01e400, 0x01e480, 0x00470e, 0x00478e,
  0x004b0e, 0x004b8e, 0x004f19, 0x004f99, 0x01ea07, 0x01ea87, 0x01b70e, 0x01b78e,
  0x006a0e, 0x01f100, 0x01f180, 0x01f180, 0x004704, 0x004784, 0x01f600, 0x01f700,
  0x004e03, 0x004e83, 0x00c504, 0x00c584, 0x00c604, 0x00c684, 0x00d804, 0x00d884
};

static const int32_t ucp0x02[256] =
{ 0x00410f, 0x00418f, 0x004110, 0x004190, 0x00450f, 0x00458f, 0x004510, 0x004590,
  0x00490f, 0x00498f, 0x004910, 0x004990, 0x004f0f, 0x004f8f, 0x004f10, 0x004f90,
  0x00520f, 0x00528f, 0x005210, 0x005290, 0x00550f, 0x00558f, 0x005510, 0x005590,
  0x005317, 0x005397, 0x005417, 0x005497, 0x021c00, 0x021c80, 0x00480e, 0x00488e,
  0x022000, 0x022100, 0x022200, 0x022280, 0x022400, 0x022480, 0x004109, 0x004189,
  0x004518, 0x004598, 0x00d607, 0x00d687, 0x00d507, 0x00d587, 0x004f09, 0x004f89,
  0x022e07, 0x022e87, 0x005907, 0x005987, 0x023400, 0x023500, 0x023600, 0x023700,
  0x023800, 0x023900, 0x023a00, 0x023b00, 0x023b80, 0x023d00, 0x023e00, 0x023f00,
  0x024000, 0x024100, 0x024200, 0x024300, 0x024400, 0x024500, 0x024600, 0x024700,
  0x024800, 0x024900, 0x024a00, 0x024b00, 0x024c00, 0x024d00, 0x024e00, 0x024f00,
  0x025000, 0x025100, 0x025200, 0x018180, 0x018680, 0x025500, 0x018980, 0x018a80,
  0x025800, 0x018f80, 0x025a00, 0x019080, 0x025c00, 0x025d00, 0x025e00, 0x025f00,
  0x019380, 0x026100, 0x026200, 0x019480, 0x026400, 0x026500, 0x026600, 0x026700,
  0x019780, 0x019680, 0x026a00, 0x026b00, 0x026c00, 0x026d00, 0x026e00, 0x019c80,
  0x027000, 0x027100, 0x019d80, 0x027300, 0x027400, 0x019f80, 0x027600, 0x027700,
  0x027800, 0x027900, 0x027a00, 0x027b00, 0x027c00, 0x027d00, 0x027e00, 0x027f00,
  0x01a680, 0x028100, 0x028200, 0x01a980, 0x028400, 0x028500, 0x028600, 0x028700,
  0x01ae80, 0x028900, 0x01b180, 0x01b280, 0x028c00, 0x028d00, 0x028e00, 0x028f00,
  0x029000, 0x029100, 0x01b780, 0x029300, 0x024180, 0x029500, 0x029600, 0x029700,
  0x029800, 0x029900, 0x029a00, 0x029b00, 0x029c00, 0x029d00, 0x029e00, 0x029f00,
  0x02a000, 0x02a100, 0x02a200, 0x02a300, 0x02a400, 0x02a500, 0x02a600, 0x02a700,
  0x02a800, 0x02a900, 0x02aa00, 0x02ab00, 0x02ac00, 0x02ad00, 0x02ae00, 0x02af00,
  0x006801, 0x026601, 0x006a01, 0x007201, 0x027901, 0x027b01, 0x028101, 0x007701,
  0x007901, 0x02b900, 0x02ba00, 0x02bb00, 0x02bc00, 0x02bd00, 0x02be00, 0x02bf00,
  0x02c000, 0x02c100, 0x02c200, 0x02c300, 0x02c400, 0x02c500, 0x02c600, 0x02c700,
  0x02c800, 0x02c900, 0x02ca00, 0x02cb00, 0x02cc00, 0x02cd00, 0x02ce00, 0x02cf00,
  0x02d000, 0x02d100, 0x02d200, 0x02d300, 0x02d400, 0x02d500, 0x02d600, 0x02d700,
  0x02d800, 0x02d900, 0x02da00, 0x02db00, 0x02dc00, 0x02dd00, 0x02de00, 0x02df00,
  0x026301, 0x006c01, 0x007301, 0x007801, 0x029501, 0x02e500, 0x02e600, 0x02e700,
  0x02e800, 0x02e900, 0x02ea00, 0x02eb00, 0x02ec00, 0x02ed00, 0x02ee00, 0x02ef00,
  0x02f000, 0x02f100, 0x02f200, 0x02f300, 0x02f400, 0x02f500, 0x02f600, 0x02f700,
  0x02f800, 0x02f900, 0x02fa00, 0x02fb00, 0x02fc00, 0x02fd00, 0x02fe00, 0x02ff00
};

static const int32_t ucp0x03[256] =
{ 0x030000, 0x030100, 0x030200, 0x030300, 0x030400, 0x030500, 0x030600, 0x030700,
  0x030800, 0x030900, 0x030a00, 0x030b00, 0x030c00, 0x030d00, 0x030e00, 0x030f00,
  0x031000, 0x031100, 0x031200, 0x031300, 0x031400, 0x031500, 0x031600, 0x031700,
  0x031800, 0x031900, 0x031a00, 0x031b00, 0x031c00, 0x031d00, 0x031e00, 0x031f00,
  0x032000, 0x032100, 0x032200, 0x032300, 0x032400, 0x032500, 0x032600, 0x032700,
  0x032800, 0x032900, 0x032a00, 0x032b00, 0x032c00, 0x032d00, 0x032e00, 0x032f00,
  0x033000, 0x033100, 0x033200, 0x033300, 0x033400, 0x033500, 0x033600, 0x033700,
  0x033800, 0x033900, 0x033a00, 0x033b00, 0x033c00, 0x033d00, 0x033e00, 0x033f00,
  0x030002, 0x030102, 0x034200, 0x031302, 0x030804, 0x039980, 0x034600, 0x034700,
  0x034800, 0x034900, 0x034a00, 0x034b00, 0x034c00, 0x034d00, 0x034e00, 0x034f00,
  0x035000, 0x035100, 0x035200, 0x035300, 0x035400, 0x035500, 0x035600, 0x035700,
  0x035800, 0x035900, 0x035a00, 0x035b00, 0x035c00, 0x035d00, 0x035e00, 0x035f00,
  0x036000, 0x036100, 0x036200, 0x036300, 0x036400, 0x036500, 0x036600, 0x036700,
  0x036800, 0x036900, 0x036a00, 0x036b00, 0x036c00, 0x036d00, 0x036e00, 0x036f00,
  0x037000, 0x037100, 0x037200, 0x037300, 0x02b902, 0x037500, 0x037600, 0x037700,
  0x037800, 0x037900, 0x037a00, 0x037b00, 0x037c00, 0x037d00, 0x003b02, 0x037f00,
  0x038000, 0x038100, 0x038200, 0x038300, 0x038400, 0x00a804, 0x039104, 0x00b702,
  0x039504, 0x039704, 0x039904, 0x038b00, 0x039f04, 0x038d00, 0x03a504, 0x03a904,
  0x03ca04, 0x039100, 0x039200, 0x039300, 0x039400, 0x039500, 0x039600, 0x039700,
  0x039800, 0x039900, 0x039a00, 0x039b00, 0x039c00, 0x039d00, 0x039e00, 0x039f00,
  0x03a000, 0x03a100, 0x03a200, 0x03a300, 0x03a400, 0x03a500, 0x03a600, 0x03a700,
  0x03a800, 0x03a900, 0x03990a, 0x03a50a, 0x039184, 0x039584, 0x039784, 0x039984,
  0x03cb04, 0x039180, 0x039280, 0x039380, 0x039480, 0x039580, 0x039680, 0x039780,
  0x039880, 0x039980, 0x039a80, 0x039b80, 0x039c80, 0x039d80, 0x039e80, 0x039f80,
  0x03a080, 0x03a180, 0x03a380, 0x03a380, 0x03a480, 0x03a580, 0x03a680, 0x03a780,
  0x03a880, 0x03a980, 0x03998a, 0x03a58a, 0x039f84, 0x03a584, 0x03a984, 0x03cf00,
  0x039280, 0x039880, 0x03d200, 0x03d204, 0x03d20a, 0x03a680, 0x03a080, 0x03d700,
  0x03d800, 0x03d880, 0x03da00, 0x03da80, 0x03dc00, 0x03dc80, 0x03de00, 0x03de80,
  0x03e000, 0x03e080, 0x03e200, 0x03e280, 0x03e400, 0x03e480, 0x03e600, 0x03e680,
  0x03e800, 0x03e880, 0x03ea00, 0x03ea80, 0x03ec00, 0x03ec80, 0x03ee00, 0x03ee80,
  0x039a80, 0x03a180, 0x03f980, 0x03f300, 0x03f400, 0x039580, 0x03f600, 0x03f700,
  0x03f780, 0x03f900, 0x03fa00, 0x03fa80, 0x03fc00, 0x03fd00, 0x03fe00, 0x03ff00
};

static const int32_t ucp0x04[256] =
{ 0x041503, 0x04150a, 0x040200, 0x041304, 0x040400, 0x040500, 0x040600, 0x04060a,
  0x040800, 0x040900, 0x040a00, 0x040b00, 0x041a04, 0x041803, 0x042308, 0x040f00,
  0x041000, 0x041100, 0x041200, 0x041300, 0x041400, 0x041500, 0x041600, 0x041700,
  0x041800, 0x041808, 0x041a00, 0x041b00, 0x041c00, 0x041d00, 0x041e00, 0x041f00,
  0x042000, 0x042100, 0x042200, 0x042300, 0x042400, 0x042500, 0x042600, 0x042700,
  0x042800, 0x042900, 0x042a00, 0x042b00, 0x042c00, 0x042d00, 0x042e00, 0x042f00,
  0x041080, 0x041180, 0x041280, 0x041380, 0x041480, 0x041580, 0x041680, 0x041780,
  0x041880, 0x041888, 0x041a80, 0x041b80, 0x041c80, 0x041d80, 0x041e80, 0x041f80,
  0x042080, 0x042180, 0x042280, 0x042380, 0x042480, 0x042580, 0x042680, 0x042780,
  0x042880, 0x042980, 0x042a80, 0x042b80, 0x042c80, 0x042d80, 0x042e80, 0x042f80,
  0x041583, 0x04158a, 0x040280, 0x041384, 0x040480, 0x040580, 0x040680, 0x04068a,
  0x040880, 0x040980, 0x040a80, 0x040b80, 0x041a84, 0x041883, 0x042388, 0x040f80,
  0x046000, 0x046080, 0x046200, 0x046280, 0x046400, 0x046480, 0x046600, 0x046680,
  0x046800, 0x046880, 0x046a00, 0x046a80, 0x046c00, 0x046c80, 0x046e00, 0x046e80,
  0x047000, 0x047080, 0x047200, 0x047280, 0x047400, 0x047480, 0x04740f, 0x04748f,
  0x047800, 0x047880, 0x047a00, 0x047a80, 0x047c00, 0x047c80, 0x047e00, 0x047e80,
  0x048000, 0x048080, 0x048200, 0x048300, 0x048400, 0x048500, 0x048600, 0x048700,
  0x048800, 0x048900, 0x048a00, 0x048a80, 0x048c00, 0x048c80, 0x048e00, 0x048e80,
  0x049000, 0x049080, 0x049200, 0x049280, 0x049400, 0x049480, 0x049600, 0x049680,
  0x049800, 0x049880, 0x049a00, 0x049a80, 0x049c00, 0x049c80, 0x049e00, 0x049e80,
  0x04a000, 0x04a080, 0x04a200, 0x04a280, 0x04a400, 0x04a480, 0x04a600, 0x04a680,
  0x04a800, 0x04a880, 0x04aa00, 0x04aa80, 0x04ac00, 0x04ac80, 0x04ae00, 0x04ae80,
  0x04b000, 0x04b080, 0x04b200, 0x04b280, 0x04b400, 0x04b480, 0x04b600, 0x04b680,
  0x04b800, 0x04b880, 0x04ba00, 0x04ba80, 0x04bc00, 0x04bc80, 0x04be00, 0x04be80,
  0x04c000, 0x041608, 0x041688, 0x04c300, 0x04c380, 0x04c500, 0x04c580, 0x04c700,
  0x04c780, 0x04c900, 0x04c980, 0x04cb00, 0x04cb80, 0x04cd00, 0x04cd80, 0x04cf00,
  0x041008, 0x041088, 0x04100a, 0x04108a, 0x04d400, 0x04d480, 0x041508, 0x041588,
  0x04d800, 0x04d880, 0x04d80a, 0x04d88a, 0x04160a, 0x04168a, 0x04170a, 0x04178a,
  0x04e000, 0x04e080, 0x041807, 0x041887, 0x04180a, 0x04188a, 0x041e0a, 0x041e8a,
  0x04e800, 0x04e880, 0x04e80a, 0x04e88a, 0x042d0a, 0x042d8a, 0x042307, 0x042387,
  0x04230a, 0x04238a, 0x04230d, 0x04238d, 0x04270a, 0x04278a, 0x04f600, 0x04f680,
  0x042b0a, 0x042b8a, 0x04fa00, 0x04fb00, 0x04fc00, 0x04fd00, 0x04fe00, 0x04ff00
};

static const int32_t ucp0x05[256] =
{ 0x050000, 0x050080, 0x050200, 0x050280, 0x050400, 0x050480, 0x050600, 0x050680,
  0x050800, 0x050880, 0x050a00, 0x050a80, 0x050c00, 0x050c80, 0x050e00, 0x050e80,
  0x051000, 0x051100, 0x051200, 0x051300, 0x051400, 0x051500, 0x051600, 0x051700,
  0x051800, 0x051900, 0x051a00, 0x051b00, 0x051c00, 0x051d00, 0x051e00, 0x051f00,
  0x052000, 0x052100, 0x052200, 0x052300, 0x052400, 0x052500, 0x052600, 0x052700,
  0x052800, 0x052900, 0x052a00, 0x052b00, 0x052c00, 0x052d00, 0x052e00, 0x052f00,
  0x053000, 0x053100, 0x053200, 0x053300, 0x053400, 0x053500, 0x053600, 0x053700,
  0x053800, 0x053900, 0x053a00, 0x053b00, 0x053c00, 0x053d00, 0x053e00, 0x053f00,
  0x054000, 0x054100, 0x054200, 0x054300, 0x054400, 0x054500, 0x054600, 0x054700,
  0x054800, 0x054900, 0x054a00, 0x054b00, 0x054c00, 0x054d00, 0x054e00, 0x054f00,
  0x055000, 0x055100, 0x055200, 0x055300, 0x055400, 0x055500, 0x055600, 0x055700,
  0x055800, 0x055900, 0x055a00, 0x055b00, 0x055c00, 0x055d00, 0x055e00, 0x055f00,
  0x056000, 0x053180, 0x053280, 0x053380, 0x053480, 0x053580, 0x053680, 0x053780,
  0x053880, 0x053980, 0x053a80, 0x053b80, 0x053c80, 0x053d80, 0x053e80, 0x053f80,
  0x054080, 0x054180, 0x054280, 0x054380, 0x054480, 0x054580, 0x054680, 0x054780,
  0x054880, 0x054980, 0x054a80, 0x054b80, 0x054c80, 0x054d80, 0x054e80, 0x054f80,
  0x055080, 0x055180, 0x055280, 0x055380, 0x055480, 0x055580, 0x055680, 0x058700,
  0x058800, 0x058900, 0x058a00, 0x058b00, 0x058c00, 0x058d00, 0x058e00, 0x058f00,
  0x059000, 0x059100, 0x059200, 0x059300, 0x059400, 0x059500, 0x059600, 0x059700,
  0x059800, 0x059900, 0x059a00, 0x059b00, 0x059c00, 0x059d00, 0x059e00, 0x059f00,
  0x05a000, 0x05a100, 0x05a200, 0x05a300, 0x05a400, 0x05a500, 0x05a600, 0x05a700,
  0x05a800, 0x05a900, 0x05aa00, 0x05ab00, 0x05ac00, 0x05ad00, 0x05ae00, 0x05af00,
  0x05b000, 0x05b100, 0x05b200, 0x05b300, 0x05b400, 0x05b500, 0x05b600, 0x05b700,
  0x05b800, 0x05b900, 0x05ba00, 0x05bb00, 0x05bc00, 0x05bd00, 0x05be00, 0x05bf00,
  0x05c000, 0x05c100, 0x05c200, 0x05c300, 0x05c400, 0x05c500, 0x05c600, 0x05c700,
  0x05c800, 0x05c900, 0x05ca00, 0x05cb00, 0x05cc00, 0x05cd00, 0x05ce00, 0x05cf00,
  0x05d000, 0x05d100, 0x05d200, 0x05d300, 0x05d400, 0x05d500, 0x05d600, 0x05d700,
  0x05d800, 0x05d900, 0x05da00, 0x05db00, 0x05dc00, 0x05dd00, 0x05de00, 0x05df00,
  0x05e000, 0x05e100, 0x05e200, 0x05e300, 0x05e400, 0x05e500, 0x05e600, 0x05e700,
  0x05e800, 0x05e900, 0x05ea00, 0x05eb00, 0x05ec00, 0x05ed00, 0x05ee00, 0x05ef00,
  0x05f000, 0x05f100, 0x05f200, 0x05f300, 0x05f400, 0x05f500, 0x05f600, 0x05f700,
  0x05f800, 0x05f900, 0x05fa00, 0x05fb00, 0x05fc00, 0x05fd00, 0x05fe00, 0x05ff00
};

static const int32_t ucp0x06[256] =
{ 0x060000, 0x060100, 0x060200, 0x060300, 0x060400, 0x060500, 0x060600, 0x060700,
  0x060800, 0x060900, 0x060a00, 0x060b00, 0x060c00, 0x060d00, 0x060e00, 0x060f00,
  0x061000, 0x061100, 0x061200, 0x061300, 0x061400, 0x061500, 0x061600, 0x061700,
  0x061800, 0x061900, 0x061a00, 0x061b00, 0x061c00, 0x061d00, 0x061e00, 0x061f00,
  0x062000, 0x062100, 0x062729, 0x06272a, 0x06482a, 0x06272b, 0x064a2a, 0x062700,
  0x062800, 0x062900, 0x062a00, 0x062b00, 0x062c00, 0x062d00, 0x062e00, 0x062f00,
  0x063000, 0x063100, 0x063200, 0x063300, 0x063400, 0x063500, 0x063600, 0x063700,
  0x063800, 0x063900, 0x063a00, 0x063b00, 0x063c00, 0x063d00, 0x063e00, 0x063f00,
  0x064000, 0x064100, 0x064200, 0x064300, 0x064400, 0x064500, 0x064600, 0x064700,
  0x064800, 0x064900, 0x064a00, 0x064b00, 0x064c00, 0x064d00, 0x064e00, 0x064f00,
  0x065000, 0x065100, 0x065200, 0x065300, 0x065400, 0x065500, 0x065600, 0x065700,
  0x065800, 0x065900, 0x065a00, 0x065b00, 0x065c00, 0x065d00, 0x065e00, 0x065f00,
  0x066000, 0x066100, 0x066200, 0x066300, 0x066400, 0x066500, 0x066600, 0x066700,
  0x066800, 0x066900, 0x066a00, 0x066b00, 0x066c00, 0x066d00, 0x066e00, 0x066f00,
  0x067000, 0x067100, 0x067200, 0x067300, 0x067400, 0x067500, 0x067600, 0x067700,
  0x067800, 0x067900, 0x067a00, 0x067b00, 0x067c00, 0x067d00, 0x067e00, 0x067f00,
  0x068000, 0x068100, 0x068200, 0x068300, 0x068400, 0x068500, 0x068600, 0x068700,
  0x068800, 0x068900, 0x068a00, 0x068b00, 0x068c00, 0x068d00, 0x068e00, 0x068f00,
  0x069000, 0x069100, 0x069200, 0x069300, 0x069400, 0x069500, 0x069600, 0x069700,
  0x069800, 0x069900, 0x069a00, 0x069b00, 0x069c00, 0x069d00, 0x069e00, 0x069f00,
  0x06a000, 0x06a100, 0x06a200, 0x06a300, 0x06a400, 0x06a500, 0x06a600, 0x06a700,
  0x06a800, 0x06a900, 0x06aa00, 0x06ab00, 0x06ac00, 0x06ad00, 0x06ae00, 0x06af00,
  0x06b000, 0x06b100, 0x06b200, 0x06b300, 0x06b400, 0x06b500, 0x06b600, 0x06b700,
  0x06b800, 0x06b900, 0x06ba00, 0x06bb00, 0x06bc00, 0x06bd00, 0x06be00, 0x06bf00,
  0x06d52a, 0x06c100, 0x06c12a, 0x06c300, 0x06c400, 0x06c500, 0x06c600, 0x06c700,
  0x06c800, 0x06c900, 0x06ca00, 0x06cb00, 0x06cc00, 0x06cd00, 0x06ce00, 0x06cf00,
  0x06d000, 0x06d100, 0x06d200, 0x06d22a, 0x06d400, 0x06d500, 0x06d600, 0x06d700,
  0x06d800, 0x06d900, 0x06da00, 0x06db00, 0x06dc00, 0x06dd00, 0x06de00, 0x06df00,
  0x06e000, 0x06e100, 0x06e200, 0x06e300, 0x06e400, 0x06e500, 0x06e600, 0x06e700,
  0x06e800, 0x06e900, 0x06ea00, 0x06eb00, 0x06ec00, 0x06ed00, 0x06ee00, 0x06ef00,
  0x06f000, 0x06f100, 0x06f200, 0x06f300, 0x06f400, 0x06f500, 0x06f600, 0x06f700,
  0x06f800, 0x06f900, 0x06fa00, 0x06fb00, 0x06fc00, 0x06fd00, 0x06fe00, 0x06ff00
};

static const int32_t ucp0x09[256] =
{ 0x090000, 0x090100, 0x090200, 0x090300, 0x090400, 0x090500, 0x090600, 0x090700,
  0x090800, 0x090900, 0x090a00, 0x090b00, 0x090c00, 0x090d00, 0x090e00, 0x090f00,
  0x091000, 0x091100, 0x091200, 0x091300, 0x091400, 0x091500, 0x091600, 0x091700,
  0x091800, 0x091900, 0x091a00, 0x091b00, 0x091c00, 0x091d00, 0x091e00, 0x091f00,
  0x092000, 0x092100, 0x092200, 0x092300, 0x092400, 0x092500, 0x092600, 0x092700,
  0x092800, 0x09282c, 0x092a00, 0x092b00, 0x092c00, 0x092d00, 0x092e00, 0x092f00,
  0x093000, 0x09302c, 0x093200, 0x093300, 0x09332c, 0x093500, 0x093600, 0x093700,
  0x093800, 0x093900, 0x093a00, 0x093b00, 0x093c00, 0x093d00, 0x093e00, 0x093f00,
  0x094000, 0x094100, 0x094200, 0x094300, 0x094400, 0x094500, 0x094600, 0x094700,
  0x094800, 0x094900, 0x094a00, 0x094b00, 0x094c00, 0x094d00, 0x094e00, 0x094f00,
  0x095000, 0x095100, 0x095200, 0x095300, 0x095400, 0x095500, 0x095600, 0x095700,
  0x09152c, 0x09162c, 0x09172c, 0x091c2c, 0x09212c, 0x09222c, 0x092b2c, 0x092f2c,
  0x096000, 0x096100, 0x096200, 0x096300, 0x096400, 0x096500, 0x096600, 0x096700,
  0x096800, 0x096900, 0x096a00, 0x096b00, 0x096c00, 0x096d00, 0x096e00, 0x096f00,
  0x097000, 0x097100, 0x097200, 0x097300, 0x097400, 0x097500, 0x097600, 0x097700,
  0x097800, 0x097900, 0x097a00, 0x097b00, 0x097c00, 0x097d00, 0x097e00, 0x097f00,
  0x098000, 0x098100, 0x098200, 0x098300, 0x098400, 0x098500, 0x098600, 0x098700,
  0x098800, 0x098900, 0x098a00, 0x098b00, 0x098c00, 0x098d00, 0x098e00, 0x098f00,
  0x099000, 0x099100, 0x099200, 0x099300, 0x099400, 0x099500, 0x099600, 0x099700,
  0x099800, 0x099900, 0x099a00, 0x099b00, 0x099c00, 0x099d00, 0x099e00, 0x099f00,
  0x09a000, 0x09a100, 0x09a200, 0x09a300, 0x09a400, 0x09a500, 0x09a600, 0x09a700,
  0x09a800, 0x09a900, 0x09aa00, 0x09ab00, 0x09ac00, 0x09ad00, 0x09ae00, 0x09af00,
  0x09b000, 0x09b100, 0x09b200, 0x09b300, 0x09b400, 0x09b500, 0x09b600, 0x09b700,
  0x09b800, 0x09b900, 0x09ba00, 0x09bb00, 0x09bc00, 0x09bd00, 0x09be00, 0x09bf00,
  0x09c000, 0x09c100, 0x09c200, 0x09c300, 0x09c400, 0x09c500, 0x09c600, 0x09c700,
  0x09c800, 0x09c900, 0x09ca00, 0x09cb00, 0x09cc00, 0x09cd00, 0x09ce00, 0x09cf00,
  0x09d000, 0x09d100, 0x09d200, 0x09d300, 0x09d400, 0x09d500, 0x09d600, 0x09d700,
  0x09d800, 0x09d900, 0x09da00, 0x09db00, 0x09a12d, 0x09a22d, 0x09de00, 0x09af2d,
  0x09e000, 0x09e100, 0x09e200, 0x09e300, 0x09e400, 0x09e500, 0x09e600, 0x09e700,
  0x09e800, 0x09e900, 0x09ea00, 0x09eb00, 0x09ec00, 0x09ed00, 0x09ee00, 0x09ef00,
  0x09f000, 0x09f100, 0x09f200, 0x09f300, 0x09f400, 0x09f500, 0x09f600, 0x09f700,
  0x09f800, 0x09f900, 0x09fa00, 0x09fb00, 0x09fc00, 0x09fd00, 0x09fe00, 0x09ff00
};

static const int32_t ucp0x0a[256] =
{ 0x0a0000, 0x0a0100, 0x0a0200, 0x0a0300, 0x0a0400, 0x0a0500, 0x0a0600, 0x0a0700,
  0x0a0800, 0x0a0900, 0x0a0a00, 0x0a0b00, 0x0a0c00, 0x0a0d00, 0x0a0e00, 0x0a0f00,
  0x0a1000, 0x0a1100, 0x0a1200, 0x0a1300, 0x0a1400, 0x0a1500, 0x0a1600, 0x0a1700,
  0x0a1800, 0x0a1900, 0x0a1a00, 0x0a1b00, 0x0a1c00, 0x0a1d00, 0x0a1e00, 0x0a1f00,
  0x0a2000, 0x0a2100, 0x0a2200, 0x0a2300, 0x0a2400, 0x0a2500, 0x0a2600, 0x0a2700,
  0x0a2800, 0x0a2900, 0x0a2a00, 0x0a2b00, 0x0a2c00, 0x0a2d00, 0x0a2e00, 0x0a2f00,
  0x0a3000, 0x0a3100, 0x0a3200, 0x0a322e, 0x0a3400, 0x0a3500, 0x0a382e, 0x0a3700,
  0x0a3800, 0x0a3900, 0x0a3a00, 0x0a3b00, 0x0a3c00, 0x0a3d00, 0x0a3e00, 0x0a3f00,
  0x0a4000, 0x0a4100, 0x0a4200, 0x0a4300, 0x0a4400, 0x0a4500, 0x0a4600, 0x0a4700,
  0x0a4800, 0x0a4900, 0x0a4a00, 0x0a4b00, 0x0a4c00, 0x0a4d00, 0x0a4e00, 0x0a4f00,
  0x0a5000, 0x0a5100, 0x0a5200, 0x0a5300, 0x0a5400, 0x0a5500, 0x0a5600, 0x0a5700,
  0x0a5800, 0x0a162e, 0x0a172e, 0x0a1c2e, 0x0a5c00, 0x0a5d00, 0x0a2b2e, 0x0a5f00,
  0x0a6000, 0x0a6100, 0x0a6200, 0x0a6300, 0x0a6400, 0x0a6500, 0x0a6600, 0x0a6700,
  0x0a6800, 0x0a6900, 0x0a6a00, 0x0a6b00, 0x0a6c00, 0x0a6d00, 0x0a6e00, 0x0a6f00,
  0x0a7000, 0x0a7100, 0x0a7200, 0x0a7300, 0x0a7400, 0x0a7500, 0x0a7600, 0x0a7700,
  0x0a7800, 0x0a7900, 0x0a7a00, 0x0a7b00, 0x0a7c00, 0x0a7d00, 0x0a7e00, 0x0a7f00,
  0x0a8000, 0x0a8100, 0x0a8200, 0x0a8300, 0x0a8400, 0x0a8500, 0x0a8600, 0x0a8700,
  0x0a8800, 0x0a8900, 0x0a8a00, 0x0a8b00, 0x0a8c00, 0x0a8d00, 0x0a8e00, 0x0a8f00,
  0x0a9000, 0x0a9100, 0x0a9200, 0x0a9300, 0x0a9400, 0x0a9500, 0x0a9600, 0x0a9700,
  0x0a9800, 0x0a9900, 0x0a9a00, 0x0a9b00, 0x0a9c00, 0x0a9d00, 0x0a9e00, 0x0a9f00,
  0x0aa000, 0x0aa100, 0x0aa200, 0x0aa300, 0x0aa400, 0x0aa500, 0x0aa600, 0x0aa700,
  0x0aa800, 0x0aa900, 0x0aaa00, 0x0aab00, 0x0aac00, 0x0aad00, 0x0aae00, 0x0aaf00,
  0x0ab000, 0x0ab100, 0x0ab200, 0x0ab300, 0x0ab400, 0x0ab500, 0x0ab600, 0x0ab700,
  0x0ab800, 0x0ab900, 0x0aba00, 0x0abb00, 0x0abc00, 0x0abd00, 0x0abe00, 0x0abf00,
  0x0ac000, 0x0ac100, 0x0ac200, 0x0ac300, 0x0ac400, 0x0ac500, 0x0ac600, 0x0ac700,
  0x0ac800, 0x0ac900, 0x0aca00, 0x0acb00, 0x0acc00, 0x0acd00, 0x0ace00, 0x0acf00,
  0x0ad000, 0x0ad100, 0x0ad200, 0x0ad300, 0x0ad400, 0x0ad500, 0x0ad600, 0x0ad700,
  0x0ad800, 0x0ad900, 0x0ada00, 0x0adb00, 0x0adc00, 0x0add00, 0x0ade00, 0x0adf00,
  0x0ae000, 0x0ae100, 0x0ae200, 0x0ae300, 0x0ae400, 0x0ae500, 0x0ae600, 0x0ae700,
  0x0ae800, 0x0ae900, 0x0aea00, 0x0aeb00, 0x0aec00, 0x0aed00, 0x0aee00, 0x0aef00,
  0x0af000, 0x0af100, 0x0af200, 0x0af300, 0x0af400, 0x0af500, 0x0af600, 0x0af700,
  0x0af800, 0x0af900, 0x0afa00, 0x0afb00, 0x0afc00, 0x0afd00, 0x0afe00, 0x0aff00
};

static const int32_t ucp0x0b[256] =
{ 0x0b0000, 0x0b0100, 0x0b0200, 0x0b0300, 0x0b0400, 0x0b0500, 0x0b0600, 0x0b0700,
  0x0b0800, 0x0b0900, 0x0b0a00, 0x0b0b00, 0x0b0c00, 0x0b0d00, 0x0b0e00, 0x0b0f00,
  0x0b1000, 0x0b1100, 0x0b1200, 0x0b1300, 0x0b1400, 0x0b1500, 0x0b1600, 0x0b1700,
  0x0b1800, 0x0b1900, 0x0b1a00, 0x0b1b00, 0x0b1c00, 0x0b1d00, 0x0b1e00, 0x0b1f00,
  0x0b2000, 0x0b2100, 0x0b2200, 0x0b2300, 0x0b2400, 0x0b2500, 0x0b2600, 0x0b2700,
  0x0b2800, 0x0b2900, 0x0b2a00, 0x0b2b00, 0x0b2c00, 0x0b2d00, 0x0b2e00, 0x0b2f00,
  0x0b3000, 0x0b3100, 0x0b3200, 0x0b3300, 0x0b3400, 0x0b3500, 0x0b3600, 0x0b3700,
  0x0b3800, 0x0b3900, 0x0b3a00, 0x0b3b00, 0x0b3c00, 0x0b3d00, 0x0b3e00, 0x0b3f00,
  0x0b4000, 0x0b4100, 0x0b4200, 0x0b4300, 0x0b4400, 0x0b4500, 0x0b4600, 0x0b4700,
  0x0b4800, 0x0b4900, 0x0b4a00, 0x0b4b00, 0x0b4c00, 0x0b4d00, 0x0b4e00, 0x0b4f00,
  0x0b5000, 0x0b5100, 0x0b5200, 0x0b5300, 0x0b5400, 0x0b5500, 0x0b5600, 0x0b5700,
  0x0b5800, 0x0b5900, 0x0b5a00, 0x0b5b00, 0x0b212f, 0x0b222f, 0x0b5e00, 0x0b5f00,
  0x0b6000, 0x0b6100, 0x0b6200, 0x0b6300, 0x0b6400, 0x0b6500, 0x0b6600, 0x0b6700,
  0x0b6800, 0x0b6900, 0x0b6a00, 0x0b6b00, 0x0b6c00, 0x0b6d00, 0x0b6e00, 0x0b6f00,
  0x0b7000, 0x0b7100, 0x0b7200, 0x0b7300, 0x0b7400, 0x0b7500, 0x0b7600, 0x0b7700,
  0x0b7800, 0x0b7900, 0x0b7a00, 0x0b7b00, 0x0b7c00, 0x0b7d00, 0x0b7e00, 0x0b7f00,
  0x0b8000, 0x0b8100, 0x0b8200, 0x0b8300, 0x0b8400, 0x0b8500, 0x0b8600, 0x0b8700,
  0x0b8800, 0x0b8900, 0x0b8a00, 0x0b8b00, 0x0b8c00, 0x0b8d00, 0x0b8e00, 0x0b8f00,
  0x0b9000, 0x0b9100, 0x0b9200, 0x0b9300, 0x0b9400, 0x0b9500, 0x0b9600, 0x0b9700,
  0x0b9800, 0x0b9900, 0x0b9a00, 0x0b9b00, 0x0b9c00, 0x0b9d00, 0x0b9e00, 0x0b9f00,
  0x0ba000, 0x0ba100, 0x0ba200, 0x0ba300, 0x0ba400, 0x0ba500, 0x0ba600, 0x0ba700,
  0x0ba800, 0x0ba900, 0x0baa00, 0x0bab00, 0x0bac00, 0x0bad00, 0x0bae00, 0x0baf00,
  0x0bb000, 0x0bb100, 0x0bb200, 0x0bb300, 0x0bb400, 0x0bb500, 0x0bb600, 0x0bb700,
  0x0bb800, 0x0bb900, 0x0bba00, 0x0bbb00, 0x0bbc00, 0x0bbd00, 0x0bbe00, 0x0bbf00,
  0x0bc000, 0x0bc100, 0x0bc200, 0x0bc300, 0x0bc400, 0x0bc500, 0x0bc600, 0x0bc700,
  0x0bc800, 0x0bc900, 0x0bca00, 0x0bcb00, 0x0bcc00, 0x0bcd00, 0x0bce00, 0x0bcf00,
  0x0bd000, 0x0bd100, 0x0bd200, 0x0bd300, 0x0bd400, 0x0bd500, 0x0bd600, 0x0bd700,
  0x0bd800, 0x0bd900, 0x0bda00, 0x0bdb00, 0x0bdc00, 0x0bdd00, 0x0bde00, 0x0bdf00,
  0x0be000, 0x0be100, 0x0be200, 0x0be300, 0x0be400, 0x0be500, 0x0be600, 0x0be700,
  0x0be800, 0x0be900, 0x0bea00, 0x0beb00, 0x0bec00, 0x0bed00, 0x0bee00, 0x0bef00,
  0x0bf000, 0x0bf100, 0x0bf200, 0x0bf300, 0x0bf400, 0x0bf500, 0x0bf600, 0x0bf700,
  0x0bf800, 0x0bf900, 0x0bfa00, 0x0bfb00, 0x0bfc00, 0x0bfd00, 0x0bfe00, 0x0bff00
};

static const int32_t ucp0x0c[256] =
{ 0x0c0000, 0x0c0100, 0x0c0200, 0x0c0300, 0x0c0400, 0x0c0500, 0x0c0600, 0x0c0700,
  0x0c0800, 0x0c0900, 0x0c0a00, 0x0c0b00, 0x0c0c00, 0x0c0d00, 0x0c0e00, 0x0c0f00,
  0x0c1000, 0x0c1100, 0x0c1200, 0x0c1300, 0x0c1400, 0x0c1500, 0x0c1600, 0x0c1700,
  0x0c1800, 0x0c1900, 0x0c1a00, 0x0c1b00, 0x0c1c00, 0x0c1d00, 0x0c1e00, 0x0c1f00,
  0x0c2000, 0x0c2100, 0x0c2200, 0x0c2300, 0x0c2400, 0x0c2500, 0x0c2600, 0x0c2700,
  0x0c2800, 0x0c2900, 0x0c2a00, 0x0c2b00, 0x0c2c00, 0x0c2d00, 0x0c2e00, 0x0c2f00,
  0x0c3000, 0x0c3100, 0x0c3200, 0x0c3300, 0x0c3400, 0x0c3500, 0x0c3600, 0x0c3700,
  0x0c3800, 0x0c3900, 0x0c3a00, 0x0c3b00, 0x0c3c00, 0x0c3d00, 0x0c3e00, 0x0c3f00,
  0x0c4000, 0x0c4100, 0x0c4200, 0x0c4300, 0x0c4400, 0x0c4500, 0x0c4600, 0x0c4700,
  0x0c4630, 0x0c4900, 0x0c4a00, 0x0c4b00, 0x0c4c00, 0x0c4d00, 0x0c4e00, 0x0c4f00,
  0x0c5000, 0x0c5100, 0x0c5200, 0x0c5300, 0x0c5400, 0x0c5500, 0x0c5600, 0x0c5700,
  0x0c5800, 0x0c5900, 0x0c5a00, 0x0c5b00, 0x0c5c00, 0x0c5d00, 0x0c5e00, 0x0c5f00,
  0x0c6000, 0x0c6100, 0x0c6200, 0x0c6300, 0x0c6400, 0x0c6500, 0x0c6600, 0x0c6700,
  0x0c6800, 0x0c6900, 0x0c6a00, 0x0c6b00, 0x0c6c00, 0x0c6d00, 0x0c6e00, 0x0c6f00,
  0x0c7000, 0x0c7100, 0x0c7200, 0x0c7300, 0x0c7400, 0x0c7500, 0x0c7600, 0x0c7700,
  0x0c7800, 0x0c7900, 0x0c7a00, 0x0c7b00, 0x0c7c00, 0x0c7d00, 0x0c7e00, 0x0c7f00,
  0x0c8000, 0x0c8100, 0x0c8200, 0x0c8300, 0x0c8400, 0x0c8500, 0x0c8600, 0x0c8700,
  0x0c8800, 0x0c8900, 0x0c8a00, 0x0c8b00, 0x0c8c00, 0x0c8d00, 0x0c8e00, 0x0c8f00,
  0x0c9000, 0x0c9100, 0x0c9200, 0x0c9300, 0x0c9400, 0x0c9500, 0x0c9600, 0x0c9700,
  0x0c9800, 0x0c9900, 0x0c9a00, 0x0c9b00, 0x0c9c00, 0x0c9d00, 0x0c9e00, 0x0c9f00,
  0x0ca000, 0x0ca100, 0x0ca200, 0x0ca300, 0x0ca400, 0x0ca500, 0x0ca600, 0x0ca700,
  0x0ca800, 0x0ca900, 0x0caa00, 0x0cab00, 0x0cac00, 0x0cad00, 0x0cae00, 0x0caf00,
  0x0cb000, 0x0cb100, 0x0cb200, 0x0cb300, 0x0cb400, 0x0cb500, 0x0cb600, 0x0cb700,
  0x0cb800, 0x0cb900, 0x0cba00, 0x0cbb00, 0x0cbc00, 0x0cbd00, 0x0cbe00, 0x0cbf00,
  0x0cc000, 0x0cc100, 0x0cc200, 0x0cc300, 0x0cc400, 0x0cc500, 0x0cc600, 0x0cc700,
  0x0cc800, 0x0cc900, 0x0cca00, 0x0ccb00, 0x0ccc00, 0x0ccd00, 0x0cce00, 0x0ccf00,
  0x0cd000, 0x0cd100, 0x0cd200, 0x0cd300, 0x0cd400, 0x0cd500, 0x0cd600, 0x0cd700,
  0x0cd800, 0x0cd900, 0x0cda00, 0x0cdb00, 0x0cdc00, 0x0cdd00, 0x0cde00, 0x0cdf00,
  0x0ce000, 0x0ce100, 0x0ce200, 0x0ce300, 0x0ce400, 0x0ce500, 0x0ce600, 0x0ce700,
  0x0ce800, 0x0ce900, 0x0cea00, 0x0ceb00, 0x0cec00, 0x0ced00, 0x0cee00, 0x0cef00,
  0x0cf000, 0x0cf100, 0x0cf200, 0x0cf300, 0x0cf400, 0x0cf500, 0x0cf600, 0x0cf700,
  0x0cf800, 0x0cf900, 0x0cfa00, 0x0cfb00, 0x0cfc00, 0x0cfd00, 0x0cfe00, 0x0cff00
};

static const int32_t ucp0x0d[256] =
{ 0x0d0000, 0x0d0100, 0x0d0200, 0x0d0300, 0x0d0400, 0x0d0500, 0x0d0600, 0x0d0700,
  0x0d0800, 0x0d0900, 0x0d0a00, 0x0d0b00, 0x0d0c00, 0x0d0d00, 0x0d0e00, 0x0d0f00,
  0x0d1000, 0x0d1100, 0x0d1200, 0x0d1300, 0x0d1400, 0x0d1500, 0x0d1600, 0x0d1700,
  0x0d1800, 0x0d1900, 0x0d1a00, 0x0d1b00, 0x0d1c00, 0x0d1d00, 0x0d1e00, 0x0d1f00,
  0x0d2000, 0x0d2100, 0x0d2200, 0x0d2300, 0x0d2400, 0x0d2500, 0x0d2600, 0x0d2700,
  0x0d2800, 0x0d2900, 0x0d2a00, 0x0d2b00, 0x0d2c00, 0x0d2d00, 0x0d2e00, 0x0d2f00,
  0x0d3000, 0x0d3100, 0x0d3200, 0x0d3300, 0x0d3400, 0x0d3500, 0x0d3600, 0x0d3700,
  0x0d3800, 0x0d3900, 0x0d3a00, 0x0d3b00, 0x0d3c00, 0x0d3d00, 0x0d3e00, 0x0d3f00,
  0x0d4000, 0x0d4100, 0x0d4200, 0x0d4300, 0x0d4400, 0x0d4500, 0x0d4600, 0x0d4700,
  0x0d4800, 0x0d4900, 0x0d4a00, 0x0d4b00, 0x0d4c00, 0x0d4d00, 0x0d4e00, 0x0d4f00,
  0x0d5000, 0x0d5100, 0x0d5200, 0x0d5300, 0x0d5400, 0x0d5500, 0x0d5600, 0x0d5700,
  0x0d5800, 0x0d5900, 0x0d5a00, 0x0d5b00, 0x0d5c00, 0x0d5d00, 0x0d5e00, 0x0d5f00,
  0x0d6000, 0x0d6100, 0x0d6200, 0x0d6300, 0x0d6400, 0x0d6500, 0x0d6600, 0x0d6700,
  0x0d6800, 0x0d6900, 0x0d6a00, 0x0d6b00, 0x0d6c00, 0x0d6d00, 0x0d6e00, 0x0d6f00,
  0x0d7000, 0x0d7100, 0x0d7200, 0x0d7300, 0x0d7400, 0x0d7500, 0x0d7600, 0x0d7700,
  0x0d7800, 0x0d7900, 0x0d7a00, 0x0d7b00, 0x0d7c00, 0x0d7d00, 0x0d7e00, 0x0d7f00,
  0x0d8000, 0x0d8100, 0x0d8200, 0x0d8300, 0x0d8400, 0x0d8500, 0x0d8600, 0x0d8700,
  0x0d8800, 0x0d8900, 0x0d8a00, 0x0d8b00, 0x0d8c00, 0x0d8d00, 0x0d8e00, 0x0d8f00,
  0x0d9000, 0x0d9100, 0x0d9200, 0x0d9300, 0x0d9400, 0x0d9500, 0x0d9600, 0x0d9700,
  0x0d9800, 0x0d9900, 0x0d9a00, 0x0d9b00, 0x0d9c00, 0x0d9d00, 0x0d9e00, 0x0d9f00,
  0x0da000, 0x0da100, 0x0da200, 0x0da300, 0x0da400, 0x0da500, 0x0da600, 0x0da700,
  0x0da800, 0x0da900, 0x0daa00, 0x0dab00, 0x0dac00, 0x0dad00, 0x0dae00, 0x0daf00,
  0x0db000, 0x0db100, 0x0db200, 0x0db300, 0x0db400, 0x0db500, 0x0db600, 0x0db700,
  0x0db800, 0x0db900, 0x0dba00, 0x0dbb00, 0x0dbc00, 0x0dbd00, 0x0dbe00, 0x0dbf00,
  0x0dc000, 0x0dc100, 0x0dc200, 0x0dc300, 0x0dc400, 0x0dc500, 0x0dc600, 0x0dc700,
  0x0dc800, 0x0dc900, 0x0dca00, 0x0dcb00, 0x0dcc00, 0x0dcd00, 0x0dce00, 0x0dcf00,
  0x0dd000, 0x0dd100, 0x0dd200, 0x0dd300, 0x0dd400, 0x0dd500, 0x0dd600, 0x0dd700,
  0x0dd800, 0x0dd900, 0x0dd931, 0x0ddb00, 0x0ddc00, 0x0ddc31, 0x0dde00, 0x0ddf00,
  0x0de000, 0x0de100, 0x0de200, 0x0de300, 0x0de400, 0x0de500, 0x0de600, 0x0de700,
  0x0de800, 0x0de900, 0x0dea00, 0x0deb00, 0x0dec00, 0x0ded00, 0x0dee00, 0x0def00,
  0x0df000, 0x0df100, 0x0df200, 0x0df300, 0x0df400, 0x0df500, 0x0df600, 0x0df700,
  0x0df800, 0x0df900, 0x0dfa00, 0x0dfb00, 0x0dfc00, 0x0dfd00, 0x0dfe00, 0x0dff00
};

static const int32_t ucp0x0f[256] =
{ 0x0f0000, 0x0f0100, 0x0f0200, 0x0f0300, 0x0f0400, 0x0f0500, 0x0f0600, 0x0f0700,
  0x0f0800, 0x0f0900, 0x0f0a00, 0x0f0b00, 0x0f0b01, 0x0f0d00, 0x0f0e00, 0x0f0f00,
  0x0f1000, 0x0f1100, 0x0f1200, 0x0f1300, 0x0f1400, 0x0f1500, 0x0f1600, 0x0f1700,
  0x0f1800, 0x0f1900, 0x0f1a00, 0x0f1b00, 0x0f1c00, 0x0f1d00, 0x0f1e00, 0x0f1f00,
  0x0f2000, 0x0f2100, 0x0f2200, 0x0f2300, 0x0f2400, 0x0f2500, 0x0f2600, 0x0f2700,
  0x0f2800, 0x0f2900, 0x0f2a00, 0x0f2b00, 0x0f2c00, 0x0f2d00, 0x0f2e00, 0x0f2f00,
  0x0f3000, 0x0f3100, 0x0f3200, 0x0f3300, 0x0f3400, 0x0f3500, 0x0f3600, 0x0f3700,
  0x0f3800, 0x0f3900, 0x0f3a00, 0x0f3b00, 0x0f3c00, 0x0f3d00, 0x0f3e00, 0x0f3f00,
  0x0f4000, 0x0f4100, 0x0f4200, 0x0f4300, 0x0f4400, 0x0f4500, 0x0f4600, 0x0f4700,
  0x0f4800, 0x0f4900, 0x0f4a00, 0x0f4b00, 0x0f4c00, 0x0f4d00, 0x0f4e00, 0x0f4f00,
  0x0f5000, 0x0f5100, 0x0f5200, 0x0f5300, 0x0f5400, 0x0f5500, 0x0f5600, 0x0f5700,
  0x0f5800, 0x0f5900, 0x0f5a00, 0x0f5b00, 0x0f5c00, 0x0f5d00, 0x0f5e00, 0x0f5f00,
  0x0f6000, 0x0f6100, 0x0f6200, 0x0f6300, 0x0f6400, 0x0f6500, 0x0f6600, 0x0f6700,
  0x0f6800, 0x0f6900, 0x0f6a00, 0x0f6b00, 0x0f6c00, 0x0f6d00, 0x0f6e00, 0x0f6f00,
  0x0f7000, 0x0f7100, 0x0f7200, 0x0f7132, 0x0f7400, 0x0f7133, 0x0fb234, 0x0f7700,
  0x0fb334, 0x0f7900, 0x0f7a00, 0x0f7b00, 0x0f7c00, 0x0f7d00, 0x0f7e00, 0x0f7f00,
  0x0f8000, 0x0f7134, 0x0f8200, 0x0f8300, 0x0f8400, 0x0f8500, 0x0f8600, 0x0f8700,
  0x0f8800, 0x0f8900, 0x0f8a00, 0x0f8b00, 0x0f8c00, 0x0f8d00, 0x0f8e00, 0x0f8f00,
  0x0f9000, 0x0f9100, 0x0f9200, 0x0f9300, 0x0f9400, 0x0f9500, 0x0f9600, 0x0f9700,
  0x0f9800, 0x0f9900, 0x0f9a00, 0x0f9b00, 0x0f9c00, 0x0f9d00, 0x0f9e00, 0x0f9f00,
  0x0fa000, 0x0fa100, 0x0fa200, 0x0fa300, 0x0fa400, 0x0fa500, 0x0fa600, 0x0fa700,
  0x0fa800, 0x0fa900, 0x0faa00, 0x0fab00, 0x0fac00, 0x0fad00, 0x0fae00, 0x0faf00,
  0x0fb000, 0x0fb100, 0x0fb200, 0x0fb300, 0x0fb400, 0x0fb500, 0x0fb600, 0x0fb700,
  0x0fb800, 0x0fb900, 0x0fba00, 0x0fbb00, 0x0fbc00, 0x0fbd00, 0x0fbe00, 0x0fbf00,
  0x0fc000, 0x0fc100, 0x0fc200, 0x0fc300, 0x0fc400, 0x0fc500, 0x0fc600, 0x0fc700,
  0x0fc800, 0x0fc900, 0x0fca00, 0x0fcb00, 0x0fcc00, 0x0fcd00, 0x0fce00, 0x0fcf00,
  0x0fd000, 0x0fd100, 0x0fd200, 0x0fd300, 0x0fd400, 0x0fd500, 0x0fd600, 0x0fd700,
  0x0fd800, 0x0fd900, 0x0fda00, 0x0fdb00, 0x0fdc00, 0x0fdd00, 0x0fde00, 0x0fdf00,
  0x0fe000, 0x0fe100, 0x0fe200, 0x0fe300, 0x0fe400, 0x0fe500, 0x0fe600, 0x0fe700,
  0x0fe800, 0x0fe900, 0x0fea00, 0x0feb00, 0x0fec00, 0x0fed00, 0x0fee00, 0x0fef00,
  0x0ff000, 0x0ff100, 0x0ff200, 0x0ff300, 0x0ff400, 0x0ff500, 0x0ff600, 0x0ff700,
  0x0ff800, 0x0ff900, 0x0ffa00, 0x0ffb00, 0x0ffc00, 0x0ffd00, 0x0ffe00, 0x0fff00
};

static const int32_t ucp0x10[256] =
{ 0x100000, 0x100100, 0x100200, 0x100300, 0x100400, 0x100500, 0x100600, 0x100700,
  0x100800, 0x100900, 0x100a00, 0x100b00, 0x100c00, 0x100d00, 0x100e00, 0x100f00,
  0x101000, 0x101100, 0x101200, 0x101300, 0x101400, 0x101500, 0x101600, 0x101700,
  0x101800, 0x101900, 0x101a00, 0x101b00, 0x101c00, 0x101d00, 0x101e00, 0x101f00,
  0x102000, 0x102100, 0x102200, 0x102300, 0x102400, 0x102500, 0x102600, 0x102700,
  0x102800, 0x102900, 0x102a00, 0x102b00, 0x102c00, 0x102d00, 0x102e00, 0x102f00,
  0x103000, 0x103100, 0x103200, 0x103300, 0x103400, 0x103500, 0x103600, 0x103700,
  0x103800, 0x103900, 0x103a00, 0x103b00, 0x103c00, 0x103d00, 0x103e00, 0x103f00,
  0x104000, 0x104100, 0x104200, 0x104300, 0x104400, 0x104500, 0x104600, 0x104700,
  0x104800, 0x104900, 0x104a00, 0x104b00, 0x104c00, 0x104d00, 0x104e00, 0x104f00,
  0x105000, 0x105100, 0x105200, 0x105300, 0x105400, 0x105500, 0x105600, 0x105700,
  0x105800, 0x105900, 0x105a00, 0x105b00, 0x105c00, 0x105d00, 0x105e00, 0x105f00,
  0x106000, 0x106100, 0x106200, 0x106300, 0x106400, 0x106500, 0x106600, 0x106700,
  0x106800, 0x106900, 0x106a00, 0x106b00, 0x106c00, 0x106d00, 0x106e00, 0x106f00,
  0x107000, 0x107100, 0x107200, 0x107300, 0x107400, 0x107500, 0x107600, 0x107700,
  0x107800, 0x107900, 0x107a00, 0x107b00, 0x107c00, 0x107d00, 0x107e00, 0x107f00,
  0x108000, 0x108100, 0x108200, 0x108300, 0x108400, 0x108500, 0x108600, 0x108700,
  0x108800, 0x108900, 0x108a00, 0x108b00, 0x108c00, 0x108d00, 0x108e00, 0x108f00,
  0x109000, 0x109100, 0x109200, 0x109300, 0x109400, 0x109500, 0x109600, 0x109700,
  0x109800, 0x109900, 0x109a00, 0x109b00, 0x109c00, 0x109d00, 0x109e00, 0x109f00,
  0x10a000, 0x10a100, 0x10a200, 0x10a300, 0x10a400, 0x10a500, 0x10a600, 0x10a700,
  0x10a800, 0x10a900, 0x10aa00, 0x10ab00, 0x10ac00, 0x10ad00, 0x10ae00, 0x10af00,
  0x10b000, 0x10b100, 0x10b200, 0x10b300, 0x10b400, 0x10b500, 0x10b600, 0x10b700,
  0x10b800, 0x10b900, 0x10ba00, 0x10bb00, 0x10bc00, 0x10bd00, 0x10be00, 0x10bf00,
  0x10c000, 0x10c100, 0x10c200, 0x10c300, 0x10c400, 0x10c500, 0x10c600, 0x10c700,
  0x10c800, 0x10c900, 0x10ca00, 0x10cb00, 0x10cc00, 0x10cd00, 0x10ce00, 0x10cf00,
  0x10d000, 0x10d100, 0x10d200, 0x10d300, 0x10d400, 0x10d500, 0x10d600, 0x10d700,
  0x10d800, 0x10d900, 0x10da00, 0x10db00, 0x10dc00, 0x10dd00, 0x10de00, 0x10df00,
  0x10e000, 0x10e100, 0x10e200, 0x10e300, 0x10e400, 0x10e500, 0x10e600, 0x10e700,
  0x10e800, 0x10e900, 0x10ea00, 0x10eb00, 0x10ec00, 0x10ed00, 0x10ee00, 0x10ef00,
  0x10f000, 0x10f100, 0x10f200, 0x10f300, 0x10f400, 0x10f500, 0x10f600, 0x10f700,
  0x10f800, 0x10f900, 0x10fa00, 0x10fb00, 0x10dc01, 0x10fd00, 0x10fe00, 0x10ff00
};

static const int32_t ucp0x1d[256] =
{ 0x1d0000, 0x1d0100, 0x1d0200, 0x1d0300, 0x1d0400, 0x1d0500, 0x1d0600, 0x1d0700,
  0x1d0800, 0x1d0900, 0x1d0a00, 0x1d0b00, 0x1d0c00, 0x1d0d00, 0x1d0e00, 0x1d0f00,
  0x1d1000, 0x1d1100, 0x1d1200, 0x1d1300, 0x1d1400, 0x1d1500, 0x1d1600, 0x1d1700,
  0x1d1800, 0x1d1900, 0x1d1a00, 0x1d1b00, 0x1d1c00, 0x1d1d00, 0x1d1e00, 0x1d1f00,
  0x1d2000, 0x1d2100, 0x1d2200, 0x1d2300, 0x1d2400, 0x1d2500, 0x1d2600, 0x1d2700,
  0x1d2800, 0x1d2900, 0x1d2a00, 0x1d2b00, 0x004101, 0x00c601, 0x004201, 0x1d2f00,
  0x004401, 0x004501, 0x018e01, 0x004701, 0x004801, 0x004901, 0x004a01, 0x004b01,
  0x004c01, 0x004d01, 0x004e01, 0x1d3b00, 0x004f01, 0x022201, 0x005001, 0x005201,
  0x005401, 0x005501, 0x005701, 0x006101, 0x025001, 0x025101, 0x1d0201, 0x006201,
  0x006401, 0x006501, 0x025901, 0x025b01, 0x025c01, 0x006701, 0x1d4e00, 0x006b01,
  0x006d01, 0x014b01, 0x006f01, 0x025401, 0x1d1601, 0x1d1701, 0x007001, 0x007401,
  0x007501, 0x1d1d01, 0x026f01, 0x007601, 0x1d2501, 0x03b201, 0x03b301, 0x03b401,
  0x03c601, 0x03c701, 0x006901, 0x007201, 0x007501, 0x007601, 0x03b201, 0x03b301,
  0x03c101, 0x03c601, 0x03c701, 0x1d6b00, 0x1d6c00, 0x1d6d00, 0x1d6e00, 0x1d6f00,
  0x1d7000, 0x1d7100, 0x1d7200, 0x1d7300, 0x1d7400, 0x1d7500, 0x1d7600, 0x1d7700,
  0x043d01, 0x1d7900, 0x1d7a00, 0x1d7b00, 0x1d7c00, 0x1d7d00, 0x1d7e00, 0x1d7f00,
  0x1d8000, 0x1d8100, 0x1d8200, 0x1d8300, 0x1d8400, 0x1d8500, 0x1d8600, 0x1d8700,
  0x1d8800, 0x1d8900, 0x1d8a00, 0x1d8b00, 0x1d8c00, 0x1d8d00, 0x1d8e00, 0x1d8f00,
  0x1d9000, 0x1d9100, 0x1d9200, 0x1d9300, 0x1d9400, 0x1d9500, 0x1d9600, 0x1d9700,
  0x1d9800, 0x1d9900, 0x1d9a00, 0x025201, 0x006301, 0x025501, 0x00f001, 0x025c01,
  0x006601, 0x025f01, 0x026101, 0x026501, 0x026801, 0x026901, 0x026a01, 0x1d7b01,
  0x029d01, 0x026d01, 0x1d8501, 0x029f01, 0x027101, 0x027001, 0x027201, 0x027301,
  0x027401, 0x027501, 0x027801, 0x028201, 0x028301, 0x01ab01, 0x028901, 0x028a01,
  0x1d1c01, 0x028b01, 0x028c01, 0x007a01, 0x029001, 0x029101, 0x029201, 0x03b801,
  0x1dc000, 0x1dc100, 0x1dc200, 0x1dc300, 0x1dc400, 0x1dc500, 0x1dc600, 0x1dc700,
  0x1dc800, 0x1dc900, 0x1dca00, 0x1dcb00, 0x1dcc00, 0x1dcd00, 0x1dce00, 0x1dcf00,
  0x1dd000, 0x1dd100, 0x1dd200, 0x1dd300, 0x1dd400, 0x1dd500, 0x1dd600, 0x1dd700,
  0x1dd800, 0x1dd900, 0x1dda00, 0x1ddb00, 0x1ddc00, 0x1ddd00, 0x1dde00, 0x1ddf00,
  0x1de000, 0x1de100, 0x1de200, 0x1de300, 0x1de400, 0x1de500, 0x1de600, 0x1de700,
  0x1de800, 0x1de900, 0x1dea00, 0x1deb00, 0x1dec00, 0x1ded00, 0x1dee00, 0x1def00,
  0x1df000, 0x1df100, 0x1df200, 0x1df300, 0x1df400, 0x1df500, 0x1df600, 0x1df700,
  0x1df800, 0x1df900, 0x1dfa00, 0x1dfb00, 0x1dfc00, 0x1dfd00, 0x1dfe00, 0x1dff00
};

static const int32_t ucp0x1e[256] =
{ 0x004116, 0x004196, 0x004209, 0x004289, 0x004214, 0x004294, 0x00421d, 0x00429d,
  0x00c704, 0x00c784, 0x004409, 0x004489, 0x004414, 0x004494, 0x00441d, 0x00449d,
  0x004418, 0x004498, 0x00441a, 0x00449a, 0x011203, 0x011283, 0x011204, 0x011284,
  0x00451a, 0x00459a, 0x00451c, 0x00459c, 0x022808, 0x022888, 0x004609, 0x004689,
  0x004707, 0x004787, 0x004809, 0x004889, 0x004814, 0x004894, 0x00480a, 0x00488a,
  0x004818, 0x004898, 0x00481b, 0x00489b, 0x00491c, 0x00499c, 0x00cf04, 0x00cf84,
  0x004b04, 0x004b84, 0x004b14, 0x004b94, 0x004b1d, 0x004b9d, 0x004c14, 0x004c94,
  0x1e3607, 0x1e3687, 0x004c1d, 0x004c9d, 0x004c1a, 0x004c9a, 0x004d04, 0x004d84,
  0x004d09, 0x004d89, 0x004d14, 0x004d94, 0x004e09, 0x004e89, 0x004e14, 0x004e94,
  0x004e1d, 0x004e9d, 0x004e1a, 0x004e9a, 0x00d504, 0x00d584, 0x00d50a, 0x00d58a,
  0x014c03, 0x014c83, 0x014c04, 0x014c84, 0x005004, 0x005084, 0x005009, 0x005089,
  0x005209, 0x005289, 0x005214, 0x005294, 0x1e5a07, 0x1e5a87, 0x00521d, 0x00529d,
  0x005309, 0x005389, 0x005314, 0x005394, 0x015a09, 0x015a89, 0x016009, 0x016089,
  0x1e6209, 0x1e6289, 0x005409, 0x005489, 0x005414, 0x005494, 0x00541d, 0x00549d,
  0x00541a, 0x00549a, 0x005515, 0x005595, 0x00551c, 0x00559c, 0x00551a, 0x00559a,
  0x016804, 0x016884, 0x016a0a, 0x016a8a, 0x005606, 0x005686, 0x005614, 0x005694,
  0x005703, 0x005783, 0x005704, 0x005784, 0x00570a, 0x00578a, 0x005709, 0x005789,
  0x005714, 0x005794, 0x005809, 0x005889, 0x00580a, 0x00588a, 0x005909, 0x005989,
  0x005a05, 0x005a85, 0x005a14, 0x005a94, 0x005a1d, 0x005a9d, 0x00681d, 0x00740a,
  0x00770c, 0x00790c, 0x1e9a00, 0x005389, 0x1e9c00, 0x1e9d00, 0x1e9e00, 0x1e9f00,
  0x004114, 0x004194, 0x00410b, 0x00418b, 0x00c204, 0x00c284, 0x00c203, 0x00c283,
  0x00c20b, 0x00c28b, 0x00c206, 0x00c286, 0x1ea005, 0x1ea085, 0x010204, 0x010284,
  0x010203, 0x010283, 0x01020b, 0x01028b, 0x010206, 0x010286, 0x1ea008, 0x1ea088,
  0x004514, 0x004594, 0x00450b, 0x00458b, 0x004506, 0x004586, 0x00ca04, 0x00ca84,
  0x00ca03, 0x00ca83, 0x00ca0b, 0x00ca8b, 0x00ca06, 0x00ca86, 0x1eb805, 0x1eb885,
  0x00490b, 0x00498b, 0x004914, 0x004994, 0x004f14, 0x004f94, 0x004f0b, 0x004f8b,
  0x00d404, 0x00d484, 0x00d403, 0x00d483, 0x00d40b, 0x00d48b, 0x00d406, 0x00d486,
  0x1ecc05, 0x1ecc85, 0x01a004, 0x01a084, 0x01a003, 0x01a083, 0x01a00b, 0x01a08b,
  0x01a006, 0x01a086, 0x01a014, 0x01a094, 0x005514, 0x005594, 0x00550b, 0x00558b,
  0x01af04, 0x01af84, 0x01af03, 0x01af83, 0x01af0b, 0x01af8b, 0x01af06, 0x01af86,
  0x01af14, 0x01af94, 0x005903, 0x005983, 0x005914, 0x005994, 0x00590b, 0x00598b,
  0x005906, 0x005986, 0x1efa00, 0x1efb00, 0x1efc00, 0x1efd00, 0x1efe00, 0x1eff00
};

static const int32_t ucp0x1f[256] =
{ 0x039191, 0x039192, 0x1f0883, 0x1f0983, 0x1f0884, 0x1f0984, 0x1f089f, 0x1f099f,
  0x039111, 0x039112, 0x1f0803, 0x1f0903, 0x1f0804, 0x1f0904, 0x1f081f, 0x1f091f,
  0x039591, 0x039592, 0x1f1883, 0x1f1983, 0x1f1884, 0x1f1984, 0x1f1600, 0x1f1700,
  0x039511, 0x039512, 0x1f1803, 0x1f1903, 0x1f1804, 0x1f1904, 0x1f1e00, 0x1f1f00,
  0x039791, 0x039792, 0x1f2883, 0x1f2983, 0x1f2884, 0x1f2984, 0x1f289f, 0x1f299f,
  0x039711, 0x039712, 0x1f2803, 0x1f2903, 0x1f2804, 0x1f2904, 0x1f281f, 0x1f291f,
  0x039991, 0x039992, 0x1f3883, 0x1f3983, 0x1f3884, 0x1f3984, 0x1f389f, 0x1f399f,
  0x039911, 0x039912, 0x1f3803, 0x1f3903, 0x1f3804, 0x1f3904, 0x1f381f, 0x1f391f,
  0x039f91, 0x039f92, 0x1f4883, 0x1f4983, 0x1f4884, 0x1f4984, 0x1f4600, 0x1f4700,
  0x039f11, 0x039f12, 0x1f4803, 0x1f4903, 0x1f4804, 0x1f4904, 0x1f4e00, 0x1f4f00,
  0x03c511, 0x03a592, 0x1f5003, 0x1f5983, 0x1f5004, 0x1f5984, 0x1f501f, 0x1f599f,
  0x1f5800, 0x03a512, 0x1f5a00, 0x1f5903, 0x1f5c00, 0x1f5904, 0x1f5e00, 0x1f591f,
  0x03a991, 0x03a992, 0x1f6883, 0x1f6983, 0x1f6884, 0x1f6984, 0x1f689f, 0x1f699f,
  0x03a911, 0x03a912, 0x1f6803, 0x1f6903, 0x1f6804, 0x1f6904, 0x1f681f, 0x1f691f,
  0x039183, 0x038682, 0x039583, 0x038882, 0x039783, 0x038982, 0x039983, 0x038a82,
  0x039f83, 0x038c82, 0x03a583, 0x038e82, 0x03a983, 0x038f82, 0x1f7e00, 0x1f7f00,
  0x1f08a0, 0x1f09a0, 0x1f0aa0, 0x1f0ba0, 0x1f0ca0, 0x1f0da0, 0x1f0ea0, 0x1f0fa0,
  0x1f0820, 0x1f0920, 0x1f0a20, 0x1f0b20, 0x1f0c20, 0x1f0d20, 0x1f0e20, 0x1f0f20,
  0x1f28a0, 0x1f29a0, 0x1f2aa0, 0x1f2ba0, 0x1f2ca0, 0x1f2da0, 0x1f2ea0, 0x1f2fa0,
  0x1f2820, 0x1f2920, 0x1f2a20, 0x1f2b20, 0x1f2c20, 0x1f2d20, 0x1f2e20, 0x1f2f20,
  0x1f68a0, 0x1f69a0, 0x1f6aa0, 0x1f6ba0, 0x1f6ca0, 0x1f6da0, 0x1f6ea0, 0x1f6fa0,
  0x1f6820, 0x1f6920, 0x1f6a20, 0x1f6b20, 0x1f6c20, 0x1f6d20, 0x1f6e20, 0x1f6f20,
  0x039188, 0x039187, 0x1f7020, 0x0391a0, 0x03ac20, 0x1fb500, 0x03b11f, 0x1fb620,
  0x039108, 0x039107, 0x039103, 0x038602, 0x039120, 0x1fbd00, 0x039980, 0x1fbf00,
  0x1fc000, 0x00a81f, 0x1f7420, 0x0397a0, 0x03ae20, 0x1fc500, 0x03b71f, 0x1fc620,
  0x039503, 0x038802, 0x039703, 0x038902, 0x039720, 0x1fbf03, 0x1fbf04, 0x1fbf1f,
  0x039988, 0x039987, 0x03ca03, 0x039002, 0x1fd400, 0x1fd500, 0x03b91f, 0x03ca1f,
  0x039908, 0x039907, 0x039903, 0x038a02, 0x1fdc00, 0x1ffe03, 0x1ffe04, 0x1ffe1f,
  0x03a588, 0x03a587, 0x03cb03, 0x03b002, 0x03c111, 0x03a192, 0x03c51f, 0x03cb1f,
  0x03a508, 0x03a507, 0x03a503, 0x038e02, 0x03a112, 0x00a803, 0x038502, 0x006002,
  0x1ff000, 0x1ff100, 0x1f7c20, 0x03a9a0, 0x03ce20, 0x1ff500, 0x03c91f, 0x1ff620,
  0x039f03, 0x038c02, 0x03a903, 0x038f02, 0x03a920, 0x00b402, 0x1ffe00, 0x1fff00
};

static const int32_t ucp0x20[256] =
{ 0x200202, 0x200302, 0x200200, 0x200300, 0x200400, 0x200500, 0x200600, 0x002001,
  0x200800, 0x200900, 0x200a00, 0x200b00, 0x200c00, 0x200d00, 0x200e00, 0x200f00,
  0x201000, 0x201001, 0x201200, 0x201300, 0x201400, 0x201500, 0x201600, 0x201700,
  0x201800, 0x201900, 0x201a00, 0x201b00, 0x201c00, 0x201d00, 0x201e00, 0x201f00,
  0x202000, 0x202100, 0x202200, 0x202300, 0x202400, 0x202500, 0x202600, 0x202700,
  0x202800, 0x202900, 0x202a00, 0x202b00, 0x202c00, 0x202d00, 0x202e00, 0x002001,
  0x203000, 0x203100, 0x203200, 0x203300, 0x203400, 0x203500, 0x203600, 0x203700,
  0x203800, 0x203900, 0x203a00, 0x203b00, 0x203c00, 0x203d00, 0x203e00, 0x203f00,
  0x204000, 0x204100, 0x204200, 0x204300, 0x204400, 0x204500, 0x204600, 0x204700,
  0x204800, 0x204900, 0x204a00, 0x204b00, 0x204c00, 0x204d00, 0x204e00, 0x204f00,
  0x205000, 0x205100, 0x205200, 0x205300, 0x205400, 0x205500, 0x205600, 0x205700,
  0x205800, 0x205900, 0x205a00, 0x205b00, 0x205c00, 0x205d00, 0x205e00, 0x205f00,
  0x206000, 0x206100, 0x206200, 0x206300, 0x206400, 0x206500, 0x206600, 0x206700,
  0x206800, 0x206900, 0x206a00, 0x206b00, 0x206c00, 0x206d00, 0x206e00, 0x206f00,
  0x003001, 0x006901, 0x207200, 0x207300, 0x003401, 0x003501, 0x003601, 0x003701,
  0x003801, 0x003901, 0x002b01, 0x221201, 0x003d01, 0x002801, 0x002901, 0x006e01,
  0x003001, 0x003101, 0x003201, 0x003301, 0x003401, 0x003501, 0x003601, 0x003701,
  0x003801, 0x003901, 0x002b01, 0x221201, 0x003d01, 0x002801, 0x002901, 0x208f00,
  0x006101, 0x006501, 0x006f01, 0x007801, 0x025901, 0x209500, 0x209600, 0x209700,
  0x209800, 0x209900, 0x209a00, 0x209b00, 0x209c00, 0x209d00, 0x209e00, 0x209f00,
  0x20a000, 0x20a100, 0x20a200, 0x20a300, 0x20a400, 0x20a500, 0x20a600, 0x20a700,
  0x20a800, 0x20a900, 0x20aa00, 0x20ab00, 0x20ac00, 0x20ad00, 0x20ae00, 0x20af00,
  0x20b000, 0x20b100, 0x20b200, 0x20b300, 0x20b400, 0x20b500, 0x20b600, 0x20b700,
  0x20b800, 0x20b900, 0x20ba00, 0x20bb00, 0x20bc00, 0x20bd00, 0x20be00, 0x20bf00,
  0x20c000, 0x20c100, 0x20c200, 0x20c300, 0x20c400, 0x20c500, 0x20c600, 0x20c700,
  0x20c800, 0x20c900, 0x20ca00, 0x20cb00, 0x20cc00, 0x20cd00, 0x20ce00, 0x20cf00,
  0x20d000, 0x20d100, 0x20d200, 0x20d300, 0x20d400, 0x20d500, 0x20d600, 0x20d700,
  0x20d800, 0x20d900, 0x20da00, 0x20db00, 0x20dc00, 0x20dd00, 0x20de00, 0x20df00,
  0x20e000, 0x20e100, 0x20e200, 0x20e300, 0x20e400, 0x20e500, 0x20e600, 0x20e700,
  0x20e800, 0x20e900, 0x20ea00, 0x20eb00, 0x20ec00, 0x20ed00, 0x20ee00, 0x20ef00,
  0x20f000, 0x20f100, 0x20f200, 0x20f300, 0x20f400, 0x20f500, 0x20f600, 0x20f700,
  0x20f800, 0x20f900, 0x20fa00, 0x20fb00, 0x20fc00, 0x20fd00, 0x20fe00, 0x20ff00
};

static const int32_t ucp0x21[256] =
{ 0x210000, 0x210100, 0x004301, 0x210300, 0x210400, 0x210500, 0x210600, 0x210700,
  0x210800, 0x210900, 0x006701, 0x004801, 0x004801, 0x004801, 0x006801, 0x012701,
  0x004901, 0x004901, 0x004c01, 0x006c01, 0x211400, 0x004e01, 0x211600, 0x211700,
  0x211800, 0x005001, 0x005101, 0x005201, 0x005201, 0x005201, 0x211e00, 0x211f00,
  0x212000, 0x212100, 0x212200, 0x212300, 0x005a01, 0x212500, 0x03a902, 0x212700,
  0x005a01, 0x212900, 0x004b02, 0x00c502, 0x004201, 0x004301, 0x212e00, 0x006501,
  0x004501, 0x004601, 0x213200, 0x004d01, 0x006f01, 0x213500, 0x213600, 0x213700,
  0x213800, 0x006901, 0x213a00, 0x213b00, 0x03c001, 0x03b301, 0x039301, 0x03a001,
  0x221101, 0x214100, 0x214200, 0x214300, 0x214400, 0x004401, 0x006401, 0x006501,
  0x006901, 0x006a01, 0x214a00, 0x214b00, 0x214c00, 0x214d00, 0x214e00, 0x214f00,
  0x215000, 0x215100, 0x215200, 0x215300, 0x215400, 0x215500, 0x215600, 0x215700,
  0x215800, 0x215900, 0x215a00, 0x215b00, 0x215c00, 0x215d00, 0x215e00, 0x215f00,
  0x216000, 0x216100, 0x216200, 0x216300, 0x216400, 0x216500, 0x216600, 0x216700,
  0x216800, 0x216900, 0x216a00, 0x216b00, 0x216c00, 0x216d00, 0x216e00, 0x216f00,
  0x216080, 0x216180, 0x216280, 0x216380, 0x216480, 0x216580, 0x216680, 0x216780,
  0x216880, 0x216980, 0x216a80, 0x216b80, 0x216c80, 0x216d80, 0x216e80, 0x216f80,
  0x218000, 0x218100, 0x218200, 0x218300, 0x218400, 0x218500, 0x218600, 0x218700,
  0x218800, 0x218900, 0x218a00, 0x218b00, 0x218c00, 0x218d00, 0x218e00, 0x218f00,
  0x219000, 0x219100, 0x219200, 0x219300, 0x219400, 0x219500, 0x219600, 0x219700,
  0x219800, 0x219900, 0x21901e, 0x21921e, 0x219c00, 0x219d00, 0x219e00, 0x219f00,
  0x21a000, 0x21a100, 0x21a200, 0x21a300, 0x21a400, 0x21a500, 0x21a600, 0x21a700,
  0x21a800, 0x21a900, 0x21aa00, 0x21ab00, 0x21ac00, 0x21ad00, 0x21941e, 0x21af00,
  0x21b000, 0x21b100, 0x21b200, 0x21b300, 0x21b400, 0x21b500, 0x21b600, 0x21b700,
  0x21b800, 0x21b900, 0x21ba00, 0x21bb00, 0x21bc00, 0x21bd00, 0x21be00, 0x21bf00,
  0x21c000, 0x21c100, 0x21c200, 0x21c300, 0x21c400, 0x21c500, 0x21c600, 0x21c700,
  0x21c800, 0x21c900, 0x21ca00, 0x21cb00, 0x21cc00, 0x21d01e, 0x21d41e, 0x21d21e,
  0x21d000, 0x21d100, 0x21d200, 0x21d300, 0x21d400, 0x21d500, 0x21d600, 0x21d700,
  0x21d800, 0x21d900, 0x21da00, 0x21db00, 0x21dc00, 0x21dd00, 0x21de00, 0x21df00,
  0x21e000, 0x21e100, 0x21e200, 0x21e300, 0x21e400, 0x21e500, 0x21e600, 0x21e700,
  0x21e800, 0x21e900, 0x21ea00, 0x21eb00, 0x21ec00, 0x21ed00, 0x21ee00, 0x21ef00,
  0x21f000, 0x21f100, 0x21f200, 0x21f300, 0x21f400, 0x21f500, 0x21f600, 0x21f700,
  0x21f800, 0x21f900, 0x21fa00, 0x21fb00, 0x21fc00, 0x21fd00, 0x21fe00, 0x21ff00
};

static const int32_t ucp0x22[256] =
{ 0x220000, 0x220100, 0x220200, 0x220300, 0x22031e, 0x220500, 0x220600, 0x220700,
  0x220800, 0x22081e, 0x220a00, 0x220b00, 0x220b1e, 0x220d00, 0x220e00, 0x220f00,
  0x221000, 0x221100, 0x221200, 0x221300, 0x221400, 0x221500, 0x221600, 0x221700,
  0x221800, 0x221900, 0x221a00, 0x221b00, 0x221c00, 0x221d00, 0x221e00, 0x221f00,
  0x222000, 0x222100, 0x222200, 0x222300, 0x22231e, 0x222500, 0x22251e, 0x222700,
  0x222800, 0x222900, 0x222a00, 0x222b00, 0x222c00, 0x222d00, 0x222e00, 0x222f00,
  0x223000, 0x223100, 0x223200, 0x223300, 0x223400, 0x223500, 0x223600, 0x223700,
  0x223800, 0x223900, 0x223a00, 0x223b00, 0x223c00, 0x223d00, 0x223e00, 0x223f00,
  0x224000, 0x223c1e, 0x224200, 0x224300, 0x22431e, 0x224500, 0x224600, 0x22451e,
  0x224800, 0x22481e, 0x224a00, 0x224b00, 0x224c00, 0x224d00, 0x224e00, 0x224f00,
  0x225000, 0x225100, 0x225200, 0x225300, 0x225400, 0x225500, 0x225600, 0x225700,
  0x225800, 0x225900, 0x225a00, 0x225b00, 0x225c00, 0x225d00, 0x225e00, 0x225f00,
  0x003d1e, 0x226100, 0x22611e, 0x226300, 0x226400, 0x226500, 0x226600, 0x226700,
  0x226800, 0x226900, 0x226a00, 0x226b00, 0x226c00, 0x224d1e, 0x003c1e, 0x003e1e,
  0x22641e, 0x22651e, 0x227200, 0x227300, 0x22721e, 0x22731e, 0x227600, 0x227700,
  0x22761e, 0x22771e, 0x227a00, 0x227b00, 0x227c00, 0x227d00, 0x227e00, 0x227f00,
  0x227a1e, 0x227b1e, 0x228200, 0x228300, 0x22821e, 0x22831e, 0x228600, 0x228700,
  0x22861e, 0x22871e, 0x228a00, 0x228b00, 0x228c00, 0x228d00, 0x228e00, 0x228f00,
  0x229000, 0x229100, 0x229200, 0x229300, 0x229400, 0x229500, 0x229600, 0x229700,
  0x229800, 0x229900, 0x229a00, 0x229b00, 0x229c00, 0x229d00, 0x229e00, 0x229f00,
  0x22a000, 0x22a100, 0x22a200, 0x22a300, 0x22a400, 0x22a500, 0x22a600, 0x22a700,
  0x22a800, 0x22a900, 0x22aa00, 0x22ab00, 0x22a21e, 0x22a81e, 0x22a91e, 0x22ab1e,
  0x22b000, 0x22b100, 0x22b200, 0x22b300, 0x22b400, 0x22b500, 0x22b600, 0x22b700,
  0x22b800, 0x22b900, 0x22ba00, 0x22bb00, 0x22bc00, 0x22bd00, 0x22be00, 0x22bf00,
  0x22c000, 0x22c100, 0x22c200, 0x22c300, 0x22c400, 0x22c500, 0x22c600, 0x22c700,
  0x22c800, 0x22c900, 0x22ca00, 0x22cb00, 0x22cc00, 0x22cd00, 0x22ce00, 0x22cf00,
  0x22d000, 0x22d100, 0x22d200, 0x22d300, 0x22d400, 0x22d500, 0x22d600, 0x22d700,
  0x22d800, 0x22d900, 0x22da00, 0x22db00, 0x22dc00, 0x22dd00, 0x22de00, 0x22df00,
  0x227c1e, 0x227d1e, 0x22911e, 0x22921e, 0x22e400, 0x22e500, 0x22e600, 0x22e700,
  0x22e800, 0x22e900, 0x22b21e, 0x22b31e, 0x22b41e, 0x22b51e, 0x22ee00, 0x22ef00,
  0x22f000, 0x22f100, 0x22f200, 0x22f300, 0x22f400, 0x22f500, 0x22f600, 0x22f700,
  0x22f800, 0x22f900, 0x22fa00, 0x22fb00, 0x22fc00, 0x22fd00, 0x22fe00, 0x22ff00
};

static const int32_t ucp0x23[256] =
{ 0x230000, 0x230100, 0x230200, 0x230300, 0x230400, 0x230500, 0x230600, 0x230700,
  0x230800, 0x230900, 0x230a00, 0x230b00, 0x230c00, 0x230d00, 0x230e00, 0x230f00,
  0x231000, 0x231100, 0x231200, 0x231300, 0x231400, 0x231500, 0x231600, 0x231700,
  0x231800, 0x231900, 0x231a00, 0x231b00, 0x231c00, 0x231d00, 0x231e00, 0x231f00,
  0x232000, 0x232100, 0x232200, 0x232300, 0x232400, 0x232500, 0x232600, 0x232700,
  0x232800, 0x300802, 0x300902, 0x232b00, 0x232c00, 0x232d00, 0x232e00, 0x232f00,
  0x233000, 0x233100, 0x233200, 0x233300, 0x233400, 0x233500, 0x233600, 0x233700,
  0x233800, 0x233900, 0x233a00, 0x233b00, 0x233c00, 0x233d00, 0x233e00, 0x233f00,
  0x234000, 0x234100, 0x234200, 0x234300, 0x234400, 0x234500, 0x234600, 0x234700,
  0x234800, 0x234900, 0x234a00, 0x234b00, 0x234c00, 0x234d00, 0x234e00, 0x234f00,
  0x235000, 0x235100, 0x235200, 0x235300, 0x235400, 0x235500, 0x235600, 0x235700,
  0x235800, 0x235900, 0x235a00, 0x235b00, 0x235c00, 0x235d00, 0x235e00, 0x235f00,
  0x236000, 0x236100, 0x236200, 0x236300, 0x236400, 0x236500, 0x236600, 0x236700,
  0x236800, 0x236900, 0x236a00, 0x236b00, 0x236c00, 0x236d00, 0x236e00, 0x236f00,
  0x237000, 0x237100, 0x237200, 0x237300, 0x237400, 0x237500, 0x237600, 0x237700,
  0x237800, 0x237900, 0x237a00, 0x237b00, 0x237c00, 0x237d00, 0x237e00, 0x237f00,
  0x238000, 0x238100, 0x238200, 0x238300, 0x238400, 0x238500, 0x238600, 0x238700,
  0x238800, 0x238900, 0x238a00, 0x238b00, 0x238c00, 0x238d00, 0x238e00, 0x238f00,
  0x239000, 0x239100, 0x239200, 0x239300, 0x239400, 0x239500, 0x239600, 0x239700,
  0x239800, 0x239900, 0x239a00, 0x239b00, 0x239c00, 0x239d00, 0x239e00, 0x239f00,
  0x23a000, 0x23a100, 0x23a200, 0x23a300, 0x23a400, 0x23a500, 0x23a600, 0x23a700,
  0x23a800, 0x23a900, 0x23aa00, 0x23ab00, 0x23ac00, 0x23ad00, 0x23ae00, 0x23af00,
  0x23b000, 0x23b100, 0x23b200, 0x23b300, 0x23b400, 0x23b500, 0x23b600, 0x23b700,
  0x23b800, 0x23b900, 0x23ba00, 0x23bb00, 0x23bc00, 0x23bd00, 0x23be00, 0x23bf00,
  0x23c000, 0x23c100, 0x23c200, 0x23c300, 0x23c400, 0x23c500, 0x23c600, 0x23c700,
  0x23c800, 0x23c900, 0x23ca00, 0x23cb00, 0x23cc00, 0x23cd00, 0x23ce00, 0x23cf00,
  0x23d000, 0x23d100, 0x23d200, 0x23d300, 0x23d400, 0x23d500, 0x23d600, 0x23d700,
  0x23d800, 0x23d900, 0x23da00, 0x23db00, 0x23dc00, 0x23dd00, 0x23de00, 0x23df00,
  0x23e000, 0x23e100, 0x23e200, 0x23e300, 0x23e400, 0x23e500, 0x23e600, 0x23e700,
  0x23e800, 0x23e900, 0x23ea00, 0x23eb00, 0x23ec00, 0x23ed00, 0x23ee00, 0x23ef00,
  0x23f000, 0x23f100, 0x23f200, 0x23f300, 0x23f400, 0x23f500, 0x23f600, 0x23f700,
  0x23f800, 0x23f900, 0x23fa00, 0x23fb00, 0x23fc00, 0x23fd00, 0x23fe00, 0x23ff00
};

static const int32_t ucp0x24[256] =
{ 0x240000, 0x240100, 0x240200, 0x240300, 0x240400, 0x240500, 0x240600, 0x240700,
  0x240800, 0x240900, 0x240a00, 0x240b00, 0x240c00, 0x240d00, 0x240e00, 0x240f00,
  0x241000, 0x241100, 0x241200, 0x241300, 0x241400, 0x241500, 0x241600, 0x241700,
  0x241800, 0x241900, 0x241a00, 0x241b00, 0x241c00, 0x241d00, 0x241e00, 0x241f00,
  0x242000, 0x242100, 0x242200, 0x242300, 0x242400, 0x242500, 0x242600, 0x242700,
  0x242800, 0x242900, 0x242a00, 0x242b00, 0x242c00, 0x242d00, 0x242e00, 0x242f00,
  0x243000, 0x243100, 0x243200, 0x243300, 0x243400, 0x243500, 0x243600, 0x243700,
  0x243800, 0x243900, 0x243a00, 0x243b00, 0x243c00, 0x243d00, 0x243e00, 0x243f00,
  0x244000, 0x244100, 0x244200, 0x244300, 0x244400, 0x244500, 0x244600, 0x244700,
  0x244800, 0x244900, 0x244a00, 0x244b00, 0x244c00, 0x244d00, 0x244e00, 0x244f00,
  0x245000, 0x245100, 0x245200, 0x245300, 0x245400, 0x245500, 0x245600, 0x245700,
  0x245800, 0x245900, 0x245a00, 0x245b00, 0x245c00, 0x245d00, 0x245e00, 0x245f00,
  0x003101, 0x003201, 0x003301, 0x003401, 0x003501, 0x003601, 0x003701, 0x003801,
  0x003901, 0x246900, 0x246a00, 0x246b00, 0x246c00, 0x246d00, 0x246e00, 0x246f00,
  0x247000, 0x247100, 0x247200, 0x247300, 0x247400, 0x247500, 0x247600, 0x247700,
  0x247800, 0x247900, 0x247a00, 0x247b00, 0x247c00, 0x247d00, 0x247e00, 0x247f00,
  0x248000, 0x248100, 0x248200, 0x248300, 0x248400, 0x248500, 0x248600, 0x248700,
  0x248800, 0x248900, 0x248a00, 0x248b00, 0x248c00, 0x248d00, 0x248e00, 0x248f00,
  0x249000, 0x249100, 0x249200, 0x249300, 0x249400, 0x249500, 0x249600, 0x249700,
  0x249800, 0x249900, 0x249a00, 0x249b00, 0x249c00, 0x249d00, 0x249e00, 0x249f00,
  0x24a000, 0x24a100, 0x24a200, 0x24a300, 0x24a400, 0x24a500, 0x24a600, 0x24a700,
  0x24a800, 0x24a900, 0x24aa00, 0x24ab00, 0x24ac00, 0x24ad00, 0x24ae00, 0x24af00,
  0x24b000, 0x24b100, 0x24b200, 0x24b300, 0x24b400, 0x24b500, 0x004101, 0x004201,
  0x004301, 0x004401, 0x004501, 0x004601, 0x004701, 0x004801, 0x004901, 0x004a01,
  0x004b01, 0x004c01, 0x004d01, 0x004e01, 0x004f01, 0x005001, 0x005101, 0x005201,
  0x005301, 0x005401, 0x005501, 0x005601, 0x005701, 0x005801, 0x005901, 0x005a01,
  0x004181, 0x004281, 0x004381, 0x004481, 0x004581, 0x004681, 0x004781, 0x004881,
  0x004981, 0x004a81, 0x004b81, 0x004c81, 0x004d81, 0x004e81, 0x004f81, 0x005081,
  0x005181, 0x005281, 0x005381, 0x005481, 0x005581, 0x005681, 0x005781, 0x005881,
  0x005981, 0x005a81, 0x003001, 0x24eb00, 0x24ec00, 0x24ed00, 0x24ee00, 0x24ef00,
  0x24f000, 0x24f100, 0x24f200, 0x24f300, 0x24f400, 0x24f500, 0x24f600, 0x24f700,
  0x24f800, 0x24f900, 0x24fa00, 0x24fb00, 0x24fc00, 0x24fd00, 0x24fe00, 0x24ff00
};

static const int32_t ucp0x2a[256] =
{ 0x2a0000, 0x2a0100, 0x2a0200, 0x2a0300, 0x2a0400, 0x2a0500, 0x2a0600, 0x2a0700,
  0x2a0800, 0x2a0900, 0x2a0a00, 0x2a0b00, 0x2a0c00, 0x2a0d00, 0x2a0e00, 0x2a0f00,
  0x2a1000, 0x2a1100, 0x2a1200, 0x2a1300, 0x2a1400, 0x2a1500, 0x2a1600, 0x2a1700,
  0x2a1800, 0x2a1900, 0x2a1a00, 0x2a1b00, 0x2a1c00, 0x2a1d00, 0x2a1e00, 0x2a1f00,
  0x2a2000, 0x2a2100, 0x2a2200, 0x2a2300, 0x2a2400, 0x2a2500, 0x2a2600, 0x2a2700,
  0x2a2800, 0x2a2900, 0x2a2a00, 0x2a2b00, 0x2a2c00, 0x2a2d00, 0x2a2e00, 0x2a2f00,
  0x2a3000, 0x2a3100, 0x2a3200, 0x2a3300, 0x2a3400, 0x2a3500, 0x2a3600, 0x2a3700,
  0x2a3800, 0x2a3900, 0x2a3a00, 0x2a3b00, 0x2a3c00, 0x2a3d00, 0x2a3e00, 0x2a3f00,
  0x2a4000, 0x2a4100, 0x2a4200, 0x2a4300, 0x2a4400, 0x2a4500, 0x2a4600, 0x2a4700,
  0x2a4800, 0x2a4900, 0x2a4a00, 0x2a4b00, 0x2a4c00, 0x2a4d00, 0x2a4e00, 0x2a4f00,
  0x2a5000, 0x2a5100, 0x2a5200, 0x2a5300, 0x2a5400, 0x2a5500, 0x2a5600, 0x2a5700,
  0x2a5800, 0x2a5900, 0x2a5a00, 0x2a5b00, 0x2a5c00, 0x2a5d00, 0x2a5e00, 0x2a5f00,
  0x2a6000, 0x2a6100, 0x2a6200, 0x2a6300, 0x2a6400, 0x2a6500, 0x2a6600, 0x2a6700,
  0x2a6800, 0x2a6900, 0x2a6a00, 0x2a6b00, 0x2a6c00, 0x2a6d00, 0x2a6e00, 0x2a6f00,
  0x2a7000, 0x2a7100, 0x2a7200, 0x2a7300, 0x2a7400, 0x2a7500, 0x2a7600, 0x2a7700,
  0x2a7800, 0x2a7900, 0x2a7a00, 0x2a7b00, 0x2a7c00, 0x2a7d00, 0x2a7e00, 0x2a7f00,
  0x2a8000, 0x2a8100, 0x2a8200, 0x2a8300, 0x2a8400, 0x2a8500, 0x2a8600, 0x2a8700,
  0x2a8800, 0x2a8900, 0x2a8a00, 0x2a8b00, 0x2a8c00, 0x2a8d00, 0x2a8e00, 0x2a8f00,
  0x2a9000, 0x2a9100, 0x2a9200, 0x2a9300, 0x2a9400, 0x2a9500, 0x2a9600, 0x2a9700,
  0x2a9800, 0x2a9900, 0x2a9a00, 0x2a9b00, 0x2a9c00, 0x2a9d00, 0x2a9e00, 0x2a9f00,
  0x2aa000, 0x2aa100, 0x2aa200, 0x2aa300, 0x2aa400, 0x2aa500, 0x2aa600, 0x2aa700,
  0x2aa800, 0x2aa900, 0x2aaa00, 0x2aab00, 0x2aac00, 0x2aad00, 0x2aae00, 0x2aaf00,
  0x2ab000, 0x2ab100, 0x2ab200, 0x2ab300, 0x2ab400, 0x2ab500, 0x2ab600, 0x2ab700,
  0x2ab800, 0x2ab900, 0x2aba00, 0x2abb00, 0x2abc00, 0x2abd00, 0x2abe00, 0x2abf00,
  0x2ac000, 0x2ac100, 0x2ac200, 0x2ac300, 0x2ac400, 0x2ac500, 0x2ac600, 0x2ac700,
  0x2ac800, 0x2ac900, 0x2aca00, 0x2acb00, 0x2acc00, 0x2acd00, 0x2ace00, 0x2acf00,
  0x2ad000, 0x2ad100, 0x2ad200, 0x2ad300, 0x2ad400, 0x2ad500, 0x2ad600, 0x2ad700,
  0x2ad800, 0x2ad900, 0x2ada00, 0x2adb00, 0x2add1e, 0x2add00, 0x2ade00, 0x2adf00,
  0x2ae000, 0x2ae100, 0x2ae200, 0x2ae300, 0x2ae400, 0x2ae500, 0x2ae600, 0x2ae700,
  0x2ae800, 0x2ae900, 0x2aea00, 0x2aeb00, 0x2aec00, 0x2aed00, 0x2aee00, 0x2aef00,
  0x2af000, 0x2af100, 0x2af200, 0x2af300, 0x2af400, 0x2af500, 0x2af600, 0x2af700,
  0x2af800, 0x2af900, 0x2afa00, 0x2afb00, 0x2afc00, 0x2afd00, 0x2afe00, 0x2aff00
};

static const int32_t ucp0x2c[256] =
{ 0x2c0000, 0x2c0100, 0x2c0200, 0x2c0300, 0x2c0400, 0x2c0500, 0x2c0600, 0x2c0700,
  0x2c0800, 0x2c0900, 0x2c0a00, 0x2c0b00, 0x2c0c00, 0x2c0d00, 0x2c0e00, 0x2c0f00,
  0x2c1000, 0x2c1100, 0x2c1200, 0x2c1300, 0x2c1400, 0x2c1500, 0x2c1600, 0x2c1700,
  0x2c1800, 0x2c1900, 0x2c1a00, 0x2c1b00, 0x2c1c00, 0x2c1d00, 0x2c1e00, 0x2c1f00,
  0x2c2000, 0x2c2100, 0x2c2200, 0x2c2300, 0x2c2400, 0x2c2500, 0x2c2600, 0x2c2700,
  0x2c2800, 0x2c2900, 0x2c2a00, 0x2c2b00, 0x2c2c00, 0x2c2d00, 0x2c2e00, 0x2c2f00,
  0x2c0080, 0x2c0180, 0x2c0280, 0x2c0380, 0x2c0480, 0x2c0580, 0x2c0680, 0x2c0780,
  0x2c0880, 0x2c0980, 0x2c0a80, 0x2c0b80, 0x2c0c80, 0x2c0d80, 0x2c0e80, 0x2c0f80,
  0x2c1080, 0x2c1180, 0x2c1280, 0x2c1380, 0x2c1480, 0x2c1580, 0x2c1680, 0x2c1780,
  0x2c1880, 0x2c1980, 0x2c1a80, 0x2c1b80, 0x2c1c80, 0x2c1d80, 0x2c1e80, 0x2c1f80,
  0x2c2080, 0x2c2180, 0x2c2280, 0x2c2380, 0x2c2480, 0x2c2580, 0x2c2680, 0x2c2780,
  0x2c2880, 0x2c2980, 0x2c2a80, 0x2c2b80, 0x2c2c80, 0x2c2d80, 0x2c2e80, 0x2c5f00,
  0x2c6000, 0x2c6100, 0x2c6200, 0x2c6300, 0x2c6400, 0x2c6500, 0x2c6600, 0x2c6700,
  0x2c6800, 0x2c6900, 0x2c6a00, 0x2c6b00, 0x2c6c00, 0x2c6d00, 0x2c6e00, 0x2c6f00,
  0x2c7000, 0x2c7100, 0x2c7200, 0x2c7300, 0x2c7400, 0x2c7500, 0x2c7600, 0x2c7700,
  0x2c7800, 0x2c7900, 0x2c7a00, 0x2c7b00, 0x2c7c00, 0x2c7d00, 0x2c7e00, 0x2c7f00,
  0x2c8000, 0x2c8080, 0x2c8200, 0x2c8280, 0x2c8400, 0x2c8480, 0x2c8600, 0x2c8680,
  0x2c8800, 0x2c8880, 0x2c8a00, 0x2c8a80, 0x2c8c00, 0x2c8c80, 0x2c8e00, 0x2c8e80,
  0x2c9000, 0x2c9080, 0x2c9200, 0x2c9280, 0x2c9400, 0x2c9480, 0x2c9600, 0x2c9680,
  0x2c9800, 0x2c9880, 0x2c9a00, 0x2c9a80, 0x2c9c00, 0x2c9c80, 0x2c9e00, 0x2c9e80,
  0x2ca000, 0x2ca080, 0x2ca200, 0x2ca280, 0x2ca400, 0x2ca480, 0x2ca600, 0x2ca680,
  0x2ca800, 0x2ca880, 0x2caa00, 0x2caa80, 0x2cac00, 0x2cac80, 0x2cae00, 0x2cae80,
  0x2cb000, 0x2cb080, 0x2cb200, 0x2cb280, 0x2cb400, 0x2cb480, 0x2cb600, 0x2cb680,
  0x2cb800, 0x2cb880, 0x2cba00, 0x2cba80, 0x2cbc00, 0x2cbc80, 0x2cbe00, 0x2cbe80,
  0x2cc000, 0x2cc080, 0x2cc200, 0x2cc280, 0x2cc400, 0x2cc480, 0x2cc600, 0x2cc680,
  0x2cc800, 0x2cc880, 0x2cca00, 0x2cca80, 0x2ccc00, 0x2ccc80, 0x2cce00, 0x2cce80,
  0x2cd000, 0x2cd080, 0x2cd200, 0x2cd280, 0x2cd400, 0x2cd480, 0x2cd600, 0x2cd680,
  0x2cd800, 0x2cd880, 0x2cda00, 0x2cda80, 0x2cdc00, 0x2cdc80, 0x2cde00, 0x2cde80,
  0x2ce000, 0x2ce080, 0x2ce200, 0x2ce280, 0x2ce400, 0x2ce500, 0x2ce600, 0x2ce700,
  0x2ce800, 0x2ce900, 0x2cea00, 0x2ceb00, 0x2cec00, 0x2ced00, 0x2cee00, 0x2cef00,
  0x2cf000, 0x2cf100, 0x2cf200, 0x2cf300, 0x2cf400, 0x2cf500, 0x2cf600, 0x2cf700,
  0x2cf800, 0x2cf900, 0x2cfa00, 0x2cfb00, 0x2cfc00, 0x2cfd00, 0x2cfe00, 0x2cff00
};

static const int32_t ucp0x2d[256] =
{ 0x10a080, 0x10a180, 0x10a280, 0x10a380, 0x10a480, 0x10a580, 0x10a680, 0x10a780,
  0x10a880, 0x10a980, 0x10aa80, 0x10ab80, 0x10ac80, 0x10ad80, 0x10ae80, 0x10af80,
  0x10b080, 0x10b180, 0x10b280, 0x10b380, 0x10b480, 0x10b580, 0x10b680, 0x10b780,
  0x10b880, 0x10b980, 0x10ba80, 0x10bb80, 0x10bc80, 0x10bd80, 0x10be80, 0x10bf80,
  0x10c080, 0x10c180, 0x10c280, 0x10c380, 0x10c480, 0x10c580, 0x2d2600, 0x2d2700,
  0x2d2800, 0x2d2900, 0x2d2a00, 0x2d2b00, 0x2d2c00, 0x2d2d00, 0x2d2e00, 0x2d2f00,
  0x2d3000, 0x2d3100, 0x2d3200, 0x2d3300, 0x2d3400, 0x2d3500, 0x2d3600, 0x2d3700,
  0x2d3800, 0x2d3900, 0x2d3a00, 0x2d3b00, 0x2d3c00, 0x2d3d00, 0x2d3e00, 0x2d3f00,
  0x2d4000, 0x2d4100, 0x2d4200, 0x2d4300, 0x2d4400, 0x2d4500, 0x2d4600, 0x2d4700,
  0x2d4800, 0x2d4900, 0x2d4a00, 0x2d4b00, 0x2d4c00, 0x2d4d00, 0x2d4e00, 0x2d4f00,
  0x2d5000, 0x2d5100, 0x2d5200, 0x2d5300, 0x2d5400, 0x2d5500, 0x2d5600, 0x2d5700,
  0x2d5800, 0x2d5900, 0x2d5a00, 0x2d5b00, 0x2d5c00, 0x2d5d00, 0x2d5e00, 0x2d5f00,
  0x2d6000, 0x2d6100, 0x2d6200, 0x2d6300, 0x2d6400, 0x2d6500, 0x2d6600, 0x2d6700,
  0x2d6800, 0x2d6900, 0x2d6a00, 0x2d6b00, 0x2d6c00, 0x2d6d00, 0x2d6e00, 0x2d6101,
  0x2d7000, 0x2d7100, 0x2d7200, 0x2d7300, 0x2d7400, 0x2d7500, 0x2d7600, 0x2d7700,
  0x2d7800, 0x2d7900, 0x2d7a00, 0x2d7b00, 0x2d7c00, 0x2d7d00, 0x2d7e00, 0x2d7f00,
  0x2d8000, 0x2d8100, 0x2d8200, 0x2d8300, 0x2d8400, 0x2d8500, 0x2d8600, 0x2d8700,
  0x2d8800, 0x2d8900, 0x2d8a00, 0x2d8b00, 0x2d8c00, 0x2d8d00, 0x2d8e00, 0x2d8f00,
  0x2d9000, 0x2d9100, 0x2d9200, 0x2d9300, 0x2d9400, 0x2d9500, 0x2d9600, 0x2d9700,
  0x2d9800, 0x2d9900, 0x2d9a00, 0x2d9b00, 0x2d9c00, 0x2d9d00, 0x2d9e00, 0x2d9f00,
  0x2da000, 0x2da100, 0x2da200, 0x2da300, 0x2da400, 0x2da500, 0x2da600, 0x2da700,
  0x2da800, 0x2da900, 0x2daa00, 0x2dab00, 0x2dac00, 0x2dad00, 0x2dae00, 0x2daf00,
  0x2db000, 0x2db100, 0x2db200, 0x2db300, 0x2db400, 0x2db500, 0x2db600, 0x2db700,
  0x2db800, 0x2db900, 0x2dba00, 0x2dbb00, 0x2dbc00, 0x2dbd00, 0x2dbe00, 0x2dbf00,
  0x2dc000, 0x2dc100, 0x2dc200, 0x2dc300, 0x2dc400, 0x2dc500, 0x2dc600, 0x2dc700,
  0x2dc800, 0x2dc900, 0x2dca00, 0x2dcb00, 0x2dcc00, 0x2dcd00, 0x2dce00, 0x2dcf00,
  0x2dd000, 0x2dd100, 0x2dd200, 0x2dd300, 0x2dd400, 0x2dd500, 0x2dd600, 0x2dd700,
  0x2dd800, 0x2dd900, 0x2dda00, 0x2ddb00, 0x2ddc00, 0x2ddd00, 0x2dde00, 0x2ddf00,
  0x2de000, 0x2de100, 0x2de200, 0x2de300, 0x2de400, 0x2de500, 0x2de600, 0x2de700,
  0x2de800, 0x2de900, 0x2dea00, 0x2deb00, 0x2dec00, 0x2ded00, 0x2dee00, 0x2def00,
  0x2df000, 0x2df100, 0x2df200, 0x2df300, 0x2df400, 0x2df500, 0x2df600, 0x2df700,
  0x2df800, 0x2df900, 0x2dfa00, 0x2dfb00, 0x2dfc00, 0x2dfd00, 0x2dfe00, 0x2dff00
};

static const int32_t ucp0x30[256] =
{ 0x002001, 0x300100, 0x300200, 0x300300, 0x300400, 0x300500, 0x300600, 0x300700,
  0x300800, 0x300900, 0x300a00, 0x300b00, 0x300c00, 0x300d00, 0x300e00, 0x300f00,
  0x301000, 0x301100, 0x301200, 0x301300, 0x301400, 0x301500, 0x301600, 0x301700,
  0x301800, 0x301900, 0x301a00, 0x301b00, 0x301c00, 0x301d00, 0x301e00, 0x301f00,
  0x302000, 0x302100, 0x302200, 0x302300, 0x302400, 0x302500, 0x302600, 0x302700,
  0x302800, 0x302900, 0x302a00, 0x302b00, 0x302c00, 0x302d00, 0x302e00, 0x302f00,
  0x303000, 0x303100, 0x303200, 0x303300, 0x303400, 0x303500, 0x303600, 0x303700,
  0x303800, 0x303900, 0x303a00, 0x303b00, 0x303c00, 0x303d00, 0x303e00, 0x303f00,
  0x304000, 0x304100, 0x304200, 0x304300, 0x304400, 0x304500, 0x304600, 0x304700,
  0x304800, 0x304900, 0x304a00, 0x304b00, 0x304b35, 0x304d00, 0x304d35, 0x304f00,
  0x304f35, 0x305100, 0x305135, 0x305300, 0x305335, 0x305500, 0x305535, 0x305700,
  0x305735, 0x305900, 0x305935, 0x305b00, 0x305b35, 0x305d00, 0x305d35, 0x305f00,
  0x305f35, 0x306100, 0x306135, 0x306300, 0x306400, 0x306435, 0x306600, 0x306635,
  0x306800, 0x306835, 0x306a00, 0x306b00, 0x306c00, 0x306d00, 0x306e00, 0x306f00,
  0x306f35, 0x306f36, 0x307200, 0x307235, 0x307236, 0x307500, 0x307535, 0x307536,
  0x307800, 0x307835, 0x307836, 0x307b00, 0x307b35, 0x307b36, 0x307e00, 0x307f00,
  0x308000, 0x308100, 0x308200, 0x308300, 0x308400, 0x308500, 0x308600, 0x308700,
  0x308800, 0x308900, 0x308a00, 0x308b00, 0x308c00, 0x308d00, 0x308e00, 0x308f00,
  0x309000, 0x309100, 0x309200, 0x309300, 0x304635, 0x309500, 0x309600, 0x309700,
  0x309800, 0x309900, 0x309a00, 0x309b00, 0x309c00, 0x309d00, 0x309d35, 0x309f00,
  0x30a000, 0x30a100, 0x30a200, 0x30a300, 0x30a400, 0x30a500, 0x30a600, 0x30a700,
  0x30a800, 0x30a900, 0x30aa00, 0x30ab00, 0x30ab35, 0x30ad00, 0x30ad35, 0x30af00,
  0x30af35, 0x30b100, 0x30b135, 0x30b300, 0x30b335, 0x30b500, 0x30b535, 0x30b700,
  0x30b735, 0x30b900, 0x30b935, 0x30bb00, 0x30bb35, 0x30bd00, 0x30bd35, 0x30bf00,
  0x30bf35, 0x30c100, 0x30c135, 0x30c300, 0x30c400, 0x30c435, 0x30c600, 0x30c635,
  0x30c800, 0x30c835, 0x30ca00, 0x30cb00, 0x30cc00, 0x30cd00, 0x30ce00, 0x30cf00,
  0x30cf35, 0x30cf36, 0x30d200, 0x30d235, 0x30d236, 0x30d500, 0x30d535, 0x30d536,
  0x30d800, 0x30d835, 0x30d836, 0x30db00, 0x30db35, 0x30db36, 0x30de00, 0x30df00,
  0x30e000, 0x30e100, 0x30e200, 0x30e300, 0x30e400, 0x30e500, 0x30e600, 0x30e700,
  0x30e800, 0x30e900, 0x30ea00, 0x30eb00, 0x30ec00, 0x30ed00, 0x30ee00, 0x30ef00,
  0x30f000, 0x30f100, 0x30f200, 0x30f300, 0x30a635, 0x30f500, 0x30f600, 0x30ef35,
  0x30f035, 0x30f135, 0x30f235, 0x30fb00, 0x30fc00, 0x30fd00, 0x30fd35, 0x30ff00
};

static const int32_t ucp0x31[256] =
{ 0x310000, 0x310100, 0x310200, 0x310300, 0x310400, 0x310500, 0x310600, 0x310700,
  0x310800, 0x310900, 0x310a00, 0x310b00, 0x310c00, 0x310d00, 0x310e00, 0x310f00,
  0x311000, 0x311100, 0x311200, 0x311300, 0x311400, 0x311500, 0x311600, 0x311700,
  0x311800, 0x311900, 0x311a00, 0x311b00, 0x311c00, 0x311d00, 0x311e00, 0x311f00,
  0x312000, 0x312100, 0x312200, 0x312300, 0x312400, 0x312500, 0x312600, 0x312700,
  0x312800, 0x312900, 0x312a00, 0x312b00, 0x312c00, 0x312d00, 0x312e00, 0x312f00,
  0x313000, 0x313100, 0x313200, 0x313300, 0x313400, 0x313500, 0x313600, 0x313700,
  0x313800, 0x313900, 0x313a00, 0x313b00, 0x313c00, 0x313d00, 0x313e00, 0x313f00,
  0x314000, 0x314100, 0x314200, 0x314300, 0x314400, 0x314500, 0x314600, 0x314700,
  0x314800, 0x314900, 0x314a00, 0x314b00, 0x314c00, 0x314d00, 0x314e00, 0x314f00,
  0x315000, 0x315100, 0x315200, 0x315300, 0x315400, 0x315500, 0x315600, 0x315700,
  0x315800, 0x315900, 0x315a00, 0x315b00, 0x315c00, 0x315d00, 0x315e00, 0x315f00,
  0x316000, 0x316100, 0x316200, 0x316300, 0x316400, 0x316500, 0x316600, 0x316700,
  0x316800, 0x316900, 0x316a00, 0x316b00, 0x316c00, 0x316d00, 0x316e00, 0x316f00,
  0x317000, 0x317100, 0x317200, 0x317300, 0x317400, 0x317500, 0x317600, 0x317700,
  0x317800, 0x317900, 0x317a00, 0x317b00, 0x317c00, 0x317d00, 0x317e00, 0x317f00,
  0x318000, 0x318100, 0x318200, 0x318300, 0x318400, 0x318500, 0x318600, 0x318700,
  0x318800, 0x318900, 0x318a00, 0x318b00, 0x318c00, 0x318d00, 0x318e00, 0x318f00,
  0x319000, 0x319100, 0x4e0001, 0x4e8c01, 0x4e0901, 0x56db01, 0x4e0a01, 0x4e2d01,
  0x4e0b01, 0x753201, 0x4e5901, 0x4e1901, 0x4e0101, 0x592901, 0x573001, 0x4eba01,
  0x31a000, 0x31a100, 0x31a200, 0x31a300, 0x31a400, 0x31a500, 0x31a600, 0x31a700,
  0x31a800, 0x31a900, 0x31aa00, 0x31ab00, 0x31ac00, 0x31ad00, 0x31ae00, 0x31af00,
  0x31b000, 0x31b100, 0x31b200, 0x31b300, 0x31b400, 0x31b500, 0x31b600, 0x31b700,
  0x31b800, 0x31b900, 0x31ba00, 0x31bb00, 0x31bc00, 0x31bd00, 0x31be00, 0x31bf00,
  0x31c000, 0x31c100, 0x31c200, 0x31c300, 0x31c400, 0x31c500, 0x31c600, 0x31c700,
  0x31c800, 0x31c900, 0x31ca00, 0x31cb00, 0x31cc00, 0x31cd00, 0x31ce00, 0x31cf00,
  0x31d000, 0x31d100, 0x31d200, 0x31d300, 0x31d400, 0x31d500, 0x31d600, 0x31d700,
  0x31d800, 0x31d900, 0x31da00, 0x31db00, 0x31dc00, 0x31dd00, 0x31de00, 0x31df00,
  0x31e000, 0x31e100, 0x31e200, 0x31e300, 0x31e400, 0x31e500, 0x31e600, 0x31e700,
  0x31e800, 0x31e900, 0x31ea00, 0x31eb00, 0x31ec00, 0x31ed00, 0x31ee00, 0x31ef00,
  0x31f000, 0x31f100, 0x31f200, 0x31f300, 0x31f400, 0x31f500, 0x31f600, 0x31f700,
  0x31f800, 0x31f900, 0x31fa00, 0x31fb00, 0x31fc00, 0x31fd00, 0x31fe00, 0x31ff00
};

static const int32_t ucp0x32[256] =
{ 0x320000, 0x320100, 0x320200, 0x320300, 0x320400, 0x320500, 0x320600, 0x320700,
  0x320800, 0x320900, 0x320a00, 0x320b00, 0x320c00, 0x320d00, 0x320e00, 0x320f00,
  0x321000, 0x321100, 0x321200, 0x321300, 0x321400, 0x321500, 0x321600, 0x321700,
  0x321800, 0x321900, 0x321a00, 0x321b00, 0x321c00, 0x321d00, 0x321e00, 0x321f00,
  0x322000, 0x322100, 0x322200, 0x322300, 0x322400, 0x322500, 0x322600, 0x322700,
  0x322800, 0x322900, 0x322a00, 0x322b00, 0x322c00, 0x322d00, 0x322e00, 0x322f00,
  0x323000, 0x323100, 0x323200, 0x323300, 0x323400, 0x323500, 0x323600, 0x323700,
  0x323800, 0x323900, 0x323a00, 0x323b00, 0x323c00, 0x323d00, 0x323e00, 0x323f00,
  0x324000, 0x324100, 0x324200, 0x324300, 0x324400, 0x324500, 0x324600, 0x324700,
  0x324800, 0x324900, 0x324a00, 0x324b00, 0x324c00, 0x324d00, 0x324e00, 0x324f00,
  0x325000, 0x325100, 0x325200, 0x325300, 0x325400, 0x325500, 0x325600, 0x325700,
  0x325800, 0x325900, 0x325a00, 0x325b00, 0x325c00, 0x325d00, 0x325e00, 0x325f00,
  0x110001, 0x110201, 0x110301, 0x110501, 0x110601, 0x110701, 0x110901, 0x110b01,
  0x110c01, 0x110e01, 0x110f01, 0x111001, 0x111101, 0x111201, 0x326e00, 0x326f00,
  0x327000, 0x327100, 0x327200, 0x327300, 0x327400, 0x327500, 0x327600, 0x327700,
  0x327800, 0x327900, 0x327a00, 0x327b00, 0x327c00, 0x327d00, 0x327e00, 0x327f00,
  0x4e0001, 0x4e8c01, 0x4e0901, 0x56db01, 0x4e9401, 0x516d01, 0x4e0301, 0x516b01,
  0x4e5d01, 0x534101, 0x670801, 0x706b01, 0x6c3401, 0x672801, 0x91d101, 0x571f01,
  0x65e501, 0x682a01, 0x670901, 0x793e01, 0x540d01, 0x727901, 0x8ca101, 0x795d01,
  0x52b401, 0x79d801, 0x753701, 0x597301, 0x906901, 0x512a01, 0x537001, 0x6ce801,
  0x980501, 0x4f1101, 0x519901, 0x6b6301, 0x4e0a01, 0x4e2d01, 0x4e0b01, 0x5de601,
  0x53f301, 0x533b01, 0x5b9701, 0x5b6601, 0x76e301, 0x4f0101, 0x8cc701, 0x535401,
  0x591c01, 0x32b100, 0x32b200, 0x32b300, 0x32b400, 0x32b500, 0x32b600, 0x32b700,
  0x32b800, 0x32b900, 0x32ba00, 0x32bb00, 0x32bc00, 0x32bd00, 0x32be00, 0x32bf00,
  0x32c000, 0x32c100, 0x32c200, 0x32c300, 0x32c400, 0x32c500, 0x32c600, 0x32c700,
  0x32c800, 0x32c900, 0x32ca00, 0x32cb00, 0x32cc00, 0x32cd00, 0x32ce00, 0x32cf00,
  0x30a201, 0x30a401, 0x30a601, 0x30a801, 0x30aa01, 0x30ab01, 0x30ad01, 0x30af01,
  0x30b101, 0x30b301, 0x30b501, 0x30b701, 0x30b901, 0x30bb01, 0x30bd01, 0x30bf01,
  0x30c101, 0x30c401, 0x30c601, 0x30c801, 0x30ca01, 0x30cb01, 0x30cc01, 0x30cd01,
  0x30ce01, 0x30cf01, 0x30d201, 0x30d501, 0x30d801, 0x30db01, 0x30de01, 0x30df01,
  0x30e001, 0x30e101, 0x30e201, 0x30e401, 0x30e601, 0x30e801, 0x30e901, 0x30ea01,
  0x30eb01, 0x30ec01, 0x30ed01, 0x30ef01, 0x30f001, 0x30f101, 0x30f201, 0x32ff00
};

static const int32_t* const ucoll_map[UNICODE_MAP_SIZE] =
{ ucp0x00, ucp0x01, ucp0x02, ucp0x03, ucp0x04, ucp0x05, ucp0x06,    NULL,
     NULL, ucp0x09, ucp0x0a, ucp0x0b, ucp0x0c, ucp0x0d,    NULL, ucp0x0f,
  ucp0x10,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
     NULL,    NULL,    NULL,    NULL,    NULL, ucp0x1d, ucp0x1e, ucp0x1f,
  ucp0x20, ucp0x21, ucp0x22, ucp0x23, ucp0x24,    NULL,    NULL,    NULL,
     NULL,    NULL, ucp0x2a,    NULL, ucp0x2c, ucp0x2d,    NULL,    NULL,
  ucp0x30, ucp0x31, ucp0x32,    NULL,    NULL,    NULL,    NULL,    NULL,
     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,
     NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL,    NULL
};

static int
sort_point(int code)
{ int cp = code / 256;

  if ( cp < UNICODE_MAP_SIZE && ucoll_map[cp] )
    return ucoll_map[cp][code&0xff];

  return (code<<8);
}

static int
sort_pointA(int code)
{ return ucp0x00[code&0xff];
}

