/*
 * samplelib_libsndfile.h - Header file for libsndfile library plugin
 *
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __SAMPLELIB_LIBSNDFILE_H__
#define __SAMPLELIB_LIBSNDFILE_H__

#include <glib.h>
#include "GObjSup.h"

#include <libswami/SwamiSamplelib.h>


/* iiwusynth SwamiWavetbl object */


typedef struct _SamplelibLibsndfile SamplelibLibsndfile;
typedef struct _SamplelibLibsndfileClass SamplelibLibsndfileClass;

#define SAMPLELIB_TYPE_LIBSNDFILE   (wavetbl_iiwusynth_get_type ())
#define SAMPLELIB_LIBSNDFILE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), SAMPLELIB_TYPE_LIBSNDFILE, \
   SamplelibLibsndfile))
#define SAMPLELIB_LIBSNDFILE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), SAMPLELIB_TYPE_LIBSNDFILE, \
   SamplelibLibsndfileClass))
#define SAMPLELIB_IS_LIBSNDFILE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SAMPLELIB_TYPE_LIBSNDFILE))
#define SAMPLELIB_IS_LIBSNDFILE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), SAMPLELIB_TYPE_LIBSNDFILE))

typedef struct _realtime_noteon_t realtime_noteon_t;

/* iiwusynth SwamiWavetbl object */
struct _SamplelibLibsndfile
{
  SwamiSamplelib object;	/* derived from SwamiSamplelib */
};

/* iiwusynth wavetbl class */
struct _SamplelibLibsndfileClass
{
  SwamiSamplelibClass parent_class; /* derived from SwamiSamplelibClass */
};

#endif
