/*
 * SwamiPlugin.h - Header file for Swami plugin system
 *
 * Swami
 * Copyright (C) 1999-2003 Josh Green <jgreen@users.sourceforge.net>
 *
 * Code borrowed and modified from:
 * GStreamer (gst/gstplugin.h)
 * Copyright (C) 1999,2000 Erik Walthinsen <omega@cse.ogi.edu>
 *                    2000 Wim Taymans <wtay@chello.be>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Swami homepage: http://swami.sourceforge.net
 */
#ifndef __GST_PLUGIN_H__
#define __GST_PLUGIN_H__

#include <gmodule.h>
#include "config.h"
#include "swamidll.h"

typedef struct _SwamiPlugin		SwamiPlugin;
typedef struct _SwamiPluginDesc		SwamiPluginDesc;

struct _SwamiPlugin {
  /*< private >*/
  char *name;			/* name of the plugin */
  char *descr;			/* description of plugin */
  char *author;			/* author of this plugin */
  char *copyright;		/* copyright string */

  char *filename;		/* filename it came from */
  GModule *module;		/* contains the module if the plugin is loaded */
};

/* Initializer function: returns SWAMI_OK if plugin initialised successfully */
typedef int (*SwamiPluginInitFunc) (GModule *module, SwamiPlugin *plugin);

struct _SwamiPluginDesc {
  int major_version; /* major version of core that plugin was compiled for */
  int minor_version; /* minor version of core that plugin was compiled for */
  char *name;        /* name of plugin */
  char *descr;			/* description of plugin */
  char *author;			/* author of plugin */
  char *copyright;		/* copyright string */
  SwamiPluginInitFunc plugin_init; /* pointer to plugin_init function */
};

#define SWAMI_PLUGIN_DESC(major, minor, name, descr, author, copyright, init) \
SWAMI_API SwamiPluginDesc swami_plugin_desc = {		\
  major,						\
  minor,						\
  name,							\
  descr,						\
  author,						\
  copyright,						\
  init							\
};							

SWAMI_API void _swami_plugin_initialize (void);
void _swami_plugin_register_static (SwamiPluginDesc *desc);
SWAMI_API void swami_plugin_add_path (const char *path);

SWAMI_API gboolean swami_plugin_is_loaded	(SwamiPlugin *plugin);

SWAMI_API void swami_plugin_load_all (void);
SWAMI_API void swami_plugin_unload_all (void);

SWAMI_API gboolean swami_plugin_load (const char *name);
SWAMI_API gboolean swami_plugin_load_absolute (const char *name);
SWAMI_API gboolean swami_library_load (const char *name);
SWAMI_API gboolean swami_plugin_load_plugin (SwamiPlugin *plugin);

SWAMI_API SwamiPlugin *swami_plugin_find (const char *name);
SWAMI_API GList *swami_plugin_get_list (void);

#endif /* __SWAMI_PLUGIN_H__ */
